---
lang: el
title: Ο Κώδικας Δεοντολογίας σας
description: Διευκολύνετε την υγιούς και εποικοδομητική συμπεριφορά της κοινότητας με την υιοθέτηση και επιβολή ενός κώδικα δεοντολογίας.
class: coc
order: 8
image: /assets/images/cards/coc.png
related:
  - building
  - leadership
---

## Γιατί χρειάζομαι έναν κώδικα δεοντολογίας;

Ο κώδικας δεοντολογίας είναι ένα έγγραφο που καθορίζει τις προσδοκίες συμπεριφοράς για τους συμμετέχοντες στο πρότζεκτ σας. Η υιοθέτηση και η επιβολή ενός κώδικα δεοντολογίας μπορεί να συμβάλει στη δημιουργία θετικής κοινωνικής ατμόσφαιρας για την κοινότητά σας.

Οι κώδικες δεοντολογίας βοηθούν στην προστασία όχι μόνο των συμμετεχόντων σας, αλλά και εσάς τους ίδιους. Εάν συντηρείτε ένα πρότζεκτ, μπορεί να διαπιστώσετε ότι οι μη παραγωγικές συμπεριφορές των άλλων συμμετεχόντων μπορεί να σας κάνουν να νιώθετε εξαντλημένοι ή δυσαρεστημένοι με την εργασία σας με την πάροδο του χρόνου.

Ένας κώδικας δεοντολογίας σας δίνει τη δυνατότητα να διευκολύνετε την υγιή, εποικοδομητική συμπεριφορά της κοινότητας. Το να είστε προληπτικοί μειώνει την πιθανότητα να κουραστείτε εσείς ή άλλοι από το πρότζεκτ σας και σας βοηθά να αναλάβετε δράση όταν κάποιος κάνει κάτι με το οποίο δεν συμφωνείτε.

## Καθιέρωση ενός κώδικα συμπεριφοράς

Προσπαθήστε να καθιερώσετε έναν κώδικα συμπεριφοράς όσο το δυνατόν νωρίτερα: ιδανικά, όταν δημιουργείτε για πρώτη φορά το πρότζεκτ σας.

Εκτός από την κοινοποίηση των προσδοκιών σας, ένας κώδικας δεοντολογίας περιγράφει τα εξής:

* Πού τίθεται σε ισχύ ο κώδικας συμπεριφοράς _(μόνο σε θέματα και αιτήσεις διανομής ή σε δραστηριότητες της κοινότητας, όπως εκδηλώσεις;)_
* Σε ποιους ισχύει ο κώδικας συμπεριφοράς _(μέλη της κοινότητας και συντηρητές, αλλά τι γίνεται με τους χορηγούς;)_
* Τι συμβαίνει αν κάποιος παραβιάσει τον κώδικα συμπεριφοράς
* Πώς μπορεί κάποιος να αναφέρει παραβιάσεις

Όπου μπορείτε, χρησιμοποιήστε την προϋπάρχουσα τέχνη. Το [Contributor Covenant](https://contributor-covenant.org/) είναι ένας drop-in κώδικας συμπεριφοράς που χρησιμοποιείται από πάνω από 40.000 έργα ανοικτού κώδικα, συμπεριλαμβανομένων των Kubernetes, Rails και Swift.

Ο [Django Code of Conduct](https://www.djangoproject.com/conduct/) και ο [Citizen Code of Conduct](https://web.archive.org/web/20200330154000/http://citizencodeofconduct.org/) είναι επίσης δύο καλά παραδείγματα κώδικα συμπεριφοράς.

Τοποθετήστε ένα αρχείο CODE_OF_CONDUCT στο ριζικό κατάλογο του πρότζεκτ σας και κάντε το ορατό στην κοινότητά σας, συνδέοντάς το από το αρχείο CONTRIBUTING ή README.

## Αποφασίζοντας πώς θα επιβάλλετε τον κώδικα συμπεριφοράς σας

<aside markdown="1" class="pquote">
  Ένας κώδικας συμπεριφοράς που δεν επιβάλλεται (ή δεν μπορεί να επιβληθεί) είναι χειρότερος από το να μην υπάρχει καθόλου κώδικας συμπεριφοράς: στέλνει το μήνυμα ότι οι αξίες του κώδικα συμπεριφοράς δεν είναι στην πραγματικότητα σημαντικές ή σεβαστές στην κοινότητά σας.
  <p markdown="1" class="pquote-credit">
- [Πρωτοβουλία Ada](https://webcache.googleusercontent.com/search?q=cache:YfqdTk5H9ikJ:https://adainitiative.org/2014/02/18/howto-design-a-code-of-conduct-for-your-community)
  </p>
</aside>

Θα πρέπει να εξηγήσετε πώς θα επιβληθεί ο κώδικας συμπεριφοράς σας **_πριν_** συμβεί μια παραβίαση. Υπάρχουν διάφοροι λόγοι για να το κάνετε αυτό:

* Δείχνει ότι είστε σοβαροί στο να αναλάβετε δράση όταν χρειάζεται.

* Η κοινότητά σας θα αισθάνεται πιο καθησυχαστική ότι οι καταγγελίες πράγματι εξετάζονται.

* Θα καθησυχάσετε την κοινότητά σας ότι η διαδικασία επανεξέτασης είναι δίκαιη και διαφανής, σε περίπτωση που ποτέ βρεθούν υπό διερεύνηση για παραβίαση.

Θα πρέπει να δώσετε στους ανθρώπους έναν ιδιωτικό τρόπο (όπως μια διεύθυνση ηλεκτρονικού ταχυδρομείου) για να αναφέρουν μια παραβίαση του κώδικα δεοντολογίας και να εξηγήσετε ποιος λαμβάνει αυτή την αναφορά. Θα μπορούσε να είναι ένας συντηρητής, μια ομάδα συντηρητών ή μια ομάδα εργασίας κώδικα δεοντολογίας.

Μην ξεχνάτε ότι κάποιος μπορεί να θέλει να αναφέρει μια παραβίαση για ένα άτομο που λαμβάνει αυτές τις αναφορές. Σε αυτή την περίπτωση, δώστε τους τη δυνατότητα να αναφέρουν τις παραβιάσεις σε κάποιον άλλο. Για παράδειγμα, οι @ctb και @mr-c [εξηγούν για το πρότζεκτ τους](https://github.com/dib-lab/khmer/blob/HEAD/CODE_OF_CONDUCT.rst), [khmer](https://github.com/dib-lab/khmer):

> Περιπτώσεις καταχρηστικής, παρενοχλητικής ή άλλως απαράδεκτης συμπεριφοράς μπορούν να αναφερθούν στέλνοντας email στο **khmer-project@idyll.org**, το οποίο απευθύνεται μόνο στους C. Titus Brown και Michael R. Crusoe. Για να αναφέρετε ένα θέμα που αφορά κάποιον από τους δύο, στείλτε email στον **Judi Brown Clarke, Ph.D.**, τον διευθυντή ποικιλομορφίας στο Κέντρο BEACON για τη μελέτη της εξέλιξης στην πράξη, ένα Κέντρο Επιστήμης και Τεχνολογίας του NSF*.

Για έμπνευση, δείτε το [εγχειρίδιο επιβολής](https://www.djangoproject.com/conduct/enforcement-manual/) του Django (αν και μπορεί να μην χρειάζεστε κάτι τόσο περιεκτικό, ανάλογα με το μέγεθος του πρότζεκτ σας).

## Επιβολή του κώδικα συμπεριφοράς σας

Μερικές φορές, παρά τις προσπάθειές σας, κάποιος θα κάνει κάτι που παραβιάζει αυτόν τον κώδικα. Υπάρχουν διάφοροι τρόποι για να αντιμετωπίσετε την αρνητική ή επιβλαβή συμπεριφορά όταν αυτή προκύψει.

### Συγκεντρώστε πληροφορίες σχετικά με την κατάσταση

Αντιμετωπίστε τη φωνή κάθε μέλους της κοινότητας εξίσου σημαντική με τη δική σας. Αν λάβετε μια αναφορά ότι κάποιος παραβίασε τον κώδικα συμπεριφοράς, πάρτε την στα σοβαρά και ερευνήστε το θέμα, ακόμη και αν δεν ταιριάζει με τη δική σας εμπειρία με το συγκεκριμένο άτομο. Με τον τρόπο αυτό σηματοδοτείτε στην κοινότητά σας ότι εκτιμάτε την άποψή της και εμπιστεύεστε την κρίση της.

Το εν λόγω μέλος της κοινότητας μπορεί να είναι ένας επαναλαμβανόμενος παραβάτης που κάνει τους άλλους να αισθάνονται συνεχώς άβολα, ή μπορεί να έχει πει ή κάνει κάτι μόνο μία φορά. Και τα δύο μπορούν να αποτελέσουν λόγο για τη λήψη μέτρων, ανάλογα με το πλαίσιο.

Πριν απαντήσετε, δώστε χρόνο στον εαυτό σας να καταλάβει τι συνέβη. Διαβάστε τα προηγούμενα σχόλια και συζητήσεις του ατόμου για να καταλάβετε καλύτερα ποιος είναι και γιατί μπορεί να ενήργησε με αυτόν τον τρόπο. Προσπαθήστε να συγκεντρώσετε άλλες οπτικές γωνίες εκτός από τις δικές σας σχετικά με αυτό το άτομο και τη συμπεριφορά του.

<aside markdown="1" class="pquote">
  Μην παρασύρεστε σε μια διαφωνία. Μην παρασυρθείτε στο να ασχοληθείτε με τη συμπεριφορά κάποιου άλλου πριν τελειώσετε με το θέμα που σας απασχολεί. Επικεντρωθείτε σε αυτό που χρειάζεστε.
  <p markdown="1" class="pquote-credit">
- Stephanie Zvan, ["So You've Got Yourself a Policy. Now What?"](https://the-orbit.net/almostdiamonds/2014/04/10/so-youve-got-yourself-a-policy-now-what/)
  </p>
</aside>

### Αναλάβετε την κατάλληλη δράση

Αφού συγκεντρώσετε και επεξεργαστείτε επαρκείς πληροφορίες, θα πρέπει να αποφασίσετε τι πρέπει να κάνετε. Καθώς εξετάζετε τα επόμενα βήματά σας, να θυμάστε ότι στόχος σας ως συντονιστής είναι να προωθήσετε ένα ασφαλές, με σεβασμό και συνεργασία περιβάλλον. Σκεφτείτε όχι μόνο πώς να αντιμετωπίσετε την εν λόγω κατάσταση, αλλά και πώς η αντίδρασή σας θα επηρεάσει τη συμπεριφορά και τις προσδοκίες της υπόλοιπης κοινότητάς σας στο μέλλον.

Όταν κάποιος αναφέρει μια παραβίαση του κώδικα συμπεριφοράς, είναι δική σας δουλειά, όχι δική τους, να το χειριστείτε. Ορισμένες φορές, ο καταγγέλλων αποκαλύπτει πληροφορίες με μεγάλο κίνδυνο για την καριέρα του, τη φήμη του ή τη σωματική του ακεραιότητα. Ο εξαναγκασμός τους να αντιμετωπίσουν τον παρενοχλητή τους θα μπορούσε να θέσει τον αναφέροντα σε επικίνδυνη θέση. Θα πρέπει να χειρίζεστε την άμεση επικοινωνία με το εν λόγω πρόσωπο, εκτός εάν ο δημοσιογράφος ζητήσει ρητά το αντίθετο.

Υπάρχουν μερικοί τρόποι με τους οποίους μπορείτε να αντιδράσετε σε μια παραβίαση του κώδικα δεοντολογίας:

* **Δώστε στο εν λόγω άτομο μια δημόσια προειδοποίηση** και εξηγήστε πώς η συμπεριφορά του επηρέασε αρνητικά τους άλλους, κατά προτίμηση στο κανάλι όπου συνέβη. Όπου είναι δυνατόν, η δημόσια επικοινωνία μεταφέρει στην υπόλοιπη κοινότητα ότι παίρνετε σοβαρά τον κώδικα συμπεριφοράς. Να είστε ευγενικοί, αλλά αυστηροί στην επικοινωνία σας.

* **Επικοινωνήστε ιδιωτικά με το εν λόγω άτομο** για να εξηγήσετε πώς η συμπεριφορά του επηρέασε αρνητικά τους άλλους. Μπορεί να θέλετε να χρησιμοποιήσετε ένα ιδιωτικό κανάλι επικοινωνίας, εάν η κατάσταση αφορά ευαίσθητες προσωπικές πληροφορίες. Εάν επικοινωνήσετε με κάποιον ιδιαιτέρως, καλό θα ήταν να ενημερώσετε όσους ανέφεραν πρώτοι την κατάσταση, ώστε να γνωρίζουν ότι αναλάβατε δράση. Ζητήστε τη συγκατάθεση του ατόμου που έκανε την αναφορά πριν τον κάνετε CC.

Μερικές φορές, δεν μπορεί να επιτευχθεί λύση. Το εν λόγω άτομο μπορεί να γίνει επιθετικό ή εχθρικό όταν έρθει αντιμέτωπο ή δεν αλλάζει τη συμπεριφορά του. Σε αυτή την περίπτωση, μπορεί να θέλετε να εξετάσετε το ενδεχόμενο να αναλάβετε ισχυρότερη δράση. Για παράδειγμα:

* **Αποβολή του εν λόγω ατόμου** από το πρότζεκτ, με προσωρινή απαγόρευση συμμετοχής σε οποιαδήποτε πτυχή του πρότζεκτ.

* **Μόνιμος αποκλεισμός** του ατόμου από το πρότζεκτ

Ο αποκλεισμός μελών δεν πρέπει να λαμβάνεται ελαφρά τη καρδία και αντιπροσωπεύει μια μόνιμη και αγεφύρωτη διαφορά απόψεων. Θα πρέπει να λαμβάνετε αυτά τα μέτρα μόνο όταν είναι σαφές ότι δεν μπορεί να επιτευχθεί λύση.

## Οι ευθύνες σας ως συντηρητής

Ένας κώδικας συμπεριφοράς δεν είναι ένας νόμος που επιβάλλεται αυθαίρετα. Εσείς είστε ο εφαρμοστής του κώδικα δεοντολογίας και είναι δική σας ευθύνη να ακολουθείτε τους κανόνες που θεσπίζει ο κώδικας δεοντολογίας.

Ως συντηρητής θεσπίζετε τις κατευθυντήριες γραμμές για την κοινότητά σας και επιβάλλετε αυτές τις κατευθυντήριες γραμμές σύμφωνα με τους κανόνες που ορίζονται στον κώδικα συμπεριφοράς σας. Αυτό σημαίνει ότι λαμβάνετε σοβαρά υπόψη κάθε αναφορά για παραβίαση του κώδικα συμπεριφοράς. Ο καταγγέλλων οφείλει να εξετάσει διεξοδικά και δίκαια την καταγγελία του. Εάν διαπιστώσετε ότι η συμπεριφορά που ανέφεραν δεν αποτελεί παραβίαση, επικοινωνήστε το με σαφήνεια σε αυτούς και εξηγήστε τους γιατί δεν πρόκειται να λάβετε μέτρα γι' αυτό. Το τι θα κάνουν με αυτό εξαρτάται από αυτούς: να ανεχθούν τη συμπεριφορά με την οποία είχαν πρόβλημα ή να σταματήσουν να συμμετέχουν στην κοινότητα.

Μια αναφορά συμπεριφοράς που _τεχνικά_ δεν παραβιάζει τον κώδικα συμπεριφοράς μπορεί να υποδεικνύει ότι υπάρχει πρόβλημα στην κοινότητά σας, και θα πρέπει να διερευνήσετε αυτό το πιθανό πρόβλημα και να ενεργήσετε αναλόγως. Αυτό μπορεί να περιλαμβάνει την αναθεώρηση του κώδικα συμπεριφοράς σας για να αποσαφηνίσετε την αποδεκτή συμπεριφορά ή/και να μιλήσετε με το άτομο του οποίου η συμπεριφορά αναφέρθηκε και να του πείτε ότι, ενώ δεν παραβίασε τον κώδικα συμπεριφοράς, παρακάμπτει τα όρια του αναμενόμενου και κάνει ορισμένους συμμετέχοντες να αισθάνονται άβολα.

Τελικά, ως συντηρητής, εσείς θέτετε και επιβάλλετε τα πρότυπα αποδεκτής συμπεριφοράς. Έχετε τη δυνατότητα να διαμορφώσετε τις αξίες της κοινότητας του πρότζεκτ και οι συμμετέχοντες περιμένουν από εσάς να επιβάλλετε αυτές τις αξίες με δίκαιο και ισορροπημένο τρόπο.

## Ενθαρρύνετε τη συμπεριφορά που θέλετε να δείτε στον κόσμο 🌎

Όταν ένα πρότζεκτ φαίνεται εχθρικό ή μη φιλόξενο, ακόμη και αν πρόκειται για ένα μόνο άτομο του οποίου η συμπεριφορά είναι ανεκτή από τους άλλους, κινδυνεύετε να χάσετε πολλούς ακόμη συνεισφέροντες, μερικούς από τους οποίους μπορεί να μην συναντήσετε ποτέ. Δεν είναι πάντα εύκολο να υιοθετήσετε ή να επιβάλλετε έναν κώδικα συμπεριφοράς, αλλά η καλλιέργεια ενός φιλόξενου περιβάλλοντος θα βοηθήσει την κοινότητά σας να αναπτυχθεί.
