---
lang: el
title: Χτίζοντας Ευπρόσδεκτες Κοινότητες
description: Χτίζοντας μια κοινωνιά που να ενθαρρύνει τα μέλη της να χρησιμοποιεί, να συνεισφέρει, και να προωθεί το πρότζεκτ σας.
class: building
order: 4
image: /assets/images/cards/building.png
related:
  - best-practices
  - coc
---

## Προετοιμάζοντας το πρότζεκτ σας για την επιτυχία

Ξεκινήσατε το πρότζεκτ σας, το διαδίδετε και ο κόσμος το ελέγχει. Φοβερό! Τώρα, πώς θα τους κάνετε να παραμείνουν;

Μια φιλόξενη κοινότητα είναι μια επένδυση στο μέλλον και τη φήμη του πρότζεκτ σας. Αν το πρότζεκτ σας μόλις αρχίζει να βλέπει τις πρώτες συνεισφορές, ξεκινήστε δίνοντας στους πρώτους συνεισφέροντες μια θετική εμπειρία και διευκολύνετέ τους να συνεχίσουν να επιστρέφουν.

### Κάντε τους ανθρώπους να αισθάνονται ευπρόσδεκτοι

Ένας τρόπος για να σκεφτείτε την κοινότητα του έργου σας είναι αυτό που ο @MikeMcQuaid αποκαλεί [contributor funnel](https://mikemcquaid.com/2018/08/14/the-open-source-contributor-funnel-why-people-dont-contribute-to-your-open-source-project/):

![Contributor funnel](/assets/images/building-community/contributor_funnel_mikemcquaid.png)

Καθώς χτίζετε την κοινότητά σας, σκεφτείτε πώς κάποιος που βρίσκεται στην κορυφή του χωνιού (ένας δυνητικός χρήστης) θα μπορούσε θεωρητικά να φτάσει στο κάτω μέρος (ένας ενεργός συντηρητής). Στόχος σας είναι να μειώσετε τις τριβές σε κάθε στάδιο της εμπειρίας του συνεισφέροντος. Όταν οι άνθρωποι έχουν εύκολες επιτυχίες, θα νιώθουν κίνητρο να κάνουν περισσότερα.

Ξεκινήστε με την τεκμηρίωσή σας:

* **Κάντε εύκολο για κάποιον να χρησιμοποιήσει το πρότζεκτ σας.** [Ένα φιλικό README](../starting-a-project/#γράφοντας-ένα-readme) και σαφή παραδείγματα κώδικα θα διευκολύνουν οποιονδήποτε βρεθεί στο πρότζεκτ σας να ξεκινήσει.
* **Εξηγήστε με σαφήνεια πώς να συνεισφέρετε**, χρησιμοποιώντας [το αρχείο CONTRIBUTING](../starting-a-project/#γράφοντας-τις-κατευθυντήριες-γραμμές-συνεισφοράς-σας) και διατηρώντας τα θέματά σας ενημερωμένα.
* **Καλά πρώτα θέματα**: Για να βοηθήσετε τους νέους συνεισφέροντες να ξεκινήσουν, σκεφτείτε ρητά [την επισήμανση θεμάτων που είναι αρκετά απλά για να τα αντιμετωπίσουν οι αρχάριοι](https://help.github.com/en/articles/helping-new-contributors-find-your-project-with-labels). Στη συνέχεια, το GitHub θα εμφανίσει αυτά τα θέματα σε διάφορα σημεία της πλατφόρμας, αυξάνοντας τις χρήσιμες συνεισφορές και μειώνοντας τις τριβές από τους χρήστες που αντιμετωπίζουν θέματα που είναι πολύ δύσκολα για το επίπεδό τους.

[Η έρευνα του GitHub για τον ανοικτό κώδικα του 2017](http://opensourcesurvey.org/2017/) έδειξε ότι η ελλιπής ή συγκεχυμένη τεκμηρίωση είναι το μεγαλύτερο πρόβλημα για τους χρήστες ανοικτού κώδικα. Η καλή τεκμηρίωση προσκαλεί τους ανθρώπους να αλληλεπιδράσουν με το πρότζεκτ σας. Τελικά, κάποιος θα ανοίξει ένα ζήτημα ή ένα αίτημα. Χρησιμοποιήστε αυτές τις αλληλεπιδράσεις ως ευκαιρίες για να τους μετακινήσετε προς τα κάτω στο χωνί.

* **Όταν κάποιος νέος μπαίνει στο έργο σας, ευχαριστήστε τον για το ενδιαφέρον του!** Αρκεί μια αρνητική εμπειρία για να κάνει κάποιον να μην θέλει να επιστρέψει.
* **Ανταποκριθείτε.** Αν δεν απαντήσετε στο θέμα τους για ένα μήνα, οι πιθανότητες είναι ότι έχουν ήδη ξεχάσει το έργο σας.
* **Να είστε ανοιχτόμυαλοι όσον αφορά τους τύπους συνεισφορών που θα δεχτείτε.** Πολλοί συνεισφέροντες ξεκινούν με μια αναφορά σφάλματος ή μια μικρή διόρθωση. Υπάρχουν [πολλοί τρόποι συνεισφοράς](../how-to-contribute/#τι-σημαίνει-να-συνεισφέρετε) σε ένα πρότζεκτ. Αφήστε τους ανθρώπους να βοηθήσουν με τον τρόπο που θέλουν να βοηθήσουν.
* **Αν υπάρχει μια συνεισφορά με την οποία διαφωνείτε,** ευχαριστήστε τους για την ιδέα τους και [εξηγήστε γιατί](../best-practices/#μαθαίνοντας-να-λέτε-όχι) δεν ταιριάζει στο πεδίο εφαρμογής του πρότζεκτυ, παραπέμποντας στη σχετική τεκμηρίωση αν την έχετε.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikeal?s=180" class="pquote-avatar" alt="avatar">
  Η συνεισφορά στον ανοιχτό κώδικα είναι ευκολότερη για κάποιους από άλλους. Υπάρχει μεγάλος φόβος να τους φωνάξουν ότι δεν κάνουν κάτι σωστά ή ότι απλά δεν ταιριάζουν. (...) Δίνοντας στους συνεισφέροντες ένα μέρος για να συνεισφέρουν με πολύ χαμηλή τεχνική επάρκεια (τεκμηρίωση, markdown περιεχομένου ιστού, κ.λπ.) μπορείτε να μειώσετε σημαντικά αυτές τις ανησυχίες.
  <p markdown="1" class="pquote-credit">
- @mikeal, ["Growing a contributor base in modern open source"](https://opensource.com/life/16/5/growing-contributor-base-modern-open-source)
  </p>
</aside>

Η πλειονότητα των συνεισφερόντων ανοιχτού κώδικα είναι "περιστασιακοί συνεισφέροντες": άνθρωποι που συνεισφέρουν σε ένα πρότζεκτ μόνο περιστασιακά. Ένας περιστασιακός συνεισφέρων μπορεί να μην έχει χρόνο να ενημερωθεί πλήρως για το πρότζεκτ σας, οπότε η δουλειά σας είναι να τους διευκολύνετε να συνεισφέρουν.

Η ενθάρρυνση άλλων συνεισφερόντων είναι μια επένδυση και στον εαυτό σας. Όταν εξουσιοδοτείτε τους μεγαλύτερους θαυμαστές σας να ασχοληθούν με το πρότζεκτ για το οποίο είναι ενθουσιασμένοι, υπάρχει λιγότερη πίεση να κάνετε τα πάντα εσείς.

### Καταγράψτε τα πάντα

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">
  Έχετε πάει ποτέ σε μια (τεχνολογική) εκδήλωση όπου δεν γνωρίζατε κανέναν, αλλά όλοι οι άλλοι έμοιαζαν να στέκονται σε ομάδες και να συζητούν σαν παλιοί φίλοι; (...) Φανταστείτε τώρα ότι θέλετε να συνεισφέρετε σε ένα πρότζεκτ ανοικτού κώδικα, αλλά δεν καταλαβαίνετε γιατί ή πώς συμβαίνει αυτό.
  <p markdown="1" class="pquote-credit">
- @janl, ["Sustainable Open Source"](https://web.archive.org/web/20200723213552/https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

Όταν ξεκινάτε ένα νέο πρότζεκτ, μπορεί να σας φαίνεται φυσικό να κρατάτε την εργασία σας ιδιωτική. Αλλά τα έργα ανοικτού κώδικα ευδοκιμούν όταν τεκμηριώνετε τη διαδικασία σας δημόσια.

Όταν καταγράφετε τα πράγματα, περισσότεροι άνθρωποι μπορούν να συμμετέχουν σε κάθε βήμα της διαδικασίας. Μπορεί να λάβετε βοήθεια για κάτι που δεν γνωρίζατε καν ότι χρειαζόσασταν.

Η καταγραφή των πραγμάτων σημαίνει κάτι περισσότερο από απλή τεχνική τεκμηρίωση. Κάθε φορά που νιώθετε την ανάγκη να γράψετε κάτι ή να συζητήσετε κατ' ιδίαν το έργο σας, αναρωτηθείτε αν μπορείτε να το δημοσιοποιήσετε.

Να είστε διαφανείς σχετικά με τον οδικό χάρτη του έργου σας, τα είδη των συνεισφορών που αναζητάτε, τον τρόπο εξέτασης των συνεισφορών ή τους λόγους για τους οποίους πήρατε ορισμένες αποφάσεις.

Αν παρατηρήσετε ότι πολλοί χρήστες αντιμετωπίζουν το ίδιο πρόβλημα, τεκμηριώστε τις απαντήσεις στο README.

Για συναντήσεις, σκεφτείτε να δημοσιεύσετε τις σημειώσεις ή τα συμπεράσματα σας σε ένα σχετικό θέμα. Η ανατροφοδότηση που θα λάβετε από αυτό το επίπεδο διαφάνειας μπορεί να σας εκπλήξει.

Η τεκμηρίωση των πάντων ισχύει και για την εργασία που κάνετε. Αν εργάζεστε σε μια ουσιαστική ενημέρωση του πρότζεκτ σας, βάλτε την σε ένα pull request και σημειώστε την ως εργασία σε εξέλιξη (WIP). Με αυτόν τον τρόπο, άλλοι άνθρωποι μπορούν να νιώσουν ότι συμμετέχουν στη διαδικασία από νωρίς.

### Να ανταποκρίνεστε

Καθώς [προωθείτε το έργο σας](../finding-users), οι άνθρωποι θα έχουν ανατροφοδότηση για εσάς. Μπορεί να έχουν ερωτήσεις σχετικά με το πώς λειτουργούν τα πράγματα ή να χρειάζονται βοήθεια για να ξεκινήσουν.

Προσπαθήστε να ανταποκρίνεστε όταν κάποιος καταθέτει ένα ζήτημα, υποβάλλει ένα αίτημα ή κάνει μια ερώτηση σχετικά με το πρότζεκτ σας. Όταν απαντάτε γρήγορα, οι άνθρωποι θα αισθάνονται ότι είναι μέρος ενός διαλόγου και θα είναι πιο ενθουσιώδεις για τη συμμετοχή τους.

Ακόμα και αν δεν μπορείτε να εξετάσετε το αίτημα αμέσως, η έγκαιρη αναγνώρισή του συμβάλλει στην αύξηση της δέσμευσης. Δείτε πώς απάντησε ο @tdreyno σε ένα pull request στο [Middleman](https://github.com/middleman/middleman/pull/1466):

![Middleman pull request](/assets/images/building-community/middleman_pr.png)

[Μια μελέτη της Mozilla διαπίστωσε ότι](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177) οι συνεισφέροντες που λάμβαναν αξιολογήσεις κώδικα (code reviews) εντός 48 ωρών είχαν πολύ υψηλότερο ποσοστό επιστροφής και επαναλαμβανόμενης συνεισφοράς.

Συζητήσεις σχετικά με το πρότζεκτ σας θα μπορούσαν επίσης να συμβαίνουν και σε άλλα μέρη του διαδικτύου, όπως το Stack Overflow, το Twitter ή το Reddit. Μπορείτε να ρυθμίσετε ειδοποιήσεις σε ορισμένα από αυτά τα μέρη, ώστε να ειδοποιείστε όταν κάποιος αναφέρει το πρότζεκτ σας.

### Δώστε στην κοινότητά σας ένα μέρος για να συγκεντρωθεί

Υπάρχουν δύο λόγοι για να δώσετε στην κοινότητά σας ένα μέρος για να συγκεντρωθεί.

Ο πρώτος λόγος είναι γι' αυτούς. Βοηθήστε τους ανθρώπους να γνωριστούν μεταξύ τους. Οι άνθρωποι με κοινά ενδιαφέροντα θα θέλουν αναπόφευκτα ένα μέρος για να μιλήσουν γι' αυτά. Και όταν η επικοινωνία είναι δημόσια και προσβάσιμη, ο καθένας μπορεί να διαβάσει τα αρχεία του παρελθόντος για να ενημερωθεί και να συμμετάσχει.

Ο δεύτερος λόγος είναι για εσάς. Αν δεν δώσετε στους ανθρώπους ένα δημόσιο μέρος για να μιλήσουν για το πρότζεκτ σας, πιθανότατα θα επικοινωνήσουν απευθείας μαζί σας. Στην αρχή, μπορεί να φαίνεται αρκετά εύκολο να απαντήσετε σε ιδιωτικά μηνύματα "μόνο αυτή τη φορά". Αλλά με την πάροδο του χρόνου, ειδικά αν το πρότζεκτ σας γίνει δημοφιλές, θα νιώσετε εξαντλημένοι. Αντισταθείτε στον πειρασμό να επικοινωνείτε με τους ανθρώπους για το πρότζεκτ σας ιδιωτικά. Αντ' αυτού, κατευθύνετέ τους σε ένα καθορισμένο δημόσιο κανάλι.

Η δημόσια επικοινωνία μπορεί να είναι τόσο απλή όσο το να κατευθύνετε τους ανθρώπους να ανοίξουν ένα θέμα αντί να σας στείλουν απευθείας email ή να σχολιάσουν στο ιστολόγιό σας. Θα μπορούσατε επίσης να δημιουργήσετε μια λίστα αλληλογραφίας ή έναν λογαριασμό στο Twitter, το Slack ή ένα κανάλι IRC για να συζητούν οι άνθρωποι για το πρότζεκτ σας. Ή δοκιμάστε όλα τα παραπάνω!

Το [Kubernetes kops](https://github.com/kubernetes/kops#getting-involved) ορίζει ώρες γραφείου κάθε δεύτερη εβδομάδα για να βοηθήσει τα μέλη της κοινότητας:

> Το Kops διαθέτει επίσης χρόνο που ορίζεται κάθε δεύτερη εβδομάδα για να προσφέρει βοήθεια και καθοδήγηση στην κοινότητα. Οι συντηρητές του Kops έχουν συμφωνήσει να ορίσουν χρόνο ειδικά αφιερωμένο στη συνεργασία με νεοεισερχόμενους, στη βοήθεια με PRs και στη συζήτηση νέων χαρακτηριστικών.

Αξιοσημείωτες εξαιρέσεις στη δημόσια επικοινωνία είναι: 1) θέματα ασφάλειας και 2) ευαίσθητες παραβιάσεις του κώδικα συμπεριφοράς. Θα πρέπει πάντα να έχετε έναν τρόπο για τους ανθρώπους να αναφέρουν αυτά τα ζητήματα ιδιωτικά. Αν δεν θέλετε να χρησιμοποιείτε το προσωπικό σας email, δημιουργήστε μια ειδική διεύθυνση email.

## Μεγαλώνοντας την κοινότητά σας

Οι κοινότητες είναι εξαιρετικά ισχυρές. Αυτή η δύναμη μπορεί να είναι ευλογία ή κατάρα, ανάλογα με τον τρόπο που την ασκείτε. Καθώς η κοινότητα του πρότζεκτ σας μεγαλώνει, υπάρχουν τρόποι να τη βοηθήσετε να γίνει μια δύναμη οικοδόμησης και όχι καταστροφής.

### Μην ανέχεστε τους κακούς φορείς

Κάθε δημοφιλές πρότζεκτ θα προσελκύσει αναπόφευκτα ανθρώπους που βλάπτουν, αντί να βοηθούν, την κοινότητά σας. Μπορεί να ξεκινήσουν περιττές συζητήσεις, να τσακωθούν για ασήμαντα χαρακτηριστικά ή να εκφοβίσουν άλλους.

Κάντε ό,τι μπορείτε για να υιοθετήσετε μια πολιτική μηδενικής ανοχής απέναντι σε αυτούς τους τύπους ανθρώπων. Αν δεν ελεγχθούν, οι αρνητικοί άνθρωποι θα κάνουν τους άλλους ανθρώπους της κοινότητάς σας να νιώθουν άβολα. Μπορεί ακόμη και να φύγουν.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/okdistribute?s=180" class="pquote-avatar" alt="avatar">
  Η αλήθεια είναι ότι η ύπαρξη μιας υποστηρικτικής κοινότητας είναι το κλειδί. Δεν θα μπορούσα ποτέ να κάνω αυτή τη δουλειά χωρίς τη βοήθεια των συναδέλφων μου, των φιλικών αγνώστων στο διαδίκτυο και των φλύαρων καναλιών IRC. (...) Μην συμβιβάζεστε με λιγότερα. Μην συμβιβάζεστε με μαλάκες.
  <p markdown="1" class="pquote-credit">
- @okdistribute, ["How to Run a FOSS Project"](https://okdistribute.xyz/post/okf-de)
  </p>
</aside>

Οι τακτικές συζητήσεις για ασήμαντες πτυχές του πρότζεκτ σας αποσπούν την προσοχή των άλλων, συμπεριλαμβανομένου και εσάς, από το να επικεντρωθούν σε σημαντικά καθήκοντα. Τα νέα άτομα που φτάνουν στο πρότζεκτ σας μπορεί να δουν αυτές τις συζητήσεις και να μην θέλουν να συμμετάσχουν.

Όταν βλέπετε αρνητική συμπεριφορά να συμβαίνει στο πρότζεκτ σας, φωνάξτε την δημόσια. Εξηγήστε, με ευγενικό αλλά αυστηρό τόνο, γιατί η συμπεριφορά τους δεν είναι αποδεκτή. Αν το πρόβλημα επιμένει, ίσως χρειαστεί να [τους ζητήσετε να φύγουν](../code-of-conduct/#επιβολή-του-κώδικα-συμπεριφοράς-σας). Ο [κώδικας δεοντολογίας](../code-of-conduct/) μπορεί να αποτελέσει εποικοδομητικό οδηγό για αυτές τις συζητήσεις.

### Συναντήστε τους συνεισφέροντες εκεί που βρίσκονται

Η καλή τεκμηρίωση γίνεται όλο και πιο σημαντική καθώς η κοινότητά σας μεγαλώνει. Οι περιστασιακοί συνεισφέροντες, οι οποίοι μπορεί διαφορετικά να μην είναι εξοικειωμένοι με το πρότζεκτ σας, διαβάζουν την τεκμηρίωσή σας για να αποκτήσουν γρήγορα το πλαίσιο που χρειάζονται.

Στο αρχείο σας CONTRIBUTING, πείτε ρητά στους νέους συνεισφέροντες πώς να ξεκινήσουν. Ίσως μάλιστα να θέλετε να φτιάξετε μια ειδική ενότητα για το σκοπό αυτό. Το [Django](https://github.com/django/django), για παράδειγμα, έχει μια ειδική σελίδα για να καλωσορίζει τους νέους συνεισφέροντες.

![Django new contributors page](/assets/images/building-community/django_new_contributors.png)

Στην ουρά θεμάτων σας, επισημάνετε σφάλματα που είναι κατάλληλα για διαφορετικούς τύπους συνεισφερόντων: για παράδειγμα, [_"μόνο για πρωτοεμφανιζόμενους"_](https://kentcdodds.com/blog/first-timers-only), _"καλό πρώτο θέμα"_, ή _"τεκμηρίωση"_. [Αυτές οι ετικέτες](https://github.com/librariesio/libraries.io/blob/6afea1a3354aef4672d9b3a9fc4cc308d60020c8/app/models/github_issue.rb#L8-L14) διευκολύνουν κάποιον νέο στο πρότζεκτ σας να σαρώσει γρήγορα τα θέματά σας και να ξεκινήσει.

Τέλος, χρησιμοποιήστε την τεκμηρίωσή σας για να κάνετε τους ανθρώπους να αισθάνονται ευπρόσδεκτοι σε κάθε βήμα της διαδικασίας.

Δεν θα αλληλεπιδράσετε ποτέ με τους περισσότερους ανθρώπους που θα βρεθούν στο πρότζεκτ σας. Μπορεί να υπάρξουν συνεισφορές που δεν λάβατε επειδή κάποιος ένιωσε εκφοβισμένος ή δεν ήξερε από πού να ξεκινήσει. Ακόμη και μερικά καλά λόγια μπορούν να αποτρέψουν κάποιον από το να εγκαταλείψει το πρότζεκτ σας απογοητευμένος.

Για παράδειγμα, να πώς ξεκινάει ο [Rubinius](https://github.com/rubinius/rubinius/) τον [οδηγό συνεισφοράς του](https://github.com/rubinius/rubinius/blob/HEAD/.github/contributing.md):

> Θέλουμε να ξεκινήσουμε λέγοντας σας ευχαριστούμε που χρησιμοποιείτε το Rubinius. Αυτό το πρότζεκτ είναι έργο αγάπης και εκτιμούμε όλους τους χρήστες που εντοπίζουν σφάλματα, κάνουν βελτιώσεις στην απόδοση και βοηθούν με την τεκμηρίωση. Κάθε συνεισφορά έχει νόημα, γι' αυτό σας ευχαριστούμε για τη συμμετοχή σας. Τούτου λεχθέντος, παραθέτουμε μερικές οδηγίες που σας ζητάμε να ακολουθήσετε ώστε να μπορέσουμε να αντιμετωπίσουμε με επιτυχία το πρόβλημά σας.

### Μοιραστείτε την ιδιοκτησία του πρότζεκτ σας

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/sagesharp?s=180" class="pquote-avatar" alt="avatar">
  Οι ηγέτες σας θα έχουν διαφορετικές απόψεις, όπως πρέπει να έχουν όλες οι υγιείς κοινότητες! Ωστόσο, πρέπει να λάβετε μέτρα για να διασφαλίσετε ότι η πιο δυνατή φωνή δεν κερδίζει πάντα, κουράζοντας τους ανθρώπους, και ότι ακούγονται οι λιγότερο εξέχουσες και μειονοτικές φωνές.
  <p markdown="1" class="pquote-credit">
- @sagesharp, ["What makes a good community?"](https://sage.thesharps.us/2015/10/06/what-makes-a-good-community/)
  </p>
</aside>

Οι άνθρωποι είναι ενθουσιασμένοι να συνεισφέρουν σε πρότζεκτς όταν αισθάνονται την αίσθηση της ιδιοκτησίας. Αυτό δεν σημαίνει ότι πρέπει να παραδώσετε το όραμα του πρότζεκτ σας ή να δεχτείτε συνεισφορές που δεν θέλετε. Αλλά όσο περισσότερο δίνετε τα εύσημα στους άλλους, τόσο περισσότερο θα παραμείνουν στο πρότζεκτ.

Δείτε αν μπορείτε να βρείτε τρόπους να μοιράζεστε την ιδιοκτησία με την κοινότητά σας όσο το δυνατόν περισσότερο. Ακολουθούν μερικές ιδέες:

* **Αποφύγετε την επιδιόρθωση εύκολων (μη κρίσιμων) σφαλμάτων.** Αντ' αυτού, χρησιμοποιήστε τα ως ευκαιρίες για να προσλάβετε νέους συνεισφέροντες ή να καθοδηγήσετε κάποιον που θα ήθελε να συνεισφέρει. Μπορεί να φαίνεται αφύσικο στην αρχή, αλλά η επένδυσή σας θα αποδώσει με την πάροδο του χρόνου. Για παράδειγμα, ο @michaeljoseph ζήτησε από έναν συνεργάτη να υποβάλει ένα pull request για ένα πρόβλημα [Cookiecutter](https://github.com/audreyr/cookiecutter) παρακάτω, αντί να το διορθώσει ο ίδιος.

![Cookiecutter issue](/assets/images/building-community/cookiecutter_submit_pr.png)

* **Ξεκινήστε ένα αρχείο CONTRIBUTORS ή AUTHORS στο πρότζκετ σας** το οποίο θα απαριθμεί όλους όσους έχουν συνεισφέρει στο πρότζεκτ σας, όπως κάνει το [Sinatra](https://github.com/sinatra/sinatra/blob/HEAD/AUTHORS.md).

* Αν έχετε μια σημαντική κοινότητα, **αποστείλετε ένα ενημερωτικό δελτίο ή γράψτε μια δημοσίευση στο ιστολόγιο** ευχαριστώντας τους συνεισφέροντες. Το [This Week in Rust](https://this-week-in-rust.org/) του Rust και το [Shoutouts](http://hood.ie/blog/shoutouts-week-24.html) του Hoodie είναι δύο καλά παραδείγματα.

* **Δώστε σε κάθε συνεισφέροντα πρόσβαση για commit.** Ο @felixge διαπίστωσε ότι αυτό έκανε τους ανθρώπους [πιο ενθουσιασμένους να γυαλίζουν τις διορθώσεις τους](https://felixge.de/2013/03/11/the-pull-request-hack.html), και βρήκε ακόμα και νέους συντηρητές για πρότζεκτ στα οποία δεν είχε δουλέψει για λίγο καιρό.

* Αν το πρότζεκτ σας είναι στο GitHub, **μεταφέρετε το πρότζκετ σας από τον προσωπικό σας λογαριασμό σε έναν [Οργανισμό](https://help.github.com/articles/creating-a-new-organization-account/)** και προσθέστε τουλάχιστον έναν εφεδρικό διαχειριστή. Οι οργανισμοί διευκολύνουν την εργασία σε πρότζεκτς με εξωτερικούς συνεργάτες.

Η πραγματικότητα είναι ότι [τα περισσότερα πρότζεκτς έχουν μόνο](https://peerj.com/preprints/1233/) έναν ή δύο συντηρητές που κάνουν την περισσότερη δουλειά. Όσο μεγαλύτερο είναι το πρότζεκτ σας και όσο μεγαλύτερη είναι η κοινότητά σας, τόσο πιο εύκολο είναι να βρείτε βοήθεια.

Παρόλο που μπορεί να μην βρίσκετε πάντα κάποιον να ανταποκριθεί στο κάλεσμα, το να στέλνετε ένα σήμα εκεί έξω αυξάνει τις πιθανότητες να βοηθήσουν και άλλοι άνθρωποι. Και όσο νωρίτερα ξεκινήσετε, τόσο νωρίτερα μπορούν να βοηθήσουν οι άνθρωποι.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gr2m?s=180" class="pquote-avatar" alt="avatar">
  \[Είναι προς το συμφέρον σας\] να προσλάβετε συνεργάτες που απολαμβάνουν και είναι ικανοί να κάνουν τα πράγματα που εσείς δεν κάνετε. Σας αρέσει να προγραμματίζετε, αλλά όχι να απαντάτε σε θέματα; Τότε εντοπίστε εκείνα τα άτομα στην κοινότητά σας που το κάνουν και αφήστε τα να το κάνουν.
  <p markdown="1" class="pquote-credit">
- @gr2m, ["Welcoming Communities"](http://hood.ie/blog/welcoming-communities.html)
  </p>
</aside>

## Επίλυση συγκρούσεων

Στα αρχικά στάδια του πρότζεκτ σας, η λήψη σημαντικών αποφάσεων είναι εύκολη. Όταν θέλετε να κάνετε κάτι, απλά το κάνετε.

Καθώς το πρότζεκτ σας γίνεται πιο δημοφιλές, περισσότεροι άνθρωποι θα ενδιαφέρονται για τις αποφάσεις που παίρνετε. Ακόμα και αν δεν έχετε μια μεγάλη κοινότητα συνεισφερόντων, αν το πρότζεκτ σας έχει πολλούς χρήστες, θα βρείτε ανθρώπους να συμμετέχουν στις αποφάσεις ή να θέτουν τα δικά τους ζητήματα.

Ως επί το πλείστον, αν έχετε καλλιεργήσει μια φιλική κοινότητα με σεβασμό και έχετε τεκμηριώσει ανοιχτά τις διαδικασίες σας, η κοινότητά σας θα μπορέσει να βρει λύση. Αλλά μερικές φορές συναντάτε ένα ζήτημα που είναι λίγο πιο δύσκολο να αντιμετωπιστεί.

### Ορίστε τον πήχη της ευγένειας

Όταν η κοινότητά σας παλεύει με ένα δύσκολο ζήτημα, τα πνεύματα μπορεί να ανέβουν. Οι άνθρωποι μπορεί να θυμώσουν ή να απογοητευτούν και να ξεσπάσουν ο ένας στον άλλον ή σε εσάς.

Η δουλειά σας ως συντηρητής είναι να αποτρέψετε την κλιμάκωση αυτών των καταστάσεων. Ακόμα και αν έχετε ισχυρή άποψη για το θέμα, προσπαθήστε να πάρετε τη θέση του συντονιστή ή του διευκολυντή, αντί να μπείτε στη μάχη και να προωθήσετε τις απόψεις σας. Αν κάποιος είναι αγενής ή μονοπωλεί τη συζήτηση, [δράστε αμέσως](../building-community/#μην-ανέχεστε-τους-κακούς-φορείς) για να διατηρήσετε τις συζητήσεις πολιτισμένες και παραγωγικές.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kennethreitz?s=180" class="pquote-avatar" alt="avatar">
  Ως συντηρητής ενός πρότζεκτ, είναι εξαιρετικά σημαντικό να σέβεστε τους συνεργάτες σας. Συχνά παίρνουν πολύ προσωπικά αυτά που λέτε.
  <p markdown="1" class="pquote-credit">
- @kennethreitz, ["Be Cordial or Be on Your Way"](https://web.archive.org/web/20200509154531/https://kenreitz.org/essays/be-cordial-or-be-on-your-way)
  </p>
</aside>

Άλλοι άνθρωποι αναζητούν από εσάς καθοδήγηση. Δώστε το καλό παράδειγμα. Μπορείτε ακόμα να εκφράσετε απογοήτευση, δυσαρέσκεια ή ανησυχία, αλλά να το κάνετε με ηρεμία.

Το να διατηρείτε την ψυχραιμία σας δεν είναι εύκολο, αλλά η επίδειξη ηγετικής ικανότητας βελτιώνει την υγεία της κοινότητάς σας. Το διαδίκτυο σας ευχαριστεί.

### Αντιμετωπίστε το README σας ως σύνταγμα

Το README σας είναι [κάτι περισσότερο από ένα σύνολο οδηγιών](../starting-a-project/#γράφοντας-ένα-readme). Είναι επίσης ένα μέρος για να μιλήσετε για τους στόχους σας, το όραμα του προϊόντος και τον οδικό χάρτη. Αν οι άνθρωποι επικεντρώνονται υπερβολικά στη συζήτηση για την αξία ενός συγκεκριμένου χαρακτηριστικού, μπορεί να βοηθήσει να επανεξετάσετε το README σας και να μιλήσετε για το ανώτερο όραμα του πρότζεκτ σας. Η εστίαση στο README σας αποπροσωποποιεί επίσης τη συζήτηση, ώστε να μπορείτε να έχετε μια εποικοδομητική συζήτηση.

### Επικεντρωθείτε στο ταξίδι, όχι στον προορισμό

Ορισμένα πρότζεκτ χρησιμοποιούν μια διαδικασία ψηφοφορίας για τη λήψη σημαντικών αποφάσεων. Αν και λογική με την πρώτη ματιά, η ψηφοφορία δίνει έμφαση στο να φτάσουμε σε μια "απάντηση", αντί να ακούτε και να αντιμετωπίζετε τις ανησυχίες του άλλου.

Η ψηφοφορία μπορεί να γίνει πολιτική, όπου τα μέλη της κοινότητας αισθάνονται πιεσμένα να κάνουν χάρες ο ένας στον άλλον ή να ψηφίσουν με συγκεκριμένο τρόπο. Επίσης, δεν ψηφίζουν όλοι, είτε πρόκειται για τη [σιωπηλή πλειοψηφία](https://ben.balter.com/2016/03/08/optimizing-for-power-users-and-edge-cases/#the-silent-majority-of-users) στην κοινότητά σας, είτε για σημερινούς χρήστες που δεν γνώριζαν ότι γινόταν ψηφοφορία.

Ορισμένες φορές, η ψηφοφορία είναι απαραίτητη για την ισοφάριση. Όσο μπορείτε, ωστόσο, δώστε έμφαση στην ["αναζήτηση συναίνεσης"](https://en.wikipedia.org/wiki/Consensus-seeking_decision-making) και όχι στη συναίνεση.

Στο πλαίσιο μιας διαδικασίας αναζήτησης συναίνεσης, τα μέλη της κοινότητας συζητούν τις σημαντικότερες ανησυχίες μέχρι να νιώσουν ότι έχουν ακουστεί επαρκώς. Όταν απομένουν μόνο δευτερεύουσες ανησυχίες, η κοινότητα προχωράει μπροστά. Η "αναζήτηση συναίνεσης" αναγνωρίζει ότι μια κοινότητα μπορεί να μην είναι σε θέση να καταλήξει σε μια τέλεια απάντηση. Αντιθέτως, δίνει προτεραιότητα στην ακρόαση και τη συζήτηση.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lee-dohm?s=180" class="pquote-avatar" alt="avatar">
  Ένα μέρος του λόγου για τον οποίο δεν υπάρχει ένα σύστημα ψηφοφορίας για τα θέματα Atom είναι επειδή η ομάδα Atom δεν πρόκειται να ακολουθήσει ένα σύστημα ψηφοφορίας σε όλες τις περιπτώσεις. Μερικές φορές πρέπει να επιλέγουμε αυτό που θεωρούμε σωστό ακόμα και αν δεν είναι δημοφιλές. (...) Αυτό που μπορώ να προσφέρω και δεσμεύομαι να κάνω... είναι ότι η δουλειά μου είναι να ακούω την κοινότητα.
  <p markdown="1" class="pquote-credit">
- @lee-dohm on Η διαδικασία λήψης αποφάσεων του Atom
  </p>
</aside>

Ακόμα και αν δεν υιοθετείτε στην πραγματικότητα μια διαδικασία αναζήτησης συναίνεσης, ως συντηρητής πρότζεκτ, είναι σημαντικό να γνωρίζουν οι άνθρωποι ότι ακούτε. Το να κάνετε τους άλλους ανθρώπους να αισθάνονται ότι ακούγονται και να δεσμεύεστε να επιλύσετε τις ανησυχίες τους, συμβάλλει σε μεγάλο βαθμό στην εκτόνωση των ευαίσθητων καταστάσεων. Στη συνέχεια, ακολουθήστε τα λόγια σας με πράξεις.

Μην βιάζεστε να πάρετε μια απόφαση για χάρη της επίλυσης. Βεβαιωθείτε ότι όλοι αισθάνονται ότι ακούγονται και ότι όλες οι πληροφορίες έχουν δημοσιοποιηθεί προτού προχωρήσετε προς μια λύση.

### Κρατήστε τη συζήτηση εστιασμένη στη δράση

Η συζήτηση είναι σημαντική, αλλά υπάρχει διαφορά μεταξύ παραγωγικών και μη παραγωγικών συζητήσεων.

Ενθαρρύνετε τη συζήτηση εφόσον κινείται ενεργά προς την κατεύθυνση της επίλυσης. Εάν είναι σαφές ότι η συζήτηση μαραζώνει ή ξεφεύγει από το θέμα, οι αιχμές γίνονται προσωπικές ή οι άνθρωποι τσακώνονται για ασήμαντες λεπτομέρειες, είναι καιρός να την κλείσετε.

Το να επιτρέπετε τη συνέχιση αυτών των συζητήσεων δεν είναι μόνο κακό για το συγκεκριμένο θέμα, αλλά και για την υγεία της κοινότητάς σας. Στέλνει το μήνυμα ότι αυτού του είδους οι συζητήσεις επιτρέπονται ή ακόμη και ενθαρρύνονται, και μπορεί να αποθαρρύνει τους ανθρώπους από το να εγείρουν ή να επιλύσουν μελλοντικά ζητήματα.

Με κάθε σημείο που διατυπώνεται από εσάς ή από άλλους, αναρωτηθείτε: _"Πώς αυτό μας φέρνει πιο κοντά σε μια λύση;"_

Εάν η συζήτηση αρχίζει να ξεφεύγει, ρωτήστε την ομάδα, _"Ποια βήματα πρέπει να ακολουθήσουμε στη συνέχεια;"_ για να επαναπροσανατολίσετε τη συζήτηση.

Εάν μια συζήτηση είναι σαφές ότι δεν οδηγεί πουθενά, δεν υπάρχουν σαφείς ενέργειες που πρέπει να γίνουν ή η κατάλληλη ενέργεια έχει ήδη γίνει, κλείστε το θέμα και εξηγήστε γιατί το κλείσατε.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  Το να καθοδηγείς ένα thread προς τη χρησιμότητα χωρίς να γίνεσαι πιεστικός είναι τέχνη. Δεν θα πετύχει αν απλά νουθετήσουμε τους ανθρώπους να σταματήσουν να σπαταλούν το χρόνο τους ή αν τους ζητήσουμε να μην γράφουν αν δεν έχουν κάτι εποικοδομητικό να πουν. (...) Αντ' αυτού, πρέπει να προτείνετε τις προϋποθέσεις για περαιτέρω πρόοδο: να δώσετε στους ανθρώπους μια διαδρομή, ένα μονοπάτι να ακολουθήσουν που οδηγεί στα αποτελέσματα που θέλετε, χωρίς όμως να ακούγεται σαν να υπαγορεύετε τη συμπεριφορά.
  <p markdown="1" class="pquote-credit">
- @kfogel, [_Producing OSS_](https://producingoss.com/en/producingoss.html#common-pitfalls)
  </p>
</aside>

### Διαλέξτε τις μάχες σας με σύνεση

Το πλαίσιο είναι σημαντικό. Σκεφτείτε ποιος συμμετέχει στη συζήτηση και πώς εκπροσωπεί την υπόλοιπη κοινότητα.

Είναι όλοι στην κοινότητα αναστατωμένοι ή έστω ασχολούνται με αυτό το θέμα; Ή είναι ένας μοναχικός ταραχοποιός; Μην ξεχνάτε να λαμβάνετε υπόψη τα σιωπηλά μέλη της κοινότητάς σας, όχι μόνο τις ενεργές φωνές.

Εάν το ζήτημα δεν αντιπροσωπεύει τις ευρύτερες ανάγκες της κοινότητάς σας, ίσως χρειαστεί απλώς να αναγνωρίσετε τις ανησυχίες μερικών ανθρώπων. Αν πρόκειται για επαναλαμβανόμενο ζήτημα χωρίς σαφή λύση, παραπέμψτε τους σε προηγούμενες συζητήσεις για το θέμα και κλείστε το thread.

### Προσδιορίστε ένα κριτήριο ισορροπίας της κοινότητας

Με καλή συμπεριφορά και σαφή επικοινωνία, οι περισσότερες δύσκολες καταστάσεις επιλύονται. Ωστόσο, ακόμη και σε μια παραγωγική συζήτηση, μπορεί απλώς να υπάρχει διάσταση απόψεων σχετικά με το πώς πρέπει να προχωρήσουμε. Σε αυτές τις περιπτώσεις, προσδιορίστε ένα άτομο ή μια ομάδα ατόμων που μπορεί να χρησιμεύσει ως ρυθμιστής ισορροπίας.

Ένας ισοβαθμιστής θα μπορούσε να είναι ο κύριος συντηρητής του πρότζεκτ, ή θα μπορούσε να είναι μια μικρή ομάδα ανθρώπων που λαμβάνει μια απόφαση βάσει ψηφοφορίας. Ιδανικά, έχετε προσδιορίσει έναν ισοβαθμιστή και τη σχετική διαδικασία σε ένα αρχείο GOVERNANCE πριν χρειαστεί ποτέ να το χρησιμοποιήσετε.

Η απόφαση ισοβαθμίας σας θα πρέπει να είναι η τελευταία λύση. Τα διχαστικά ζητήματα είναι μια ευκαιρία για την κοινότητά σας να αναπτυχθεί και να μάθει. Αγκαλιάστε αυτές τις ευκαιρίες και χρησιμοποιήστε μια συνεργατική διαδικασία για να προχωρήσετε σε λύση, όπου είναι δυνατόν.

## Η κοινότητα είναι η ❤️ του ανοιχτού κώδικα

Οι υγιείς, ακμάζουσες κοινότητες τροφοδοτούν τις χιλιάδες ώρες που αφιερώνονται στον ανοικτό κώδικα κάθε εβδομάδα. Πολλοί συνεισφέροντες επισημαίνουν άλλους ανθρώπους ως τον λόγο που εργάζονται - ή δεν εργάζονται - στον ανοικτό κώδικα. Μαθαίνοντας πώς να αξιοποιείτε εποικοδομητικά αυτή τη δύναμη, θα βοηθήσετε κάποιον εκεί έξω να έχει μια αξέχαστη εμπειρία ανοιχτού κώδικα.
