---
lang: el
title: Βέλτιστες Πρακτικές για Συντηρητές
description: Διευκολύνοντας την ζωή σας ως συντηρητής ανοιχτού κώδικα, από την τεκμηρίωση των διαδικασιών μέχρι και την αξιοποίηση της κοινότητάς σας.
class: best-practices
order: 5
image: /assets/images/cards/best-practices.png
related:
  - metrics
  - leadership
---

## Τι σημαίνει να είσαι συντηρητής;

Αν συντηρείτε ένα έργο ανοιχτού κώδικα που χρησιμοποιείται από πολλούς ανθρώπους, μπορεί να έχετε παρατηρήσει ότι προγραμματίζετε λιγότερο και απαντάτε περισσότερο σε ερωτήματα.

Στα αρχικά στάδια ενός πρότζεκτ, πειραματίζεστε με νέες ιδέες και παίρνετε αποφάσεις με βάση το τι θέλετε. Καθώς το έργο σας αυξάνει τη φήμη του, θα βρεθείτε να συνεργάζεστε περισσότερο με τους χρήστες και τους συνεισφορείς σας.

Η συντήρηση ενός έργου απαιτεί κάτι περισσότερο από κώδικα. Αυτές οι εργασίες είναι συχνά απροσδόκητες, αλλά είναι εξίσου σημαντικές για ένα αναπτυσσόμενο πρότζεκτ. Συγκεντρώσαμε μερικούς τρόπους για να κάνετε τη ζωή σας ευκολότερη, από την τεκμηρίωση των διαδικασιών μέχρι την αξιοποίηση της κοινότητάς σας.

## Τεκμηριώνοντας τις διαδικασίες σας

Η καταγραφή των πραγμάτων είναι ένα από τα πιο σημαντικά πράγματα που μπορείτε να κάνετε ως συντηρητής.

Η τεκμηρίωση του πρότζεκτ όχι μόνο αποσαφηνίζει τη δική σας σκέψη, αλλά βοηθάει και τους άλλους να καταλάβουν τι χρειάζεστε ή τι περιμένετε, πριν καν ρωτήσουν.

Η καταγραφή των πραγμάτων καθιστά ευκολότερο να λέτε όχι όταν κάτι δεν ταιριάζει στο πεδίο εφαρμογής σας. Επίσης, διευκολύνει τους άλλους να συνεισφέρουν και να βοηθήσουν. Ποτέ δεν ξέρετε ποιος μπορεί να διαβάσει ή να χρησιμοποιήσει το έργο σας.

Ακόμα και αν δεν χρησιμοποιείτε ολόκληρες παραγράφους, το να σημειώνετε πράγματα με bullet points είναι καλύτερο από το να μην γράφετε τίποτα.

Να θυμάστε να διατηρείτε την τεκμηρίωσή σας ενημερωμένη. Αν δεν μπορείτε να το κάνετε πάντα αυτό, διαγράψτε την ξεπερασμένη τεκμηρίωσή σας ή αναφέρετε ότι είναι ξεπερασμένη, ώστε οι συνεισφέροντες να γνωρίζουν ότι οι ενημερώσεις είναι ευπρόσδεκτες.

### Καταγράψτε το όραμα του πρότζεκτ σας

Ξεκινήστε γράφοντας τους στόχους του έργου σας. Προσθέστε τους στο αρχείο README ή δημιουργήστε ένα ξεχωριστό αρχείο με το όνομα VISION. Αν υπάρχουν άλλα αντικείμενα που θα μπορούσαν να βοηθήσουν, όπως ένας χάρτης πορείας του έργου, δημοσιοποιήστε και αυτά.

Η ύπαρξη ενός σαφούς, τεκμηριωμένου οράματος σας κρατάει εστιασμένους και σας βοηθά να αποφύγετε τον "ερπυσμό του πεδίου εφαρμογής" από τις συνεισφορές των άλλων.

Για παράδειγμα, ο @lord διαπίστωσε ότι η ύπαρξη ενός οράματος έργου τον βοήθησε να καταλάβει σε ποια αιτήματα να αφιερώσει χρόνο. Ως νέος συντηρητής, μετάνιωσε που δεν τήρησε το πεδίο εφαρμογής του έργου του, όταν έλαβε το πρώτο του αίτημα για μία νέα λειτορυγία για το [Slate](https://github.com/lord/slate).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lord?s=180" class="pquote-avatar" alt="avatar">
  Τα έκανα μαντάρα. Δεν κατέβαλα προσπάθεια για να βρω μια ολοκληρωμένη λύση. Αντί για μια μισή λύση, θα ήθελα να είχα πει "Δεν έχω χρόνο γι' αυτό τώρα, αλλά θα το προσθέσω στη μακροπρόθεσμη λίστα των καλών-αν-υπήρχαν πραγμάτων".
  <p markdown="1" class="pquote-credit">
— @lord, ["Tips for new open source maintainers"](https://lord.io/blog/2014/oss-tips/)
  </p>
</aside>

### Επικοινωνήστε τις προσδοκίες σας

Οι κανόνες μπορεί να είναι νευραλγικοί για να τους γράψετε. Μερικές φορές μπορεί να αισθάνεστε ότι αστυνομεύετε τη συμπεριφορά των άλλων ή ότι σκοτώνετε όλη τη διασκέδαση.

Γραμμένοι και επιβαλλόμενοι δίκαια, ωστόσο, οι καλοί κανόνες ενδυναμώνουν τους συντηρητές. Σας αποτρέπουν από το να σας παρασύρουν να κάνετε πράγματα που δεν θέλετε.

Οι περισσότεροι άνθρωποι που έρχονται σε επαφή με το πρότζεκτ σας δεν γνωρίζουν τίποτα για εσάς ή τις συνθήκες που επικρατούν. Μπορεί να υποθέσουν ότι πληρώνεστε για να εργάζεστε σε αυτό, ειδικά αν πρόκειται για κάτι που χρησιμοποιούν τακτικά και από το οποίο εξαρτώνται. Ίσως κάποια στιγμή αφιερώσατε πολύ χρόνο στο πρότζεκτ σας, αλλά τώρα είστε απασχολημένοι με μια νέα δουλειά ή ένα νέο μέλος της οικογένειας.

Όλα αυτά είναι απολύτως εντάξει! Απλώς βεβαιωθείτε ότι οι άλλοι άνθρωποι το γνωρίζουν.

Αν η συντήρηση του έργου σας γίνεται με μερική απασχόληση ή καθαρά εθελοντικά, να είστε ειλικρινείς σχετικά με το πόσο χρόνο διαθέτετε. Αυτό δεν είναι το ίδιο με το πόσο χρόνο νομίζετε ότι απαιτεί το έργο ή πόσο χρόνο θέλουν οι άλλοι να ξοδέψετε.

Ακολουθούν μερικοί κανόνες που αξίζει να καταγράψετε:

* Πώς μια συνεισφορά εξετάζεται και γίνεται αποδεκτή (_Χρειάζονται δοκιμές; Ένα πρότυπο θέματος;_)
* Τα είδη των συνεισφορών που θα δεχτείτε (_Θέλετε βοήθεια μόνο για ένα συγκεκριμένο μέρος του κώδικά σας;_)
* Πότε είναι σκόπιμο να δώσετε συνέχεια (_για παράδειγμα, "Μπορείτε να περιμένετε απάντηση από έναν συντηρητή εντός 7 ημερών. Αν δεν έχετε ακούσει τίποτα μέχρι τότε, μπορείτε να στείλετε μήνυμα στο νήμα."_)
* Πόσο χρόνο αφιερώνετε στο έργο (_για παράδειγμα, "Ξοδεύουμε μόνο περίπου 5 ώρες την εβδομάδα σε αυτό το έργο"_)

Το [Jekyll](https://github.com/jekyll/jekyll/tree/master/docs), [CocoaPods](https://github.com/CocoaPods/CocoaPods/wiki/Communication-&-Design-Rules), και το [Homebrew](https://github.com/Homebrew/brew/blob/bbed7246bc5c5b7acb8c1d427d10b43e090dfd39/docs/Maintainers-Avoiding-Burnout.md) είναι κάποια παραδείγματα από πρότζεκτ με κανόνες για τους συντηρητές και τους συνεισφέροντες.

### Κρατήστε την επικοινωνία δημόσια

Μην ξεχνάτε επίσης να τεκμηριώνετε τις αλληλεπιδράσεις σας. Όπου μπορείτε, κρατήστε την επικοινωνία σχετικά με το πρότζεκτ σας δημόσια. Αν κάποιος προσπαθήσει να επικοινωνήσει μαζί σας ιδιαιτέρως για να συζητήσει ένα αίτημα χαρακτηριστικών ή μια ανάγκη υποστήριξης, κατευθύνετε τον ευγενικά σε ένα δημόσιο κανάλι επικοινωνίας, όπως μια λίστα αλληλογραφίας ή έναν ανιχνευτή προβλημάτων.

Εάν συναντηθείτε με άλλους συντηρητές ή λάβετε μια σημαντική απόφαση ιδιωτικά, τεκμηριώστε αυτές τις συζητήσεις δημόσια, ακόμη και αν πρόκειται απλώς για την ανάρτηση των σημειώσεών σας.

Με αυτόν τον τρόπο, όποιος προσχωρεί στην κοινότητά σας θα έχει πρόσβαση στις ίδιες πληροφορίες με κάποιον που είναι εκεί για χρόνια.

## Μαθαίνοντας να λέτε όχι

Έχετε καταγράψει τα πράγματα. Ιδανικά, όλοι θα διάβαζαν το έγγραφο τεκμηρίωσής σας, αλλά στην πραγματικότητα, θα πρέπει να υπενθυμίζετε στους άλλους ότι υπάρχει αυτή η γνώση.

Το να έχετε τα πάντα καταγεγραμμένα, ωστόσο, βοηθά στην αποπροσωποποίηση των καταστάσεων όταν χρειάζεται να επιβάλλετε τους κανόνες σας.

Το να λέτε όχι δεν έχει πλάκα, αλλά _"Η συνεισφορά σας δεν ταιριάζει με τα κριτήρια αυτού του έργου"_ μοιάζει λιγότερο προσωπικό από το _"Δεν μου αρέσει η συνεισφορά σας"_.

Το να λέτε όχι ισχύει σε πολλές περιπτώσεις που θα συναντήσετε ως συντηρητής: αιτήσεις για χαρακτηριστικά που δεν ταιριάζουν στο πεδίο εφαρμογής, κάποιος που εκτροχιάζει μια συζήτηση, που κάνει περιττή δουλειά για άλλους.

### Κρατήστε τη συζήτηση φιλική

Ένα από τα πιο σημαντικά μέρη που θα εξασκηθείτε στο να λέτε όχι είναι στην ουρά των ζητημάτων και των αιτημάτων (issues and pull requests). Ως συντηρητής έργου, αναπόφευκτα θα λάβετε προτάσεις που δεν θέλετε να δεχτείτε.

Ίσως η συνεισφορά να αλλάζει το πεδίο εφαρμογής του έργου σας ή να μην ταιριάζει με το όραμά σας. Ίσως η ιδέα είναι καλή, αλλά η υλοποίηση είναι φτωχή.

Ανεξάρτητα από τον λόγο, είναι δυνατόν να χειριστείτε με διακριτικότητα τις συνεισφορές που δεν ανταποκρίνονται στα πρότυπα του έργου σας.

Αν λάβετε μια συνεισφορά που δεν θέλετε να αποδεχτείτε, η πρώτη σας αντίδραση μπορεί να είναι να την αγνοήσετε ή να προσποιηθείτε ότι δεν την είδατε. Κάτι τέτοιο θα μπορούσε να πληγώσει τα αισθήματα του άλλου ατόμου και να αποθαρρύνει ακόμη και άλλους πιθανούς συνεισφέροντες στην κοινότητά σας.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/krausefx?s=180" class="pquote-avatar" alt="avatar">
  Το κλειδί για τον χειρισμό της υποστήριξης πρότζεκτ ανοιχτού κώδικα μεγάλης κλίμακας είναι η συνεχής λύση των θεμάτων. Προσπαθήστε να αποφύγετε την καθυστέρηση των θεμάτων. Αν είστε προγραμματιστής iOS ξέρετε πόσο απογοητευτικό μπορεί να είναι να υποβάλλετε radars. Μπορεί να λάβετε απάντηση 2 χρόνια αργότερα και να σας πουν να προσπαθήσετε ξανά με την τελευταία έκδοση του iOS.
  <p markdown="1" class="pquote-credit">
— @KrauseFx, ["Scaling open source communities"](https://krausefx.com/blog/scaling-open-source-communities)
  </p>
</aside>

Μην αφήνετε μια ανεπιθύμητη συνεισφορά ανοιχτή επειδή αισθάνεστε ένοχοι ή επειδή θέλετε να είστε ευγενικοί. Με την πάροδο του χρόνου, τα αναπάντητα ζητήματα και αιτήματα θα κάνουν την εργασία στο έργο σας να μοιάζει πολύ πιο αγχωτική και εκφοβιστική.

Είναι προτιμότερο να κλείνετε αμέσως τις συνεισφορές που ξέρετε ότι δεν θέλετε να δεχτείτε. Αν το έργο σας πάσχει ήδη από ένα μεγάλο ανεκτέλεστο, ο @steveklabnik έχει προτάσεις για το [πώς να ταξινομείτε αποτελεσματικά τα θέματα](https://words.steveklabnik.com/how-to-be-an-open-source-gardener).

Δεύτερον, η αγνόηση συνεισφορών στέλνει ένα αρνητικό μήνυμα στην κοινότητά σας. Η συνεισφορά σε ένα έργο μπορεί να είναι εκφοβιστική, ειδικά αν είναι η πρώτη φορά που κάποιος συνεισφέρει. Ακόμα και αν δεν αποδεχτείτε τη συνεισφορά του, αναγνωρίστε το άτομο που βρίσκεται πίσω από αυτή και ευχαριστήστε το για το ενδιαφέρον του. Είναι ένα μεγάλο κομπλιμέντο!

Εάν δεν θέλετε να δεχτείτε μια συνεισφορά:

* **Ευχαριστήστε τους** για τη συνεισφορά τους
* **Εξηγήστε γιατί δεν ταιριάζει** στο πεδίο εφαρμογής του έργου, και προσφέρετε σαφείς προτάσεις βελτίωσης, αν είστε σε θέση. Να είστε ευγενικοί, αλλά σταθεροί.
* **Να παραπέμψετε σε σχετική τεκμηρίωση**, αν την έχετε. Εάν παρατηρήσετε επαναλαμβανόμενες αιτήσεις για πράγματα που δεν θέλετε να δεχτείτε, προσθέστε τα στην τεκμηρίωσή σας για να αποφύγετε την επανάληψη.
* **Κλείστε το αίτημα**

Δεν θα πρέπει να χρειάζεστε περισσότερες από 1-2 προτάσεις για να απαντήσετε. Για παράδειγμα, όταν ένας χρήστης του [celery](https://github.com/celery/celery/) ανέφερε ένα σφάλμα σχετικό με τα Windows, ο @berkerpeksag [απάντησε με](https://github.com/celery/celery/issues/3383):

![Celery screenshot](/assets/images/best-practices/celery.png)

Αν η σκέψη να πείτε όχι σας τρομάζει, δεν είστε οι μόνοι. Όπως [το έθεσε](https://blog.jessfraz.com/post/the-art-of-closing/) ο @jessfraz:

> Έχω μιλήσει με συντηρητές από διάφορα πρότζεκτς ανοιχτού κώδικα, Mesos, Kubernetes, Chromium, και όλοι συμφωνούν ότι ένα από τα δυσκολότερα μέρη του να είσαι συντηρητής είναι να λέει κανείς "Όχι" σε patches που δεν θέλεις.

Μην αισθάνεστε ένοχοι που δεν θέλετε να αποδεχτείτε την συνεισφορά κάποιου. Ο πρώτος κανόνας του ανοιχτού κώδικα, [σύμφωνα με τον](https://twitter.com/solomonstre/status/715277134978113536) @shykes: _"Το όχι είναι προσωρινό, το ναι είναι παντοτινό."_ Ενώ η κατανόηση του ενθουσιασμού ενός άλλου ατόμου είναι καλό πράγμα, η απόρριψη μιας συνεισφοράς δεν είναι το ίδιο με την απόρριψη του ατόμου πίσω από αυτήν.

Σε τελική ανάλυση, αν μια συνεισφορά δεν είναι αρκετά καλή, δεν είστε υποχρεωμένοι να την αποδεχτείτε. Να είστε ευγενικοί και να ανταποκρίνεστε όταν οι άνθρωποι συνεισφέρουν στο έργο σας, αλλά να δέχεστε μόνο τις αλλαγές που πραγματικά πιστεύετε ότι θα κάνουν το έργο σας καλύτερο. Όσο πιο συχνά εξασκείστε στο να λέτε όχι, τόσο πιο εύκολο γίνεται. Υπόσχεση.

### Να είστε προνοητικοί

Για να μειώσετε εξαρχής τον όγκο των ανεπιθύμητων συνεισφορών, εξηγήστε τη διαδικασία του έργου σας για την υποβολή και την αποδοχή συνεισφορών στον οδηγό συνεισφοράς σας.

Αν λαμβάνετε πάρα πολλές συνεισφορές χαμηλής ποιότητας, απαιτήστε από τους συνεισφέροντες να κάνουν λίγη δουλειά εκ των προτέρων, για παράδειγμα:

* Συμπλήρωση ενός ζητήματος (issue) ή έναν κατάλογο αιτήματος (pull request)
* Άνοιγμα ζητήματος πριν την υποβολή ενός αιτήματος

Αν δεν τηρούν τους κανόνες σας, κλείστε αμέσως το θέμα και παραπέμψτε στην τεκμηρίωσή σας.

Αν και αυτή η προσέγγιση μπορεί να σας φανεί αγενής στην αρχή, το να είστε προληπτικοί είναι στην πραγματικότητα καλό και για τα δύο μέρη. Μειώνει την πιθανότητα κάποιος να αφιερώσει πολλές χαμένες ώρες εργασίας σε ένα pull request που δεν πρόκειται να αποδεχτείτε. Και καθιστά ευκολότερη τη διαχείριση του φόρτου εργασίας σας.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikemcquaid?s=180" class="pquote-avatar" alt="avatar">
  Ιδανικά, εξηγήστε τους και σε ένα αρχείο CONTRIBUTING.md πώς μπορούν να πάρουν μια καλύτερη ένδειξη στο μέλλον για το τι θα γίνει ή δεν θα γίνει αποδεκτό πριν ξεκινήσουν την εργασία.
  <p markdown="1" class="pquote-credit">
— @MikeMcQuaid, ["Kindly Closing Pull Requests"](https://github.com/blog/2124-kindly-closing-pull-requests)
  </p>
</aside>

Μερικές φορές, όταν λέτε όχι, ο πιθανός συνεισφορέας σας μπορεί να εκνευριστεί ή να επικρίνει την απόφασή σας. Αν η συμπεριφορά του γίνει εχθρική, [λάβετε μέτρα για να εκτονώσετε την κατάσταση](https://github.com/jonschlinkert/maintainers-guide-to-staying-positive#action-items) ή ακόμα και να τον απομακρύνετε από την κοινότητά σας, αν δεν είναι πρόθυμος να συνεργαστεί εποικοδομητικά.

### Αποδεχτείτε την καθοδήγηση

Ίσως κάποιος στην κοινότητά σας υποβάλλει τακτικά συνεισφορές που δεν ανταποκρίνονται στα πρότυπα του έργου σας. Μπορεί να είναι απογοητευτικό και για τα δύο μέρη να περνούν επανειλημμένα από απορρίψεις.

Αν δείτε ότι κάποιος είναι ενθουσιασμένος με το έργο σας, αλλά χρειάζεται λίγη βελτίωση, κάντε υπομονή. Εξηγήστε με σαφήνεια σε κάθε περίπτωση γιατί οι συνεισφορές τους δεν ανταποκρίνονται στις προσδοκίες του έργου. Προσπαθήστε να τους υποδείξετε μια πιο εύκολη ή λιγότερο ασαφή εργασία, όπως ένα ζήτημα με την ένδειξη _"καλό πρώτο ζήτημα",_ για να αρχίσουν να συμμετέχουν. Αν έχετε χρόνο, σκεφτείτε να τους καθοδηγήσετε κατά την πρώτη τους συνεισφορά ή βρείτε κάποιον άλλον στην κοινότητά σας που θα μπορούσε να είναι πρόθυμος να τους καθοδηγήσει.

## Αξιοποιήστε την κοινότητά σας

Δεν χρειάζεται να κάνετε τα πάντα μόνοι σας. Η κοινότητα του έργου σας υπάρχει για κάποιο λόγο! Ακόμα και αν δεν έχετε ακόμα μια ενεργή κοινότητα συνεισφερόντων, αν έχετε πολλούς χρήστες, βάλτε τους να δουλέψουν.

### Μοιραστείτε το φόρτο εργασίας

Αν ψάχνετε για άλλους να συνεισφέρουν, ξεκινήστε ρωτώντας γύρω σας.

Ένας τρόπος για να κερδίσετε νέους συνεισφέροντες είναι να επισημάνετε ρητά [θέματα που είναι αρκετά απλά για να τα αντιμετωπίσουν οι αρχάριοι](https://help.github.com/en/articles/helping-new-contributors-find-your-project-with-labels). Στη συνέχεια, το GitHub θα εμφανίσει αυτά τα ζητήματα σε διάφορα σημεία της πλατφόρμας, αυξάνοντας την προβολή τους.

Όταν βλέπετε νέους συνεισφέροντες να κάνουν επαναλαμβανόμενες συνεισφορές, αναγνωρίστε το έργο τους προσφέροντας περισσότερες ευθύνες. Τεκμηριώστε τον τρόπο με τον οποίο οι άλλοι μπορούν να εξελιχθούν σε ηγετικούς ρόλους αν το επιθυμούν.

Το να ενθαρρύνετε τους άλλους να [μοιράζονται την ιδιοκτησία του έργου](../building-community/#μοιραστείτε-την-ιδιοκτησία-του-πρότζεκτ-σας) μπορεί να μειώσει σημαντικά τον δικό σας φόρτο εργασίας, όπως ανακάλυψε η @lmccart στο έργο της, [p5.js](https://github.com/processing/p5.js).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lmccart?s=180" class="pquote-avatar" alt="avatar">
  Έλεγα, "Ναι, ο καθένας μπορεί να συμμετάσχει, δεν χρειάζεται να έχεις μεγάλη εμπειρία στον προγραμματισμό [...]". Είχαμε ανθρώπους που δήλωναν συμμετοχή [σε μια εκδήλωση] και τότε ήταν που πραγματικά αναρωτήθηκα: είναι αλήθεια αυτό που έλεγα; Θα εμφανιστούν 40 άτομα και δεν είναι ότι μπορώ να καθίσω με τον καθένα τους... Αλλά οι άνθρωποι συγκεντρώθηκαν και κατά κάποιο τρόπο λειτούργησε. Μόλις ένα άτομο το καταλάβαινε, μπορούσε να διδάξει τον διπλανό του.
  <p markdown="1" class="pquote-credit">
—  @lmccart, ["What Does "Open Source" Even Mean? p5.js Edition"](https://medium.com/@kenjagan/what-does-open-source-even-mean-p5-js-edition-98c02d354b39)
  </p>
</aside>

Αν χρειαστεί να αποχωρήσετε από το έργο σας, είτε για διακοπή είτε μόνιμα, δεν είναι ντροπή να ζητήσετε από κάποιον άλλον να αναλάβει τη θέση σας.

Αν άλλοι άνθρωποι είναι ενθουσιασμένοι με την κατεύθυνσή του, δώστε τους δεσμευτική πρόσβαση ή παραδώστε επίσημα τον έλεγχο σε κάποιον άλλον. Αν κάποιος έχει διακλαδίσει το έργο σας (fork) και το συντηρεί ενεργά αλλού, σκεφτείτε το ενδεχόμενο να παραπέμψετε στη διακλάδωση από το αρχικό σας έργο. Είναι σπουδαίο που τόσοι πολλοί άνθρωποι θέλουν να συνεχίσει το έργο σας να ζει!

Ο @progrium [διαπίστωσε ότι](https://web.archive.org/web/20151204215958/https://progrium.com/blog/2015/12/04/leadership-guilt-and-pull-requests/) καταγράφοντας το όραμα για το έργο του, [Dokku](https://github.com/dokku/dokku), βοήθησε αυτούς τους στόχους να συνεχίσουν να ζουν ακόμα και μετά την αποχώρησή του από το έργο:

> Έγραψα μια σελίδα wiki που περιέγραφε τι ήθελα και γιατί το ήθελα. Για κάποιο λόγο με εξέπληξε το γεγονός ότι οι συντηρητές άρχισαν να κινούν το πρότζεκτ προς αυτή την κατεύθυνση! Συνέβη ακριβώς όπως θα το έκανα εγώ; Όχι πάντα. Αλλά και πάλι έφερε το έργο πιο κοντά σε αυτό που έγραψα.

### Αφήστε τους άλλους να φτιάξουν τις λύσεις που χρειάζονται

Αν ένας πιθανός συνεισφέροντας έχει διαφορετική άποψη για το τι πρέπει να κάνει το έργο σας, ίσως θελήσετε να τον ενθαρρύνετε απαλά να δουλέψει στο δικό του fork.

Η διακλάδωση ενός έργου δεν χρειάζεται να είναι κάτι κακό. Η δυνατότητα αντιγραφής και τροποποίησης έργων είναι ένα από τα καλύτερα πράγματα στον ανοικτό κώδικα. Το να ενθαρρύνετε τα μέλη της κοινότητάς σας να εργαστούν στη δική τους διακλάδωση μπορεί να τους προσφέρει τη δημιουργική διέξοδο που χρειάζονται, χωρίς να έρχεται σε σύγκρουση με το όραμα του έργου σας.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/geerlingguy?s=180" class="pquote-avatar" alt="avatar">
  Εξυπηρετώ το 80% των περιπτώσεων χρήσης. Αν είστε ένας από τους μονόκερους, παρακαλείσθε να κάνετε fork τη δουλειά μου. Δεν θα προσβληθώ! Τα δημόσια πρότζεκτ μου προορίζονται σχεδόν πάντα για την επίλυση των πιο συνηθισμένων προβλημάτων- προσπαθώ να διευκολύνω την εμβάθυνση, είτε με το να κάνω fork το πρότζεκτ μου είτε με το να το επεκτείνω.
  <p markdown="1" class="pquote-credit">
- @geerlingguy, ["Why I Close PRs"](https://www.jeffgeerling.com/blog/2016/why-i-close-prs-oss-project-maintainer-notes)
  </p>
</aside>

Το ίδιο ισχύει και για έναν χρήστη που θέλει πραγματικά μια λύση την οποία απλά δεν έχετε το εύρος ζώνης για να κατασκευάσετε. Η προσφορά APIs και customization hooks μπορεί να βοηθήσει τους άλλους να ικανοποιήσουν τις δικές τους ανάγκες, χωρίς να χρειάζεται να τροποποιήσουν άμεσα τον πηγαίο κώδικα. Ο @orta [διαπίστωσε ότι](https://artsy.github.io/blog/2016/07/03/handling-big-projects/) η ενθάρρυνση των plugins για τα CocoaPods οδήγησε σε "μερικές από τις πιο ενδιαφέρουσες ιδέες":

> Είναι σχεδόν αναπόφευκτο ότι μόλις ένα πρότζεκτ γίνει μεγάλο, οι συντηρητές πρέπει να γίνουν πολύ πιο συντηρητικοί σχετικά με το πώς εισάγουν νέο κώδικα. Γίνεστε καλοί στο να λέτε "όχι", αλλά πολλοί άνθρωποι έχουν νόμιμες ανάγκες. Οπότε, αντί γι' αυτό, καταλήγετε να μετατρέψετε το εργαλείο σας σε πλατφόρμα.

## Φέρτε τα ρομπότ

Όπως ακριβώς υπάρχουν εργασίες στις οποίες μπορούν να σας βοηθήσουν άλλοι άνθρωποι, έτσι υπάρχουν και εργασίες που δεν θα έπρεπε ποτέ να κάνει κανένας άνθρωπος. Τα ρομπότ είναι οι φίλοι σας. Χρησιμοποιήστε τα για να κάνετε τη ζωή σας ως συντηρητής ευκολότερη.

### Απαιτήστε δοκιμές και άλλους ελέγχους για να βελτιώσετε την ποιότητα του κώδικά σας

Ένας από τους σημαντικότερους τρόπους με τους οποίους μπορείτε να αυτοματοποιήσετε το πρότζεκτ σας είναι η προσθήκη δοκιμών (tests).

Οι δοκιμές βοηθούν τους συνεισφέροντες να αισθάνονται σίγουροι ότι δεν θα χαλάσουν τίποτα. Επίσης, σας διευκολύνουν να αναθεωρείτε και να αποδέχεστε γρήγορα τις συνεισφορές. Όσο πιο ευέλικτοι είστε, τόσο πιο αφοσιωμένη μπορεί να είναι η κοινότητά σας.

Ορίστε αυτόματες δοκιμές που θα εκτελούνται σε όλες τις εισερχόμενες συνεισφορές και βεβαιωθείτε ότι οι δοκιμές σας μπορούν εύκολα να εκτελούνται τοπικά από τους συνεισφέροντες. Απαιτήστε ότι όλες οι συνεισφορές κώδικα περνούν τις δοκιμές σας πριν υποβληθούν. Θα βοηθήσετε στον καθορισμό ενός ελάχιστου προτύπου ποιότητας για όλες τις υποβολές. Οι [Απαιτούμενοι έλεγχοι κατάστασης](https://help.github.com/articles/about-required-status-checks/) στο GitHub μπορούν να βοηθήσουν να διασφαλιστεί ότι καμία αλλαγή δεν συγχωνεύεται χωρίς να έχουν περάσει οι δοκιμές σας.

Αν προσθέσετε δοκιμές, φροντίστε να εξηγήσετε πώς λειτουργούν στο αρχείο CONTRIBUTING.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/edunham?s=180" class="pquote-avatar" alt="avatar">
  Πιστεύω ότι οι δοκιμές είναι απαραίτητες για όλο τον κώδικα που δουλεύουν οι άνθρωποι. Αν ο κώδικας ήταν πλήρως και απόλυτα σωστός, δεν θα χρειαζόταν αλλαγές - γράφουμε κώδικα μόνο όταν κάτι είναι λάθος, είτε αυτό σημαίνει ότι "Καταρρέει" είτε ότι "Του λείπει το τάδε χαρακτηριστικό". Και ανεξαρτήτως των αλλαγών που κάνετε, οι δοκιμές είναι απαραίτητες για να πιάνετε τυχόν παλινδρομήσεις που μπορεί να εισαγάγετε κατά λάθος.
  <p markdown="1" class="pquote-credit">
- @edunham, ["Rust's Community Automation"](https://edunham.net/2016/09/27/rust_s_community_automation.html)
  </p>
</aside>

### Χρησιμοποιήστε εργαλεία για την αυτοματοποίηση βασικών εργασιών συντήρησης

Τα καλά νέα σχετικά με τη συντήρηση ενός δημοφιλούς πρότζεκτ είναι ότι άλλοι συντηρητές έχουν πιθανότατα αντιμετωπίσει παρόμοια ζητήματα και έχουν κατασκευάσει μια λύση για αυτά.

Υπάρχει μια [ποικιλία διαθέσιμων εργαλείων](https://github.com/showcases/tools-for-open-source) που βοηθούν στην αυτοματοποίηση ορισμένων πτυχών των εργασιών συντήρησης. Μερικά παραδείγματα:

* Το [semantic-release](https://github.com/semantic-release/semantic-release) αυτοματοποιεί τις εκδόσεις σας
* Το [mention-bot](https://github.com/facebook/mention-bot) αναφέρει πιθανούς αναθεωρητές (reviewers) για τα pull requests
* Το [Danger](https://github.com/danger/danger) βοηθά στην αυτοματοποίηση της αναθεώρησης κώδικα (code review)
* Το [no-response](https://github.com/probot/no-response) κλείνει θέματα στα οποία ο συγγραφέας δεν έχει απαντήσει σε ένα αίτημα για περισσότερες πληροφορίες
* Το [dependabot](https://github.com/dependabot) ελέγχει τα αρχεία εξαρτήσεων σας κάθε μέρα για ξεπερασμένες απαιτήσεις και ανοίγει μεμονωμένα pull requests για όποια βρει

Για αναφορές σφαλμάτων και άλλες κοινές συνεισφορές, το GitHub διαθέτει [Πρότυπα ζητημάτων και πρότυπα αιτημάτων](https://github.com/blog/2111-issue-and-pull-request-templates), τα οποία μπορείτε να δημιουργήσετε για να βελτιώσετε την επικοινωνία που λαμβάνετε. Ο @TalAter δημιούργησε έναν οδηγό [Choose Your Own Adventure guide](https://www.talater.com/open-source-templates/#/) για να σας βοηθήσει να γράψετε τα πρότυπα των ζητημάτων και των PR σας.

Για να διαχειριστείτε τις ειδοποιήσεις ηλεκτρονικού ταχυδρομείου σας, μπορείτε να δημιουργήσετε [φίλτρα ηλεκτρονικού ταχυδρομείου](https://github.com/blog/2203-email-updates-about-your-own-activity) για να οργανώνετε με βάση την προτεραιότητα.

Αν θέλετε να προχωρήσετε λίγο περισσότερο, οι οδηγοί στυλ και οι λιντέρ μπορούν να τυποποιήσουν τις συνεισφορές στο πρότζεκτ και να τις κάνουν πιο εύκολες στην αναθεώρηση και στην αποδοχή τους.

Ωστόσο, αν τα πρότυπα σας είναι πολύ περίπλοκα, μπορεί να αυξήσουν τα εμπόδια στη συνεισφορά. Βεβαιωθείτε ότι προσθέτετε μόνο αρκετούς κανόνες για να κάνετε τη ζωή όλων πιο εύκολη.

Αν δεν είστε σίγουροι για το ποια εργαλεία να χρησιμοποιήσετε, κοιτάξτε τι κάνουν άλλα δημοφιλή πρότζεκτ, ειδικά αυτά που ανήκουν στο οικοσύστημά σας. Για παράδειγμα, πώς μοιάζει η διαδικασία συνεισφοράς για άλλες ενότητες του Node; Η χρήση παρόμοιων εργαλείων και προσεγγίσεων θα κάνει επίσης τη διαδικασία σας πιο οικεία στους συνεισφέροντες-στόχους σας.

## Δεν πειράζει να κάνετε διάλειμμα!

Η εργασία σε ανοιχτό κώδικα κάποτε σας έδινε χαρά. Ίσως τώρα αρχίζει να σας κάνει να νιώθετε αποφυγή ή ενοχές.

Ίσως αισθάνεστε συγκλονισμένοι ή μια αυξανόμενη αίσθηση τρόμου όταν σκέφτεστε τα πρότζεκτ σας. Και εν τω μεταξύ, τα ζητήματα και τα αιτήματα για την έκδοση προτάσεων συσσωρεύονται.

Η επαγγελματική εξουθένωση είναι ένα πραγματικό και διάχυτο ζήτημα στην εργασία ανοιχτού κώδικα, ειδικά μεταξύ των συντηρητών. Ως συντηρητής, η ευτυχία σας είναι αδιαπραγμάτευτη προϋπόθεση για την επιβίωση κάθε έργου ανοιχτού κώδικα.

Αν και θα έπρεπε να είναι αυτονόητο, κάντε ένα διάλειμμα! Δεν θα πρέπει να περιμένετε μέχρι να νιώσετε εξαντλημένοι για να κάνετε διακοπές. Ο @brettcannon, ένας κύριος προγραμματιστής της Python, αποφάσισε να κάνει [ένα μήνα διακοπές](https://snarky.ca/why-i-took-october-off-from-oss-volunteering/) μετά από 14 χρόνια εθελοντικής εργασίας στο OSS.

Ακριβώς όπως και σε κάθε άλλο είδος εργασίας, το να κάνετε τακτικά διαλείμματα θα σας κρατήσει ανανεωμένους, χαρούμενους και ενθουσιασμένους με τη δουλειά σας.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/danielbachhuber?s=180" class="pquote-avatar" alt="avatar">
  Διατηρώντας το WP-CLI, ανακάλυψα ότι πρέπει πρώτα να κάνω τον εαυτό μου ευτυχισμένο και να θέσω σαφή όρια στη συμμετοχή μου. Η καλύτερη ισορροπία που έχω βρει είναι 2-5 ώρες την εβδομάδα, ως μέρος του κανονικού μου προγράμματος εργασίας. Αυτό κρατάει τη συμμετοχή μου ως πάθος και δεν την αισθάνομαι υπερβολικά σαν δουλειά. Επειδή ιεραρχώ τα θέματα στα οποία εργάζομαι, μπορώ να σημειώνω τακτική πρόοδο σε ό,τι θεωρώ πιο σημαντικό.
  <p markdown="1" class="pquote-credit">
- @danielbachhuber, ["Τα συλλυπητήριά μου, είστε τώρα ο συντηρητής ενός δημοφιλούς πρότζεκτ ανοικτού κώδικα"](https://web.archive.org/web/20220306014037/https://danielbachhuber.com/2016/06/26/my-condolences-youre-now-the-maintainer-of-a-popular-open-source-project/)
  </p>
</aside>

Μερικές φορές, μπορεί να είναι δύσκολο να κάνεις ένα διάλειμμα από την εργασία ανοιχτού κώδικα όταν νιώθεις ότι όλοι σε χρειάζονται. Οι άνθρωποι μπορεί ακόμη και να προσπαθήσουν να σας κάνουν να νιώσετε ένοχοι που απομακρύνεστε.

Κάνετε ό,τι μπορείτε για να βρείτε υποστήριξη για τους χρήστες και την κοινότητά σας, ενώ βρίσκεστε μακριά από ένα έργο. Αν δεν μπορείτε να βρείτε την υποστήριξη που χρειάζεστε, κάντε ένα διάλειμμα ούτως ή άλλως. Φροντίστε να επικοινωνείτε όταν δεν είστε διαθέσιμοι, ώστε οι άνθρωποι να μην μπερδεύονται από την έλλειψη ανταπόκρισής σας.

Το να κάνετε διαλείμματα ισχύει και για κάτι περισσότερο από τις διακοπές. Αν δεν θέλετε να κάνετε εργασίες ανοιχτού κώδικα τα Σαββατοκύριακα ή κατά τη διάρκεια των ωρών εργασίας, επικοινωνήστε αυτές τις προσδοκίες στους άλλους, ώστε να ξέρουν να μην σας ενοχλούν.

## Φροντίστε πρώτα τον εαυτό σας!

Η διατήρηση ενός δημοφιλούς πρότζεκτ απαιτεί διαφορετικές δεξιότητες από τα προηγούμενα στάδια ανάπτυξης, αλλά δεν είναι λιγότερο ικανοποιητική. Ως συντηρητής, θα εξασκήσετε ηγετικές και προσωπικές δεξιότητες σε ένα επίπεδο που λίγοι άνθρωποι έχουν την ευκαιρία να βιώσουν. Αν και δεν είναι πάντα εύκολο να το διαχειριστείτε, ο καθορισμός σαφών ορίων και η ανάληψη μόνο όσων σας βολεύουν θα σας βοηθήσει να παραμείνετε ευτυχισμένοι, ανανεωμένοι και παραγωγικοί.
