---
lang: de
title: Ein Open-Source-Projekt starten
description: Erfahren Sie mehr über die Open-Source-Welt und machen Sie sich bereit, Ihr eigenes Projekt zu starten.
class: beginners
order: 2
image: /assets/images/cards/beginner.png
related:
  - finding
  - building
---

## Was ist Open-Source, und warum?

Sie denken also über einen Sprung in die Open-Source-Welt nach? Herzlichen Glückwunsch, die Welt weiß Ihren Beitrag zu schätzen! Lassen Sie uns darüber sprechen, was Open-Source ist und warum sich Leute dafür engagieren.

### Was genau bedeutet "Open-Source"?

Ein Open-Source-Projekt kann von **jedem Menschen für jeden Zweck verwendet, inspiziert, modifiziert und weiterverbreitet werden.** Diese Rechte werden [mittels einer Open-Source-Lizenz durchgesetzt](https://opensource.org/licenses).

Open-Source ist so mächtig, weil es Barrieren für Nutzung und Zusammenarbeit senkt und Personen somit ermöglicht, Ideen schneller zu verbreiten und Dinge schneller zu verbessern. Zudem ermöglicht es den Benutzer\*innen\*n, ihr eigenes Computing besser unter Kontrolle zu behalten, als mit proprietären Lösungen. Ein Unternehmen, das Open-Source-Software verwendet, kann beispielsweise jemanden einstellen, um maßgeschneiderte Verbesserungen an der Software vorzunehmen, anstatt von den Produktentscheidungen des Anbieters abhängig zu sein.

_Freie Software_ meint dieselbe Art von Projekten wie _Open-Source_. Der [Begriff](https://de.wikipedia.org/wiki/Free/Libre_Open_Source_Software) wird manchmal auch kombiniert mit "Freie/Libre und Open-Source-Software" (FOSS bzw. FLOSS). _Frei_ und _Libre_ meinen hierbei die Freiheit, nicht den [Preis](#bedeutet-open-source-auch-gratis).

### Warum veröffentlichen Menschen den Quellcode ihrer Software?

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kentcdodds?s=180" class="pquote-avatar" alt="avatar">

  Die lohnenswertesten Erfahrungen, die ich bei der Verwendung von Open-Source und der Zusammenarbeit daran mache, kommen von den Beziehungen, die ich mit anderen Entwicklern\*innen aufbaue, die mit vielen der gleichen Probleme konfrontiert sind wie ich.

  _One of the most rewarding experiences I get out of using and collaborating on open source comes from the relationships that I build with other developers facing many of the same problems I am._

  <p markdown="1" class="pquote-credit">
— @kentcdodds, ["How getting into Open-Source has been awesome for me"](https://kentcdodds.com/blog/how-getting-into-open-source-has-been-awesome-for-me)
  </p>
</aside>

[Es gibt viele Gründe](https://ben.balter.com/2015/11/23/why-open-source/) warum eine Person oder Organisation ein Projekt open-sourcen wollen würde. Beispielsweise:

* **Zusammenarbeit:** Open-Source-Projekte nehmen Beiträge aus der ganzen Welt an. [Exercism](https://github.com/exercism/) beispielsweise ist eine Programmierübungsplatform mit über 350 Kontributor\*innen.

* **Anpassungen:** Open-Source-Projekte können von jedem Menschen für fast jeden Zweck benutzt werden. Leute können daraus sogar andere Dinge bauen. [WordPress](https://github.com/WordPress) beispielsweise begann als ein Fork eines existierenden Projekts namens [b2](https://github.com/WordPress/book/blob/HEAD/Content/Part%201/2-b2-cafelog.md).

* **Transparenz:** In einem Open-Source-Projekt können Fehler oder Ungereimtheiten von jedem behoben werden. Transparenz ist sowohl für Regierungen in [Bulgarien](https://medium.com/@bozhobg/bulgaria-got-a-law-requiring-open-source-98bf626cf70a) oder den [Vereinigten Staaten](https://web.archive.org/web/20180306072551/https://www.cio.gov/2016/08/11/peoples-code.html), für regulierte Industrien wie den Banken- oder Gesundheitssektor und für Sicherheitssoftware wie [Let's Encrypt](https://github.com/letsencrypt) gleichermaßen wichtig.

Open-Source ist nicht nur für Software, sondern auch für alle anderen Bereiche geeignet, von Datensätzen bis hin zu Büchern. Stöbern Sie durch [GitHub Explore](https://github.com/explore), um einen Eindruck der thematischen Breite von Open-Source-Projekten zu bekommen.

### Bedeutet Open-Source auch "gratis"?

Einer der größten Vorteile von Open-Source ist, dass es kein Geld kostet. "Gratis" dagegen ist nur ein Nebenprodukt des Gesamtwertes.

Weil [eine Open-Source-Lizenz bedingt](https://opensource.org/osd-annotated), dass jeder die Software nutzen, modifizieren, und weiterverbreiten darf (für nahezu jeden Zweck), nehmen die Projekte selbst meist kein Geld dafür. Wenn sie es täten, könnte jeder ganz legal die Projekte kopieren und die dann freie Version nutzen.

Daher sind die meisten Open-Source-Projekte kostenlos, aber das ist kein Teil der Open-Source-Definition. Es gibt für Open-Source-Projekte Möglichkeiten, sich indirekt bezahlen zu lassen (z.B. über Doppel-Lizenzierung oder eingeschränkte Funktionen) und dabei trotzdem die offizielle Definition von Open-Source weiterhin einzuhalten.

## Sollte ich mein eigenes Open-Source-Projekt starten?

Die kurze Antwort ist "Ja!", denn egal wie das Ergebnis aussieht: Ein eigenes Projekt zu starten ist eine großartige Möglichkeit zu lernen, wie Open-Source funktioniert.

Wenn Sie noch nie den Quellcode eines Projektes geöffnet haben, werden Sie vielleicht nervös darüber sein, was die Leute sagen werden, oder ob es jemandem auffallen wird. Mit diesen Bedenken sind Sie nicht allein!

Open-Source-Arbeit ist eine kreative Aktivität wie Schreiben oder Malen, oder anderes. Es kann beängstigend sein, seine Arbeit mit der Welt zu teilen. Jedoch ist Übung der einzige Weg besser zu werden, auch wenn man kein Publikum hat.

Wenn Sie noch nicht überzeugt sind, nehmen Sie sich einen Moment Zeit, um darüber nachzudenken, was Ihre Ziele sein könnten.

### Ihre Ziele definieren

Ziele können Ihnen helfen, herauszufinden, woran Sie arbeiten sollen, was Sie ablehnen sollten und wo Sie Hilfe von anderen brauchen. Fragen Sie sich zuerst: _Warum starte ich dieses Projekt?_

Es gibt keine richtige Antwort auf diese Frage. Vielleicht haben Sie mehrere Ziele für ein einzelnes Projekt oder verschiedene Projekte mit unterschiedlichen Zielen.

Wenn es Ihr einziges Ziel ist, Ihre Arbeit zu zeigen, wollen Sie vielleicht nicht einmal Beiträge und sagen dies sogar in Ihrer README. Andererseits, wenn Sie sich Beiträge wünschen: Investieren Sie Zeit in eine klare Dokumentation, damit sich Neuankömmlinge willkommen fühlen.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mavris?s=180" class="pquote-avatar" alt="avatar">

  Irgendwann habe ich eine eigene UIAlertView erstellt, die ich benutzt habe... Und ich entschied mich dafür, sie zu veröffentlichen, also habe ich sie dynamischer gestaltet und auf GitHub hochgeladen und auch meine erste Dokumentation geschrieben, die anderen Entwickler\*innen erklärt, wie sie meine UIAlertView in ihren Projekten verwenden können. Wahrscheinlich hat es nie jemand benutzt, weil es ein einfaches Projekt war, aber ich fühlte mich wegen meines Beitrags gut.

  _At some point I created a custom UIAlertView that I was using...and I decided to make it open source. So I modified it to be more dynamic and uploaded it to GitHub. I also wrote my first documentation explaining to other developers how to use it on their projects. Probably nobody ever used it because it was a simple project but I was feeling good about my contribution._

  <p markdown="1" class="pquote-credit">
— @mavris, ["Self-taught Software Developers: Why Open Source is important to us"](https://medium.com/rocknnull/self-taught-software-engineers-why-open-source-is-important-to-us-fe2a3473a576)
  </p>
</aside>

Wenn Ihr Projekt wächst, braucht Ihre Community mehr als nur Code von Ihnen. Die Reaktion auf Probleme, die Überprüfung von Code und das Anpreisen Ihres Projekts sind alles wichtige Aufgaben in einem Open-Source-Projekt.

Während die Zeit, die Sie für nicht-Programmieraufgaben aufwenden, von der Größe und dem Umfang Ihres Projekts abhängt, sollten Sie als Betreuer\*in darauf vorbereitet sein, diese selbst anzugehen oder jemanden zu finden, der Ihnen hilft.

**Wenn Sie Teil eines Unternehmens sind, das ein Projekt startet**, stellen Sie sicher, dass Ihr Projekt über die internen Ressourcen verfügt, die es braucht, um zu gedeihen: Sie wollen klarstellen, wer für die Wartung des Projekts nach dem Start verantwortlich ist und wie Sie diese Aufgaben mit Ihrer Community teilen.

Wenn Sie ein dediziertes Budget oder Personal für Werbung, Betrieb und Wartung des Projekts benötigen, planen Sie dies frühzeitig.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/captainsafia?s=180" class="pquote-avatar" alt="avatar">

  Wenn Sie mit dem Open-Source-Projekt beginnen, ist es wichtig, dass Ihre Managementprozesse die Beiträge und Fähigkeiten der Community rund um Ihr Projekt berücksichtigen. Scheuen Sie sich nicht, Mitarbeiter\*innen, die nicht in Ihrem Unternehmen beschäftigt sind, in Kernbereiche des Projekts einzubeziehen - besonders wenn sie häufig mitwirken.

  _As you begin to open source the project, it's important to make sure that your management processes take into consideration the contributions and abilities of the community around your project. Don't be afraid to involve contributors who are not employed in your business in key aspects of the project — especially if they are frequent contributors._

  <p markdown="1" class="pquote-credit">
— @captainsafia, ["So you wanna open source a project, eh?"](https://dev.to/captainsafia/so-you-wanna-open-source-a-project-eh-5779)
  </p>
</aside>

### Zu anderen Projekten beitragen

Ist Ihr Ziel zu lernen, wie man mit anderen zusammenarbeitet oder wie Open-Source funktioniert, sollten Sie in Erwägung ziehen zu einem bestehenden Projekt beizutragen. Dies kann so einfach sein wie die Korrektur von Tippfehlern oder das Aktualisieren der Dokumentation.

Wenn Sie sich nicht sicher sind, wie Sie als Mitwirkende\*r anfangen können, schauen Sie sich unseren Artikel "[Wie zu Open-Source beitragen?](../how-to-contribute/)" an.

## Ein eigenes Open-Source-Projekt starten

Es gibt keine perfekte Zeit, um Ihre Arbeit zu veröffentlichen. Sie können eine Idee, ein in Arbeit befindliches Projekt, oder ein Jahre altes Closed-Source-Projekt öffnen.

Im Allgemeinen können Sie sich für Open-Source entscheiden, wenn Sie möchten, dass andere Ihre Arbeit sehen sollen und bereit sind, Feedback zu akzeptieren.

Unabhängig davon, in welcher Phase Sie sich für Open-Source entscheiden, sollte jedes Projekt die folgende Dokumentation enthalten:

* [Eine Open-Source-Lizenz](https://help.github.com/articles/open-source-licensing/#where-does-the-license-live-on-my-repository)
* [Eine README](https://help.github.com/articles/create-a-repo/#commit-your-first-change)
* [Beitragsrichtlinien](https://help.github.com/articles/setting-guidelines-for-repository-contributors/)
* [einen Verhaltenskodex](../code-of-conduct/)

Als Maintainer\*in helfen Ihnen diese Komponenten, Erwartungen zu kommunizieren, Beiträge zu verwalten und die gesetzlichen Rechte aller (einschließlich Ihrer eigenen) zu schützen. Sie tragen zudem zu einer positiven Erfahrung in Ihrem Projekt bei.

Wenn sich Ihr Projekt auf GitHub befindet, können Sie diese Dateien mit den empfohlenen Dateinamen in Ihrem Stammverzeichnis ablegen, damit GitHub sie erkennt und automatisch an Ihre Leser\*innen weitergeben kann.

### Eine Lizenz auswählen

Eine Open-Source-Lizenz garantiert, dass andere Ihr Projekt ohne Nebenwirkungen nutzen, kopieren, modifizieren und wieder einbringen können. Außerdem schützt sie Sie vor unangenehmen rechtlichen Situationen. **Wenn Sie ein Open-Source-Projekt starten, müssen Sie eine Lizenz angeben.**

Rechtsangelegenheiten sind kein Spaß. Die gute Nachricht ist, dass Sie eine bestehende Lizenz kopieren und in Ihr Repository einfügen können. Es dauert also nur eine Minute, Ihre harte Arbeit zu schützen.

[MIT](https://choosealicense.com/licenses/mit/), [Apache 2.0](https://choosealicense.com/licenses/apache-2.0/), und [GPLv3](https://choosealicense.com/licenses/gpl-3.0/) sind die populärsten Open-Source-Lizenzen, aber [es gibt viele andere](https://choosealicense.com) zur Auswahl.

Wenn Sie ein neues Projekt auf GitHub erstellen, haben Sie die Möglichkeit, eine Lizenz auszuwählen. Mit einer Open-Source-Lizenz wird Ihr GitHub-Projekt auch wirklich zum Open-Source-Projekt.

![Eine Lizenz auswählen](/assets/images/starting-a-project/repository-license-picker.png)

Wenn Sie weitere Fragen oder Bedenken bezüglich der rechtlichen Aspekte der Verwaltung eines Open-Source-Projekts haben, [können Sie sich an uns wenden](../legal/).

### Eine README schreiben

READMEs erklären nicht nur, wie Sie Ihr Projekt verwenden, sondern auch, warum Ihr Projekt wichtig ist und was Ihre Benutzer\*innen damit machen können.

Versuchen Sie in Ihrer README folgende Fragen zu beantworten:

* Was macht dieses Projekt?
* Warum ist es nützlich?
* Wie kann ich es nutzen oder dazu etwas beitragen?
* Wo wird mir geholfen, wenn ich Hilfe benötige?

Sie können Ihre README verwenden, um andere Fragen zu beantworten: z.B. wie Sie mit Beiträgen handhaben, welche Ziele das Projekt verfolgt, oder wie es um Lizenzen und Zuschreibungen steht. Wenn Sie keine Beiträge annehmen wollen oder Ihr Projekt noch nicht produktionsreif ist, schreiben Sie auch diese Informationen auf.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/tracymakes?s=180" class="pquote-avatar" alt="avatar">

  Bessere Dokumentation bedeutet mehr Benutzer\*innen, weniger Supportanfragen und mehr Mitwirkende. (...) Denken Sie daran, dass Ihre Leser\*innen und andere Leute, die auf Ihr Projekt stoßen andere Erfahrungshintergründe haben.

  _Better documentation means more users, less support requests, and more contributors. (...) Remember that your readers aren't you. There are people who might come to a project who have completely different experiences._

  <p markdown="1" class="pquote-credit">
— @tracymakes, ["Writing So Your Words Are Read (video)"](https://www.youtube.com/watch?v=8LiV759Bje0&list=PLmV2D6sIiX3U03qc-FPXgLFGFkccCEtfv&index=10)
  </p>
</aside>

Manchmal vermeiden es Leute, eine README zu schreiben, weil sie das Gefühl haben, das Projekt sei unvollendet, oder weil sie keine Beiträge wollen. Aber auch dies sind gute Gründe, eine zu schreiben.

Weitere Inspirationen zum Schreiben einer README finden Sie in @dguo's ["Make a README"-Anleitung](https://www.makeareadme.com/) oder in @PurpleBooth's [README-Vorlage](https://gist.github.com/PurpleBooth/109311bb0361f32d87a2).

Wenn Sie eine README-Datei im Hauptordner Ihres Projektes anlegen, zeigt GitHub diese automatisch auf der Homepage des Repos an.

### Ihre Beitragsrichtlinien aufschreiben

Eine CONTRIBUTING-Datei erklärt Ihrem Publikum, wie es zu Ihrem Projekt beitragen kann. Folgende Informationen können darin beispielsweise enthalten sein:

* Wie eine Fehlerbericht eingereicht werden kann (probieren Sie hierfür die [Issue- und Pull-Request-Vorlagen](https://github.com/blog/2111-issue-and-pull-request-templates))
* Wie neue Funktionen vorgeschlagen werden sollten
* Wie die Entwicklungsumgebung eingerichtet wird
* Wie getestet wird

Neben thematischen Details präsentiert die CONTRIBUTING-Datei auch Ihre Erwartungen an Beiträge, z.B:

* Wie Sie möchten, dass andere beitragen
* Ihre Pläne und Ziele für das Projekt
* Wie Mitwirkende Sie kontaktieren sollten (oder auch nicht)

Mit einem warmen, freundlichen Ton und spezifischen Vorschlägen für Beiträge (wie z.B. "Dokumentationen verfassen" oder "eine Website erstellen") können Sie dazu beitragen, dass sich Neuankömmlinge willkommen und wohlfühlen.

Beispielsweise leitet [Active Admin](https://github.com/activeadmin/activeadmin/)  [ihre Beitragsrichtlinien](https://github.com/activeadmin/activeadmin/blob/HEAD/CONTRIBUTING.md) ein mit:

> Zuerst einmal vielen Dank, dass Sie überlegt haben, einen Beitrag zu Active Admin zu leisten, denn es sind Menschen wie Sie, die Active Admin so großartig machen.
>
> First off, thank you for considering contributing to Active Admin. It's people like you that make Active Admin such a great tool.

In der Anfangsphase Ihres Projekts kann Ihre CONTRIBUTING-Datei einfach sein. Sie sollten immer erklären, wie Fehler oder Probleme gemeldet werden können und welche technischen Anforderungen (z.B. Tests) Leute erfüllen müssen, um einen Beitrag zu leisten.

Im Laufe der Zeit können Sie weitere häufig gestellte Fragen zu Ihrer CONTRIBUTING-Datei hinzufügen. Diese Informationen aufzuschreiben verhindert, dass weniger Leute die immer wieder gleichen Fragen stellen werden.

@nayafia's [CONTRIBUTING-Vorlage](https://github.com/nayafia/contributing-template/blob/HEAD/CONTRIBUTING-template.md) oder @mozilla's ["How to Build a CONTRIBUTING.md"](https://mozillascience.github.io/working-open-workshop/contributing/) helfen Ihnen, Ihre Beitragsrichtlinien zu entwerfen.

Verlinken Sie Ihre CONTRIBUTING-Datei in Ihrer README, damit sie gleich bemerkt wird. Wenn Sie sie zudem [in Ihr Repo einchecken](https://help.github.com/articles/setting-guidelines-for-repository-contributors/), wird GitHub automatisch auf sie aufmerksam machen, wenn jemand ein Issue oder Pull Request erstellt.

![Beitragsrichtlinien](/assets/images/starting-a-project/Contributing-guidelines.jpg)

### Einen Verhaltenskodex etablieren

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mlynch?s=180" class="pquote-avatar" alt="avatar">

  Wir haben alle Erfahrungen gemacht, wo wir mit Beleidigungen zu tun hatten, entweder als Betreuer\*in beim Erklären, warum etwas auf eine bestimmte Weise geschehen musste, oder als Benutzer\*in (...) beim Stellen einer einfachen Frage. (...) Ein Verhaltenskodex wird zu einem leicht referenzierbaren und verlinkbaren Dokument, das klar stellt, dass Ihr Team den konstruktiven Diskurs sehr ernst nimmt.

  _We've all had experiences where we faced what was probably abuse either as a maintainer trying to explain why something had to be a certain way, or as a user...asking a simple question. (...) A code of conduct becomes an easily referenced and linkable document that indicates that your team takes constructive discourse very seriously._

  <p markdown="1" class="pquote-credit">
— @mlynch, ["Making Open Source a Happier Place"](https://medium.com/ionic-and-the-mobile-web/making-open-source-a-happier-place-3b90d254f5f)
  </p>
</aside>

Letztendlich hilft ein Verhaltenskodex, Grundregeln für das Verhalten der Projektbeteiligten festzulegen - insbesondere wenn Sie ein Open-Source-Projekt für eine Community oder ein Unternehmen starten. Ein Verhaltenskodex hilft Ihnen, ein gesundes, konstruktives Gemeinschaftsverhalten zu fördern, das Ihnen als Maintainer\*in Stress erspart.

Weitere Information finden Sie in unserer [Anleitung für Verhaltenskodizes](../code-of-conduct/).

Neben der Klarstellung, _welches_ Verhalten Sie von den Mitwirkenden erwarten, beschreibt ein Verhaltenskodex auch, auf wen sich diese Erwartungen beziehen, wann sie gelten und was zu tun ist, wenn ein Verstoß vorliegt.

Ähnlich zu Open-Source-Lizenzen, kommen auch Standards für Verhaltenskodizes auf, sodass Sie keinen komplett eigenen schreiben müssen. Der [Contributor Covenant](https://contributor-covenant.org/) ist ein einsatzbereiter Verhaltenskodex, der von [über 40'000 Open-Source-Projekten](http://contributor-covenant.org/adopters/) verwendet wird, einschließlich Kubernetes, Rails und Swift. Egal welchen Text Sie nutzen, Sie sollten vorbereitet sein, ihn wenn nötig auch durchzusetzen.

Fügen Sie den Text direkt in eine CODE_OF_CONDUCT-Datei in Ihrem Repository ein. Halten Sie die Datei im Stammverzeichnis Ihres Projekts, damit sie leicht zu finden ist, und verlinken Sie sie von Ihrer README.

## Ihr Projekt benennen und zur Marke machen

Eine Marke besteht aus mehr als einem auffälligen Logo oder einem einprägsamen Projektnamen. Es geht darum, wie Sie über Ihr Projekt sprechen und wen Sie mit Ihrer Botschaft erreichen.

### Den richtigen Namen auswählen

Wählen Sie einen Namen, der leicht zu merken ist und im Idealfall eine Vorstellung davon vermittelt, was das Projekt bewirkt. Beispielsweise:

* [Sentry](https://github.com/getsentry/sentry) überwacht Apps und meldet Abstürze
* [Thin](https://github.com/macournoyer/thin) ist ein schneller, einfacher Web-Server in Ruby

Wenn Sie auf einem bestehenden Projekt aufbauen, kann die Verwendung des Namens als Präfix helfen, zu klären, was Ihr Projekt tut ([node-fetch](https://github.com/bitinn/node-fetch) z.B. implementiert `window.fetch` für Node.js).

Denken Sie vor allem an die Klarheit. Wortspiele machen Spaß, aber denken Sie daran, dass manche Witze nicht in andere Kulturen oder für Menschen mit anderen Erfahrungen als Ihren, übersetzt werden können. Einige Ihrer potenziellen Nutzer\*innen könnten Mitarbeiter\*innen in Unternehmen sein: Sie wollen es ihnen nicht unangenehm machen, wenn sie Ihr Projekt bei der Arbeit erklären müssen!

### Namenskonflikte vermeiden

[Prüfen Sie, ob es Open-Source-Projekte mit ähnlichem Namen gibt](http://ivantomic.com/projects/ospnc/), insbesondere in derselben Sprache oder demselben Ökosystem. Wenn Ihr Projektname mit einem existierenden, populären Projekt überlappt, könnte das Ihr Publikum verwirren.

Wenn Sie möchten, dass eine Website, ein Twitter-Handle, o.Ä. Ihr Projekt repräsentieren, stellen Sie sicher, dass Sie die von Ihnen gewünschten Namen erhalten können. Um auf Nummer sicher zu gehen, können Sie [diese Namen jetzt reservieren](https://instantdomainsearch.com/), auch wenn Sie sie noch nicht verwenden möchten.

Achten Sie darauf, dass der Name Ihres Projekts keine Marken verletzt, denn ein Unternehmen könnte Sie auffordern, Ihr Projekt zu einem späteren Zeitpunkt abzubrechen. Im schlimmsten Fall leitet ein Unternehmen sogar rechtliche Schritte gegen Sie ein. Dieses Risiko einzugehen, ist es einfach nicht wert.

Nutzen Sie die [WIPO Global Brand Database](http://www.wipo.int/branddb/en/), um auf Namenskonflikte zu prüfen. Wenn Sie in einer Firma sind, ist dies eine der Aufgaben, bei denen [Ihr Justiziariat Sie unterstützen kann](../legal/).

Zum Schluss noch eine schnelle Google-Suche nach Ihrem Projektnamen: Werden die Leute Ihr Projekt leicht finden können, oder erscheint etwas anderes in den Suchergebnissen, das Sie nicht sehen möchten?

### Auch der Schreib- und Programmierstil beeinflussen Ihre Marke!

Während Sie an dem Projekt arbeiten, werden Sie eine Menge schreiben: README, Anleitungen, Dokumentation, Antworten auf Anfragen, vielleicht sogar Newsletter an eine Mailingliste.

Egal ob offizielle Dokumentation oder informelle E-Mail: Ihr Schreibstil ist ein Markenzeichen Ihres Projektes. Bedenken Sie, wie er bei Ihrem Publikum ankommt, und ob dies dem Tonfall entspricht, den Sie herüberbringen möchten.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">

  Ich habe versucht, an jeder Diskussion auf der Mailingliste teilzunehmen, in der Absicht, nett zu den Leuten zu sein, ihre Anfragen ernst zu nehmen und Hilfe anzubieten. Nach einer Weile blieben Leuten einfach dabei, nicht nur um Fragen zu stellen, sondern auch um anderen zu antworten, und erfreulicherweise übernahmen sie meinen Schreibstil.

  _I tried to be involved with every thread on the mailing list, and showing exemplary behaviour, being nice to people, taking their issues seriously and trying to be helpful overall. After a while, people stuck around not to only ask questions, but to help with the answering as well, and to my complete delight, they mimicked my style._

  <p markdown="1" class="pquote-credit">
— @janl on [CouchDB](https://github.com/apache/couchdb), ["Sustainable Open Source"](https://web.archive.org/web/20200723213552/https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

Freundliche, [inklusive Sprache](https://fairlanguage.com/service/) kann Ihr Projekt einladender für neue Mitwirkende machen. Bleiben Sie auch bei einfacher/leichter Sprache, denn nicht alle Ihrer Leser\*innen haben die Fähigkeit, komplizierte Formulierungen sofort zu verstehen.

Neben Wortwahl und Schreibstil wird auch Ihr Programmierstil Teil der Marke Ihres Projekts. [Angular](https://github.com/johnpapa/angular-styleguide) und [jQuery](https://contribute.jquery.org/style-guide/js/) beispielsweise haben strenge Richtlinien dafür.

Eine Stilrichtlinie ist nicht sofort zum Start Ihres Projekts nötig, und vielleicht genießen Sie es auch, unterschiedliche Programmierstile in Ihr Projekt zu integrieren. Allerdings sollten Sie davon ausgehen, dass verschiedene Schreib- und Programmierstile verschiedene Leute anziehen oder abstoßen. Die Weichen für die Gemeinschaft, die Sie letztendlich aufbauen möchten, werden schon in frühen Projektphasen gestellt.

## Ihre Checkliste zur Startvorbreitung

Bereit für den Start Ihres Open-Source-Projektes? Diese Checkliste hilft Ihnen dabei. Alle Stationen bereit? Dann los! [Klicken Sie auf "publish"](https://help.github.com/articles/making-a-private-repository-public/) und klopfen Sie sich auf die Schulter.

**Dokumentation**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
    Das Projekt hat eine LICENSE-Datei mit einer Open-Source-Lizenz
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
    Grundlegende Dokumentation (README, CONTRIBUTING, CODE_OF_CONDUCT)
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
    Der Projektname ist einprägsam, vermittelt Zweck und Nutzen des Projektes, überschneidet sich nicht mit einem existierenden Projekt oder einem Markennamen
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
    Die Issue-Liste ist auf dem neuesten Stand, klar organisiert und mit Labels versehen
  </label>
</div>

**Code**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
    Der Code nutzt konsistente Konventionen, sowie klare Namen für Funktionen, Methoden und Variablen
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
    Der Code ist gut kommentiert, und dokumentiert Intentionen und Randfälle
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
    Weder Versionsgeschichte, noch Issues, oder Pull Requests enthalten sensible Daten (bspw. Passwörter oder andere nicht-öffentliche Informationen)
  </label>
</div>

**Menschen**

Wenn Sie als Einzelperson arbeiten:

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
  Sie haben mit der Rechtsabteilung gesprochen und/oder verstehen die Immaterialgüterrechter und Open-Source-Politik Ihrer Firma (wenn Sie angestellt sind)
  </label>
</div>

Wenn Sie als Firma oder Organisation arbeiten:

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
    Sie haben mit der Rechtsabteilung gesprochen
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox10" class="overflow-hidden d-block text-normal">
    Sie haben einen Plan zur Ankündigung und Vermarktung Ihres Projektes
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
    Jemand steht für Interaktionen mit der Community bereit (Issues beantworten, Pull Requests prüfen und mergen)
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
    Mindestens zwei Personen haben Admin-Zugang zum Projekt
  </label>
</div>

## Geschafft!

Herzlichen Glückwunsch zu Ihrem ersten Open-Source-Projekt! Egal was dabei rauskommt, öffentlich zu arbeiten, ist es ein Geschenk an die Gemeinschaft. Sie erschaffen mit jedem Commit, jedem Kommentar und jedem Pull Request eine Gelegenheit für sich selbst und andere, etwas zu lernen und intellektuell zu wachsen.
