---
lang: de
untranslated: false
title: Balance für Open-Source-Maintainer halten
description: Tipps zur Selbsthilfe und zur Vermeidung von Burnout als Maintainer.
class: balance
order: 0
image: /assets/images/cards/maintaining-balance-for-open-source-maintainers.png
---

Wenn ein Open-Source-Projekt immer beliebter wird, ist es wichtig, sich klare Grenzen zu setzen, um die Balance zu halten, damit man auf lange Sicht motiviert und produktiv bleibt. 

Um Einblicke in die Erfahrungen von Maintainern und ihre Strategien, eine Balance zu finden, zu gewinnen, haben wir einen Workshop mit 40 Mitgliedern der <a href="http://maintainers.github.com/">Maintainer-Community</a> durchgeführt. So konnten wir aus erster Hand von ihren Erfahrungen mit Burnout in der Open-Source-Branche und den Praktiken lernen, die ihnen geholfen haben, bei ihrer Arbeit eine Balance zu halten. An dieser Stelle kommt das Konzept der persönlichen Ökologie ins Spiel.

Was also ist persönliche Ökologie? <a href="https://rockwoodleadership.org/nonprofit-four-day-workweek-can-take-care-still-change-world/#:~:text=personal%20ecology%3A%20maintaining%20balance%2C%20pacing%20and%20efficiency%20to%20sustain%20your%20energy%20over%20a%20lifetime%20of%20activism">Laut dem Rockwood Leadership Institute</a> geht es darum, "<strong>das Gleichgewicht, das Tempo und die Effizienz aufrechtzuerhalten, um unsere Energie ein Leben lang zu erhalten</strong>." Dies gab unseren Gesprächen einen Rahmen und half den Maintainern, ihre Beiträge als Teil eines größeren Ökosystems zu erkennen, das sich im Laufe der Zeit weiterentwickelt. Burnout, ein Syndrom, das aus chronischem Stress am Arbeitsplatz resultiert, wie [von der WHO definiert](https://icd.who.int/browse11/l-m/en#/http://id.who.int/icd/entity/129180281), ist unter Maintainern keine Seltenheit. Dies führt oft zu einem Motivationsverlust, einer Unfähigkeit, sich zu konzentrieren, und einem Mangel an Empathie für die Mitwirkenden und die Community, mit der man arbeitet.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gabek?s=180" class="pquote-avatar" alt="avatar">
  Ich war nicht in der Lage, mich zu konzentrieren oder mit einer Aufgabe zu beginnen. Mir fehlte es an Empathie für die Benutzer.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/gabek">@gabek</a>, Maintainer des Owncast Live-Streaming-Servers, über die Folgen von Burnout auf seine Arbeit mit Open Source
  </p>
</aside>

Indem sie sich mit dem Konzept der persönlichen Ökologie vertraut machen, können Maintainer Burnout vorbeugen, der eigenen Gesundheit Priorität einräumen und ein Gefühl der Ausgeglichenheit bewahren, um ihre Bestleistung zu erbringen.

## Tipps zur Selbsthilfe und zur Vorbeugung von Burnout als Maintainer:

### Erkennen Sie Ihre Motivation für Open-Source-Arbeit

Nehmen Sie sich Zeit, darüber nachzudenken, was Sie an der Pflege von Open-Source-Projekten reizt. Wenn Sie Ihre Motivationen verstehen, können Sie die Arbeit so priorisieren, dass Sie engagiert und bereit für neue Herausforderungen bleiben. Ob es das positive Feedback der Benutzer ist, die Freude an der Zusammenarbeit und am Austausch mit der Gemeinschaft oder die Befriedigung, in den Code einzutauchen - das Erkennen Ihrer Motivationen kann Ihnen helfen, Ihren Fokus zu richten.

### Überlegen Sie, was Sie aus dem Gleichgewicht und in Stress bringt

Es ist wichtig zu verstehen, was die Ursachen für Burnout sind. Hier sind ein paar gemeinsame Ursachen, die wir bei Open-Source-Betreuern festgestellt haben:

* **Mangel an positivem Feedback:** Nutzer sind viel eher bereit, Beschwerden zu äußern, wenn sie ein Problem haben. Wenn alles gut läuft, schweigen sie eher. Es kann entmutigend sein, eine wachsende Liste von Problemen zu sehen, ohne positives Feedback, das zeigt, wie Ihre Beiträge etwas bewirken.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/thisisnic?s=180" class="pquote-avatar" alt="avatar">
  Manchmal fühlt es sich so an, als würde man ins Leere schreien, und ich finde, dass mich dieses Feedback wirklich anspornt. Wir haben viele glückliche, aber stille Nutzer.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/thisisnic">@thisisnic</a>, Maintainer von Apache Arrow
  </p>
</aside>

* **Nicht "Nein" sagen:** Es kann leicht passieren, dass man bei einem Open-Source-Projekt mehr Verantwortung übernimmt, als man sollte. Ob von Nutzern, Mitwirkenden oder anderen Betreuern - wir können nicht immer ihren Erwartungen gerecht werden.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/agnostic-apollo?s=180" class="pquote-avatar" alt="avatar">
  Ich stellte fest, dass ich mehr als eine Aufgabe übernehmen und die Arbeit mehrerer Personen erledigen musste, wie es bei FOSS üblich ist.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/agnostic-apollo">@agnostic-apollo</a>, Maintainer von Termux, über die Ursachen von Burnout bei seiner Arbeit
  </p>
</aside>

* **Alleine arbeiten:** Ein Maintainer zu sein, kann unglaublich einsam sein. Selbst wenn Sie mit einer Gruppe von Betreuern zusammenarbeiten, war es in den letzten Jahren schwierig, sich persönlich mit zerstreuten Teams zu treffen.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gabek?s=180" class="pquote-avatar" alt="avatar">
 Vor allem seit Corona und der Arbeit von zu Hause aus ist es schwieriger, nie jemanden zu sehen oder mit jemandem zu sprechen.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/gabek">@gabek</a>, Maintainer des Owncast Live-Streaming-Servers, über die Folgen von Burnout auf seine Open-Source-Arbeit
  </p>
</aside>

* **Nicht genug Zeit oder Ressourcen:** Dies gilt insbesondere für freiwillige Maintainer, die ihre Freizeit für die Arbeit an einem Projekt opfern müssen.

<aside markdown="1" class="pquote">
  Ich hätte gerne mehr finanzielle Unterstützung, sodass ich mich auf die Open-Source-Arbeit konzentrieren kann, ohne mein Erspartes aufzubrauchen und zu wissen, dass ich später eine Menge Auftragsarbeiten erledigen muss, um das zu kompensieren.
  <p markdown="1" class="pquote-credit">
— Open-Source-Maintainer
  </p>
</aside>

* **Unterschiedliche Forderungen:**  Open Source ist voll von Gruppen mit unterschiedlichen Motivationen, die schwer zu durchschauen sind. Wenn Sie für Ihre Arbeit an Open Source bezahlt werden, können die Interessen Ihres Arbeitgebers manchmal mit denen der Community kollidieren.

<aside markdown="1" class="pquote">
  Bei kommerziellen Produkten mit offenem Quellcode besteht ein Konflikt zwischen den Interessen des Arbeitgebers und dem, was das Beste für die Gemeinschaft ist
  <p markdown="1" class="pquote-credit">
— Open-Source-Maintainer
  </p>
</aside>

### Halte Ausschau nach Zeichen für Burnout

Können Sie Ihr Tempo 10 Wochen lang beibehalten? 10 Monate? 10 Jahre?

Es gibt Tools wie die [Burnout Checklist](https://governingopen.com/resources/signs-of-burnout-checklist.html) von [@shaunagm](https://github.com/shaunagm) die Ihnen dabei helfen können, Ihr aktuelles Tempo zu reflektieren und zu sehen, ob Sie Anpassungen vornehmen können. Einige Betreuer verwenden auch Wearables, um Messwerte wie Schlafqualität und Herzfrequenzvariabilität (die beide mit Stress in Verbindung stehen) zu verfolgen.

<aside markdown="1" class="pquote">
 Ich bin ein großer Befürworter von guten Wearables. Mit der Wissenschaft dahinter kann man verstehen, was man hätte besser machen können und wie man seine Ziele optimal erreichen kann.
  <p markdown="1" class="pquote-credit">
— Open-Source-Maintainer
  </p>
</aside>

### Was brauchen Sie, um sich und Ihre Gemeinschaft weiterhin zu erhalten?

Dies wird für jeden Betreuer unterschiedlich sein und sich je nach Lebensphase und anderen äußeren Faktoren ändern. Aber hier sind ein paar Aspekte, die wir gehört haben:

* **Vertrauen Sie der Community:** Delegation and finding contributors can alleviate the workload. Having multiple points of contact for a project can help you take a break without worrying. Connect with other maintainers and the wider community–in groups like the [Maintainer Community](http://maintainers.github.com/). This can be a great resource for peer support and learning. 

  Sie können auch nach Möglichkeiten suchen, mit der Nutzergemeinde in Kontakt zu treten, damit Sie regelmäßig Feedback erhalten und die Auswirkungen Ihrer Open-Source-Arbeit verstehen.

* **Finanzierung erforschen:** Whether you're looking for some pizza money, or trying to go full time open source, there are many resources to help! As a first step, consider turning on [GitHub Sponsors](https://github.com/sponsors) to allow others to sponsor your open source work. If you're thinking about making the jump to full-time, apply for the next round of [GitHub Accelerator](http://accelerator.github.com/).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mansona?s=180" class="pquote-avatar" alt="avatar">
 Ich war vor einiger Zeit in einem Podcast und wir sprachen über die Instandhaltung von Open Source und Nachhaltigkeit. Ich fand, dass selbst eine kleine Anzahl von Leuten, die meine Arbeit auf GitHub unterstützen, mir geholfen hat, eine schnelle Entscheidung zu treffen, nicht vor einem Spiel zu sitzen, sondern stattdessen eine kleine Sache mit Open Source zu machen.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/mansona">@mansona</a>, Maintainer von EmberJS
  </p>
</aside>

* **Tools einsetzen:** Entdecken Sie Tools wie [GitHub Copilot](https://github.com/features/copilot/) und [GitHub Actions](https://github.com/features/actions), um alltägliche Aufgaben zu automatisieren und Zeit für sinnvollere Beiträge zu gewinnen.

<aside markdown="1" class="pquote">
 Verwenden Sie [Copilot](https://github.com/features/copilot/) für die langweiligen Dinge - machen Sie die Dinge, die Ihnen Spaß machen
  <p markdown="1" class="pquote-credit">
— Open-Source-Maintainer
  </p>
</aside>

* **Ausruhen und regenerieren:** Nehmen Sie sich Zeit für Ihre Hobbys und Interessen außerhalb von Open Source. Nehmen Sie sich am Wochenende frei, um sich zu entspannen und zu erholen - und stellen Sie Ihren [GitHub-Status](https://docs.github.com/account-and-profile/setting-up-and-managing-your-github-profile/customizing-your-profile/personalizing-your-profile#setting-a-status) so ein, dass er Ihre Verfügbarkeit widerspiegelt! Erholsamer Schlaf kann einen großen Unterschied machen, wenn es darum geht, Ihre Leistung langfristig aufrechtzuerhalten.

  Wenn Ihnen bestimmte Aspekte Ihres Projekts besonders viel Spaß machen, versuchen Sie, Ihre Arbeit so zu strukturieren, dass Sie sie während des Tages erleben können.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/danielroe?s=180" class="pquote-avatar" alt="avatar">
 Ich finde mehr Zeit, um "kreative Momente" in den Tag zu bringen, als dass ich versuche, am Abend abzuschalten.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/danielroe">@danielroe</a>, Maintainer von Nuxt
  </p>
</aside>

* **Grenzen setzen:** Sie können nicht zu jeder Anfrage Ja sagen. Das kann so einfach sein, wie zu sagen: "Das kann ich im Moment nicht machen und ich habe auch nicht vor, es in Zukunft zu machen", oder in der README aufzulisten, was Sie gerne machen würden und was nicht. Sie könnten zum Beispiel sagen: "Ich führe nur PRs zusammen, die eine klare Begründung haben, warum sie gemacht wurden", oder "Ich überprüfe Probleme nur abwechselnd donnerstags von 18 - 19 Uhr". Das setzt Erwartungen für andere und gibt Ihnen etwas, auf das Sie zu anderen Zeiten verweisen können, um Forderungen von Mitwirkenden oder Benutzern nach Ihrer Zeit zu deeskalieren.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikemcquaid?s=180" class="pquote-avatar" alt="avatar">
Um auf diesen Säulen wirklich vertrauen zu können, darf man nicht zu jeder Anfrage Ja sagen. Wenn Sie das tun, halten Sie sich weder beruflich noch persönlich an Grenzen und werden kein verlässlicher Mitarbeiter sein.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/mikemcquaid">@mikemcquaid</a>, Maintainer von Homebrew zum [Nein-Sagen](https://mikemcquaid.com/saying-no/)
  </p>
</aside>

  Lernen Sie, giftiges Verhalten und negative Interaktionen konsequent zu unterbinden. Es ist in Ordnung, keine Energie für Dinge aufzuwenden, die Ihnen egal sind.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/IvanSanchez?s=180" class="pquote-avatar" alt="avatar">
Meine Software ist gratis, aber meine Zeit und Aufmerksamkeit sind es nicht.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/IvanSanchez">@IvanSanchez</a>, Maintainer von Leaflet
  </p>
</aside>

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/foosel?s=180" class="pquote-avatar" alt="avatar">
Es ist kein Geheimnis, dass die Entwicklung von Open-Source-Projekten auch ihre Schattenseiten hat, und eine davon ist, dass man manchmal mit undankbaren, überheblichen oder regelrecht toxischen Leuten interagieren muss. Mit zunehmender Popularität eines Projekts steigt auch die Häufigkeit dieser Interaktion, was die Belastung der Maintainer erhöht und möglicherweise zu einem bedeutenden Risikofaktor für ein Burnout der Maintainer wird.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/foosel">@foosel</a>, Maintainer von Octoprint zu [Umgang mit toxischen Leuten](https://www.youtube.com/watch?v=7lIpP3GEyXs)
  </p>
</aside>

Denken Sie daran, dass persönliche Ökologie eine fortlaufende Praxis ist, die sich im Laufe Ihrer Open-Source-Reise weiterentwickeln wird. Indem Sie Ihre Selbstfürsorge in den Vordergrund stellen und ein Gleichgewicht aufrechterhalten, können Sie einen effektiven und nachhaltigen Beitrag zur Open-Source-Gemeinschaft leisten und sowohl Ihr Wohlbefinden als auch den Erfolg Ihrer Projekte auf lange Sicht sicherstellen.

## Weitere Artikel

* [Maintainer Community](http://maintainers.github.com/)
* [The social contract of open source](https://snarky.ca/the-social-contract-of-open-source/), Brett Cannon
* [Uncurled](https://daniel.haxx.se/uncurled/), Daniel Stenberg 
* [How to deal with toxic people](https://www.youtube.com/watch?v=7lIpP3GEyXs), Gina Häußge
* [SustainOSS](https://sustainoss.org/)
* [Rockwood Art of Leadership](https://rockwoodleadership.org/art-of-leadership/)
* [Saying No](https://mikemcquaid.com/saying-no/), Mike McQuaid
* [Governing Open](https://governingopen.com/)
* Workshop agenda was remixed from [Mozilla's Movement Building from Home](https://foundation.mozilla.org/en/blog/its-a-wrap-movement-building-from-home/) series

## Mitwirkende

Vielen Dank an alle Maintainer, die uns ihre Erfahrungen und Tipps für diesen Leitfaden zur Verfügung gestellt haben!

Dieser Leitfaden wurde von [@abbycabs](https://github.com/abbycabs) geschrieben mit Beiträgen von: 

[@agnostic-apollo](https://github.com/agnostic-apollo)
[@AndreaGriffiths11](https://github.com/AndreaGriffiths11)
[@antfu](https://github.com/antfu)
[@anthonyronda](https://github.com/anthonyronda)
[@CBID2](https://github.com/CBID2)
[@Cli4d](https://github.com/Cli4d)
[@confused-Techie](https://github.com/confused-Techie)
[@danielroe](https://github.com/danielroe)
[@Dexters-Hub](https://github.com/Dexters-Hub)
[@eddiejaoude](https://github.com/eddiejaoude)
[@Eugeny](https://github.com/Eugeny)
[@ferki](https://github.com/ferki)
[@gabek](https://github.com/gabek)
[@geromegrignon](https://github.com/geromegrignon)
[@hynek](https://github.com/hynek)
[@IvanSanchez](https://github.com/IvanSanchez)
[@karasowles](https://github.com/karasowles)
[@KoolTheba](https://github.com/KoolTheba)
[@leereilly](https://github.com/leereilly)
[@ljharb](https://github.com/ljharb)
[@nightlark](https://github.com/nightlark)
[@plarson3427](https://github.com/plarson3427)
[@Pradumnasaraf](https://github.com/Pradumnasaraf)
[@RichardLitt](https://github.com/RichardLitt)
[@rrousselGit](https://github.com/rrousselGit)
[@sansyrox](https://github.com/sansyrox)
[@schlessera](https://github.com/schlessera)
[@shyim](https://github.com/shyim)
[@smashah](https://github.com/smashah)
[@ssalbdivad](https://github.com/ssalbdivad)
[@The-Compiler](https://github.com/The-Compiler)
[@thehale](https://github.com/thehale)
[@thisisnic](https://github.com/thisisnic)
[@tudoramariei](https://github.com/tudoramariei)
[@UlisesGascon](https://github.com/UlisesGascon)
[@waldyrious](https://github.com/waldyrious)
[@WebSnke](https://github.com/WebSnke) + vielen anderen!
