---
lang: bg
title: Показатели за отворен код
description: Вземете информирани решения, за да помогнете на вашия проект с отворен код да процъфтява, като измервате и проследявате неговия успех.
class: metrics
order: 9
image: /assets/images/cards/metrics.png
related:
  - finding
  - best-practices
---

## Защо да измервате нещо?

Данните, когато се използват разумно, могат да ви помогнат да вземете по-добри решения като поддържащ отворен код.

С повече информация можете:

* Разберете как потребителите реагират на нова функция
* Разберете откъде идват новите потребители
* Идентифицирайте и решете дали да поддържате извънреден случай на употреба или функционалност
* Определете количествено популярността на вашия проект
* Разберете как се използва вашият проект
* Събирайте пари чрез спонсорства и безвъзмездни средства

Например [Homebrew](https://github.com/Homebrew/brew/blob/bbed7246bc5c5b7acb8c1d427d10b43e090dfd39/docs/Analytics.md) открива, че Google Анализ им помага да приоритизират работата:

> Homebrew се предоставя безплатно и се управлява изцяло от доброволци в свободното им време. В резултат на това нямаме ресурсите да направим подробни потребителски проучвания на потребителите на Homebrew, за да решим как най-добре да проектираме бъдещи функции и да дадем приоритет на текущата работа. Анонимните обобщени потребителски анализи ни позволяват да приоритизираме поправки и функции въз основа на това как, къде и кога хората използват Homebrew.

Популярността не е всичко. Всеки влиза в отворен код по различни причини. Ако целта ви като поддържащ отворен код е да покажете работата си, да сте прозрачни относно кода си или просто да се забавлявате, показателите може да не са важни за вас.

Ако се интересувате от разбирането на вашия проект на по-дълбоко ниво, прочетете за начини да анализирате дейността на вашия проект.

## Откритие

Преди някой да може да използва или да допринесе обратно за вашия проект, той трябва да знае, че той съществува. Запитайте се: _хората намират ли този проект?_

![Графика на трафика](/assets/images/metrics/repo_traffic_graphs_tooltip.png)

Ако вашият проект се хоства в GitHub, [можете да видите](https://help.github.com/articles/about-repository-graphs/#traffic) колко хора попадат на вашия проект и откъде идват. От страницата на вашия проект щракнете върху "Прозрения", след това върху "Трафик". На тази страница можете да видите:

* **Общ брой показвания на страници:** Ви казва колко пъти е бил прегледан вашият проект

* **Общ брой уникални посетители:** Ви казва колко души са видели проекта Ви

* **Препоръчващи сайтове:** Ви казва откъде идват посетителите. Този показател може да ви помогне да разберете къде да достигнете до аудиторията си и дали усилията ви за промоция работят.

* **Популярно съдържание:** Ви казва къде отиват посетителите във вашия проект, разбити по показвания на страници и уникални посетители.

[Звездите на GitHub](https://help.github.com/articles/about-stars/) също могат да помогнат за предоставяне на основна мярка за популярност. Въпреки че звездите на GitHub не са непременно свързани с изтегляния и използване, те могат да ви кажат колко хора обръщат внимание на работата ви.

Може също да искате да [проследите откриваемостта на конкретни места](https://opensource.com/business/16/6/pirate-metrics): например Google PageRank, трафик от препоръчани потребители от уебсайта на вашия проект или препоръчани потребители от други отворени изходни проекти или уебсайтове.

## Използване

Хората намират вашия проект в това диво и лудо нещо, което наричаме интернет. В идеалния случай, когато видят вашия проект, те ще се почувстват принудени да направят нещо. Вторият въпрос, който ще искате да зададете е: _хората използват ли този проект?_

Ако използвате мениджър на пакети, като npm или RubyGems.org, за разпространение на вашия проект, може да сте в състояние да проследявате изтеглянията на вашия проект.

Всеки мениджър на пакети може да използва малко по-различна дефиниция на "изтегляне" и изтеглянията не са непременно свързани с инсталиранията или използването, но предоставя някаква базова линия за сравнение. Опитайте да използвате [Libraries.io](https://libraries.io/), за да проследявате статистическите данни за използването в много популярни мениджъри на пакети.

Ако вашият проект е в GitHub, отворете отново страницата "Трафик". Можете да използвате [графиката за клониране](https://github.com/blog/1873-clone-graphs), за да видите колко пъти вашият проект е бил клониран за даден ден, разбити на общия брой клонинги и уникални клонинги.

![Графика за клониране](/assets/images/metrics/clone_graph.png)

Ако употребата е ниска в сравнение с броя на хората, които са открили вашия проект, трябва да имате предвид два проблема. Или:

* Вашият проект не преобразува успешно вашата аудитория, или
* Привличате грешната аудитория

Например, ако вашият проект попадне на първа страница на Hacker News, вероятно ще видите скок в откриването (трафик), но по-нисък процент на реализация, защото достигате до всички в Hacker News. Ако обаче вашият Ruby проект бъде представен на Ruby конференция, е по-вероятно да видите висок процент на реализация от целева аудитория.

Опитайте се да разберете откъде идва вашата аудитория и помолете другите за обратна връзка на страницата на вашия проект, за да разберете с кой от тези два проблема се сблъсквате.

След като разберете, че хората използват вашия проект, може да искате да опитате да разберете какво правят с него. Надграждат ли го, като разклоняват вашия код и добавят функции? Използват ли го за наука или за бизнес?

## Задържане

Хората намират вашия проект и го използват. Следващият въпрос, който ще искате да си зададете, е: _хората допринасят ли обратно за този проект?_

Никога не е твърде рано да започнете да мислите за сътрудници. Без други хора да се намесят, рискувате да се поставите в нездравословна ситуация, в която вашият проект е _популярен_ (много хора го използват), но не е _поддържан_ (няма достатъчно време за поддръжка, за да отговори на търсенето).

Задържането също така изисква [приток на нови сътрудници](http://blog.abigailcabunoc.com/increasing-developer-engagement-at-mozilla-science-learning-advocacy#contributor-pathways_2), тъй като предишните активни сътрудници в крайна сметка ще продължат напред към други неща.

Примери за показатели на общността, които може да искате да проследявате редовно, включват:

* **Общ брой сътрудници и брой ангажименти на сътрудник:** Ви казва колко сътрудници имате и кой е повече или по-малко активен. В GitHub можете да видите това под "Прозрения" -> "Сътрудници". В момента тази графика отчита само сътрудници, които са се ангажирали с клона по подразбиране на хранилището.

![Графика на сътрудник](/assets/images/metrics/repo_contributors_specific_graph.png)

* **Първи, случайни и повторни сътрудници:** Помага ви да проследите дали получавате нови сътрудници и дали те се връщат. (Случайните сътрудници са сътрудници с малък брой ангажименти. Дали това е един комит, по-малко от пет ангажимента или нещо друго зависи от вас.) Без нови сътрудници общността на вашия проект може да изпадне в застой.

* **Брой отворени проблеми и отворени заявки за изтегляне:** Ако тези числа станат твърде високи, може да се нуждаете от помощ при сортирането на проблеми и прегледите на кода.

* **Брой _отворени_ проблеми и _отворени_ заявки за изтегляне:** Отворените проблеми означават, че някой се интересува достатъчно от вашия проект, за да отвори проблем. Ако този брой се увеличи с течение на времето, това предполага, че хората се интересуват от вашия проект.

* **Видове приноси:** Например ангажименти, коригиране на правописни грешки или грешки или коментиране на проблем.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/arfon?s=180" class="pquote-avatar" alt="avatar">
  Отвореният код е нещо повече от код. Успешните проекти с отворен код включват принос на код и документация заедно с разговори за тези промени.
  <p markdown="1" class="pquote-credit">
— @arfon, ["Формата на отворения код"](https://github.com/blog/2195-the-shape-of-open-source)
  </p>
</aside>

## Поддържаща дейност

И накрая, ще искате да затворите цикъла, като се уверите, че поддържащите вашия проект са в състояние да се справят с обема на получените вноски. Последният въпрос, който ще искате да си зададете е: _отговарям ли (или ние) на нашата общност?_

Неотзивчивите поддържащи се превръщат в пречка за проекти с отворен код. Ако някой изпрати принос, но никога не получи отговор от поддържащия, той може да се почувства обезсърчен и да напусне.

[Изследване от Mozilla](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177) предполага, че отзивчивостта на поддържащия е критичен фактор за насърчаване на повтарящи се приноси.

Помислете за [проследяване колко време отнема на вас (или на друг поддържащ) да отговорите на приносите](https://github.blog/2023-07-19-metrics-for-issues-pull-requests-and-discussions/), дали проблем или заявка за изтегляне. Отговорът не изисква предприемане на действие. Може да бъде толкова просто, колкото да кажете: _"Благодаря за вашето изпращане! Ще прегледам това през следващата седмица."_

Можете също да измерите времето, необходимо за преминаване между етапите в процеса на принос, като например:

* Средно време, през което проблемът остава отворен
* Дали проблемите се затварят от PRте
* Дали остарелите проблеми се затварят
* Средно време за обединяване на заявка за изтегляне

## Използвайте 📊, за да научите за хората

Разбирането на показателите ще ви помогне да изградите активен, разрастващ се проект с отворен код. Дори и да не проследявате всеки показател на таблото за управление, използвайте рамката по-горе, за да фокусирате вниманието си върху типа поведение, което ще помогне на вашия проект да процъфтява.

[CHAOSS](https://chaoss.community/) е гостоприемна общност с отворен код, фокусирана върху анализи, показатели и софтуер за здравето на общността.
