---
lang: bg
untranslated: true
title: Поддържане на баланс за поддържащите отворен код
description: Съвети за самообслужване и избягване на прегаряне като поддържащ.
class: balance
order: 0
image: /assets/images/cards/maintaining-balance-for-open-source-maintainers.png
---

Тъй като популярността на проекта с отворен код нараства, става важно да поставите ясни граници, които да ви помогнат да поддържате баланс, за да останете освежени и продуктивни в дългосрочен план.

За да придобием представа за опита на поддържащите и техните стратегии за намиране на баланс, проведохме семинар с 40 членове на <a href="http://maintainers.github.com/">общността на поддържащите</a>, което ни позволи да се поучат от техния опит от първа ръка с бърнаут в отворен код и практиките, които са им помогнали да поддържат баланс в работата си. Тук влиза в действие концепцията за лична екология.

И така, какво е лична екология? Като <a href="https://rockwoodleadership.org/nonprofit-four-day-workweek-can-take-care-still-change-world/#:~:text=personal%20ecology%3A%20maintaining%20balance% 2C%20pacing%20and%20efficiency%20to%20sustain%20your%20energy%20over%20a%20lifetime%20of%20activism">описано от Rockwood Leadership Institute</a>, то включва "<strong>поддържане на баланс, темпо и ефективност за поддържане на енергията ни през целия живот</strong>." Това рамкира нашите разговори, помагайки на поддържащите да разпознаят своите действия и приноси като части от по-голяма екосистема, която се развива с течение на времето. Бърнаут, синдром в резултат на хроничен стрес на работното място, както [дефиниран от СЗО](https://icd.who.int/browse11/l-m/en#/http://id.who.int/icd/entity/129180281) , не е необичайно сред поддържащите. Това често води до загуба на мотивация, невъзможност за фокусиране и липса на съпричастност към сътрудниците и общността, с която работите.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gabek?s=180" class="pquote-avatar" alt="avatar">
  Не можах да се съсредоточа или да започна задача. Липсваше ми съчувствие към потребителите.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/gabek">@gabek</a>, поддържащ сървъра за стрийминг на живо Owncast, за въздействието на прегарянето върху неговата работа с отворен код
  </p>
</aside>

Възприемайки концепцията за лична екология, поддържащите могат проактивно да избягват прегарянето, да дават приоритет на грижата за себе си и да поддържат чувство за баланс, за да вършат най-добрата си работа.

## Съвети за самообслужване и избягване на прегаряне като поддържащ персонал:

### Определете вашите мотивации за работа с отворен код

Отделете време, за да помислите кои части от поддръжката с отворен код ви зареждат с енергия. Разбирането на вашата мотивация може да ви помогне да приоритизирате работата по начин, който ви държи ангажирани и готови за нови предизвикателства. Независимо дали става въпрос за положителната обратна връзка от потребителите, радостта от сътрудничеството и общуването с общността или удовлетворението от гмуркането в кода, разпознаването на вашите мотивации може да ви помогне да насочите фокуса си.

### Помислете какво ви кара да излизате от баланс и да сте стресирани

Важно е да разберем какво ни кара да изгаряме. Ето няколко общи теми, които видяхме сред поддържащите отворен код:

* **Липса на положителна обратна връзка:** Много по-вероятно е потребителите да се свържат, когато имат оплакване. Ако всичко работи добре, те са склонни да мълчат. Може да е обезкуражаващо да видите нарастващ списък от проблеми без положителната обратна връзка, показваща как вашият принос прави разликата.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/thisisnic?s=180" class="pquote-avatar" alt="avatar">
  Понякога се чувствам малко като да крещя в празнотата и откривам, че обратната връзка наистина ме зарежда с енергия. Имаме много щастливи, но тихи потребители.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/thisisnic">@thisisnic</a>, поддържащ Apache Arrow
  </p>
</aside>

* **Да не казваш "не":** Може да е лесно да поемеш повече отговорности, отколкото би трябвало за проект с отворен код. Независимо дали е от потребители, сътрудници или други поддържащи – ние не винаги можем да оправдаем техните очаквания.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/agnostic-apollo?s=180" class="pquote-avatar" alt="avatar">
  Открих, че поемам повече от един и трябва да върша работата на множество хора, както обикновено се прави във FOSS.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/agnostic-apollo">@agnostic-apollo</a>, поддържащ Termux, за това какво причинява прегаряне в тяхната работа
  </p>
</aside>

* **Да работиш сам:** Да си поддържащ може да бъде невероятно самотен. Дори ако работите с група поддържащи, последните няколко години бяха трудни за свикване на разпределени екипи лично.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gabek?s=180" class="pquote-avatar" alt="avatar">
 Особено след COVID и работата от вкъщи е по-трудно никога да не виждаш никого или да говориш с никого.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/gabek">@gabek</a>, поддържащ сървъра за стрийминг на живо Owncast, за въздействието на прегарянето върху неговата работа с отворен код
  </p>
</aside>

* **Няма достатъчно време или ресурси:** Това е особено вярно за поддържащи доброволци, които трябва да жертват свободното си време, за да работят по проект.

<aside markdown="1" class="pquote">
  [Бих искал да имам] повече финансова подкрепа, за да мога да се съсредоточа върху работата с отворен код, без да изразходвам спестяванията си и да знам, че ще трябва да сключвам много договори, за да компенсирам това по-късно.
  <p markdown="1" class="pquote-credit">
— поддържащ отворен код
  </p>
</aside>

* **Противоречиви изисквания:** Отвореният код е пълен с групи с различни мотивации, които могат да бъдат трудни за ориентиране. Ако ви се плаща да работите с отворен код, интересите на вашия работодател понякога могат да бъдат в противоречие с общността.

<aside markdown="1" class="pquote">
  С платен отворен код, конфликт между фокуса на работодателя и най-доброто за общността
  <p markdown="1" class="pquote-credit">
— поддържащ отворен код
  </p>
</aside>

### Внимавайте за признаци на прегаряне

Можете ли да поддържате темпото си 10 седмици? 10 месеца? 10 години?

Има инструменти като [Burnout Checklist](https://governingopen.com/resources/signs-of-burnout-checklist.html) от [@shaunagm](https://github.com/shaunagm), които могат да ви помогнат помислете върху текущото си темпо и вижте дали има някакви корекции, които можете да направите. Някои поддържащи също използват технология за носене, за да проследяват показатели като качество на съня и променливост на сърдечната честота (и двете свързани със стреса).

<aside markdown="1" class="pquote">
 Аз съм голям привърженик на добрите облекла. С науката зад това можете да разберете как бихте могли да се справите по-добре и как да стигнете до оптимално състояние на това, което искате да правите.
  <p markdown="1" class="pquote-credit">
— поддържащ отворен код
  </p>
</aside>

### От какво се нуждаете, за да продължите да поддържате себе си и общността си?

Това ще изглежда различно за всеки поддържащ и ще се променя в зависимост от вашата фаза от живота и други външни фактори. Но ето няколко теми, които чухме:

* **Разчитайте на общността:** Делегирането и намирането на сътрудници може да облекчи работното натоварване. Наличието на множество точки за контакт за даден проект може да ви помогне да си починете, без да се притеснявате. Свържете се с други поддържащи и по-широката общност – в групи като [Maintainer Community](http://maintainers.github.com/). Това може да бъде чудесен ресурс за партньорска подкрепа и обучение.

   Можете също така да търсите начини да се ангажирате с потребителската общност, така че да можете редовно да чувате обратна връзка и да разбирате въздействието на вашата работа с отворен код.

* **Разгледайте финансирането:** Независимо дали търсите малко пари за пица или се опитвате да преминете на пълен работен ден към отворен код, има много ресурси, които да ви помогнат! Като първа стъпка помислете дали да не включите [Спонсорите на GitHub](https://github.com/sponsors), за да позволите на други да спонсорират вашата работа с отворен код. Ако обмисляте да преминете към пълен работен ден, кандидатствайте за следващия кръг на [GitHub Accelerator](http://accelerator.github.com/).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mansona?s=180" class="pquote-avatar" alt="avatar">
 Бях в подкаст преди малко и си говорехме за поддръжка с отворен код и устойчивост. Открих, че дори малък брой хора, които подкрепят работата ми в GitHub, ми помогнаха да взема бързо решение да не седя пред игра, а вместо това да направя едно малко нещо с отворен код.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/mansona">@mansona</a>, поддържащ EmberJS
  </p>
</aside>

* **Използвайте инструменти:** Разгледайте инструменти като [GitHub Copilot](https://github.com/features/copilot/) и [GitHub Actions](https://github.com/features/actions), за да автоматизирате светски задачи и освободете времето си за по-значими приноси.

<aside markdown="1" class="pquote">
 Използвайте [Copilot](https://github.com/features/copilot/) за скучните неща - правете забавните неща
  <p markdown="1" class="pquote-credit">
— поддържащ отворен код
  </p>
</aside>

* **Почивка и презареждане:** Отделете време за вашите хобита и интереси извън отворен код. Вземете почивни дни, за да се отпуснете и да се подмладите – и задайте своя [статус в GitHub](https://docs.github.com/account-and-profile/setting-up-and-managing-your-github-profile/customizing-your-profile/personalizing-your-profile#setting-a-status), за да отразява вашата наличност! Добрият нощен сън може да направи голяма разлика в способността ви да поддържате усилията си в дългосрочен план.

   Ако намирате определени аспекти от вашия проект за особено приятни, опитайте се да структурирате работата си, така че да можете да я изживявате през целия си ден.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/danielroe?s=180" class="pquote-avatar" alt="avatar">
 Намирам повече възможност да поръся "моменти на творчество" в средата на деня, вместо да се опитвам да се изключа вечер.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/danielroe">@danielroe</a>, поддържащ Nuxt
  </p>
</aside>

* **Задайте граници:** Не можете да кажете "да" на всяка молба. Това може да бъде толкова просто, колкото да кажете: "Не мога да стигна до това в момента и нямам планове за бъдещето" или да посочите какво искате да правите и какво да не правите в README. Например, можете да кажете: "Аз обединявам само PR-и, които имат ясно изброени причини, поради които са направени", или "Преглеждам проблемите само в четвъртък от 18 до 19 часа". Това определя очакванията за другите и ви дава нещо да посочите в други моменти, за да помогнете за намаляване на изискванията от сътрудници или потребители във вашето време.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikemcquaid?s=180" class="pquote-avatar" alt="avatar">
За да се доверите смислено на другите по тези оси, не можете да сте някой, който казва "да" на всяка молба. Правейки това, вие не поддържате никакви граници, професионално или лично, и няма да бъдете надежден колега.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/mikemcquaid">@mikemcquaid</a>, поддържащ Homebrew на [Казвайки не](https://mikemcquaid.com/saying-no/)
  </p>
</aside>

  Научете се да сте твърди в спирането на токсичното поведение и негативните взаимодействия. Добре е да не давате енергия на неща, които не ви интересуват.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/IvanSanchez?s=180" class="pquote-avatar" alt="avatar">
    Моят софтуер е безплатен, но моето време и внимание не са.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/IvanSanchez">@IvanSanchez</a>, поддържащ Leaflet
  </p>
</aside>

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/foosel?s=180" class="pquote-avatar" alt="avatar">
    Не е тайна, че поддръжката с отворен код има своите тъмни страни и една от тях е понякога да се налага да взаимодействате с доста неблагодарни, имащи право или направо токсични хора. С нарастването на популярността на даден проект нараства и честотата на този вид взаимодействие, което увеличава тежестта, поета от поддържащите, и вероятно се превръща в значителен рисков фактор за прегаряне на поддържащия.  
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/foosel">@foosel</a>, поддържащ Octoprint на [Как да се справим с токсичните хора](https://www.youtube.com/watch?v=7lIpP3GEyXs)
  </p>
</aside>

Не забравяйте, че личната екология е постоянна практика, която ще се развива, докато напредвате във вашето пътуване с отворен код. Като приоритизирате грижата за себе си и поддържате чувството за баланс, можете да допринесете за общността с отворен код ефективно и устойчиво, гарантирайки както вашето благополучие, така и успеха на вашите проекти в дългосрочен план.

## Допълнителни ресурси

* [Maintainer Community](http://maintainers.github.com/)
* [The social contract of open source](https://snarky.ca/the-social-contract-of-open-source/), Brett Cannon
* [Uncurled](https://daniel.haxx.se/uncurled/), Daniel Stenberg 
* [How to deal with toxic people](https://www.youtube.com/watch?v=7lIpP3GEyXs), Gina Häußge
* [SustainOSS](https://sustainoss.org/)
* [Rockwood Art of Leadership](https://rockwoodleadership.org/art-of-leadership/)
* [Saying No](https://mikemcquaid.com/saying-no/), Mike McQuaid
* [Governing Open](https://governingopen.com/)
* Програмата на семинара е ремиксирана от поредицата на [Mozilla's Movement Building from Home](https://foundation.mozilla.org/en/blog/its-a-wrap-movement-building-from-home/)

## Сътрудници

Много благодаря на всички поддържащи, които споделиха своя опит и съвети с нас за това ръководство!

Това ръководство е написано от [@abbycabs](https://github.com/abbycabs) с принос от: 

[@agnostic-apollo](https://github.com/agnostic-apollo)
[@AndreaGriffiths11](https://github.com/AndreaGriffiths11)
[@antfu](https://github.com/antfu)
[@anthonyronda](https://github.com/anthonyronda)
[@CBID2](https://github.com/CBID2)
[@Cli4d](https://github.com/Cli4d)
[@confused-Techie](https://github.com/confused-Techie)
[@danielroe](https://github.com/danielroe)
[@Dexters-Hub](https://github.com/Dexters-Hub)
[@eddiejaoude](https://github.com/eddiejaoude)
[@Eugeny](https://github.com/Eugeny)
[@ferki](https://github.com/ferki)
[@gabek](https://github.com/gabek)
[@geromegrignon](https://github.com/geromegrignon)
[@hynek](https://github.com/hynek)
[@IvanSanchez](https://github.com/IvanSanchez)
[@karasowles](https://github.com/karasowles)
[@KoolTheba](https://github.com/KoolTheba)
[@leereilly](https://github.com/leereilly)
[@ljharb](https://github.com/ljharb)
[@nightlark](https://github.com/nightlark)
[@plarson3427](https://github.com/plarson3427)
[@Pradumnasaraf](https://github.com/Pradumnasaraf)
[@RichardLitt](https://github.com/RichardLitt)
[@rrousselGit](https://github.com/rrousselGit)
[@sansyrox](https://github.com/sansyrox)
[@schlessera](https://github.com/schlessera)
[@shyim](https://github.com/shyim)
[@smashah](https://github.com/smashah)
[@ssalbdivad](https://github.com/ssalbdivad)
[@The-Compiler](https://github.com/The-Compiler)
[@thehale](https://github.com/thehale)
[@thisisnic](https://github.com/thisisnic)
[@tudoramariei](https://github.com/tudoramariei)
[@UlisesGascon](https://github.com/UlisesGascon)
[@waldyrious](https://github.com/waldyrious) + много други!
