---
lang: bg
title: Лидерство и управление
description: Разрастващите се проекти с отворен код могат да се възползват от формалните правила за вземане на решения.
class: leadership
order: 6
image: /assets/images/cards/leadership.png
related:
  - best-practices
  - metrics
---

## Разбиране на управлението за вашия разрастващ се проект

Вашият проект се разраства, хората са ангажирани и вие сте ангажирани да поддържате това нещо. На този етап може да се чудите как да включите редовни сътрудници на проекта във вашия работен процес, независимо дали става дума за даване на достъп за ангажимент или разрешаване на дебати в общността. Ако имате въпроси, ние имаме отговори.

## Какви са примерите за официални роли, използвани в проекти с отворен код?

Много проекти следват подобна структура за роли на сътрудници и признание.

Какво всъщност означават тези роли обаче, зависи изцяло от вас. Ето няколко типа роли, които може да разпознаете:

* **Поддържащ**
* **Сътрудник**
* **Комитер**

**За някои проекти "поддържащите"** са единствените хора в проект с достъп за ангажиране. В други проекти те са просто хората, които са изброени в README като поддържащи.

Поддържащият не е задължително да е някой, който пише код за вашия проект. Може да е някой, който е свършил много работа по евангелизирането на вашия проект, или писмена документация, която е направила проекта по-достъпен за другите. Независимо от това, което прави всеки ден, поддържащият вероятно е някой, който се чувства отговорен за посоката на проекта и се е ангажирал да го подобри.

**"Сътрудник" може да бъде всеки**, който коментира проблем или заявка за изтегляне, хора, които добавят стойност към проекта (независимо дали става въпрос за сортиране на проблеми, писане на код или организиране на събития), или всеки с обединена заявка за изтегляне (може би най-тясната дефиниция на сътрудник).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikeal?s=180" class="pquote-avatar" alt="avatar">
  \[За Node.js,\] всеки човек, който се появява, за да коментира проблем или да изпрати код, е член на общността на проекта. Само възможността да ги видите означава, че са преминали границата от потребител до сътрудник.
  <p markdown="1" class="pquote-credit">
— @mikeal, ["Healthy Open Source"](https://medium.com/the-javascript-collection/healthy-open-source-967fa8be7951)
  </p>
</aside>

**Терминът "извършител"** може да се използва за разграничаване на достъпа за ангажиране, който е специфичен тип отговорност, от други форми на принос.

Въпреки че можете да дефинирате ролите си в проекта както желаете, [помислете дали да не използвате по-широки дефиниции](../how-to-contribute/#какво-означава-да-допринасяш), за да насърчите повече форми на принос. Можете да използвате лидерски роли, за да признаете официално хора, които са направили изключителен принос към вашия проект, независимо от техните технически умения.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jacobian?s=180" class="pquote-avatar" alt="avatar">
  Може да ме познавате като "изобретателя" на Django...но всъщност аз съм човекът, който беше нает да работи върху нещо година след като то вече беше направено. (...) Хората подозират, че съм успешен благодарение на уменията ми за програмиране...но в най-добрия случай съм среден програмист.
  <p markdown="1" class="pquote-credit">
— @jacobian, ["Основна бележка на PyCon 2015" (video)](https://www.youtube.com/watch?v=hIJdFxYlEKE#t=5m0s)
  </p>
</aside>

## Как да формализирам тези лидерски роли?

Формализирането на вашите лидерски роли помага на хората да се чувстват собственост и казва на другите членове на общността към кого да търсят помощ.

За по-малък проект определянето на лидери може да бъде толкова просто, колкото добавянето на техните имена към вашия README или текстов файл CONTRIBUTORS.

За по-голям проект, ако имате уебсайт, създайте страница на екип или избройте ръководителите на проекта си там. Например [Postgres](https://github.com/postgres/postgres/) има [изчерпателна екипна страница](https://www.postgresql.org/community/contributors/) с кратки профили за всеки участник.

Ако вашият проект има много активна общност на сътрудници, можете да сформирате "основен екип" от поддържащи или дори подкомитети от хора, които поемат отговорност за различни проблемни области (например сигурност, сортиране на проблеми или поведение на общността). Позволете на хората да се самоорганизират и доброволно изпълняват ролите, които ги вълнуват най-много, вместо да ги възлагат.

<aside markdown="1" class="pquote">
  \[Ние\] допълваме основния екип с няколко "подекипа". Всеки подекип е фокусиран върху конкретна област, например езиков дизайн или библиотеки. (...) За да се осигури глобална координация и силна, съгласувана визия за проекта като цяло, всеки подекип се ръководи от член на основния екип.
  <p markdown="1" class="pquote-credit">
— ["RFC за управление на Rust"](https://github.com/rust-lang/rfcs/blob/HEAD/text/1068-rust-governance.md)
  </p>
</aside>

Лидерските екипи може да искат да създадат определен канал (като в IRC) или да се срещат редовно, за да обсъждат проекта (като в Gitter или Google Hangout). Можете дори да направите тези срещи публични, така че други хора да могат да слушат. [Cucumber-ruby](https://github.com/cucumber/cucumber-ruby), например, [поема работно време всяка седмица](https://github.com/cucumber/cucumber-ruby/blob/HEAD/CONTRIBUTING.md#talking-with-other-devs).

След като сте установили лидерски роли, не забравяйте да документирате как хората могат да ги постигнат! Установете ясен процес за това как някой може да стане поддържащ или да се присъедини към подкомисия във вашия проект и го напишете във вашия GOVERNANCE.md.

Инструменти като [Vossibility](https://github.com/icecrime/vossibility-stack) могат да ви помогнат публично да проследите кой (или не) прави принос към проекта. Документирането на тази информация избягва възприемането на общността, че поддържащите са клика, която взема решенията си частно.

И накрая, ако проектът ви е в GitHub, помислете за преместване на проекта от личния ви акаунт в организация и добавяне на поне един резервен администратор. [Организациите на GitHub](https://help.github.com/articles/creating-a-new-organization-account/) улесняват управлението на разрешения и множество хранилища и защитават наследството на вашия проект чрез [споделена собственост](../building-community/#споделете-собствеността-върху-вашия-проект).

## Кога трябва да дам на някого достъп за ангажиране?

Някои хора смятат, че трябва да дадете достъп за ангажиране на всеки, който направи принос. Това може да насърчи повече хора да почувстват собственост върху вашия проект.

От друга страна, особено за по-големи, по-сложни проекти, може да искате да дадете достъп за ангажиране само на хора, които са демонстрирали своя ангажимент. Няма един правилен начин да го направите - направете това, което ви прави най-удобно!

Ако вашият проект е в GitHub, можете да използвате [защитени клонове](https://help.github.com/articles/about-protected-branches/), за да управлявате кой може да насочва към определен клон и при какви обстоятелства.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/felixge?s=180" class="pquote-avatar" alt="avatar">
  Всеки път, когато някой ви изпрати заявка за изтегляне, дайте му достъп до вашия проект. Въпреки че в началото може да звучи невероятно глупаво, използването на тази стратегия ще ви позволи да разгърнете истинската сила на GitHub. (...) След като хората имат достъп за ангажиране, те вече не се притесняват, че корекцията им може да остане необединена... което ги кара да положат много повече работа в нея.
  <p markdown="1" class="pquote-credit">
— @felixge, ["Хакът на заявка за изтегляне"](https://felixge.de/2013/03/11/the-pull-request-hack.html)
  </p>
</aside>

## Какви са някои от общите структури на управление за проекти с отворен код?

Има три общи структури на управление, свързани с проекти с отворен код.

* **BDFL:** BDFL означава "Доброжелателен диктатор за цял живот". При тази структура един човек (обикновено първоначалният автор на проекта) има последната дума за всички основни решения по проекта. [Python](https://github.com/python) е класически пример. По-малките проекти вероятно са BDFL по подразбиране, защото има само един или двама поддържащи. Проект, който произхожда от компания, може също да попадне в категорията BDFL.

* **Меритокрация:** (Забележка: терминът "меритокрация" носи отрицателни конотации за някои общности и има [сложна социална и политическа история](http://geekfeminism.wikia.com/wiki/Meritocracy).) ** При меритокрацията на активните участници в проекти (тези, които демонстрират "заслуги") се дава официална роля за вземане на решения. Решенията обикновено се вземат въз основа на чист консенсус при гласуване. Концепцията за меритокрация е въведена от [Фондация Apache](https://www.apache.org/); [всички проекти на Apache](https://www.apache.org/index.html#projects-list) са меритокрации. Вноски могат да се правят само от лица, представляващи себе си, а не от компания.

* **Либерален принос:** При либерален модел на принос хората, които вършат най-много работа, се признават за най-влиятелни, но това се основава на текуща работа, а не на исторически принос. Решенията за големи проекти се вземат въз основа на процес на търсене на консенсус (обсъждане на основните оплаквания), а не на чисто гласуване, и се стремят да включват възможно най-много гледни точки на общността. Популярни примери за проекти, които използват либерален модел на принос, включват [Node.js](https://foundation.nodejs.org/) и [Rust](https://www.rust-lang.org/).

Кое трябва да използвате? От теб зависи! Всеки модел има предимства и компромиси. И въпреки че в началото може да изглеждат доста различни, и трите модела имат повече общо, отколкото изглежда. Ако се интересувате от приемането на един от тези модели, вижтеthese templates:

* [BDFL model template](http://oss-watch.ac.uk/resources/benevolentdictatorgovernancemodel)
* [Meritocracy model template](http://oss-watch.ac.uk/resources/meritocraticgovernancemodel)
* [Node.js's liberal contribution policy](https://medium.com/the-node-js-collection/healthy-open-source-967fa8be7951)

## Имам ли нужда от документи за управление, когато стартирам проекта си?

Няма подходящ момент да запишете управлението на вашия проект, но е много по-лесно да го дефинирате, след като видите как се развива динамиката на вашата общност. Най-добрата (и най-трудната) част от управлението с отворен код е, че е оформено от общността!

Някои ранни документи обаче неизбежно ще допринесат за управлението на вашия проект, така че започнете да записвате каквото можете. Например, можете да дефинирате ясни очаквания за поведение или как работи вашият процес на сътрудник, дори при стартирането на вашия проект.

Ако сте част от компания, стартираща проект с отворен код, струва си да проведете вътрешна дискусия преди стартирането за това как вашата компания очаква да поддържа и да взема решения за напредъка на проекта. Можете също така да искате публично да обясните нещо конкретно за това как вашата компания ще (или няма!) да бъде включена в проекта.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/caabernathy?s=180" class="pquote-avatar" alt="avatar">
  Назначаваме малки екипи за управление на проекти в GitHub, които всъщност работят върху тях във Facebook. Например React се управлява от React инженер.
  <p markdown="1" class="pquote-credit">
— @caabernathy, ["An inside look at open source at Facebook"](https://opensource.com/life/15/10/ato-interview-christine-abernathy-facebook)
  </p>
</aside>

## Какво се случва, ако корпоративните служители започнат да изпращат вноски?

Успешните проекти с отворен код се използват от много хора и компании и някои компании може в крайна сметка да имат потоци от приходи, които в крайна сметка да са свързани с проекта. Например, една компания може да използва кода на проекта като един компонент в предлагането на търговска услуга.

Тъй като проектът се използва по-широко, хората, които имат опит в него, стават все по-търсени - вие може да сте един от тях! - и понякога ще получават заплащане за работата, която вършат в проекта.

Важно е търговската дейност да се третира като нормална и просто като още един източник на енергия за развитие. Разбира се, платените разработчици не трябва да получават специално отношение спрямо неплатените; всеки принос трябва да бъде оценен според техническите си качества. Въпреки това, хората трябва да се чувстват комфортно да участват в търговска дейност и да се чувстват комфортно да посочват своите случаи на употреба, когато спорят в полза на определено подобрение или функция.

"Комерсиален" е напълно съвместим с "отворен код". "Търговски" просто означава, че някъде има замесени пари – че софтуерът се използва в търговията, което е все по-вероятно, тъй като даден проект получава приемане. (Когато софтуер с отворен код се използва като част от продукт с неотворен код, цялостният продукт все още е "патентован" софтуер, въпреки че, подобно на отворен код, може да се използва за търговски или нетърговски цели.)

Като всеки друг, комерсиално мотивираните разработчици печелят влияние в проекта чрез качеството и количеството на техния принос. Очевидно програмист, който получава заплащане за времето си, може да е в състояние да направи повече от някой, който не получава заплащане, но това е добре: плащането е само един от многото възможни фактори, които могат да повлияят на това колко прави някой. Поддържайте дискусиите по проекта си фокусирани върху приноса, а не върху външните фактори, които позволяват на хората да направят този принос.

## Нуждая ли се от юридическо лице, което да поддържа моя проект?

Нямате нужда от юридическо лице, за да поддържате вашия проект с отворен код, освен ако не боравите с пари.

Например, ако искате да създадете търговски бизнес, ще искате да създадете C Corp или LLC (ако сте базирани в САЩ). Ако просто работите по договор, свързан с вашия проект с отворен код, можете да приемате пари като едноличен собственик или да създадете LLC (ако сте базирани в САЩ).

Ако искате да приемате дарения за вашия проект с отворен код, можете да настроите бутон за дарение (с помощта на PayPal или Stripe, например), но парите няма да се приспадат от данъци, освен ако не сте квалифицирана организация с нестопанска цел (501c3, ако вие сте в САЩ).

Много проекти не желаят да преминат през неприятностите при създаването на организация с нестопанска цел, така че вместо това намират фискален спонсор с нестопанска цел. Фискален спонсор приема дарения от ваше име, обикновено в замяна на процент от дарението. [Software Freedom Conservancy](https://sfconservancy.org/), [Apache Foundation](https://www.apache.org/), [Eclipse Foundation](https://eclipse.org/org/foundation/), [Linux Foundation](https://www.linuxfoundation.org/projects) и [Open Collective](https://opencollective.com/opensource) са примери за организации, които служат като фискални спонсори за проекти с отворен код.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/piamancini?s=180" class="pquote-avatar" alt="avatar">
  Нашата цел е да предоставим инфраструктура, която общностите могат да използват, за да бъдат самоустойчиви, като по този начин създаваме среда, в която всички — сътрудници, поддръжници, спонсори — извличат конкретни ползи от това.
  <p markdown="1" class="pquote-credit">
— @piamancini, ["Преминаване извън рамката на благотворителността"](https://medium.com/open-collective/moving-beyond-the-charity-framework-b1191c33141)
  </p>
</aside>

Ако вашият проект е тясно свързан с определен език или екосистема, може да има и свързана софтуерна основа, с която можете да работите. Например [Python Software Foundation](https://www.python.org/psf/) помага за поддръжката на [PyPI](https://pypi.org/), мениджъра на пакети на Python и [Node.js Foundation](https://foundation.nodejs.org/) помага за поддръжката на [Express.js](https://expressjs.com/), базирана на възли рамка.
