---
lang: bg
title: Как да допринесете за отворения код
description: Искате ли да допринесете за отворен код? Ръководство за правене на приноси с отворен код за начинаещи и за ветерани.
class: contribute
order: 1
image: /assets/images/cards/contribute.png
related:
  - beginners
  - building
---

## Защо да допринасяте за отворен код?

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/errietta?s=180" class="pquote-avatar" alt="avatar">
  Работата върху \[freenode\] ми помогна да спечеля много от уменията, които по-късно използвах за обучението си в университета и действителната си работа. Мисля, че работата по проекти с отворен код ми помага толкова, колкото и на проекта!
  <p markdown="1" class="pquote-credit">
— [@errietta](https://github.com/errietta), ["Защо обичам да допринасям за софтуер с отворен код"](https://www.errietta.me/blog/open-source/)
  </p>
</aside>

Приносът към отворен код може да бъде възнаграждаващ начин за учене, преподаване и изграждане на опит в почти всяко умение, което можете да си представите.

Защо хората допринасят за отворен код? Много причини!

### Подобрете софтуера, на който разчитате

Много сътрудници с отворен код започват като потребители на софтуер, за който допринасят. Когато намерите грешка в софтуер с отворен код, който използвате, може да искате да погледнете източника, за да видите дали можете да го коригирате сами. Ако случаят е такъв, тогава връщането на корекцията е най-добрият начин да се уверите, че вашите приятели (и вие самите, когато актуализирате до следващото издание) ще могат да се възползват от нея.

### Подобрете съществуващите умения

Независимо дали става въпрос за кодиране, дизайн на потребителски интерфейс, графичен дизайн, писане или организиране, ако търсите практика, има задача за вас по проект с отворен код.

### Запознайте се с хора, които се интересуват от подобни неща

Проекти с отворен код с топли, гостоприемни общности карат хората да се връщат с години. Много хора създават приятелства за цял живот чрез участието си в отворен код, независимо дали се срещат по време на конференции или късно вечерни онлайн чатове за бурито.

### Намерете ментори и учете другите

Работата с други по споделен проект означава, че ще трябва да обясните как правите нещата, както и да помолите други хора за помощ. Действията на учене и преподаване могат да бъдат удовлетворяваща дейност за всички участници.

### Изградете публични артефакти, които ви помагат да развиете репутация (и кариера)

По дефиниция цялата ви работа с отворен код е публична, което означава, че получавате безплатни примери, които да вземете навсякъде като демонстрация на това, което можете да правите.

### Научете умения за хора

Отвореният код предлага възможности за практикуване на лидерски и управленски умения, като разрешаване на конфликти, организиране на екипи от хора и приоритизиране на работата.

### Овластяващо е да можеш да правиш промени, дори малки

Не е нужно да сте сътрудник през целия живот, за да се насладите на участието в отворен код. Случвало ли ви се е да видите печатна грешка в уебсайт и да ви се иска някой да я поправи? В проект с отворен код можете да направите точно това. Отвореният код помага на хората да се чувстват независими от живота си и начина, по който преживяват света, и това само по себе си е удовлетворяващо.

## Какво означава да допринасяш

Ако сте нов сътрудник на отворен код, процесът може да бъде смущаващ. Как намирате правилния проект? Ами ако не знаете как да кодирате? Ами ако нещо се обърка?

Не се притеснявайте! Има всякакви начини да се включите в проект с отворен код и няколко съвета ще ви помогнат да извлечете максимума от опита си.

### Не е нужно да добавяте код

Често срещано погрешно схващане относно приноса към отворен код е, че трябва да допринесете с код. Всъщност често другите части на проекта са [най-пренебрегвани или пренебрегвани](https://github.com/blog/2195-the-shape-of-open-source). Ще направите _огромна_ услуга на проекта, като предложите да се включите с тези видове принос!

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/orta?s=180" class="pquote-avatar" alt="avatar">
  Известен съм с работата си върху CocoaPods, но повечето хора не знаят, че всъщност не правя реална работа върху самия инструмент CocoaPods. Времето ми по проекта минава предимно в правене на неща като документация и работа по брандиране.
  <p markdown="1" class="pquote-credit">
— [@orta](https://github.com/orta), ["Преминаване към OSS по подразбиране"](https://academy.realm.io/posts/orta-therox-moving-to-oss-by-default/)
  </p>
</aside>

Дори ако обичате да пишете код, други видове приноси са чудесен начин да се включите в проект и да се срещнете с други членове на общността. Изграждането на тези взаимоотношения ще ви даде възможности да работите върху други части на проекта.

### Обичате ли да планирате събития?

* Организирайте семинари или срещи за проекта, [както @fzamperin направи за NodeSchool](https://github.com/nodeschool/organizers/issues/406)
* Организирайте конференция на проекта (ако има такава)
* Помогнете на членовете на общността да намерят правилните конференции и да представят предложения за изказване

### Обичате ли да проектирате?

* Преструктурирайте оформленията, за да подобрите използваемостта на проекта
* Извършете потребителско проучване, за да реорганизирате и прецизирате навигацията или менютата на проекта, [както предлага Drupal](https://www.drupal.org/community-initiatives/drupal-core/usability)
* Съставете ръководство за стил, за да помогнете на проекта да има последователен визуален дизайн
* Създайте изкуство за тениски или ново лого, [както направиха сътрудниците на hapi.js](https://github.com/hapijs/contrib/issues/68)

### Обичаш ли да пишеш?

* Напишете и подобрете документацията на проекта, [както @CBID2 направи за документацията на OpenSauced](https://github.com/open-sauced/docs/pull/151)
* Подгответе папка с примери, показващи как се използва проектът
* Стартирайте бюлетин за проекта или подредете акценти от пощенския списък, [както направи @opensauced за своя продукт](https://news.opensauced.pizza/about/)
* Напишете уроци за проекта, [както направиха сътрудниците на PyPA](https://packaging.python.org/)
* Напишете превод за документацията на проекта, [както @frontendwizard направи за инструкциите за CSS Flexbox предизвикателството на freeCodeCamp](https://github.com/freeCodeCamp/freeCodeCamp/pull/19077)

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kittens?s=180" class="pquote-avatar" alt="avatar">
  Сериозно, \[документацията\] е изключително важна. Документацията досега беше страхотна и беше убийствена характеристика на Babel. Има раздели, които със сигурност биха могли да поработят и дори добавянето на параграф тук или там е изключително ценено.
  <p markdown="1" class="pquote-credit">
— @kittens, ["Покана за сътрудници"](https://github.com/babel/babel/issues/1347)
  </p>
</aside>

### Обичате ли да организирате?

* Връзка към дублирани проблеми и предлагане на теми за нови проблеми, за да поддържате организацията
* Прегледайте отворените проблеми и предложете затваряне на стари, [както направи @nzakas за ESLint](https://github.com/eslint/eslint/issues/6765)
* Задавайте изясняващи въпроси по наскоро открити въпроси, за да придвижите дискусията напред

### Обичате ли да кодирате?

* Намерете открит проблем, който да решите, [както @dianjin направи за Leaflet](https://github.com/Leaflet/Leaflet/issues/4528#issuecomment-216520560)
* Попитайте дали можете да помогнете за записването на нова функция
* Автоматизирайте настройките на проекта
* Подобрете инструментите и тестването

### Обичате ли да помагате на хората?

* Отговорете на въпроси относно проекта напр. Stack Overflow ([като този пример на Postgres](https://stackoverflow.com/questions/18664074/getting-error-peer-authentication-failed-for-user-postgres-when-trying-to-ge)) или Reddit
* Отговаряйте на въпроси за хора по отворени въпроси
* Помогнете за модерирането на дискусионните табла или каналите за разговори

### Обичате ли да помагате на другите да кодират?

* Прегледайте кода на изявленията на други хора
* Напишете уроци за това как може да се използва проект
* Предложете да наставлявате друг сътрудник, [както @ereichert направи за @bronzdoc в Rust](https://github.com/rust-lang/book/issues/123#issuecomment-238049666)

### Не е нужно просто да работите върху софтуерни проекти!

Докато "отворен код" често се отнася до софтуер, можете да си сътрудничите по почти всичко. Има книги, рецепти, списъци и класове, които се разработват като проекти с отворен код.

Например:

* @sindresorhus подготвя [списък с "страхотни" списъци](https://github.com/sindresorhus/awesome)
* @h5bp поддържа [списък с потенциални въпроси за интервю](https://github.com/h5bp/Front-end-Developer-Interview-Questions) за кандидати за фронтенд разработчици
* @stuartlynn и @nicole-a-tesla направиха [колекция от забавни факти за пуфините](https://github.com/stuartlynn/puffin_facts)

Дори и да сте разработчик на софтуер, работата по проект за документация може да ви помогне да започнете работа с отворен код. Често е по-малко смущаващо да работите по проекти, които не включват код, а процесът на сътрудничество ще изгради вашата увереност и опит.

## Ориентиране към нов проект

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shaunagm?s=180" class="pquote-avatar" alt="avatar">
  Ако отидете на инструмент за проследяване на проблеми и нещата изглеждат объркващи, не сте само вие. Тези инструменти изискват много имплицитни знания, но хората могат да ви помогнат да се ориентирате в тях и можете да им задавате въпроси.
  <p markdown="1" class="pquote-credit">
— @shaunagm, ["Как да допринесете за отворения код"](https://readwrite.com/2014/10/10/open-source-diversity-how-to-contribute/)
  </p>
</aside>

За нещо повече от поправка на печатна грешка, да допринесете за отворен код е като да отидете до група непознати на парти. Ако започнете да говорите за лами, докато те бяха потънали в дискусия за златните рибки, вероятно ще ви погледнат малко странно.

Преди да се включите сляпо със собствените си предложения, започнете, като се научите как да четете стаята. По този начин увеличавате шансовете вашите идеи да бъдат забелязани и чути.

### Анатомия на проект с отворен код

Всяка общност с отворен код е различна.

Прекарването на години в един проект с отворен код означава, че сте се запознали с един проект с отворен код. Преминете към друг проект и може да откриете, че речникът, нормите и стиловете на комуникация са напълно различни.

Въпреки това много проекти с отворен код следват подобна организационна структура. Разбирането на различните роли в общността и цялостния процес ще ви помогне бързо да се ориентирате към всеки нов проект.

Типичен проект с отворен код има следните типове хора:

* **Автор:** Лицето/лицата или организацията, създали проекта
* **Собственик:** Лицето/лицата, което има административна собственост върху организацията или хранилището (не винаги е същото като оригиналния автор)
* **Поддържащи:** Сътрудници, които са отговорни за управлението на визията и управлението на организационните аспекти на проекта (Те също могат да бъдат автори или собственици на проекта.)
* **Сътрудници:** Всеки, който е допринесъл с нещо обратно към проекта
* **Членове на общността:** Хората, които използват проекта. Те могат да бъдат активни в разговорите или да изразят мнението си за посоката на проекта

По-големите проекти могат също да имат подкомисии или работни групи, фокусирани върху различни задачи, като инструменти, сортиране, модериране на общността и организиране на събития. Потърсете в уебсайта на даден проект страница за "екип" или в хранилището за документация за управление, за да намерите тази информация.

Към проекта има и документация. Тези файлове обикновено са изброени в горното ниво на хранилището.

* **ЛИЦЕНЗ:** По дефиниция всеки проект с отворен код трябва да има [лиценз за отворен код](https://choosealicense.com). Ако проектът няма лиценз, той не е с отворен код.
* **README:** README е ръководството с инструкции, което приветства новите членове на общността в проекта. Той обяснява защо проектът е полезен и как да започнете.
* **ПРИНОС:** Докато README помагат на хората да _използват_ проекта, допринасящите документи помагат на хората да _допринасят_ за проекта. Той обяснява какви видове вноски са необходими и как работи процесът. Въпреки че не всеки проект има ПРИНОСЯЩ файл, присъствието му сигнализира, че това е приветлив проект, за който можете да допринесете. Добър пример за ефективно ръководство за принос би било това от [хранилището на документи на Codecademy](https://www.codecademy.com/resources/docs/contribution-guide).
* **CODE_OF_CONDUCT:** Кодексът за поведение определя основните правила за свързаното поведение на участниците и спомага за създаването на приятелска, гостоприемна среда. Въпреки че не всеки проект има файл CODE_OF_CONDUCT, присъствието му сигнализира, че това е приветлив проект, за който можете да допринесете.
* **Друга документация:** Може да има допълнителна документация, като уроци, инструкции или политики за управление, особено за по-големи проекти като [Astro Docs](https://docs.astro.build/en/contribute/#contributing-to-docs).

И накрая, проектите с отворен код използват следните инструменти за организиране на дискусия. Четенето на архивите ще ви даде добра представа за това как общността мисли и работи.

* **Проследяване на проблеми:** Където хората обсъждат въпроси, свързани с проекта.
* **Заявки за изтегляне:** Когато хората обсъждат и преглеждат промените, които са в ход, независимо дали са за подобряване на реда код на сътрудника, използването на граматика, използването на изображения и т.н. Някои проекти, като [MDN Web Docs](https://github.com/mdn/content/blob/main/.github/workflows/markdown-lint.yml), използват определени потоци за действие на GitHub, за да автоматизират и ускорят своите прегледи на кода.
* **Дискусионни форуми или пощенски списъци:** Някои проекти могат да използват тези канали за теми за разговор (например _"Как да..."_ или _"Какво мислиш за..."_ вместо грешка отчети или заявки за функции). Други използват инструмента за проследяване на проблеми за всички разговори. Добър пример за това би бил [седмичният бюлетин на CHAOSS](https://chaoss.community/news/)
* **Синхронен чат канал:** Някои проекти използват чат канали (като Slack или IRC) за непринуден разговор, сътрудничество и бърз обмен. Добър пример за това би била [общността на Discord на EddieHub](http://discord.eddiehub.org/).

## Намиране на проект, за който да допринесете

Сега, след като разбрахте как работят проектите с отворен код, време е да намерите проект, за който да допринесете!

Ако никога преди не сте допринасяли за отворения код, приемете съвет от президента на САЩ Джон Ф. Кенеди, който веднъж каза: "Не питайте какво вашата страна може да направи за вас – попитайте какво можете да направите вие за вашата страна."_

<aside markdown="1" class="pquote">
  <img src="/assets/images/how-to-contribute/johnfkennedy.jpg" class="pquote-avatar" alt="avatar">
  Не питайте какво вашата страна може да направи за вас - попитайте какво можете да направите за вашата страна.
  <p markdown="1" class="pquote-credit">
— [_Библиотека Джон Ф. Кенеди_](https://www.jfklibrary.org/learn/education/teachers/curricular-resources/ask-not-what-your-country-can-do-for-you)
  </p>
</aside>

Приносът към отворения код се случва на всички нива, във всички проекти. Не е нужно да мислите прекалено много какъв точно ще бъде първият ви принос или как ще изглежда.

Вместо това започнете, като помислите за проектите, които вече използвате или искате да използвате. Проектите, за които ще участвате активно, са тези, към които се връщате.

В рамките на тези проекти, всеки път, когато се хванете, че мислите, че нещо може да бъде по-добро или различно, действайте според инстинкта си.

Отвореният код не е изключителен клуб; направено е от хора точно като вас. "Отворен код" е просто фантастичен термин за третиране на световните проблеми като поправими.

Може да сканирате README и да намерите повредена връзка или правописна грешка. Или сте нов потребител и сте забелязали, че нещо е счупено, или проблем, който смятате, че наистина трябва да бъде в документацията. Вместо да го игнорирате и да продължите напред, или да помолите някой друг да го поправи, вижте дали можете да помогнете, като се включите. Това е смисълът на отворения код!

> Според проучване, проведено от Игор Щайнмахер и други изследователи на компютърните науки, [28% от случайните приноси](https://www.igor.pro.br/publica/papers/saner2016.pdf) в отворен код са документация, като като корекции на печатни грешки, преформатиране или писане на превод.

Ако търсите съществуващи проблеми, които можете да коригирате, всеки проект с отворен код има страница `/contribute`, която подчертава лесни за начинаещи проблеми, с които можете да започнете. Отидете до главната страница на хранилището в GitHub и добавете `/contribute` в края на URL адреса (например [`https://github.com/facebook/react/contribute`](https://github.com/facebook/react/contribute)).

Можете също да използвате един от следните ресурси, за да ви помогне да откриете и допринесете за нови проекти:

* [GitHub Explore](https://github.com/explore/)
* [Open Source Friday](https://opensourcefriday.com)
* [First Timers Only](https://www.firsttimersonly.com/)
* [CodeTriage](https://www.codetriage.com/)
* [24 Pull Requests](https://24pullrequests.com/)
* [Up For Grabs](https://up-for-grabs.net/)
* [First Contributions](https://firstcontributions.github.io)
* [SourceSort](https://web.archive.org/web/20201111233803/https://www.sourcesort.com/)
* [OpenSauced](https://opensauced.pizza/)

### Контролен списък, преди да допринесете

Когато намерите проект, за който искате да допринесете, направете бързо сканиране, за да се уверите, че проектът е подходящ за приемане на приноси. В противен случай вашата упорита работа може никога да не получи отговор.

Ето един удобен контролен списък, за да оцените дали даден проект е добър за нови сътрудници.

**Отговаря на определението за отворен код**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
  Има ли лиценз? Обикновено в корена на хранилището има файл, наречен ЛИЦЕНЗ.
  </label>
</div>

**Проектът активно приема вноски**

Погледнете активността на комит в главния клон. В GitHub можете да видите тази информация в раздела Insights на началната страница на хранилище, като например [Virtual-Coffee](https://github.com/Virtual-Coffee/virtualcoffee.io/pulse)

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
  Кога беше последният ангажимент?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
  Колко сътрудници има проектът?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
  Колко често хората се ангажират? (В GitHub можете да намерите това, като щракнете върху "Комити" в горната лента.)
  </label>
</div>

След това разгледайте проблемите на проекта.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
    Колко отворени въпроси има?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
    Поддържащите реагират ли бързо на проблеми, когато те бъдат отворени?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
    Има ли активна дискусия по проблемите?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
    Проблемите скорошни ли са?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
    Приключват ли се проблемите? (В GitHub щракнете върху раздела "затворен" на страницата с проблеми, за да видите затворени проблеми.)
  </label>
</div>

Сега направете същото за заявките за изтегляне на проекта.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox10" class="overflow-hidden d-block text-normal">
    Колко отворени заявки за изтегляне има?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox20" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox20" class="overflow-hidden d-block text-normal">
    Поддържащите реагират ли бързо на заявки за изтегляне, когато бъдат отворени?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
    Има ли активно обсъждане на заявките за изтегляне?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
    Скорошни ли са заявките за изтегляне?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox13" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox13" class="overflow-hidden d-block text-normal">
    Колко наскоро бяха обединени всички заявки за изтегляне? (В GitHub щракнете върху раздела "затворено" на страницата "Заявки за изтегляне", за да видите затворени PR-и.)
  </label>
</div>

**Проектът е приветлив**

Проект, който е приятелски настроен и гостоприемен, сигнализира, че те ще бъдат възприемчиви към нови сътрудници.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox14" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox14" class="overflow-hidden d-block text-normal">
    Поддържащите отговарят ли услужливо на въпроси в проблеми?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox15" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox15" class="overflow-hidden d-block text-normal">
    Хората дружелюбни ли са в проблемите, дискусионния форум и чата (например IRC или Slack)?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox16" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox16" class="overflow-hidden d-block text-normal">
    Преглеждат ли се заявките за изтегляне?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox17" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox17" class="overflow-hidden d-block text-normal">
    Поддържащите благодарят ли на хората за техния принос?
  </label>
</div>

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  Всеки път, когато видите дълга нишка, проверете на място отговорите от основните разработчици, идващи късно в нишката. Обобщават ли конструктивно и предприемат ли стъпки, за да доведат нишката до решение, като същевременно остават учтиви? Ако видите да се водят много пламъчни войни, това често е знак, че енергията отива в спор, вместо в развитие.
  <p markdown="1" class="pquote-credit">
— @kfogel, [_Произвеждайте OSS_](https://producingoss.com/en/evaluating-oss-projects.html)
  </p>
</aside>

## Как да изпратите принос

Намерихте проект, който харесвате, и сте готови да дадете своя принос. Най-накрая! Ето как да получите своя принос по правилния начин.

### Ефективна комуникация

Независимо дали сте сътрудник еднократно, или се опитвате да се присъедините към общност, работата с други е едно от най-важните умения, които ще развиете в отворен код.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shubheksha?s=180" class="pquote-avatar" alt="avatar">
  \[Като нов сътрудник,\] бързо осъзнах, че трябва да задавам въпроси, ако искам да мога да затворя проблема. Прегледах набързо кодовата база. След като усетих какво се случва, помолих за повече насоки. И готово! Успях да разреша проблема, след като получих всички необходими подробности.
  <p markdown="1" class="pquote-credit">
— @shubheksha, [Много неравномерно пътешествие за начинаещи през света на отворения код](https://www.freecodecamp.org/news/a-beginners-very-bumpy-journey-through-the-world-of-open-source-4d108d540b39/)
  </p>
</aside>

Преди да отворите проблем или заявка за изтегляне, или да зададете въпрос в чата, имайте предвид тези моменти, за да помогнете на вашите идеи да се реализират ефективно.

**Дайте контекст.** Помогнете на другите да навлязат бързо. Ако попаднете на грешка, обяснете какво се опитвате да направите и как да я възпроизведете. Ако предлагате нова идея, обяснете защо смятате, че би била полезна за проекта (не само за вас!).

> 😇 _"X не се случва, когато направя Y"_
>
> 😢 _"X е повреден! Моля, поправете го."_

**Напишете си домашното предварително.** Добре е да не знаете нещата, но покажете, че сте опитали. Преди да поискате помощ, не забравяйте да проверите README на проекта, документацията, проблемите (отворени или затворени), пощенския списък и потърсете в интернет за отговор. Хората ще го оценят, когато демонстрирате, че се опитвате да учите.

> 😇 _"Не съм сигурен как да внедря X. Проверих помощните документи и не намерих никакви споменавания."_
>
> 😢 _"Как да направя X?"_

**Поддържайте заявките кратки и директни.** Подобно на изпращането на имейл, всеки принос, без значение колко прост или полезен, изисква преглед от някой друг. Много проекти имат повече входящи заявки, отколкото хора, които могат да помогнат. Бъдете кратки. Ще увеличите шанса някой да може да ви помогне.

> 😇 _"Бих искал да напиша урок за API."_
>
> 😢 _"Онзи ден карах по магистралата и спрях за газ и тогава ми хрумна тази невероятна идея за нещо, което трябва да направим, но преди да обясня това, нека ви покажа..."_

**Пазете цялата комуникация публична.** Въпреки че е изкушаващо, не се свързвайте лично с поддържащите, освен ако не трябва да споделите чувствителна информация (като проблем със сигурността или сериозно нарушение на поведението). Когато поддържате разговора публичен, повече хора могат да научат и да се възползват от вашия обмен. Дискусиите могат сами по себе си да бъдат принос.

> 😇 _(като коментар) "@-maintainer Здравейте! Как да продължим с този PR?"_
>
> 😢 _(като имейл) "Здравейте, съжалявам, че ви безпокоя по имейл, но се чудех дали сте имали възможност да прегледате моя PR"_

**Добре е да задавате въпроси (но бъдете търпеливи!).** Всеки е бил нов в проекта в някакъв момент и дори опитните сътрудници трябва да навлизат в крак, когато разглеждат нов проект. По същия принцип дори дългогодишните поддържащи не винаги са запознати с всяка част от проекта. Покажете им същото търпение, което бихте искали те да проявяват към вас.

> 😇 _"Благодаря, че разгледахте тази грешка. Следвах вашите предложения. Ето резултата."_
>
> 😢 _"Защо не можете да решите проблема ми? Това не е ли вашият проект?"_

**Уважавайте решенията на общността.** Вашите идеи може да се различават от приоритетите или визията на общността. Те могат да предложат обратна връзка или да решат да не следват вашата идея. Въпреки че трябва да обсъждате и търсите компромис, поддържащите трябва да живеят с вашето решение по-дълго, отколкото вие ще го направите. Ако не сте съгласни с тяхната посока, винаги можете да работите върху своя собствена вилица или да започнете свой собствен проект.

> 😇 _"Разочарован съм, че не можете да подкрепите моя случай на употреба, но както обяснихте, той засяга само малка част от потребителите, разбирам защо. Благодаря, че ме изслушахте."_
>
> 😢 _"Защо не подкрепите моя случай на употреба? Това е неприемливо!"_

**Преди всичко го поддържайте елегантно.** Отвореният код се състои от сътрудници от цял свят. Контекстът се губи между езиците, културите, географията и часовите зони. Освен това писмената комуникация прави по-трудно предаването на тон или настроение. Предполагайте добри намерения в тези разговори. Добре е учтиво да отхвърлите идея, да поискате повече контекст или да изясните допълнително позицията си. Просто се опитайте да оставите интернет по-добро място, отколкото когато сте го намерили.

### Събиране на контекст

Преди да предприемете нещо, направете бърза проверка, за да се уверите, че идеята ви не е била обсъждана другаде. Прегледайте README на проекта, проблеми (отворени и затворени), пощенски списък и Stack Overflow. Не е нужно да прекарвате часове в разглеждане на всичко, но бързото търсене на няколко ключови термина върши дълъг път.

Ако не можете да намерите идеята си другаде, вие сте готови да предприемете ход. Ако проектът е в GitHub, вероятно ще комуникирате, като направите следното:

* **Повдигане на проблем:** Това е като започване на разговор или дискусия
* **Заявките за изтегляне** са за започване на работа по решение.
* **Канали за комуникация:** Ако проектът има определен Discord, IRC или Slack канал, помислете дали да започнете разговор или да поискате разяснение относно вашия принос.

Преди да отворите проблем или заявка за изтегляне, проверете допринасящите документи на проекта (обикновено файл, наречен CONTRIBUTING или в README), за да видите дали трябва да включите нещо конкретно. Например, те могат да поискат да следвате шаблон или да изискват да използвате тестове.

Ако искате да направите значителен принос, отворете проблем, който да попитате, преди да работите по него. Полезно е да гледате проекта известно време (в GitHub, [можете да щракнете върху "Гледане"](https://help.github.com/articles/watching-repositories/), за да бъдете уведомени за всички разговори) и да стигнете до познавайте членовете на общността, преди да вършите работа, която може да не бъде приета.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gaearon?s=180" class="pquote-avatar" alt="avatar">
  Ще научите <em>много</em>, като вземете един проект, който активно използвате, „гледате“ го в GitHub и четете всеки брой и PR.
<p markdown="1" class="pquote-credit">
— @gaearon [за присъединяване към проекти](https://twitter.com/dan_abramov/status/819555257055322112)
  </p>
</aside>

### Отваряне на проблем

Обикновено трябва да отворите проблем в следните ситуации:

* Докладвайте за грешка, която не можете да разрешите сами
* Обсъдете тема или идея на високо ниво (например общност, визия или политики)
* Предложете нова функция или друга идея за проект

Съвети за комуникация по проблеми:

* **Ако видите отворен проблем, с който искате да се заемете**, коментирайте проблема, за да уведомите хората, че работите по него. По този начин е по-малко вероятно хората да дублират вашата работа.
* **Ако даден проблем е открит преди известно време,** е възможно той да се адресира някъде другаде или вече да е разрешен, така че коментирайте, за да поискате потвърждение, преди да започнете работа.
* **Ако сте отворили проблем, но сте разбрали отговора по-късно сами,** коментирайте проблема, за да уведомите хората, след което затворете проблема. Дори документирането на този резултат е принос към проекта.

### Отваряне на заявка за изтегляне

Обикновено трябва да отворите заявка за изтегляне в следните ситуации:

* Изпратете малки корекции като печатна грешка, повредена връзка или очевидна грешка.
* Започнете работа по принос, който вече е поискан или който вече сте обсъждали в даден брой.

Заявката за изтегляне не трябва да представлява завършена работа. Обикновено е по-добре да отворите заявка за изтегляне рано, така че другите да могат да гледат или да дадат обратна връзка за напредъка ви. Просто го отворете като "чернова" или маркирайте като "WIP" (Работа в процес) в реда за тема или в секциите "Бележки към рецензентите", ако са предоставени (или можете просто да създадете свой собствен. Подобно на това: `**## Бележки към рецензента**`). Винаги можете да добавите още ангажименти по-късно.

Ако проектът е в GitHub, ето как да изпратите заявка за изтегляне:

* **[Разклонете хранилището](https://guides.github.com/activities/forking/)** и го клонирайте локално. Свържете вашето локално към оригиналното хранилище "нагоре по веригата", като го добавите като дистанционно. Изтегляйте често промените от "нагоре по веригата", така че да сте в течение, така че когато изпратите заявката си за изтегляне, конфликтите при сливане ще бъдат по-малко вероятни. (Вижте по-подробни инструкции [тук](https://help.github.com/articles/syncing-a-fork/).)
* **[Създайте клон](https://guides.github.com/introduction/flow/)** за вашите редакции.
* **Посочете всички съответни проблеми** или подкрепяща документация във вашия PR (например "Затваря #37.")
* **Включете екранни снимки преди и след**, ако вашите промени включват разлики в HTML/CSS. Плъзнете и пуснете изображенията в тялото на вашата заявка за изтегляне.
* **Тествайте промените си!** Стартирайте промените си срещу всички съществуващи тестове, ако съществуват, и създайте нови, когато е необходимо. Важно е да се уверите, че вашите промени не нарушават съществуващия проект.
* **Допринесете в стила на проекта** според възможностите си. Това може да означава използване на отстъпи, точка и запетая или коментари по различен начин, отколкото бихте направили във вашето собствено хранилище, но улеснява поддържащия да слива, другите да разбират и поддържат в бъдеще.

Ако това е първата ви заявка за изтегляне, вижте [Направете заявка за изтегляне](http://makeapullrequest.com/), която @kentcdodds създаде като видеоурок с инструкции. Можете също така да практикувате да правите заявка за изтегляне в хранилището [Първи вноски](https://github.com/Roshanjossey/first-contributions), създадено от @Roshanjossey.

## Какво се случва, след като изпратите своя принос

Преди да започнем да празнуваме, едно от следните ще се случи, след като изпратите своя принос:

### 😭 Не получавате отговор

Надяваме се, че сте [проверили проекта за признаци на активност](#контролен-списък-преди-да-допринесете), преди да направите принос. Дори при активен проект обаче е възможно вашият принос да не получи отговор.

Ако не сте получили отговор повече от седмица, е честно да отговорите учтиво в същата тема, като помолите някого за преглед. Ако знаете името на подходящия човек, който да прегледа вашия принос, можете да го споменете с @ в тази нишка.

**Не се свързвайте лично с този човек**; не забравяйте, че публичната комуникация е жизненоважна за проектите с отворен код.

Ако дадете учтиво напомняне и все още не получите отговор, възможно е никой никога да не отговори. Чувството не е страхотно, но не позволявайте това да ви обезсърчава! 😄 Има много възможни причини, поради които не сте получили отговор, включително лични обстоятелства, които може да са извън вашия контрол. Опитайте се да намерите друг проект или начин да допринесете. Ако не друго, това е добра причина да не инвестирате твърде много време в даването на принос, преди другите членове на общността да са ангажирани и отзивчиви.

### 🚧 Някой иска промени във вашия принос

Обичайно е да бъдете помолени да направите промени във вашия принос, независимо дали това е обратна връзка относно обхвата на вашата идея или промени в кода ви.

Когато някой поиска промени, бъдете отзивчиви. Те са отделили време да прегледат приноса ви. Да отвориш PR и да си тръгнеш е лоша форма. Ако не знаете как да правите промени, проучете проблема и след това поискайте помощ, ако имате нужда от нея. Добър пример за това би била [обратната връзка, която друг сътрудник е дал на @a-m-lamb относно тяхната заявка за изтегляне към документите на Codecademy](https://github.com/Codecademy/docs/pull/3239#pullrequestreview-1628036286).

Ако вече нямате време да работите по проблема поради причини като разговорът продължава от месеци и обстоятелствата ви са се променили или не можете да намерите решение, уведомете поддържащия, за да може отворете проблема за някой друг, като [@RitaDee направи за проблем в хранилището за приложения на OpenSauced](https://github.com/open-sauced/app/issues/1656#issuecomment-1729353346).

### 👎 Вашият принос не се приема

Вашият принос може или не може да бъде приет в крайна сметка. Надяваме се, че вече не сте вложили твърде много работа в него. Ако не сте сигурни защо не е приет, е напълно разумно да помолите поддържащия за обратна връзка и разяснение. В крайна сметка обаче ще трябва да уважите, че това е тяхно решение. Не спорете и не бъдете враждебни. Винаги сте добре дошли да се разклоните и да работите върху собствената си версия, ако не сте съгласни!

### 🎉 Вашият принос се приема

Ура! Успешно направихте принос с отворен код!

## Направи го! 🎉

Независимо дали току-що сте направили първия си принос с отворен код или търсите нови начини да допринесете, надяваме се, че сте вдъхновени да предприемете действие. Дори ако вашият принос не е бил приет, не забравяйте да благодарите, когато поддържащият положил усилия да ви помогне. Отвореният код е направен от хора като вас: един проблем, заявка за изтегляне, коментар или дай пет наведнъж.
