---
lang: bg
title: Получаване на заплащане за работа с отворен код
description: Поддържайте работата си с отворен код, като получите финансова подкрепа за вашето време или за вашия проект.
class: getting-paid
order: 7
image: /assets/images/cards/getting-paid.png
related:
  - best-practices
  - leadership
---

## Защо някои хора търсят финансова подкрепа

Голяма част от работата с отворен код е доброволна. Например, някой може да се натъкне на грешка в проект, който използва, и да изпрати бързо решение, или може да му хареса да бърника с проект с отворен код в свободното си време.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gvanrossum?s=180" class="pquote-avatar" alt="avatar">
Търсех "хоби" проект за програмиране, който да ме занимава през седмицата около Коледа. (...) Имах домашен компютър и нищо друго в ръцете си. Реших да напиша интерпретатор за новия скриптов език, за който си мислех напоследък. (...) Избрах Python като работно заглавие.
  <p markdown="1" class="pquote-credit">
— @gvanrossum, ["Програмиране на Python"](https://www.python.org/doc/essays/foreword/)
  </p>
</aside>

Има много причини, поради които човек не би искал да получава заплащане за работата си с отворен код.

* **Те може вече да имат работа на пълен работен ден, която обичат,** което им позволява да допринасят за отворен код в свободното си време.
* **Харесва им да мислят за отворения код като за хоби** или творческо бягство и не искат да се чувстват финансово задължени да работят по проектите си.
* **Те получават други ползи от приноса си към отворен код,** като например изграждане на репутация или портфолио, усвояване на нови умения или чувство за близост до общност.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/alloy?s=180" class="pquote-avatar" alt="avatar">
  Финансовите дарения наистина добавят чувство за отговорност за някои. (...) За нас е важно, в глобално свързания, забързан свят, в който живеем, да можем да кажем "не сега, искам да правя нещо съвсем различно".
  <p markdown="1" class="pquote-credit">
— @alloy, ["Защо не приемаме дарения"](https://blog.cocoapods.org/Why-we-dont-accept-donations/)
  </p>
</aside>

За други, особено когато приносът е в ход или изисква значително време, получаването на плащане за принос към отворен код е единственият начин да участват, било защото проектът го изисква, или поради лични причини.

Поддържането на популярни проекти може да бъде значителна отговорност, като отнема 10 или 20 часа на седмица вместо няколко часа на месец.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ashedryden?s=180" class="pquote-avatar" alt="avatar">
  Попитайте всеки поддържащ проект с отворен код и той ще ви разкаже за реалността на количеството работа, което отива в управлението на проект. Имате клиенти. Вие решавате проблеми вместо тях. Вие създавате нови функции. Това се превръща в истинска нужда от вашето време.
  <p markdown="1" class="pquote-credit">
— @ashedryden, ["Етиката на неплатения труд и OSS общността"](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community)
  </p>
</aside>

Платената работа също дава възможност на хора от различни сфери на живота да дадат значим принос. Някои хора не могат да си позволят да прекарват неплатено време в проекти с отворен код въз основа на текущото си финансово състояние, дълг или семейни или други задължения за грижа. Това означава, че светът никога не вижда приноси от талантливи хора, които не могат да си позволят да отделят доброволно времето си. Това има етични последици, както @ashedryden [описа](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community), тъй като свършената работа е предубедени в полза на онези, които вече имат предимства в живота, които след това получават допълнителни предимства въз основа на техния доброволен принос, докато други, които не могат да бъдат доброволци, след това не получават по-късни възможности, което засилва текущата липса на разнообразие в отворения код общност.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/isaacs?s=180" class="pquote-avatar" alt="avatar">
   OSS носи огромни ползи за технологичната индустрия, което от своя страна означава ползи за всички индустрии. (...) Въпреки това, ако единствените хора, които могат да се съсредоточат върху това, са късметлиите и обсебените, тогава има огромен неизползван потенциал.
  <p markdown="1" class="pquote-credit">
— @isaacs, ["Пари и отворен код"](https://medium.com/open-source-life/money-and-open-source-d44a1953749c)
  </p>
</aside>

Ако търсите финансова подкрепа, трябва да обмислите два начина. Можете да финансирате собственото си време като сътрудник или можете да намерите организационно финансиране за проекта.

## Финансиране на вашето собствено време

Днес много хора получават заплащане, за да работят на непълен или пълен работен ден с отворен код. Най-често срещаният начин да получите заплащане за времето си е да говорите с вашия работодател.

По-лесно е да направите аргумент за работа с отворен код, ако вашият работодател действително използва проекта, но бъдете креативни с представянето си. Може би вашият работодател не използва проекта, но той използва Python и поддържането на популярен проект на Python помага за привличането на нови разработчици на Python. Може би това кара вашия работодател да изглежда по-приятелски настроен към разработчиците като цяло.

Ако нямате съществуващ проект с отворен код, върху който бихте искали да работите, но предпочитате текущата ви работа да е с отворен код, помолете вашия работодател да отвори част от техния вътрешен софтуер.

Много компании разработват програми с отворен код, за да изградят своята марка и да наемат качествени таланти.

@hueniverse например установи, че има финансови причини, които да оправдаят [инвестицията на Walmart в отворен код](https://www.infoworld.com/article/2608897/open-source-software/walmart-s-investment-in-open-source-isn-t-cheap.html). И @jamesgpearce установи, че програмата с отворен код на Facebook [има значение](https://opensource.com/business/14/10/head-of-open-source-facebook-oscon) при набирането на персонал:

> Тя е тясно свързана с нашата хакерска култура и начина, по който нашата организация се възприемаше. Попитахме нашите служители: "Знаехте ли за софтуерната програма с отворен код във Facebook?". Две трети казаха "Да". Половината казаха, че програмата е допринесла положително за решението им да работят за нас. Това не са пределни числа и се надявам, че тенденцията ще продължи.

Ако вашата компания тръгне по този път, важно е да поддържате ясни границите между общността и корпоративната дейност. В крайна сметка отвореният код се поддържа чрез принос от хора по целия свят и това е по-голямо от която и да е компания или местоположение.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jessfraz?s=180" class="pquote-avatar" alt="avatar">
  Получаването на заплащане за работа с отворен код е рядка и прекрасна възможност, но не трябва да се отказвате от страстта си в процеса. Вашата страст трябва да е причината, поради която компаниите искат да ви плащат.
  <p markdown="1" class="pquote-credit">
— @jessfraz, ["Размити линии"](https://blog.jessfraz.com/post/blurred-lines/)
  </p>
</aside>

Ако не можете да убедите настоящия си работодател да даде приоритет на работата с отворен код, помислете за намиране на нов работодател, който насърчава приноса на служителите към отворен код. Потърсете компании, които подчертават своята отдаденост на работата с отворен код. Например:

* Някои компании, като [Netflix](https://netflix.github.io/), имат уебсайтове, които подчертават тяхното участие в отворен код
* [Zalando](https://opensource.zalando.com) публикува своята [политика за принос с отворен код](https://opensource.zalando.com/docs/using/contributing/) за служители

Проекти, които произхождат от голяма компания, като [Go](https://github.com/golang) или [React](https://github.com/facebook/react), will also likely employ people to work on open source.

В зависимост от вашите лични обстоятелства можете да опитате да съберете пари независимо, за да финансирате работата си с отворен код. Например:

* @Homebrew (и [много други поддържащи и организации](https://github.com/sponsors/community)) финансират работата си чрез [Спонсори на GitHub](https://github.com/sponsors)
* @gaearon финансира работата си върху [Redux](https://github.com/reactjs/redux) чрез [кампания за групово финансиране на Patreon](https://redux.js.org/)
* @andrewgodwin финансира работа по миграции на схема на Django [чрез кампания на Kickstarter](https://www.kickstarter.com/projects/andrewgodwin/schema-migrations-for-django)

И накрая, понякога проекти с отворен код дават премии за проблеми, за които може да обмислите да помогнете.

* @ConnorChristie успя да получи плащане за [помощ](https://web.archive.org/web/20181030123412/https://webcache.googleusercontent.com/search?strip=1&q=cache:https%3A%2F%2Fgithub.com%2FMARKETProtocol%2FMARKET.js%2Fissues%2F14) @MARKETProtocol работят по своята JavaScript библиотека [чрез награда за gitcoin](https://gitcoin.co/).
* @mamiM направи японски преводи за @MetaMask след [изданието беше финансирано от Bounties Network](https://explorer.bounties.network/bounty/134).

## Намиране на финансиране за вашия проект

Освен договореностите за отделни сътрудници, понякога проектите набират пари от компании, физически лица или други за финансиране на текуща работа.

Организационното финансиране може да отиде за плащане на настоящи сътрудници, покриване на разходите за управление на проекта (като такси за хостинг) или инвестиране в нови функции или идеи.

Тъй като популярността на отворения код нараства, намирането на финансиране за проекти все още е експериментално, но има няколко общи опции.

### Съберете пари за работата си чрез кампании за групово финансиране или спонсорство

Намирането на спонсорство работи добре, ако вече имате силна публика или репутация или проектът ви е много популярен.
Няколко примера за спонсорирани проекти включват:

* **[webpack](https://github.com/webpack)** събира пари от компании и физически лица [чрез OpenCollective](https://opencollective.com/webpack)
* **[Ruby Together](https://rubytogether.org/),** организация с нестопанска цел, която плаща за работата по [bundler](https://github.com/bundler/bundler), [RubyGems](https://github.com/rubygems/rubygems) и други Ruby инфраструктурни проекти

### Създайте поток от приходи

В зависимост от вашия проект може да имате възможност да таксувате за търговска поддръжка, хоствани опции или допълнителни функции. Няколко примера включват:

* **[Sidekiq](https://github.com/mperham/sidekiq)** предлага платени версии за допълнителна поддръжка
* **[Travis CI](https://github.com/travis-ci)** предлага платени версии на своя продукт
* **[Ghost](https://github.com/TryGhost/Ghost)** е организация с нестопанска цел с платена управлявана услуга

Някои популярни проекти, като [npm](https://github.com/npm/cli) и [Docker](https://github.com/docker/docker), дори набират рисков капитал, за да подкрепят растежа на своя бизнес.

### Кандидатствайте за безвъзмездно финансиране

Някои софтуерни фондации и компании предлагат грантове за работа с отворен код. Понякога грантовете могат да се изплащат на физически лица, без да се създава юридическо лице за проекта.

* **[Прочетете документите](https://github.com/rtfd/readthedocs.org)** получи субсидия от [Поддръжка на Mozilla Open Source](https://www.mozilla.org/en-US/grants/)
* Работата по **[OpenMRS](https://github.com/openmrs)** е финансирана от [Retreat за отворен код на Stripe](https://stripe.com/blog/open-source-retreat-2016-grantees)
* **[Libraries.io](https://github.com/librariesio)** получи грант от [Фондация Слоун](https://sloan.org/programs/digital-technology)
* **[Python Software Foundation](https://www.python.org/psf/grants/)** предлага грантове за работа, свързана с Python

За по-подробни опции и казуси @nayafia [написа ръководство](https://github.com/nayafia/lemonade-stand) за получаване на заплащане за работа с отворен код. Различните видове финансиране изискват различни умения, така че преценете силните си страни, за да разберете коя опция работи най-добре за вас.

## Изграждане на случай за финансова подкрепа

Независимо дали вашият проект е нова идея или съществува от години, трябва да очаквате да вложите значителни мисли в идентифицирането на вашия целеви финансист и в представянето на убедителни аргументи.

Независимо дали искате да платите за собственото си време или да наберете средства за проект, трябва да можете да отговорите на следните въпроси.

### Въздействие

Защо този проект е полезен? Защо вашите потребители или потенциални потребители го харесват толкова много? Къде ще бъде след пет години?

### Сцепление

Опитайте се да съберете доказателства, че вашият проект има значение, независимо дали става дума за показатели, анекдоти или препоръки. Има ли компании или забележителни хора, които използват вашия проект в момента? Ако не, виден човек го е одобрил?

### Стойност за финансиращия

До финансиращите, независимо дали вашият работодател или фондация, предоставяща безвъзмездни средства, често се обръщат с възможности. Защо трябва да подкрепят вашия проект пред всяка друга възможност? Как се облагодетелстват те лично?

### Използване на средства

Какво точно ще постигнете с предложеното финансиране? Съсредоточете се върху важни етапи или резултати на проекта, вместо да плащате заплата.

### Как ще получите средствата

Финансиращият има ли някакви изисквания относно изплащането? Например, може да се наложи да сте организация с нестопанска цел или да имате фискален спонсор с нестопанска цел. Или може би средствата трябва да бъдат дадени на отделен изпълнител, а не на организация. Тези изисквания варират между финансиращите, така че не забравяйте да направите проучването си предварително.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/davegandy?s=180" class="pquote-avatar" alt="avatar">
  От години ние сме водещият ресурс за икони, удобни за уебсайтове, с общност от над 20 милиона души и сме представени в над 70 милиона уебсайта, включително Whitehouse.gov. (...) Версия 4 беше преди три години. Уеб технологиите се промениха много оттогава и честно казано, Font Awesome малко остаря. (...) Ето защо представяме Font Awesome 5. Модернизираме и пренаписваме CSS и преработваме всяка икона от горе до долу. Говорим за по-добър дизайн, по-добра последователност и по-добра четливост.
  <p markdown="1" class="pquote-credit">
— @davegandy, [Font Awesome Kickstarter видео](https://www.kickstarter.com/projects/232193852/font-awesome-5)
  </p>
</aside>

## Експериментирайте и не се отказвайте

Събирането на пари не е лесно, независимо дали сте проект с отворен код, организация с нестопанска цел или стартиращ софтуер, и в повечето случаи изисква от вас да проявите креативност. Определянето на начина, по който искате да получавате заплащане, извършването на вашите проучвания и поставянето на мястото на вашия финансиращ ще ви помогне да изградите убедителна аргументация за финансиране.
