---
lang: bg
title: Намиране на потребители за вашия проект
description: Помогнете на вашия проект с отворен код да се развие, като го предоставите в ръцете на щастливи потребители.
class: finding
order: 3
image: /assets/images/cards/finding.png
related:
  - beginners
  - building
---

## Разпространяване на думата

Няма правило, което да казва, че трябва да рекламирате проект с отворен код, когато стартирате. Има много основателни причини да работите с отворен код, които нямат нищо общо с популярността. Вместо да се надявате, че другите ще намерят и използват вашия проект с отворен код, вие трябва да разпространите думата за вашата упорита работа!

## Разберете съобщението си

Преди да започнете действителната работа по популяризиране на вашия проект, трябва да можете да обясните какво прави и защо има значение.

Какво прави вашия проект различен или интересен? Защо го създадохте? Отговорът на тези въпроси сам ще ви помогне да съобщите значението на вашия проект.

Не забравяйте, че хората се включват като потребители и в крайна сметка стават сътрудници, защото вашият проект решава проблем вместо тях. Докато мислите за посланието и стойността на вашия проект, опитайте се да ги видите през призмата на това, което _потребителите и сътрудниците_ може да искат.

Например, @robb използва примери за код, за да съобщи ясно защо неговият проект, [Картография](https://github.com/robb/Cartography), е полезен:

![Картография README](/assets/images/finding-users/cartography.jpg)

За по-задълбочено потапяне в съобщенията вижте упражнението на Mozilla ["Личности и пътеки"](https://mozillascience.github.io/working-open-workshop/personas_pathways/) за разработване на потребителски персони.

## Help people find and follow your project

<aside markdown="1" class="pquote">
  В идеалния случай се нуждаете от един „начален“ URL адрес, който можете да рекламирате и да насочвате хората към вашия проект. Не е нужно да се занимавате с изискан шаблон или дори име на домейн, но вашият проект се нуждае от фокусна точка.
  <p markdown="1" class="pquote-credit">
— Peter Cooper & Robert Nyman, ["Как да разпространявате информация за своя код"](https://hacks.mozilla.org/2013/05/how-to-spread-the-word-about-your-code/)
  </p>
</aside>

Помогнете на хората да намерят и запомнят вашия проект, като ги насочите към едно пространство от имена.

**Имайте ясен манипулатор, за да популяризирате работата си.** Twitter манипулатор, GitHub URL или IRC канал е лесен начин да насочите хората към вашия проект. Тези изходи също дават място за събиране на нарастващата общност на вашия проект.

Ако все още не желаете да създавате изходи за вашия проект, популяризирайте свой собствен Twitter или GitHub манипулатор във всичко, което правите. Популяризирането на вашия Twitter или GitHub ще позволи на хората да знаят как да се свържат с вас или да следят работата ви. Ако говорите на среща или събитие, уверете се, че вашата информация за контакт е включена във вашата биография или слайдове.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/nathanmarz?s=180" class="pquote-avatar" alt="avatar">
  Грешка, която направих в онези ранни дни (...) беше, че не започнах Twitter акаунт за проекта. Twitter е чудесен начин да информирате хората за даден проект, както и постоянно да излагате на хората информация за проекта.
  <p markdown="1" class="pquote-credit">
— @nathanmarz, ["История на Apache Storm и извлечени уроци"](http://nathanmarz.com/blog/history-of-apache-storm-and-lessons-learned.html)
  </p>
</aside>

**Помислете за създаване на уебсайт за вашия проект.** Уеб сайтът прави проекта ви по-удобен и лесен за навигация, особено когато е съчетан с ясна документация и уроци. Наличието на уебсайт също предполага, че вашият проект е активен, което ще накара вашата аудитория да се чувства по-комфортно при използването му. Дайте примери, за да дадете на хората идеи как да използват вашия проект.

[@adrianholovaty](https://news.ycombinator.com/item?id=7531689), съ-създател на Django, каза, че уебсайтът е _"далеч най-доброто нещо, което направихме с Django в ранните дни"_ .

Ако вашият проект се хоства в GitHub, можете да използвате [GitHub Pages](https://pages.github.com/), за да създадете лесно уебсайт. [Yeoman](http://yeoman.io/), [Vagrant](https://www.vagrantup.com/) и [Middleman](https://middlemanapp.com/) са [няколко примера](https://github.com/showcases/github-pages-examples) от отлични, изчерпателни уебсайтове.

![Начална страница на Vagrant](/assets/images/finding-users/vagrant_homepage.png)

Сега, след като имате съобщение за вашия проект и лесен начин за хората да го намерят, нека да излезем и да поговорим с вашата аудитория!

## Отидете там, където е аудиторията на вашия проект (онлайн)

Онлайн обхватът е чудесен начин за бързо споделяне и разпространение на информацията. Използвайки онлайн канали, вие имате потенциала да достигнете до много широка аудитория.

Възползвайте се от съществуващите онлайн общности и платформи, за да достигнете до вашата аудитория. Ако вашият проект с отворен код е софтуерен проект, вероятно можете да намерите аудиторията си в [Stack Overflow](https://stackoverflow.com/), [Reddit](https://www.reddit.com), [Hacker News](https://news.ycombinator.com/) или [Quora](https://www.quora.com/). Намерете каналите, от които смятате, че хората ще имат най-голяма полза или ще бъдат развълнувани от вашата работа.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/pazdera?s=180" class="pquote-avatar" alt="avatar">
  Всяка програма има много специфични функции, които само малка част от потребителите ще намерят полезни. Не изпращайте спам на възможно най-много хора. Вместо това насочете усилията си към общности, които ще имат полза от това да знаят за вашия проект.
  <p markdown="1" class="pquote-credit">
— @pazdera, ["Маркетинг за проекти с отворен код"](https://radek.io/2015/09/28/marketing-for-open-source-projects-3/)
  </p>
</aside>

Вижте дали можете да намерите начини да споделите проекта си по подходящи начини:

* **Запознайте се с подходящи проекти и общности с отворен код.** Понякога не е нужно директно да рекламирате проекта си. Ако вашият проект е идеален за специалисти по данни, които използват Python, запознайте се с общността за наука за данни на Python. Когато хората ви опознаят, ще се появят естествени възможности да говорите и споделяте работата си.
* **Намерете хора, които се сблъскват с проблема, който вашият проект решава.** Потърсете в свързани форуми за хора, които попадат в целевата аудитория на вашия проект. Отговорете на техния въпрос и намерете тактичен начин, когато е подходящо, да предложите вашия проект като решение.
* **Поискайте обратна връзка.** Представете себе си и работата си на публика, която ще я намери за подходяща и интересна. Бъдете конкретни относно това кой смятате, че ще има полза от вашия проект. Опитайте се да завършите изречението: _"Мисля, че моят проект наистина ще помогне на X, които се опитват да направят Y_". Слушайте и отговаряйте на отзивите на другите, вместо просто да популяризирате работата си.

Най-общо казано, фокусирайте се върху това да помагате на другите, преди да поискате неща в замяна. Тъй като всеки може лесно да рекламира проект онлайн, ще има много шум. За да се откроите от тълпата, дайте на хората контекст за това кой сте, а не само това, което искате.

Ако никой не обърне внимание или не отговори на първоначалния ви обхват, не се обезсърчавайте! Повечето стартирания на проекти са итеративен процес, който може да отнеме месеци или години. Ако не получите отговор от първия път, опитайте различна тактика или първо потърсете начини да добавите стойност към работата на другите. Популяризирането и стартирането на вашия проект изисква време и отдаденост.

## Отидете там, където е аудиторията на вашия проект (офлайн)

![Публично говорене](/assets/images/finding-users/public_speaking.jpg)

Офлайн събитията са популярен начин за популяризиране на нови проекти пред публика. Те са чудесен начин да достигнете до ангажирана аудитория и да изградите по-дълбоки човешки връзки, особено ако се интересувате от достигане до разработчици.

Ако сте [нов в публичното говорене](https://speaking.io/), започнете, като намерите местна среща, която е свързана с езика или екосистемата на вашия проект.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jhamrick?s=180" class="pquote-avatar" alt="avatar">
  Бях доста нервен да отида в PyCon. Изнасях лекция, щях да се запозная само с няколко души там, отидох за цяла седмица. (...) Все пак не трябваше да се притеснявам. PyCon беше феноменално страхотен! (...) Всички бяха невероятно дружелюбни и общителни, толкова много, че рядко намирах време да не говоря с хората!
  <p markdown="1" class="pquote-credit">
— @jhamrick, ["Как се научих да спра да се тревожа и да обичам PyCon"](http://www.jesshamrick.com/2014/04/18/how-i-learned-to-stop-worrying-and-love-pycon/)
  </p>
</aside>

Ако никога преди не сте говорили на събитие, напълно нормално е да се чувствате нервни! Не забравяйте, че публиката ви е там, защото те наистина искат да чуят за работата ви.

Докато пишете речта си, съсредоточете се върху това, което аудиторията ви ще намери за интересно и от което ще извлече полза. Поддържайте езика си приятелски настроен и достъпен. Усмихвайте се, дишайте и се забавлявайте.

<aside markdown="1" class="pquote">
  <img src="/assets/images/finding-users/lena.jpg" class="pquote-avatar" alt="avatar">
  Когато започнете да пишете речта си, независимо каква е темата ви, може да ви помогне, ако видите речта си като история, която разказвате на хората.
  <p markdown="1" class="pquote-credit">
— Lena Reinhard, ["Как да подготвим и напишем разговор за техническа конференция"](https://web.archive.org/web/20201128162836/http://wunder.schoenaberselten.com/2016/02/16/how-to-prepare-and-write-a-tech-conference-talk/)
  </p>
</aside>

Когато се почувствате готови, обмислете да говорите на конференция, за да популяризирате проекта си. Конференциите могат да ви помогнат да достигнете до повече хора, понякога от цял свят.

Потърсете конференции, които са специфични за вашия език или екосистема. Преди да изпратите своята реч, проучете конференцията, за да пригодите лекцията си за присъстващите и да увеличите шансовете си да бъдете приети да говорите на конференцията. Често можете да добиете представа за аудиторията си, като погледнете говорителите на конференцията.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ry?s=180" class="pquote-avatar" alt="avatar">
  Писах много мило на хората от JSConf и ги помолих да ми дадат място, където мога да го представя на JSConf EU. (...) Бях изключително уплашен, представяйки това нещо, върху което работих шест месеца. (...) През цялото време си мислех, о, Боже мой. Какво правя тук?
  <p markdown="1" class="pquote-credit">
— @ry, ["История на Node.js" (video)](https://www.youtube.com/watch?v=SAc0vQCC6UQ&t=24m57s)
  </p>
</aside>

## Build a reputation

В допълнение към стратегиите, описани по-горе, най-добрият начин да поканите хората да споделят и да допринесат за вашия проект е да споделяте и да допринесете за техните проекти.

Подпомагането на новодошлите, споделянето на ресурси и обмисленият принос към чужди проекти ще ви помогнат да изградите положителна репутация. Това, че сте активен член в общността с отворен код, ще помогне на хората да имат контекст за вашата работа и е по-вероятно да обърнат внимание и да споделят вашия проект. Развитието на връзки с други проекти с отворен код може дори да доведе до официални партньорства.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shazow?s=180" class="pquote-avatar" alt="avatar">
  Единствената причина urllib3 да е най-популярната библиотека на Python на трети страни днес е, че е част от заявките.
  <p markdown="1" class="pquote-credit">
— @shazow, ["Как да накарате своя проект с отворен код да процъфтява"](https://about.sourcegraph.com/blog/how-to-make-your-open-source-project-thrive-with-andrey-petrov/)
  </p>
</aside>

Никога не е твърде рано или твърде късно да започнете да изграждате репутацията си. Дори ако вече сте стартирали свой собствен проект, продължавайте да търсите начини да помагате на другите.

Няма еднодневно решение за изграждане на аудитория. Спечелването на доверието и уважението на другите отнема време и изграждането на вашата репутация никога не свършва.

## Продължавайте!

Може да отнеме много време, преди хората да забележат вашия проект с отворен код. Това е добре! Някои от най-популярните проекти днес отнеха години, за да достигнат високи нива на активност. Съсредоточете се върху изграждането на взаимоотношения, вместо да се надявате, че вашият проект спонтанно ще спечели популярност. Бъдете търпеливи и продължавайте да споделяте работата си с тези, които я оценяват.
