---
lang: bg
title: Вашият кодекс на поведение
description: Улеснявайте здравословното и конструктивно поведение на общността чрез приемане и прилагане на кодекс на поведение.
class: coc
order: 8
image: /assets/images/cards/coc.png
related:
  - building
  - leadership
---

## Защо имам нужда от кодекс на поведение?

Кодексът на поведение е документ, който определя очакванията за поведение на участниците във вашия проект. Приемането и прилагането на кодекс на поведение може да помогне за създаването на положителна социална атмосфера за вашата общност.

Кодексите на поведение помагат да защитите не само вашите участници, но и себе си. Ако поддържате проект, може да откриете, че непродуктивното отношение на другите участници може да ви накара да се почувствате изтощени или нещастни от работата си с течение на времето.

Кодексът на поведение ви дава възможност да улесните здравословното, конструктивно поведение в общността. Проактивността намалява вероятността вие или другите да се уморите от вашия проект и ви помага да предприемете действия, когато някой направи нещо, с което не сте съгласни.

## Създаване на кодекс на поведение

Опитайте се да създадете кодекс на поведение възможно най-рано: в идеалния случай, когато за първи път създавате своя проект.

В допълнение към съобщаването на вашите очаквания, кодексът на поведение описва следното:

* Където кодексът на поведение влиза в сила _(само при проблеми и заявки за изтегляне или дейности на общността като събития?)_
* За кого се прилага кодексът на поведение _(членове на общността и поддържащи лица, но какво да кажем за спонсори?)_
* Какво се случва, ако някой наруши кодекса на поведение
* Как някой може да докладва за нарушения

Където можете, използвайте предшестващо състояние на техниката. [Споразумението на сътрудниците](https://contributor-covenant.org/) е код за поведение, който се използва от над 40 000 проекта с отворен код, включително Kubernetes, Rails и Swift.

[Кодексът на поведение на Django](https://www.djangoproject.com/conduct/) и [Кодексът на поведение на гражданите](https://web.archive.org/web/20200330154000/http://citizencodeofconduct.org/) също са два добри примера на кодекс на поведение.

Поставете файл CODE_OF_CONDUCT в основната директория на вашия проект и го направете видим за вашата общност, като го свържете от вашия CONTRIBUTING или README файл.

## Решете как ще наложите своя кодекс на поведение

<aside markdown="1" class="pquote">
  Един неприложен (или неприложим) кодекс на поведение е по-лош от липсата на кодекс на поведение: той изпраща съобщението, че ценностите на кодекса на поведение всъщност не са важни или уважавани във вашата общност.
  <p markdown="1" class="pquote-credit">
— [Инициатива Ада](https://webcache.googleusercontent.com/search?q=cache:YfqdTk5H9ikJ:https://adainitiative.org/2014/02/18/howto-design-a-code-of-conduct-for-your-community)
  </p>
</aside>

Трябва да обясните как вашият кодекс за поведение ще бъде прилаган **_преди_** нарушение. Има няколко причини да го направите:

* Демонстрира, че сте сериозни относно предприемането на действия, когато е необходимо.

* Вашата общност ще се почувства по-уверена, че оплакванията действително се преглеждат.

* Ще уверите вашата общност, че процесът на преглед е честен и прозрачен, ако някога се окажат разследвани за нарушение.

Трябва да дадете на хората личен начин (като имейл адрес) да докладват за нарушение на кодекса на поведение и да обясните кой получава този доклад. Това може да бъде поддържащ, група от поддържащи или работна група за кодекс на поведение.

Не забравяйте, че някой може да поиска да докладва за нарушение на лице, което получава тези доклади. В този случай им дайте възможност да докладват за нарушения на някой друг. Например @ctb и @mr-c [обясняват за техния проект](https://github.com/dib-lab/khmer/blob/HEAD/CODE_OF_CONDUCT.rst), [khmer](https://github.com/dib-lab/khmer):

> Случаи на злоупотреба, тормоз или по друг начин неприемливо поведение могат да бъдат докладвани чрез имейл **khmer-project@idyll.org**, който отива само до C. Titus Brown и Michael R. Crusoe. За да съобщите за проблем, свързан с някой от тях, моля, изпратете имейл до **Judi Brown Clarke, Ph.D.** директора по разнообразието в BEACON Center for the Study of Evolution in Action, Център за науки и технологии на NSF.*

За вдъхновение вижте [ръководството за прилагане](https://www.djangoproject.com/conduct/enforcement-manual/) на Django (въпреки че може да не се нуждаете от нещо толкова изчерпателно, в зависимост от размера на вашия проект).

## Налагане на вашия кодекс на поведение

Понякога, въпреки всичките ви усилия, някой ще направи нещо, което нарушава този кодекс. Има няколко начина за справяне с негативното или вредно поведение, когато се появи.

### Съберете информация за ситуацията

Отнасяйте се към гласа на всеки член на общността също толкова важен, колкото и вашия собствен. Ако получите доклад, че някой е нарушил кодекса за поведение, приемете го сериозно и проучете въпроса, дори ако не съвпада с вашия собствен опит с този човек. Това сигнализира на вашата общност, че цените тяхната гледна точка и се доверявате на тяхната преценка.

Въпросният член на общността може да е повторен нарушител, който постоянно кара другите да се чувстват неудобно, или може да е казал или направил нещо само веднъж. И в двата случея могат да бъдат основание за предприемане на действие в зависимост от контекста.

Преди да отговорите, дайте си време да разберете какво се е случило. Прочетете миналите коментари и разговори на човека, за да разберете по-добре кои са те и защо може да са действали по този начин. Опитайте се да съберете гледни точки, различни от вашата собствена, за този човек и неговото поведение.

<aside markdown="1" class="pquote">
  Не се въвличайте в спор. Не се отклонявайте да се занимавате с поведението на някой друг, преди да сте приключили с разглеждането на въпроса. Съсредоточете се върху това, от което се нуждаете.
  <p markdown="1" class="pquote-credit">
— Stephanie Zvan, ["Значи си имате политика. Сега какво?"](https://the-orbit.net/almostdiamonds/2014/04/10/so-youve-got-yourself-a-policy-now-what/)
  </p>
</aside>

### Предприемете подходящи действия

След като съберете и обработите достатъчно информация, ще трябва да решите какво да правите. Докато обмисляте следващите си стъпки, не забравяйте, че вашата цел като модератор е да насърчите безопасна, уважителна и съвместна среда. Помислете не само как да се справите с въпросната ситуация, но и как вашият отговор ще повлияе на останалата част от поведението и очакванията на вашата общност в бъдеще.

Когато някой съобщи за нарушение на кодекса на поведение, ваша, а не негова работа е да се справите с него. Понякога репортерът разкрива информация с голям риск за своята кариера, репутация или физическа безопасност. Принуждаването им да се изправят срещу насилника си може да постави репортера в компрометираща позиция. Трябва да поддържате директна комуникация с въпросното лице, освен ако репортерът изрично не поиска друго.

Има няколко начина, по които можете да реагирате на нарушение на кодекса на поведение:

* **Дайте публично предупреждение на въпросното лице** и обяснете как поведението му е повлияло негативно на другите, за предпочитане в канала, където се е случило. Когато е възможно, публичната комуникация предава на останалата част от общността, че приемате кодекса за поведение сериозно. Бъдете мили, но твърди в общуването си.

* **Свържете се лично с въпросното лице**, за да обясните как поведението му е повлияло негативно на другите. Може да искате да използвате личен канал за комуникация, ако ситуацията включва чувствителна лична информация. Ако общувате с някого насаме, добра идея е да изпратите CC на онези, които първи са съобщили за ситуацията, за да знаят, че сте предприели действия. Помолете подалото сигнал лице за съгласие, преди да му изпратите CC.

Понякога не може да се постигне решение. Въпросното лице може да стане агресивно или враждебно, когато се сблъскаш с него или да не промени поведението си. В тази ситуация може да обмислите предприемането на по-строги действия. Например:

* **Забрана на въпросното лице** от проекта, наложено чрез временна забрана за участие във всеки аспект на проекта

* **Забранете за постоянно** лицето от проекта

Забраната на членове не трябва да се приема с лека ръка и представлява постоянна и непримирима разлика в гледните точки. Трябва да предприемате тези мерки само когато е ясно, че не може да се постигне решение.

## Вашите отговорности като поддържащ

Кодексът на поведение не е закон, който се прилага произволно. Вие сте наложителят на кодекса за поведение и е ваша отговорност да следвате правилата, установени от кодекса за поведение.

Като поддържащ вие установявате насоките за вашата общност и налагате тези насоки в съответствие с правилата, изложени във вашия кодекс за поведение. Това означава да приемате сериозно всеки сигнал за нарушение на кодекса за поведение. На репортера се дължи задълбочено и справедливо разглеждане на жалбата им. Ако установите, че поведението, за което са докладвали, не е нарушение, съобщете им го ясно и обяснете защо няма да предприемете действия по него. Какво ще направят с това зависи от тях: да толерират поведението, с което са имали проблем, или да спрат да участват в общността.

Докладът за поведение, което _технически_ не нарушава кодекса за поведение, все още може да показва, че има проблем във вашата общност и вие трябва да проучите този потенциален проблем и да действате съответно. Това може да включва преразглеждане на вашия кодекс за поведение, за да се изясни приемливото поведение и/или разговор с лицето, чието поведение е докладвано, и да му кажете, че макар да не е нарушил кодекса за поведение, те заобикалят ръба на очакваното и правят сигурни участниците се чувстват неудобно.

В крайна сметка, като поддържащ, вие определяте и налагате стандартите за приемливо поведение. Вие имате способността да оформяте ценностите на общността на проекта и участниците очакват от вас да налагате тези ценности по справедлив и равностоен начин.

## Насърчавайте поведението, което искате да видите в света 🌎

Когато даден проект изглежда враждебен или неприветлив, дори ако това е само един човек, чието поведение се толерира от другите, рискувате да загубите много повече сътрудници, някои от които може дори никога да не срещнете. Не винаги е лесно да приемете или наложите кодекс на поведение, но насърчаването на гостоприемна среда ще помогне на вашата общност да расте.
