---
lang: bg
title: Изграждане на приветливи общности
description: Изграждане на общност, която насърчава хората да използват, допринасят и образоват с вашия проект
class: building
order: 4
image: /assets/images/cards/building.png
related:
  - best-practices
  - coc
---

## Настройване на вашия проект за успех

Току-що стартирахте проекта си, разпространявате информацията и хората го следват. Брилянтно! Сега, как да ги накараш да останат?

Гостоприемната общност е инвестиция в бъдещето на вашия проект и вашата репутация. Ако вашият проект едва започва да вижда първите си приноси, започнете, като дадете положителен опит на първите сътрудници и ги улеснете да се връщат отново.

### Накарайте хората да се чувстват добре дошли

Един от начините да мислите за общността на вашия проект е чрез това, което @MikeMcQuaid нарича [фуния на сътрудниците](https://mikemcquaid.com/2018/08/14/the-open-source-contributor-funnel-why-people-dont-contribute-to-your-open-source-project/):

![Фуния на сътрудник](/assets/images/building-community/contributor_funnel_mikemcquaid.png)

Докато изграждате общността си, помислете как някой на върха на фунията (потенциален потребител) може теоретично да си проправи път надолу (активен поддържащ). Вашата цел е да намалите триенето на всеки етап от опита на сътрудници. Когато хората имат лесни победи, те ще бъдат стимулирани да правят повече.

Започнете с вашата документация: 

* **Направете го лесен за тези, които трябва да използват проекта.** [Приятелски документ README](../starting-a-project/#напишете-readme) и ясни примери за код ще улеснят използването му .Това е лесно начало за всеки, който попадне на вашия проект.
* **Ясно обяснете как да допринесете**, като използвате [файл за CONTRIBUTING](../starting-a-project/#напишете-вашите-указания-за-принос) и поддържате проблемите си актуални.
* **Добри първи издания**: За да помогнете на новите сътрудници да започнат, мислете ясно за [подчертаване на теми, които са достатъчно прости, за да се справи начинаещият](https://help.github.com/en/articles/helping-new-contributors-find-your-project-with-labels). След това GitHub ще покаже тези проблеми на различни места в платформата, увеличавайки полезните приноси и намалявайки напрежението от потребителите, които се справят с проблеми, които са твърде трудни за тяхното ниво.

[Проучване на GitHub за отворен код от 2017 г](http://opensourcesurvey.org/2017/) показа, че непълната или объркваща документация е най-големият проблем за потребителите с отворен код. Добрата документация приканва хората да взаимодействат с вашия проект. В крайна сметка някой ще отвори проблем или заявка. Използвайте тези взаимодействия като възможности да ги преместите надолу по фунията.

* **Когато някой нов се присъедини към вашия проект, благодарете му за проявения интерес!** Необходим е само един негативен опит, за да накара някой да не иска да се върне.
* **Бъдете отзивчиви.** Ако не отговорите на въпроса им в продължение на един месец, има вероятност те вече да са забравили за вашия проект.
* **Бъдете непредубедени относно видовете приноси, които ще приемете.** Много сътрудници започват с докладване на грешка или извършване на малка корекция. Има [много начини да допринесете](../how-to-contribute/#какво-означава-да-допринасяш) към проект. Позволете на хората да помагат по начина, по който искат да помогнат.
* **Ако има принос, с който не сте съгласни,** им благодарете за тяхната идея и [обяснете защо](../best-practices/#научете-се-да-казвате-не) не отговаря на обхвата на проекта , с връзка към съответната документация, ако я имате.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikeal?s=180" class="pquote-avatar" alt="avatar">
  Приносът към отворен код е по-лесен за някои, отколкото за други. Има голям страх да не бъдете извикани, че не правите нещо правилно или просто не се вписвате. (...) Като предоставяте на сътрудниците място да допринасят с много ниска техническа компетентност (документация, маркиране на уеб съдържание и т.н.), можете значително да намалите тези опасения.
  <p markdown="1" class="pquote-credit">
— @mikeal, ["Разрастване на база от сътрудници в съвременния отворен код"](https://opensource.com/life/16/5/growing-contributor-base-modern-open-source)
  </p>
</aside>

Повечето сътрудници с отворен код са "случайни сътрудници": хора, които допринасят за проект само от време на време. Случаен сътрудник може да няма време да се запознае напълно с вашия проект, така че вашата работа е да го улесните да допринася.

Насърчаването на други сътрудници е инвестиция и във вас самите. Когато дадете възможност на най-големите си фенове да работят с работата, която ги вълнува, има по-малко натиск да правите всичко сами.

### Документирайте всичко

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">
  Били ли сте някога на (техническо) събитие, където не познавате никого, но всички останали изглежда стоят на групи и чатят като стари приятели? (...) Сега си представете, че искате да допринесете за проект с отворен код, но не разбирате защо и как се случва това.
  <p markdown="1" class="pquote-credit">
— @janl, ["Устойчив отворен код"](https://web.archive.org/web/20200723213552/https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

Когато започвате нов проект, може да ви се стори естествено да запазите работата си в тайна. Но проектите с отворен код процъфтяват, когато документирате процеса си публично.

Когато документирате нещата, повече хора могат да бъдат включени във всяка стъпка от процеса. Може да получите помощ за нещо, от което дори не сте подозирали, че имате нужда.

Записването на неща означава повече от просто техническа документация. Всеки път, когато почувствате нужда да напишете нещо или да обсъдите работата си насаме, запитайте се дали можете да я направите публично достояние.

Бъдете прозрачни относно пътната карта на вашия проект, типовете приноси, които търсите, как се разглеждат приносите или защо сте взели определени решения.

Ако забележите, че много потребители имат същия проблем, моля, документирайте отговорите в README.

За срещи помислете за публикуване на вашите бележки или изводи в свързана тема. Обратната връзка, която ще получите от това ниво на прозрачност, може да ви изненада.

Документирането на всичко се отнася и за работата, която вършите. Ако работите върху голяма актуализация на вашия проект, поставете го в заявка за изтегляне и го маркирайте като работа в процес (WIP). По този начин други хора могат да се почувстват ангажирани в процеса на ранен етап.

### Бъдете отзивчиви

Докато [популяризирате своя проект](../finding-users), хората ще имат обратна връзка за вас. Те може да имат въпроси за това как работят нещата или да се нуждаят от помощ, за да започнат.

Опитайте се да бъдете отзивчиви, когато някой подаде проблем, изпрати заявка за изтегляне или зададе въпрос относно вашия проект. Когато отговаряте бързо, хората ще се почувстват като част от диалог и ще бъдат по-ентусиазирани да участват.

Дори и да не можете да прегледате заявката незабавно, потвърждаването й на ранен етап помага да се увеличи ангажираността. Ето как @tdreyno отговори на заявка за изтегляне на [Middleman](https://github.com/middleman/middleman/pull/1466):

![Middleman заявка за изтегляне](/assets/images/building-community/middleman_pr.png)

[Това установи проучване на Mozilla](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177) сътрудниците, които са получили прегледи на кода в рамките на 48 часа, са имали много по-висок процент на възвръщаемост и повторен принос.

Дискусиите относно вашия проект може също да се случват другаде в мрежата, като Stack Overflow, Twitter или Reddit. Можете да настроите известия на някои от тези места, така че да получавате известия, когато някой спомене вашия проект.

### Дайте на вашата общност място за събиране

Има две причини да дадете на вашата общност място за събиране.

Първата причина е за тях. Помогнете на хората да се опознаят. Хората с общи интереси неизбежно ще искат място, където да говорят за това. А когато комуникацията е публична и достъпна, всеки може да чете минали архиви, за да се запознае и да участва.

Втората причина е за вас. Ако не дадете на хората обществено място да говорят за вашия проект, те вероятно ще се свържат директно с вас. В началото може да изглежда достатъчно лесно да отговаряте на лични съобщения "само този път". Но с течение на времето, особено ако проектът ви стане популярен, ще се почувствате изтощени. Устояйте на изкушението да общувате с хората относно вашия проект насаме. Вместо това ги насочете към определен обществен канал.

Публичната комуникация може да бъде толкова проста, колкото да насочите хората да отворят проблем, вместо да ви изпращат имейл директно или да коментират в блога ви. Можете също така да настроите пощенски списък или да създадете акаунт в Twitter, Slack или IRC канал, за да могат хората да говорят за вашия проект. Или опитайте всичко по-горе!

[Kubernetes kops](https://github.com/kubernetes/kops#getting-involved) отделя работни часове през седмица, за да помогне на членовете на общността:

> Kops също така отделя време всяка седмица, за да предлага помощ и насоки на общността. Поддържащите Kops се съгласиха да отделят време, специално посветено на работа с новодошлите, подпомагане с PR и обсъждане на нови функции.

Забележителни изключения от публичната комуникация са: 1) проблеми със сигурността и 2) чувствителни нарушения на кодекса за поведение. Винаги трябва да имате начин хората да докладват тези проблеми лично. Ако не искате да използвате личния си имейл, настройте специален имейл адрес.

## Разрастване на вашата общност

Общностите са изключително силни. Тази сила може да бъде благословия или проклятие, в зависимост от това как я владеете. Тъй като общността на вашия проект расте, има начини да му помогнете да се превърне в сила на изграждане, а не на разрушение.

### Не толерирайте лоши актьори

Всеки популярен проект неизбежно ще привлече хора, които вредят, а не помагат на вашата общност. Те могат да започнат ненужни дебати, да се карат за тривиални характеристики или да тормозят другите.

Направете всичко възможно да приемете политика на нулева толерантност към този тип хора. Ако не бъдат отметнати, негативните хора ще накарат другите хора във вашата общност да се чувстват неудобно. Може дори да си тръгнат.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/okdistribute?s=180" class="pquote-avatar" alt="avatar">
  Истината е, че наличието на подкрепяща общност е от ключово значение. Никога не бих могъл да свърша тази работа без помощта на моите колеги, дружелюбни непознати в интернет и разговорливи IRC канали. (...) Не се задоволявайте с по-малко. Не се задоволявайте с глупаци.
  <p markdown="1" class="pquote-credit">
— @okdistribute, ["Как да управлявате проект FOSS"](https://okdistribute.xyz/post/okf-de)
  </p>
</aside>

Редовните дискусии за тривиални аспекти на вашия проект разсейват другите, включително вас, от фокусирането върху важни задачи. Нови хора, които пристигат във вашия проект, може да видят тези разговори и да не искат да участват.

Когато видите, че се появява негативно поведение, направете публично наблюдение за него. Обяснете с приятелски тон защо Такова поведение не е приемливо. Ако проблемът продължава, може да се наложи [да го помолите да напусне](../code-of-conduct/#вашите-отговорности-като-поддържащ). Вашият [кодекс на поведение](../code-of-conduct/) може да бъде конструктивно ръководство за тези разговори.

### Запознайте се с сътрудниците там, където са

Добрата документация става все по-важна, когато вашата общност расте. Случайни сътрудници, които иначе може да не са запознати с вашия проект, четат вашата документация, за да получат бързо контекста, от който се нуждаят.

Във вашия CONTRIBUTING файл кажете изрично на новите сътрудници как да започнат. Може дори да искате да направите специален раздел за тази цел. [Django](https://github.com/django/django), например, има специална целева страница за посрещане на нови сътрудници.

![Django страница с нови сътрудници](/assets/images/building-community/django_new_contributors.png)

В опашката си с теми маркирайте грешки, които са подходящи за различни типове сътрудници: например [_"за начинаещи"_](https://kentcdodds.com/blog/first-timers-only), _"добра първа тема"_ или _"документация"_. [Тези маркировки](https://github.com/librariesio/libraries.io/blob/6afea1a3354aef4672d9b3a9fc4cc308d60020c8/app/models/github_issue.rb#L8-L14) улесняват някой който  е нов във вашия проект бързо да сканира вашите теми и първи стъпки.

И накрая, използвайте вашата документация, за да накарате хората да се чувстват добре дошли на всяка стъпка от процеса.

Никога няма да взаимодействате с повечето хора, които ще участват във вашия проект. Възможно е да има приноси, които не сте получили, защото някой се е почувствал уплашен или не е знаел откъде да започне. Дори няколко мили думи могат да попречат на някого да напусне проекта ви разочарован.

Например, ето как [Rubinius](https://github.com/rubinius/rubinius/) започва [неговото допринасящо ръководство](https://github.com/rubinius/rubinius/blob/HEAD/.github/contributing.md):

> Искаме да започнем, като ви благодарим, че използвате Rubinius. Този проект е труд на любов и ние оценяваме всички потребители, които улавят грешки, правят подобрения на производителността и помагат с документацията. Всеки принос е значим, така че благодарим за участието. Имайки предвид това, ето няколко насоки, които ви молим да следвате, за да можем успешно да се справим с проблема ви.

### Споделете собствеността върху вашия проект

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/sagesharp?s=180" class="pquote-avatar" alt="avatar">
  Вашите лидери ще имат различни мнения, както трябва да бъдат всички здрави общности! Трябва обаче да предприемете стъпки, за да гарантирате, че най-силният глас не винаги печели, изморявайки хората, и че по-малко видните и малцинствените гласове се чуват.
  <p markdown="1" class="pquote-credit">
— @sagesharp, ["Какво прави една добра общност?"](https://sage.thesharps.us/2015/10/06/what-makes-a-good-community/)
  </p>
</aside>

Хората са развълнувани да допринасят за проекти, когато изпитват чувство за собственост. Това не означава, че трябва да преобърнете визията на вашия проект или да приемете приноси, които не искате. Но колкото повече признавате другите, толкова повече те ще останат наоколо.

Вижте дали можете да намерите начини да споделите собствеността с вашата общност колкото е възможно повече. Ето няколко идеи:

* **Отбягвайте коригирането на лесни (некритични) грешки.** Вместо това ги използвайте като възможности за набиране на нови сътрудници или наставничество на някой, който би искал да допринесе. В началото може да изглежда неестествено, но инвестицията ви ще се изплати с времето. Например @michaeljoseph помоли сътрудник да изпрати заявка за изтегляне на проблем с [Cookiecutter](https://github.com/audreyr/cookiecutter) по-долу, вместо да го коригира сам.

![Cookiecutter issue](/assets/images/building-community/cookiecutter_submit_pr.png)

* **Стартирайте файл CONTRIBUTORS или AUTHORS във вашия проект**, който изброява всички, които са допринесли за вашия проект, както прави [Sinatra](https://github.com/sinatra/sinatra/blob/HEAD/AUTHORS.md).

* Ако имате значителна общност, **изпратете бюлетин или напишете публикация в блог**, като благодарите на сътрудниците. [Тази седмица в Rust](https://this-week-in-rust.org/) на Rust и [Shoutouts](http://hood.ie/blog/shoutouts-week-24.html) на Hoodie са два добри примера.

* **Дайте достъп за ангажиране на всеки сътрудник.** @felixge установи, че това кара хората [да бъдат по-развълнувани да усъвършенстват корекциите си](https://felixge.de/2013/03/11/the-pull-request-hack.html) и дори намери нови поддържащи за проекти, по които не е работил от известно време.

* Ако проектът ви е в GitHub, **преместете проекта си от личния си акаунт в [Организация](https://help.github.com/articles/creating-a-new-organization-account/)** и добавете поне един резервен администратор. Организациите улесняват работата по проекти с външни сътрудници.

Реалността е, че [повечето проекти имат само](https://peerj.com/preprints/1233/) един или двама поддържащи, които вършат по-голямата част от работата. Колкото по-голям е вашият проект и колкото по-голяма е вашата общност, толкова по-лесно е да намерите помощ.

Въпреки че не винаги може да намерите някой, който да отговори на обаждането, подаването на сигнал там увеличава шансовете други хора да се включат. И колкото по-рано започнете, толкова по-скоро хората могат да помогнат.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gr2m?s=180" class="pquote-avatar" alt="avatar">
  \[Във ваш\] най-добър интерес е да набирате сътрудници, които се радват и които са способни да правят нещата, които вие не сте. Обичате ли да кодирате, но не и да отговаряте на въпроси? След това идентифицирайте онези хора във вашата общност, които го правят, и им го позволете.
  <p markdown="1" class="pquote-credit">
— @gr2m, ["Приветстващи общности"](http://hood.ie/blog/welcoming-communities.html)
  </p>
</aside>

## Разрешаване на конфликти

В ранните етапи на вашия проект вземането на важни решения е лесно. Когато искаш да направиш нещо, просто го правиш.

Тъй като вашият проект става по-популярен, повече хора ще се интересуват от решенията, които вземате. Дори и да нямате голяма общност от сътрудници, ако вашият проект има много потребители, ще намерите хора, които преценяват решенията или повдигат свои собствени проблеми.

В по-голямата си част, ако сте култивирали приятелска, уважителна общност и сте документирали процесите си открито, вашата общност трябва да може да намери решение. Но понякога се натъквате на проблем, който е малко по-труден за разрешаване.

### Поставете стандарта за учтивост

Когато вашата общност се бори с труден проблем, настроението може да се надигне. Хората може да се ядосат или разочароват и да си го изкарат един на друг или на вас.

Вашата работа като поддържащ е да предотвратите ескалацията на тези ситуации. Дори ако имате силно мнение по въпроса, опитайте се да заемете позицията на модератор или фасилитатор, вместо да влизате в битката и да популяризирате своите възгледи. Ако някой е нелюбезен или монополизира разговора, [действайте незабавно](../building-community/#не-толерирайте-лоши-актьори), за да поддържате дискусията цивилизована и продуктивна.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kennethreitz?s=180" class="pquote-avatar" alt="avatar">
  Като поддържащ проект е изключително важно да се отнасяте с уважение към сътрудниците си. Те често приемат много лично това, което казвате.
  <p markdown="1" class="pquote-credit">
— @kennethreitz, ["Бъдете сърдечни или бъдете на път"](https://web.archive.org/web/20200509154531/https://kenreitz.org/essays/be-cordial-or-be-on-your-way)
  </p>
</aside>

Други хора ви търсят за напътствие. Давайте добър пример. Все още можете да изразите разочарование, нещастие или загриженост, но го направете спокойно.

Да запазите хладнокръвие не е лесно, но демонстрирането на лидерство подобрява здравето на вашата общност. Интернет ви благодари.

### Отнасяйте се към вашия README като към конституция

Вашият README е [повече от просто набор от инструкции](../starting-a-project/#напишете-readme). Това също е място да говорите за вашите цели, продуктова визия и пътна карта. Ако хората са прекалено съсредоточени върху обсъждането на достойнствата на определена функция, може да ви помогне да прегледате отново вашия README и да говорите за по-високата визия на вашия проект. Фокусирането върху вашия README също обезличава разговора, така че можете да водите конструктивна дискусия.

### Фокусирайте се върху пътуването, а не върху дестинацията

Някои проекти използват процес на гласуване, за да вземат важни решения. Въпреки че е разумно на пръв поглед, гласуването набляга на достигането до "отговор", а не на изслушване и разглеждане на притесненията на другия.

Гласуването може да стане политическо, когато членовете на общността се чувстват принудени да си правят услуги или да гласуват по определен начин. Не всеки гласува също, независимо дали е [мълчаливото мнозинство](https://ben.balter.com/2016/03/08/optimizing-for-power-users-and-edge-cases/#the-silent-majority-of-users) във вашата общност или настоящи потребители, които не са знаели, че се провежда гласуване.

Понякога е необходим равен вот. Доколкото можете обаче, наблягайте на ["търсенето на консенсус"](https://en.wikipedia.org/wiki/Consensus-seeking_decision-making), а не на консенсуса .

При процес на търсене на консенсус членовете на общността обсъждат основните опасения, докато не почувстват, че са били адекватно изслушани. Когато останат само второстепенни грижи, общността върви напред. "Търсене на консенсус" признава, че една общност може да не е в състояние да достигне до перфектен отговор. Вместо това дава приоритет на слушането и дискусията.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lee-dohm?s=180" class="pquote-avatar" alt="avatar">
  Част от причината да няма система за гласуване за темите на Atom е, че екипът на Atom няма да следва система за гласуване във всички случаи. Понякога трябва да изберем това, което смятаме за правилно, дори и да не е популярно. (...) Това, което мога да предложа и съм се ангажирал да направя... е, че моята работа е да слушам общността.
  <p markdown="1" class="pquote-credit">
— @lee-dohm върху процеса на вземане на решения на Atom
  </p>
</aside>

Дори ако всъщност не възприемете процес на търсене на консенсус, като поддържащ проект е важно хората да знаят, че слушате. Да накарате другите хора да се почувстват чути и да се ангажират с разрешаването на притесненията им допринася много за деескалацията на чувствителни ситуации. След това последвайте думите си с действия.

Не бързайте с решение в името на решението. Уверете се, че всички се чувстват чути и че цялата информация е разпространена, преди да преминете към решение.

### Поддържайте разговора фокусиран върху действието

Дискусията е важна, но има разлика между продуктивни и непродуктивни разговори.

Насърчавайте дискусията, стига да върви активно към разрешаване. Ако е ясно, че разговорът затихва или се отклонява от темата, заяжданията стават лични или хората се бъзикат за незначителни подробности, време е да го затворите.

Позволяването на тези разговори да продължат е не само лошо за разглеждания проблем, но и за здравето на вашата общност. Изпраща съобщение, че този тип разговори са разрешени или дори насърчавани, и може да обезсърчи хората да повдигат или разрешават бъдещи проблеми.

С всяка точка, изказана от вас или от други, запитайте се: "Как това ни доближава до решение?"_

Ако разговорът започва да се разплита, попитайте групата _"Кои стъпки трябва да предприемем по-нататък?"_, за да пренасочите разговора.

Ако разговорът очевидно не води до никъде, няма ясни действия, които да бъдат предприети, или подходящото действие вече е предприето, затворете проблема и обяснете защо сте го затворили.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  Насочването на нишка към полезност, без да се натрапва, е изкуство. Няма да работи просто да увещавате хората да спрат да си губят времето или да ги молите да не публикуват, освен ако нямат нещо конструктивно да кажат. (...) Вместо това трябва да предложите условия за по-нататъшен напредък: дайте на хората маршрут, пътека, която да следват, която води до резултатите, които искате, но без да звучи така, сякаш диктувате поведението.
  <p markdown="1" class="pquote-credit">
— @kfogel, [_Продуциране OSS_](https://producingoss.com/en/producingoss.html#common-pitfalls)
  </p>
</aside>

### Подбирайте битките си мъдро

Важен е контекстът. Помислете кой участва в разговора и как той представлява останалата част от общността.

Всички в общността разстроени ли са или дори загрижени за това? Или е самотен размирник? Не забравяйте да имате предвид мълчаливите членове на вашата общност, а не само активните гласове.

Ако проблемът не представлява по-широките нужди на вашата общност, може просто да се наложи да приемете притесненията на някои хора. Ако това е повтарящ се проблем без ясно решение, моля, насочете ги към предишни дискусии по темата и затворете темата.

### Определете критерий за равновесие на общността

С добро поведение и ясна комуникация повечето трудни ситуации се разрешават. Въпреки това, дори при продуктивна дискусия, може просто да има разлика в мненията за това как да продължите. В тези случаи идентифицирайте човек или група от хора, които могат да служат като балансьор.

Нивелирът може да бъде основният поддържащ проекта или може да бъде малка група хора, които вземат решение въз основа на гласуване. В идеалния случай вие сте дефинирали нивелир и свързаната процедура във файл GOVERNANCE, преди да се наложи да го използвате.

Вашето решение за вратовръзка трябва да е последна мярка. Разделящите въпроси са възможност за вашата общност да расте и да се учи. Прегърнете тези възможности и използвайте процес на сътрудничество, за да преминете към разрешаване, когато е възможно.

## Общността е ❤️ на отворен код

Здравите, процъфтяващи общности захранват хилядите часове, вложени в отворен код всяка седмица. Много сътрудници посочват други хора като причина да работят - или да не работят - с отворен код. Като се научите как да се възползвате от тази сила конструктивно, вие ще помогнете на някого да има незабравимо изживяване с отворен код.
