---
lang: bg
title: Добри практики за поддържащи кода.
description: Улесняване на живота ви като поддържащ отворен код, от процеса на документиране до извличане на максимума от общността.
class: best-practices
order: 5
image: /assets/images/cards/best-practices.png
related:
  - metrics
  - leadership
---

## Какво означава да си поддържащ код?

Ако вашата работа е да поддържате проект с отворен код, който много хора използват, вероятно сте забелязали, че прекарвате повече време в отговаряне на въпроси, отколкото в програмиране.

В ранните етапи на проекта прекарвате време в експериментиране с нови идеи и вземане на решения въз основа на това, което харесвате. С нарастването на популярността на проекта ви ще се окажете в ситуация, в която ще работите с вашите потребители и сътрудници все повече и повече.

Поддържането на проект изисква повече от просто код. Тези задачи обикновено не се вземат предвид, но са също толкова важни за разрастващ се проект. Събрахме няколко идеи, които ще улеснят живота ви, от процеса на документиране до извличането на максимума от общността.

## Документиране на вашите процеси

Отбелязването на процедурите е една от най-добрите практики, които можете да направите като поддържащ код.

Документирането не само изяснява вашето мислене, но също така помага на другите да разберат от какво се нуждаете или очаквате, без дори да се налага да питате.

Като вземете под внимание процесите, ви е по-лесно да кажете "не", когато нечие предложение не отговаря на вашия контекст. Така Освен това улеснява други хора да се присъединят и да помогнат. Никога не знаете кой може да чете или използва вашия проект.

Дори и да не сте от хората, които пишат цели параграфи, записването на ключови моменти е по-добро от никакви.

### Изясняване на визията на вашия проект

Започнете, като напишете целите на вашия проект. Добавете ги към вашия файл README или създайте отделен файл, наречен VISION. Ако има други артефакти, които могат да помогнат, като например карта на проект, направете и тях публични.

Наличието на ясна документирана визия ви държи фокусирани и помага да избегнете неразбиране на обхвата от други сътрудници.

Например:
@lord откри фактът, че наличието на визия за проект му помогна да разбере кои заявки да даде приоритет. Като начинаещ поддържащ код, той се оплака че не е бил верен на обхвата на проекта, когато е получил първата ви заявка за функционалност [Slate](https://github.com/lord/slate).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lord?s=180" class="pquote-avatar" alt="avatar">
  Опитах. Не положих необходимите усилия, за да изляза с цялостно решение. Вместо половинчато решение, бих искал да бях казал "Нямам време за това в момента, но ще добавя функционалността към изоставането, което ще бъде разработено в бъдеще".
  <p markdown="1" class="pquote-credit">
— @lord, ["Съвети за поддържащите отворен код"](https://lord.io/blog/2014/oss-tips/)
  </p>
</aside>

### Съобщете вашите очаквания

Понякога може да е трудно да се формулират правилата, така че други хора да могат да допринесат. Може да почувствате, че се държите като ченге или разваляте забавлението на другите.

Въпреки това, написани и приложени справедливо, добрите правила дават възможност на поддържащите кода. Те ви предпазват от това да бъдете въвлечени в неща, които не искате да правите.

Повечето хора, които срещат вашия проект, не знаят нищо за вас или вашите обстоятелства. Те може да приемат, че ви е платено да работите по него, особено ако това е нещо, което те използват и от което зависят редовно. Може би някога сте отделяли много време за проекта си, но сега сте заети с нова работа или член на семейството.

Всичко е наред! Просто се уверете, че хората знаят.

Независимо дали поддържането на вашия проект е на непълно работно време или просто доброволно, бъдете честни за това колко време имате. Това не е същото като колко време мислите, че ще отнеме проектът или колко време другите искат да отделите.

Ето някои правила, които си струва да имате предвид:

* Как се преглежда и приема принос (_Трябва ли да направите някои тестове? Някакви шаблони, които да използвате за проблеми?_)
* Типовете приноси, които ще приемете (_Искате ли помощ само за част от кода?_)
* Кога е уместно да се проследи (_напр. "Можете да очаквате отговор от поддържащия код в рамките на следващите 7 дни. Ако не сте чули нищо дотогава, не се колебайте да изпратите ping на нишката."_)
*Колко време посвещавате на проекта (_напр. "Ние инвестираме само около 5 часа на седмица в този проект"_)

[Jekyll](https://github.com/jekyll/jekyll/tree/master/docs), [CocoaPods](https://github.com/CocoaPods/CocoaPods/wiki/Communication-&-Design-Rules), и [Homebrew](https://github.com/Homebrew/brew/blob/bbed7246bc5c5b7acb8c1d427d10b43e090dfd39/docs/Maintainers-Avoiding-Burnout.md) това са някои примери за проекти с ясни правила за поддържащи и сътрудници.

### Поддържайте публична комуникация

Не забравяйте да документирате и вашите взаимодействия. Където можете, поддържайте публична комуникация относно вашия проект. Ако някой се опита да се свърже с вас лично, за да обсъдите заявка за функция или нужда от поддръжка, учтиво го насочете към обществен канал за комуникация, като списък с имейли или инструмент за проследяване на проблеми.

Ако се срещнете с други поддържащи или вземете важни решения насаме, документирайте тези разговори публично, дори ако просто публикувате бележките си.

По този начин всеки, който се присъедини към вашата общност, ще има достъп до същата информация като някой, който е бил там. От години.

## Научете се да казвате не

Написахте нещата. В идеалния случай всеки ще прочете вашата документация, но в действителност ще трябва да напомняте на другите, че това знание съществува.

Наличието на всичко написано обаче помага да се обезличат ситуациите, в които е необходимо да се налагат правилата.

Да кажете "не" не е забавно, но _"Вашият принос не отговаря на критериите за този проект"_ изглежда по-малко лично от _"Не харесвам приноса ви"_.

Казването "не" се отнася за много ситуации, които ще срещнете като поддържащ код: заявки за функции, които са извън обхвата, някой дерайлира дискусия, върши ненужна работа за други.

### Поддържайте разговора приятелски

Едно от най-важните места, където ще практикувате да казвате "не", е в опашката за издаване и изтегляне на заявки. Като ръководител на проекти вие неизбежно ще получите предложения, които не искате да приемете.

Може би приносът променя обхвата на вашия проект или не отговаря на вашата визия. Може би идеята е добра, но изпълнението е ужасно.

Независимо от причината, можете тактично да се справите с приноси, които не отговарят на стандартите на проекта.

Ако получите изпращане, което не искате да приемете, първата ви реакция може да бъде да го игнорирате или да се престорите, че не сте го видели. Това може да нарани чувствата на другия човек и дори да обезкуражи други потенциални сътрудници във вашата общност.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/krausefx?s=180" class="pquote-avatar" alt="avatar">
  Ключът към управлението на поддръжката за широкомащабни проекти с отворен код е проблемите да се движат. Опитайте се да избегнете все още проблеми. Ако сте разработчик на iOS, знаете колко разочароващо може да бъде изпращането на радари. Може да получите някои новини две години по-късно и те ще бъдат помолени да ги потвърдят. Моля, опитайте отново с най-новата версия на iOS.
  <p markdown="1" class="pquote-credit">
— @KrauseFx, ["Мащабиране на общности с отворен код"](https://krausefx.com/blog/scaling-open-source-communities)
  </p>
</aside>

Не оставяйте отворен нежелан принос, защото се чувствате виновни или искате да сте мили. С течение на времето вашите въпроси без отговор и PR ще станат излишни. Това ще направи работата по вашия проект много по-стресираща и смущаваща.

Най-добре е незабавно да затворите приноси, които знаете, че не искате да приемете. Ако вашият проект вече страда от голямо изоставане или списък с функции за внедряване, @steveklabnik има предложения за [как да избирате ефективно въпроси](https://words.steveklabnik.com/how-to-be-an-open-source-gardener).

Второ, игнорирането на приносите изпраща отрицателен сигнал към вашата общност. Приносът към проект може да бъде смущаващ, особено ако на някого е за първи път. Дори и да не приемете техния принос, поздравете човека зад него и му благодарете за проявения интерес. Това е страхотен комплимент!

Ако не желаете да приемете дарение:

* **Благодаря им** за техния принос.
* **Обясни защо не отговаря** на обхвата на проекта и предлага ясни предложения за подобрение, ако е възможно. Знам мил, но твърд.
* **Споделете подходяща информация**, ако я имате. Ако забележите повтарящи се искания за неща, които не искате да приемете, добавете ги към документацията си, за да избегнете винаги да обяснявате едно и също нещо.
* **Затворете заявката**

Не трябва да имате повече от 1-2 изречения, за да отговорите. Например, когато потребител [celery](https://github.com/celery/celery/) съобщи за грешка, свързана с Windows, @berkerpeksag [той отговори с](https://github.com/celery/celery/issues/3383):

[celery screenshot](/assets/images/best-practices/celery.png)

Ако идеята да кажете "не" ви ужасява, не се чувствайте сами. Както @jessfraz [казва](https://blog.jessfraz.com/post/the-art-of-closing/):

> Говорил съм с поддържащи кодове от множество различни проекти с отворен код, Mesos, Kubernetes, Chromium, и всички те са съгласни, че една от най-трудните части да си поддържащ код е: да кажеш "Не" на пачове, които не искаш да използваш.

Не се чувствайте виновни, че не искате да приемете нечий принос. Първото правило на отворения код, [в съответствие със](https://twitter.com/solomonstre/status/715277134978113536) @shykes: _"Не, е временно; да, това е завинаги."_ Докато мъченичеството на ентусиазма на друг човек е добро нещо, отхвърлянето на принос не е същото като отхвърлянето на човека зад него.

В крайна сметка, ако даден принос не е достатъчно добър, не сте длъжни да го приемете. Знам Бъдете мили и отзивчиви, когато хората допринасят за вашия проект, но приемайте само промени, които наистина вярвате, че ще направят проекта ви по-добър. Колкото по-често се упражнявате да казвате "не", толкова по-лесно става. Това е обещание.

### Бъди проактивен

За да намалите първо обема на нежеланите приноси, обяснете процеса на вашия проект за подаване и приемане на приноси в ръководството за приноси.

Ако получите твърде много подавания с ниско качество, помолете сътрудниците да свършат малко работа предварително, например:

* Попълнете шаблон или контролен списък за проблеми или PR
*Отворете проблем, преди да изпратите PR

Ако не спазват вашите правила, незабавно затворете проблема и ги насочете към вашата документация.

Въпреки че този подход може да изглежда неприятен в началото, проактивността всъщност е добра и за двете страни. Намалете шанса някой да инвестира много часове пропиляна работа върху заявка за изтегляне, която не приемате. И опростява управлението на натоварването.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikemcquaid?s=180" class="pquote-avatar" alt="avatar">
  В идеалния случай, обяснете във файл CONTRIBUTING.md как могат да получат по-добра индикация в бъдеще за това какво би или не би било прието, преди да започнат работата.
  <p markdown="1" class="pquote-credit">
— @MikeMcQuaid, ["Любезно затваряне на заявки за изтегляне"](https://github.com/blog/2124-kindly-closing-pull-requests)
  </p>
</aside>

Понякога, когато кажете "не", вашият потенциален сътрудник може да се ядоса или да критикува решението ви. Ако поведението ви стане враждебно, [вземете мерки за обезвреждане на ситуацията](https://github.com/jonschlinkert/maintainers-guide-to-staying-positive#action-items) или дори ги отстранете от вашата общност, ако не желаят да си сътрудничат конструктивно.

### Прегърнете наставничеството

Може би някой във вашата общност редовно изпраща приноси, които не отговарят на стандартите на вашия проект. Може да бъде разочароващо и за двете страни многократното преминаване през процеса на отхвърляне.

Ако видите, че някой е Ако сте развълнувани от проекта си, но той се нуждае от малко практика, бъдете търпеливи. Обяснете ясно във всяка ситуация защо. техният принос не отговаря на очакванията на проекта. Опитайте да им дадете по-лесна или по-малко двусмислена задача, като например проблем, означен с _"добър първи проблем,"_, за да ги загреете. Ако имате време, помислете за менторство чрез първия си принос или намерете някой друг във вашата общност, който се интересува. готови да ги наставляват.

##Използване на общността

Не е нужно да правите всичко сами. Вашата проектна общност съществува с причина! Дори ако все още нямате активна общност от сътрудници, ако имате много потребители, оставете ги да работят.

### Споделете натоварването

Ако търсите други да се присъединят, започнете, като разпитате наоколо.

Когато видите нови сътрудници да правят повторни приноси, трябва да признаете работата им, като им предложите повече отговорности. Документирайте как другите могат да постигнат лидерски роли, ако желаят.

Насърчаването на други да [споделят собствеността върху проекта](../building-community/#споделете-собствеността-върху-вашия-проект) може значително да намали работното ви натоварване, както установи @lmccart във вашия проект, [p5.js](https://github.com/processing/p5.js).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lmccart?s=180" class="pquote-avatar" alt="avatar">
 Казвах: "Да, всеки може да участва, не е необходимо да имате много опит в програмирането [...]." Имаме регистрирани хора [за събития] и ето ни Тогава се запитах: вярно ли е това, което казвам? Ще има 40 души, които ще се появят и не е като да мога да седя с всеки един от тях... Но хората се събраха и се получи. Щом човек го получи, той може да учи съседите си.
  <p markdown="1" class="pquote-credit">
—  @lmccart, ["Какво в крайна сметка означава "Отворен код"? p5.js Редактиране"](https://medium.com/@kenjagan/what-does-open-source-even-mean-p5-js-edition-98c02d354b39)
  </p>
</aside>

Ако трябва да се оттеглите от проекта си, независимо дали временно или за постоянно, не е срамно да помолите някой друг да поеме вместо вас.

Ако други хора са ентусиазирани относно посоката на проекта, дайте им разрешение да се ангажират или официално предайте контрола на някой друг. Ако някой направи разклонение на вашия проект и това е активно поддържане някъде другаде, помислете за свързване на разклонението от вашия оригинален проект. Страхотно е, че толкова много хора искат вашият проект да се развива!

@progrium [установи, че](https://web.archive.org/web/20151204215958/https://progrium.com/blog/2015/12/04/leadership-guilt-and-pull-requests/) документирайки визията на вашия проект, [Dokku](https://github.com/dokku/dokku), помогне тези цели да продължават, включително и след това, което е останало на проекта:

> Написах wiki страница, описваща какво искам и защо го искам. По някаква причина бях изненадан от това! Нека поддържащите започнат да движат проекта в тази посока! Случи се? Как точно бихте го направили? Не винаги. Но както и да се приближи, аз реализирах проекта, както исках.

### Позволете на другите да създават решенията, от които се нуждаят

Ако потенциален сътрудник има различно мнение за това какво трябва да направи вашият проект, може да се наложи внимателно да го насърчите да работи върху собствената си вилка.

Разклоняването на проект не е задължително да е лошо нещо. Да можеш да копираш и модифицираш проекти е едно от най-добрите неща на отворения код. Насърчаването на членовете на вашата общност да работят върху своя собствена вилица може да осигури творческия изход, от който се нуждаят, без да противоречи на визията на вашия проект.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/geerlingguy?s=180" class="pquote-avatar" alt="avatar">
  Аз се справям с 80% от случаите на употреба. Ако сте един от еднорозите, моля, разклонете работата ми. Няма да се обидя! Моите обществени проекти почти винаги са насочени към решаване на най-често срещаните проблеми; Опитвам се да улесня отиването по-нататък или с разклонение на моята работа, или като я разширя.
  <p markdown="1" class="pquote-credit">
— @geerlingguy, ["Защо затварям PR-и"](https://www.jeffgeerling.com/blog/2016/why-i-close-prs-oss-project-maintainer-notes)
  </p>
</aside>

Същото важи и за потребител, който наистина иска решение, което вие просто нямате възможност да създадете. Предлагането на адаптивни API и кукички може да помогне на другите да посрещнат собствените си нужди, без да се налага директно да променят източника.
@orta [намери че](https://artsy.github.io/blog/2016/07/03/handling-big-projects/) окуражаващи плъгини за CocoaPods към "някои от по-интересните идеи":

> Почти неизбежно е след като проектът стане голям, поддържащите трябва да бъдат много по-консервативни по отношение на това как въвеждат нов код. Умеете да казвате "не", но много хора имат законни нужди. Следователно в крайна сметка превръщате инструмента си в платформа.

## Доведете роботите

Така Точно както има задачи, с които други хора могат да ви помогнат, има и задачи, които никое човешко същество не трябва да изпълнява. Роботите са ваши приятели. Използвайте ги, за да улесните живота си като поддържащ код.

### Изисквайте тестване и други проверки, за да подобрите качеството на вашия код

Един от най-важните начини за автоматизиране на вашия проект е чрез тестване.

Тестването помага на сътрудниците да се чувстват уверени, че няма да нарушат нищо. Те също така улесняват прегледа и бързото приемане на приноси. Колкото по-възприемчиви сте, толкова по-ангажирани ще бъдете. бъдете вашата общност.

Настройте автоматични тестове за изпълнение на всички входящи приноси и се уверете, че могат да се изпълняват локално от сътрудниците. Изисква всички приноси на код да преминат през тестване, преди да могат да бъдат изпратени. Ще помогне за установяване на минимален стандарт за качество за всички приложения.
[Необходими са проверки на състоянието](https://help.github.com/articles/about-required-status-checks/) в GitHub може да помогне да се гарантира, че никакви промени не се обединяват, без първо да преминете през тестване.

Ако добавите тестове, не забравяйте да обясните как работят във вашия CONTRIBUTING файл.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/edunham?s=180" class="pquote-avatar" alt="avatar">
  Мисля, че тестването е необходимо за целия код, върху който хората работят. Ако кодът беше напълно и перфектно правилен, нямаше да има нужда от промени - ние пишем код само когато нещо е правилно. грешно, или "Той се срива", или "Тази или онази функция липсва". Каквито и промени да правите, тестването е от съществено значение за улавяне на всякакви регресии, които може случайно да въведете.
  <p markdown="1" class="pquote-credit">
— @edunham, [Общностна автоматизация на Rust"](https://edunham.net/2016/09/27/rust_s_community_automation.html)
  </p>
</aside>

### Използвайте инструменти за автоматизиране на основни задачи по поддръжката

Добрата новина за поддържането на популярен проект е, че други поддържащи вероятно са се сблъсквали с подобни проблеми и са създали решение за него.

Има [различни налични инструменти](https://github.com/showcases/tools-for-open-source) за подпомагане на автоматизирането на някои аспекти на работата по поддръжката. Няколко примера:

* [semantic-release](https://github.com/semantic-release/semantic-release) автоматизирайте вашите версии
* [mention-bot](https://github.com/facebook/mention-bot) споменете възможни рецензенти за заявки за рул
* [Danger](https://github.com/danger/danger) помага за автоматизиране на прегледа на кода

За доклади за грешки и други общи приноси GitHub има [Шаблони за проблеми и заявки за изтегляне](https://github.com/blog/2111-issue-and-pull-request-templates), които можете да създадете, за да рационализирате комуникацията, която получавате. Можете също да конфигурирате [имейл филтри](https://github.com/blog/2203-email-updates-about-your-own-activity)за управление на вашите имейл известия.

Ако искате да станете малко по-напреднали, ръководствата за стил могат да стандартизират приноса към проекта и да ги направят по-лесни за преглед и приемане.

Въпреки това, ако вашите стандарти са твърде сложни, те могат да увеличат бариерите пред приноса. Уверете се, че добавяте само правила, за да улесните живота на всички.

Ако не сте сигурни какво инструменти, които да използвате, вижте какво правят други популярни проекти, особено тези във вашата екосистема. Например какво Как изглежда процесът на принос за други модули на Node? Използването на подобни инструменти и подходи също ще улесни. Направете своя процес по-познат на вашите целеви сътрудници.

## То е добре пауза

Работата с отворен код някога ви е носила радост. Може би сега е така започват да ви карат да се чувствате отбягващи или виновни.

Може би се чувствате претоварени или нарастващо чувство на страх, когато мислите за вашите проекти. И междувременно се натрупват проблеми и заявки за изтегляне.

Прегарянето е реален и всеобхватен проблем в работата с отворен код, особено сред поддържащите. Като поддържащ, вашето щастие е неподлежащо на обсъждане изискване за оцеляването на всеки проект с отворен код.

Въпреки че трябва да се разбира от само себе си, вземете си почивка! Не трябва да чакате, докато се почувствате изморени, за да си вземете почивка. @brettcannon, разработчик на Python, реши да вземете [едномесечна ваканция](http://www.snarky.ca/why-i-took-october-off-from-oss-volunteering) след 14 години OSS доброволчество.

Като всеки друг вид работа, редовните почивки ще ви поддържат мотивирани. свежи, щастливи и развълнувани от работата си.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/danielbachhuber?s=180" class="pquote-avatar" alt="avatar">
  Докато поддържах WP-CLI, открих Че първо трябва да се тревожа за щастието си и да поставя ясни граници на моето участие. Най-добрият баланс, който съм намерил, е 2-5 часа седмично, като част от нормалния ми работен график. Това предпазва моето участие като страст и не ме чувства твърде много като работа. Тъй като приоритизирам проблемите, по които работя, мога редовно да напредвам в това, което смятам за най-важно.
  <p markdown="1" class="pquote-credit">
— @danielbachhuber, ["Моите съболезнования, сега сте поддържащият популярен проект с отворен код"](https://web.archive.org/web/20220306014037/https://danielbachhuber.com/2016/06/26/my-condolences-youre-now-the-maintainer-of-a-popular-open-source-project/)
  </p>
</aside>

Понякога може да е трудно да си вземете почивка от работата с отворен код, когато чувствате, че целият свят има нужда от вас. Хората може дори да се опитат да ви накарат да се чувствате виновни, че сте се отдалечили.

Направете всичко възможно, за да намерите поддръжка за вашите потребители и общност, докато сте далеч от даден проект. Ако не можете да намерите подкрепата, от която се нуждаете, все пак си направете почивка. Не забравяйте да общувате, когато не сте на разположение, така че хората да не се чувстват объркани от липсата ви на отзивчивост.

Правенето на почивки се отнася и за нещо повече от ваканции. Ако не искате да работите с отворен код през почивните дни или по време на работното време, съобщете тези решения на другите, за да знаят, че няма да ви притесняват.

## Погрижете се първо за себе си!

Поддържането на популярен проект изисква различни умения от ранните етапи на растеж, но е не по-малко възнаграждаващо. Като поддържащ, вие ще практикувате лидерски умения и умения за хора на ниво, което малко хора могат да изпитат. Въпреки че не винаги е лесно да се управлява, поставянето на ясни граници и вземането само на това, което ви кара да се чувствате комфортно, ще ви помогне. за да сте щастливи, актуализирани и продуктивни.
