## Contributing

[fork]: https://github.com/github/SoftU2F/fork
[pr]: https://github.com/github/SoftU2F/compare
[code-of-conduct]: CODE_OF_CONDUCT.md
[issue-template]: issue_template.md

Hi there! We're thrilled that you'd like to contribute to this project. Your help is essential for keeping it great.

Please note that this project is released with a [Contributor Code of Conduct][code-of-conduct]. By participating in this project you agree to abide by its terms.

## Submitting a pull request

0. [Fork][fork] and clone the repository
0. Create a new branch: `git checkout -b my-branch-name`
0. Make your change, add tests, and make sure the tests still pass
0. Push to your fork and [submit a pull request][pr]
0. Pat your self on the back and wait for your pull request to be reviewed and merged.
#### **If you are submitting a patch for a security vulnerability please report it to the [bounty tracker](https://hackerone.com/github**)**

Here are a few things you can do that will increase the likelihood of your pull request being accepted:

- Write tests.
- Keep your change as focused as possible. If there are multiple changes you would like to make that are not dependent upon each other, consider submitting them as separate pull requests.
- Write a [good commit message](http://tbaggery.com/2008/04/19/a-note-about-git-commit-messages.html).
- Don't forget about your pull request. If someone comments on your pull request with things you need to do before the pull request can be merged or someone comments some suggestions for your pull request, they probably want a response. If you don't fix issues with your pull request, it probably won't be merged.

## Submitting an issue
0. Create a [new issue](https://github.com/github/SoftU2F/issues/new)
0. Refer to [this document](https://help.github.com/en/github/managing-your-work-on-github/creating-an-issue) if unsure on how to properly create a new issue
0. Follow the [issue template](issue_template.md) to provide as much details of your operating system and environment as    possible.
0. Tell us about what issues you are experiencing.
0. Tell us how to reproduce your issue(s)
0. Stay active in your issue in case a repository maintainer needs additional information
#### **If you are submitting an issue about a security vulnerability please do so [here](https://hackerone.com/github)**

## Resources

- [How to Contribute to Open Source](https://opensource.guide/how-to-contribute/)
- [About Pull Requests](https://help.github.com/articles/about-pull-requests/)
- [About issues](https://help.github.com/en/github/managing-your-work-on-github/about-issues)
- [Issues information hub](https://help.github.com/en/github/managing-your-work-on-github/managing-your-work-with-issues)
- [GitHub Help](https://help.github.com)
- [Repo security policies](https://github.com/github/SoftU2F/security/policy)
- [Repo security advisories](https://github.com/github/SoftU2F/security/advisories)
