# Smallest possible […] file

This repository aims to collect the smallest possible syntactically valid files in different programming/scripting/markup languages.

It all started with [a blog post on the smallest possible HTML/XHTML files](https://mathiasbynens.be/notes/minimal-html)…

Pull requests welcome!

_– [Mathias](https://mathiasbynens.be/)_

## License

To the extent possible under law, the author has waived all copyright and related or neighboring rights to this work.

## File types

### Archives
- [bzip2 .bz2](BZip2.bz2)
- [gzip .gz](gzip.gz) [with a filename](gzip-name.gz)
- Roshal archive .rar [1.4](rar14.rar) [4](rar4.rar) [5](rar5.rar)
- [Tape archive .tar](tar.tar)
- [ZIP .zip](zip.zip)

### Audio
- [MPEG-1 Audio Layer III .mp3](mp3.mp3)
- [Waveform Audio File Format .wav](wav.wav)

### Documents
- [Compiled HTML help .chm](compiledhtml.chm)
- [Portable Document Format .pdf](pdf.pdf)
- [Rich Text Format .rtf](rtf.rtf)
- [Window Metafile .wmf](WindowsMetafile.wmf)

### Executables
- [Dolphin](dolphin.dol)
- [DOS Command file .com](doscommand.com) [(empty)](doscommand-empty.com), [DOS Executable .exe](dosexecutable.exe), [New Executable NE .exe](newexecutable.exe), [Linear Executable LX .exe](linearexecutable.exe)
- [Executable and Linkable Format .elf](elf.o)
- [JVM class .class](java-class.class)
- [Mach-O](macho-ml) [(padded)](macho)
- [Portable Executable PE .EXE](portableexecutable.exe) [(XP only)](portableexecutable-xp.exe)
- [Small Web File/Shockwave Flash .swf](flash.swf)
- [WebAssembly .wasm](webassembly.wasm)

### Graphics
- [Bitmap image file/Device Independent Bitmap .bmp](bmp.bmp)
- [Better Portable Graphics .bpg](bpg.bpg)
- [DICOM/Digital Imaging and Communications in Medicine .dcm](dicom.dcm)
- [Graphics Interchange Format .gif](gif.gif) [(transparent)](gif-transparent.gif)
- [High Efficiency Image File](heic.heif)
- [ICO file format .ico/.cur](ico.ico)
- [JPEG File Interchange Format .jpg/.jpeg](jpeg.jpg)
- [JPEG 2000 .jp2](jpeg2.jp2)
- Netpbm [Portable BitMap Format .pbm](pbm.pbm) [(binary)](pbmb.pbm) [Portable GrayMap Format .pgm](pgm.pgm) [(binary)](pgmb.pgm) [Portable PixMap Format .ppm](ppm.ppm) [(binary)](ppmb.ppm)
- [Portable Network Graphics .png](png-transparent.png) [(truncated)](png-truncated.png)
- [Multiple-image Network Graphics .mng](mng.mng)
- [Tagged Image File Format .tif](tiff.tif)
- [Truevision Advanced Raster Graphics Adapter/TARGA .tga](targa.tga)
- [WebP .webp](webp.webp)
- [X-bitmap .xbm](x-bitmap.xbm)

### Languages
- [ada .adb](ada.adb)
- [awk .awk](awk.awk)
- [batch](batch.bat)
- [brainfuck](brainfuck.bf)
- [c .c](c.c)
- [c .h](c.h)
- [C# .cs](csharp.cs)
- [C++ .cpp](cpp.cpp)
- [clojure](clojure.clj)
- [clojure](clojure.cljc)
- [clojurescript](clojurescript.cljs)
- [cobol](cobol.cob)
- [Coffeescript](coffeescript.coffee)
- [fortran-77 .f](fortran-77.f)
- [fortran-90 .f90](fortran-90.f90)
- [go](go.go)
- [Java .java](java.java)
- [JavaScript .js](javascript.js)
- [lua](lua.lua)
- [Makefile](Makefile)
- [Nim .nim](nim.nim)
- [objective-c .m](objective-c.m)
- [Objective CAML .ml](ocaml.ml)
- [pascal .pas](pascal.pas)
- [perl .pl](perl.pl)
- [PHP: Hypertext Preprocessor .php](php.php)
- [Python .py](python.py)
- [Ruby .rb](ruby.rb)
- [shell .sh](shell.sh)
- [swift .swift](swift.swift)

### Markup
- [JavaScript Object Notation .json](json.json) [(with padding .p)](json-p.jsonp)
- [Markdown .md](markdown.md)
- [Scalable Vector Graphics .svg](svg.svg)
- [toml](toml.toml)
- [YAML Ain't Markup Language .yaml/.yml](yaml.yml)
- Extensible Hypertext Markup Language .xhtml [(basic-1.0)](xhtml-basic-1.0.xhtml) [(1.0-frameset)](xhtml-1.0-frameset.html) [(1.0-strict)](xhtml-1.0-strict.xhtml) [(1.1)](xhtml-1.1.xhtml) [(basic-1.1)](xhtml-basic-1.1.xhtml) [(5)](xhtml5.xhtml)
- Extensible Markup Language XML [1.0](xml-1.0.xml) [(valid)](xml-1.0-valid.xml) [1.1](xml-1.1.xml) [(1.1-valid)](xml-1.1-valid.xml)
- Hypertext Markup Language [(2.0)](html-2.0.html) [(3.2)](html-3.2.html) [(4.0-strict)](html-4.0-strict.html) [(4.01-strict)](html-4.01-strict.html) [(4.01-frameset)](html-4.01-frameset.html) [(4.01-transitional)](html-4.01-transitional.html) [(5)](html5.html) [iso-html](iso-html.html)

### Video
- [Audio Video Interleave .avi](AudioVideoInterleave.avi)
- [Flash Video .flv](FlashVideo.flv)
- [Mpeg4 .mp4](Mpeg4.mp4) [(with audio)](mp4-with-audio.mp4)
- [WebM .webm](webm.webm)
- [WindowsMediaVideo .wmv](WindowsMediaVideo.wmv)

### Unsorted

- [chicken](chicken.chicken)
- [crystal](crystal.cr)
- [Cascading Style Sheets .css](css.css)
- [eiffel](eiffel.e)
- [elixir](elixir.ex)
- [Git commit](https://github.com/mathiasbynens/small/commit/63a7f20c7b442c21bd9b6d4a80fdbea77e59dc6b)
- [groovy](groovy.groovy)
- [haskell_loop](haskell_loop.hs)
- [haskell_term](haskell_term.hs)
- [i](i.i7x)
- [International Color Consortium profile .icc](icc.icc)
- [inform-6](inform-6.inf)
- [intercal](intercal.i)

- [jess](jess.clp)

- [malbolge](malbolge.malbolge)
- [cache manifest .appcache](manifest.appcache)
- [opa](opa.opa)

- [promela](promela.pml)
- [scala](scala.scala)
- [story](story.ni)
- [tads-3](tads-3.t)
- [typescript](typescript.ts)
- [vertex-shader](vertex-shader.vs)
- [whitespace](whitespace.ws)
