/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.rest;

import com.pusher.rest.util.Prerequisites;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.client.utils.URIBuilder;

public class SignatureUtil {
    public static URI uri(String method, String scheme, String host, String path, String body, String key, String secret, Map<String, String> extraParams) {
        Prerequisites.noReservedKeys(extraParams);
        try {
            HashMap<String, String> allParams = new HashMap<String, String>(extraParams);
            allParams.put("auth_key", key);
            allParams.put("auth_version", "1.0");
            allParams.put("auth_timestamp", new Long(System.currentTimeMillis() / 1000L).toString());
            if (body != null) {
                allParams.put("body_md5", SignatureUtil.bodyMd5(body));
            }
            allParams.put("auth_signature", SignatureUtil.sign(SignatureUtil.buildSignatureString(method, path, allParams), secret));
            URIBuilder b = new URIBuilder().setScheme(scheme).setHost(host).setPath(path);
            for (Map.Entry e : allParams.entrySet()) {
                b.setParameter((String)e.getKey(), (String)e.getValue());
            }
            return b.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not build URI", e);
        }
    }

    private static String bodyMd5(String body) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(body.getBytes("UTF-8"));
            return Hex.encodeHexString((byte[])digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("The Pusher HTTP client requires MD5 support", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("The Pusher HTTP client needs UTF-8 support", e);
        }
    }

    public static String sign(String input, String secret) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(secret.getBytes(), "SHA256"));
            byte[] digest = mac.doFinal(input.getBytes("UTF-8"));
            return Hex.encodeHexString((byte[])digest);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Invalid secret key", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("The Pusher HTTP client requires HmacSHA256 support", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("The Pusher HTTP client needs UTF-8 support", e);
        }
    }

    static String buildSignatureString(String method, String path, Map<String, String> queryParams) {
        StringBuilder sb = new StringBuilder();
        sb.append(method).append('\n').append(path).append('\n');
        Object[] keys = queryParams.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        boolean first = true;
        for (Object key : keys) {
            if (!first) {
                sb.append('&');
            } else {
                first = false;
            }
            sb.append((String)key).append('=').append(queryParams.get(key));
        }
        return sb.toString();
    }
}

