#
# $Id: crc.py 194 2007-04-05 15:31:53Z cameron $
#

from defines import *

class crc:
    def __init__(self, parent=None):
        self.attributes = {}                    # initialize attributes
        
        self.attributes["Match"] = 1            # Match attribute set to 1 tells the main program we can be used to match 
        self.attributes["Diff"] = 1             # Diff  attribute set to 1 tells the main program we can be used to diff
        self.attributes["Level"] = FUNCTION_LEVEL | BASIC_BLOCK_LEVEL   # these flags indicated we can diff/match both functions and basic blocks
        self.parent = parent                    # set up the parent
        
        self.module_name = "CRC"                # give the module a name
        self.author      = "Peter Silberman"    # author name
        self.description = "CRC module uses the crc signature"
        self.date        = "09/22/06"
        self.homepage    = "http://www.openrce.org"
        self.contact     = "peter.silberman@gmail.com"
        self.accuracy    = ACCURACY_HIGH
        
        self.parent.register_match_function(    self.match_function_by_crc,    self )   # register a function matching routine
        self.parent.register_match_basic_block( self.match_basic_block_by_crc, self )   # register a basic block matching routine
        self.parent.register_diff_function(     self.diff_function_by_crc,     self )   # register a function diffing routine
        self.parent.register_module(self)                                               # register our module in the module table
        
    def match_function_by_crc(self, function_a, function_b):
        if function_a.ext["PAIMEIDiffFunction"].crc == function_b.ext["PAIMEIDiffFunction"].crc:
            return 1
        else:
            return 0
        
    def match_basic_block_by_crc(self, bb_a, bb_b):
        if bb_a.ext["PAIMEIDiffBasicBlock"].crc == bb_b.ext["PAIMEIDiffBasicBlock"].crc:
            return 1
        else:
            return 0
        
    def diff_function_by_crc(self, function_a, function_b):
        if function_a.ext["PAIMEIDiffFunction"].crc != function_b.ext["PAIMEIDiffFunction"].crc:
            return 0
        else:
            return 0
        
