#!/usr/bin/env python
# -*- coding: ISO-8859-1 -*-
# generated by wxGlade 0.4.1 on Fri Sep 08 21:01:42 2006
#
# $Id: DiffConfigureDlg.py 194 2007-04-05 15:31:53Z cameron $
#

import wx
import os
import re
import sys
import InsignificantConfigDlg


FUNCTION_LEVEL    = 0x0001
BASIC_BLOCK_LEVEL = 0x0002

alpha = ['a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z']

class DiffConfigureDlg(wx.Dialog):
    def __init__(self, *args, **kwds):
        # begin wxGlade: DiffConfigureDlg.__init__
        kwds["style"] = wx.DEFAULT_DIALOG_STYLE
        wx.Dialog.__init__(self, *args, **kwds)
        self.sizer_6_staticbox = wx.StaticBox(self, -1, "Configuration Options")
        self.label_1 = wx.StaticText(self, -1, "Supported Function Matching Algorithms:")
        self.FunctionMatchListCtrl = wx.ListBox(self, -1, choices=[])
        self.label_3 = wx.StaticText(self, -1, "Supported Basic Block Matching Algorithms:")
        self.BasicBlockMatchListCtrl = wx.ListBox(self, -1, choices=[])
        self.label_5 = wx.StaticText(self, -1, "Supported Function Diffing Algorithms:")
        self.FunctionDiffListCtrl = wx.ListBox(self, -1, choices=[])
        self.ImportButton = wx.Button(self, -1, "Import")
        self.ExportButton = wx.Button(self, -1, "Export")
        self.InsignificantCheckBox = wx.CheckBox(self, -1, "Use Insignificant Settings")
        self.MatchCheckBox = wx.CheckBox(self, -1, "Match Until No Change")
        self.DefineButton = wx.Button(self, -1, "Define Insignificant Settings")
        self.DoneButton = wx.Button(self, -1, "Done")
        self.CancelButton = wx.Button(self, -1, "Cancel")
        self.label_2 = wx.StaticText(self, -1, "Currently Used Function Matching Algorithms:")
        self.UsedFunctionMatchListCtrl = wx.ListBox(self, -1, choices=[])
        self.label_4 = wx.StaticText(self, -1, "Currently Used Basic Block Matching Algorithms:")
        self.UsedBasicBlockMatchListCtrl = wx.ListBox(self, -1, choices=[])
        self.label_6 = wx.StaticText(self, -1, "Currently Used Function Diffing Algorithms:")
        self.UsedFunctionDiffListCtrl = wx.ListBox(self, -1, choices=[])

        self.__set_properties()
        self.__do_layout()
        # end wxGlade
        
        self.parent = kwds["parent"]
  
  
        #fill out the list boxes
        self.MatchCheckBox.SetValue( self.parent.loop_until_change)
        self.InsignificantCheckBox.SetValue(self.parent.ignore_insignificant)
  
        i = 0        
        for method in self.parent.module_table.values():
            if method.attributes["Level"] & FUNCTION_LEVEL and method.attributes["Match"]:
                self.FunctionMatchListCtrl.Insert(method.module_name, i)
                i+=1
            
        i = 0        
        for method in self.parent.module_table.values():
            if method.attributes["Level"] & BASIC_BLOCK_LEVEL and method.attributes["Match"]:
                self.BasicBlockMatchListCtrl.Insert(method.module_name, i)
                i+=1

        i = 0        
        for method in self.parent.module_table.values():
            if method.attributes["Level"] & FUNCTION_LEVEL and method.attributes["Diff"]:
                self.FunctionDiffListCtrl.Insert(method.module_name, i)
                i+=1
            

        
        
        
        
        
        try:
            i = 0        
            for method in sorted(self.parent.used_match_function_table.keys()):
                self.UsedFunctionMatchListCtrl.Insert(method[1:], i)
                i+=1
        except:
            pass
    
    
        try:
            i = 0        
            for method in sorted(self.parent.used_match_basic_block_table.keys()):
                self.UsedBasicBlockMatchListCtrl.Insert(method[1:], i)
                i+=1
        except:
            pass
    
        try:
            i = 0        
            for method in sorted(self.parent.used_diff_function_table.keys()):
                self.UsedFunctionDiffListCtrl.Insert(method[1:], i)
                i+=1
        except:
            pass

                    
       
                
                
        #setup our event handlers
        self.Bind(wx.EVT_LISTBOX_DCLICK, self.on_function_match_dbl_clk,                self.FunctionMatchListCtrl)
        self.Bind(wx.EVT_LISTBOX_DCLICK, self.on_basic_block_match_dbl_clk,             self.BasicBlockMatchListCtrl)
        self.Bind(wx.EVT_LISTBOX_DCLICK, self.on_function_diff_dbl_clk,                 self.FunctionDiffListCtrl)
       
       
        self.Bind(wx.EVT_LISTBOX_DCLICK, self.on_function_used_match_dbl_clk,                self.UsedFunctionMatchListCtrl)
        self.Bind(wx.EVT_LISTBOX_DCLICK, self.on_basic_block_used_match_dbl_clk,             self.UsedBasicBlockMatchListCtrl)
        self.Bind(wx.EVT_LISTBOX_DCLICK, self.on_function_used_diff_dbl_clk,                 self.UsedFunctionDiffListCtrl)

        self.Bind(wx.EVT_BUTTON,         self.on_done,                          self.DoneButton)
        self.Bind(wx.EVT_BUTTON,         self.on_cancel,                        self.CancelButton)
        self.Bind(wx.EVT_BUTTON,         self.on_insignificant_config,          self.DefineButton)
        self.Bind(wx.EVT_BUTTON,         self.on_export,                        self.ExportButton)
        self.Bind(wx.EVT_BUTTON,         self.on_import,                        self.ImportButton)       



    def __set_properties(self):
        # begin wxGlade: DiffConfigureDlg.__set_properties
        self.SetTitle("Configure PAIMEIDiff")
        self.label_1.SetBackgroundColour(wx.Colour(236, 233, 216))
        self.label_3.SetBackgroundColour(wx.Colour(236, 233, 216))
        self.label_5.SetBackgroundColour(wx.Colour(236, 233, 216))
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: DiffConfigureDlg.__do_layout
        sizer_1 = wx.BoxSizer(wx.VERTICAL)
        sizer_2 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_3 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_5 = wx.BoxSizer(wx.VERTICAL)
        sizer_6 = wx.StaticBoxSizer(self.sizer_6_staticbox, wx.HORIZONTAL)
        sizer_7 = wx.BoxSizer(wx.VERTICAL)
        sizer_8 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_4 = wx.BoxSizer(wx.VERTICAL)
        sizer_4.Add(self.label_1, 0, wx.ADJUST_MINSIZE, 0)
        sizer_4.Add(self.FunctionMatchListCtrl, 2, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
        sizer_4.Add(self.label_3, 0, wx.ADJUST_MINSIZE, 0)
        sizer_4.Add(self.BasicBlockMatchListCtrl, 2, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
        sizer_4.Add(self.label_5, 0, wx.ADJUST_MINSIZE, 0)
        sizer_4.Add(self.FunctionDiffListCtrl, 2, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
        sizer_3.Add(sizer_4, 1, wx.EXPAND, 0)
        sizer_7.Add(self.ImportButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_7.Add(self.ExportButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_7.Add(self.InsignificantCheckBox, 0, wx.ADJUST_MINSIZE, 0)
        sizer_7.Add(self.MatchCheckBox, 0, wx.ADJUST_MINSIZE, 0)
        sizer_7.Add(self.DefineButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_8.Add(self.DoneButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_8.Add(self.CancelButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_7.Add(sizer_8, 1, wx.EXPAND, 0)
        sizer_6.Add(sizer_7, 1, wx.EXPAND, 0)
        sizer_3.Add(sizer_6, 1, wx.EXPAND, 0)
        sizer_5.Add(self.label_2, 0, wx.ADJUST_MINSIZE, 0)
        sizer_5.Add(self.UsedFunctionMatchListCtrl, 2, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
        sizer_5.Add(self.label_4, 0, wx.ADJUST_MINSIZE, 0)
        sizer_5.Add(self.UsedBasicBlockMatchListCtrl, 2, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
        sizer_5.Add(self.label_6, 0, wx.ADJUST_MINSIZE, 0)
        sizer_5.Add(self.UsedFunctionDiffListCtrl, 2, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
        sizer_3.Add(sizer_5, 1, wx.EXPAND, 0)
        sizer_2.Add(sizer_3, 1, wx.EXPAND, 0)
        sizer_1.Add(sizer_2, 2, wx.ALL|wx.EXPAND, 0)
        self.SetAutoLayout(True)
        self.SetSizer(sizer_1)
        sizer_1.Fit(self)
        sizer_1.SetSizeHints(self)
        self.Layout()
        # end wxGlade



    def on_function_match_dbl_clk           (self, evt):   
        selected = self.FunctionMatchListCtrl.GetStringSelection()
        self.UsedFunctionMatchListCtrl.Insert(selected,self.UsedFunctionMatchListCtrl.GetCount())

    def on_basic_block_match_dbl_clk        (self, evt):
        selected = self.BasicBlockMatchListCtrl.GetStringSelection()
        self.UsedBasicBlockMatchListCtrl.Insert(selected,self.UsedBasicBlockMatchListCtrl.GetCount())
    
    def on_function_diff_dbl_clk            (self, evt):
        selected = self.FunctionDiffListCtrl.GetStringSelection()
        self.UsedFunctionDiffListCtrl.Insert(selected,self.UsedFunctionDiffListCtrl.GetCount())
    
    

    
    def on_function_used_match_dbl_clk      (self, evt):
        self.UsedFunctionMatchListCtrl.Delete( self.UsedFunctionMatchListCtrl.GetSelection() )
    
    def on_basic_block_used_match_dbl_clk   (self, evt):
        self.UsedBasicBlockMatchListCtrl.Delete( self.UsedBasicBlockMatchListCtrl.GetSelection() )

    
    def on_function_used_diff_dbl_clk       (self, evt):
        self.UsedFunctionDiffListCtrl.Delete( self.UsedFunctionDiffListCtrl.GetSelection() )

        

    ####################################################################################################################
    def on_done(self, event):
        
        
        if self.UsedFunctionMatchListCtrl.GetCount() == 0 and self.UsedBasicBlockMatchListCtrl.GetCount():
            self.parent.err("You need to select a method to be used in the matching phase.")
            return
        
        if self.UsedFunctionDiffListCtrl.GetCount() == 0 and self.UsedBasicBlockDiffListCtrl.GetCount():
            self.parent.err("You need to select a method to be used for in the diffing phase.")
            return
        
   
        i = 0
        num = self.UsedFunctionMatchListCtrl.GetCount()
        for i in xrange(num):
            try:
                self.parent.used_match_function_table[ alpha[i] + self.UsedFunctionMatchListCtrl.GetString(i) ] = self.parent.match_function_table[ self.UsedFunctionMatchListCtrl.GetString(i) ]
            except:
                self.parent.msg("Failed to find \'%s\' handler for function matching table" % self.UsedFunctionMatchListCtrl.GetString(i))
        
        i = 0
        num = self.UsedBasicBlockMatchListCtrl.GetCount()
        for i in xrange(num):
            try:
                self.parent.used_match_basic_block_table[ alpha[i] + self.UsedBasicBlockMatchListCtrl.GetString(i) ] = self.parent.match_basic_block_table[ self.UsedBasicBlockMatchListCtrl.GetString(i) ]
            except:
                self.parent.msg("Failed to find \'%s\' handler for basic block matching table" % self.UsedBasicBlockMatchListCtrl.GetString(i))
        
        
        i = 0
        num = self.UsedFunctionDiffListCtrl.GetCount()
        for i in xrange(num):
            try:
                self.parent.used_diff_function_table[ alpha[i] + self.UsedFunctionDiffListCtrl.GetString(i) ] = self.parent.diff_function_table[ self.UsedFunctionDiffListCtrl.GetString(i) ]
            except:
                self.parent.msg("Failed to find \'%s\' handler for function diff table" % self.UsedFunctionDiffListCtrl.GetString(i))
        
        
      
    
        self.parent.ignore_insignificant = self.InsignificantCheckBox.GetValue()
        self.parent.loop_until_change = self.MatchCheckBox.GetValue()
        self.Destroy()
        
    ####################################################################################################################
    def on_cancel(self, event):
        self.Destroy()
    
    
    ####################################################################################################################
    def on_insignificant_config(self, event):
        dlg = InsignificantConfigDlg.InsignificantConfigDlg(parent=self)
        dlg.ShowModal()    

    ####################################################################################################################
    def on_export(self, event):
        dlg = wx.FileDialog(                                    \
            self,                                               \
            message     = "Select where to save file",          \
            defaultDir  = os.getcwd(),                          \
            defaultFile = "",                                   \
            wildcard    = "*.dcfg",                             \
            style       = wx.SAVE | wx.CHANGE_DIR  \
        )
        if dlg.ShowModal() != wx.ID_OK:
            return
        path = dlg.GetPath()
        dcfg_file = open(path,"w")
        i = 0
        num = self.UsedFunctionMatchListCtrl.GetCount()
        
        for i in xrange(num):
            dcfg_file.write("function_match_method=%s\n" % self.UsedFunctionMatchListCtrl.GetString(i))
        
        i = 0
        num = self.UsedBasicBlockMatchListCtrl.GetCount()
        for i in xrange(num):
            dcfg_file.write("bb_match_method=%s\n" % self.UsedBasicBlockMatchListCtrl.GetString(i))
                
        i = 0
        num = self.UsedFunctionDiffListCtrl.GetCount()
        for i in xrange(num):
            dcfg_file.write("function_diff_method=%s\n" % self.UsedFunctionDiffListCtrl.GetString(i))
        
   
                
            
        val = self.MatchCheckBox.GetValue()
        dcfg_file.write("NoChange=%d\n" % val)
        val = self.InsignificantCheckBox.GetValue()
        dcfg_file.write("IgnoreInsig=%d\n" % val)
        dcfg_file.write("InsigFunc=%d:%d:%d:%d\n" % self.parent.insignificant_function)
        dcfg_file.write("InsigBB=%d\n" % self.parent.insignificant_bb)
        dcfg_file.close()		
        
    ####################################################################################################################
    def on_import(self, event):
        dlg = wx.FileDialog(                                    \
            self,                                               \
            message     = "Select DCFG file",                   \
            defaultDir  = os.getcwd(),                          \
            defaultFile = "",                                   \
            wildcard    = "*.dcfg",                             \
            style       = wx.OPEN | wx.CHANGE_DIR               \
        )
        if dlg.ShowModal() != wx.ID_OK:
            return
        path = dlg.GetPath()
        dcfg_file = open(path, "r")
        for line in dcfg_file:
            line = line.upper().strip().replace(" ","")
            if line.find("FUNCTION_MATCH_METHOD") != -1:
                p = re.compile("FUNCTION_MATCH_METHOD=(\w+)$")
                m = p.match(line)
                if not m:
                    self.parent.err("%s is not a valid method" % line)
                else:
                    for n in self.parent.match_function_table.keys():
                        if n.upper() == m.group(1):
                            self.UsedFunctionMatchListCtrl.Insert( n, self.UsedFunctionMatchListCtrl.GetCount())
            elif line.find("BB_MATCH_METHOD") != -1:
                p = re.compile("BB_MATCH_METHOD=(\w+)$")
                m = p.match(line)
                if not m:
                    self.parent.err("%s is not a valid method" % line)
                else:
                    for n in self.parent.match_basic_block_table.keys():
                        if n.upper() == m.group(1):
                            self.UsedBasicBlockMatchListCtrl.Insert(n, self.UsedBasicBlockMatchListCtrl.GetCount())
            elif line.find("FUNCTION_DIFF_METHOD") != -1:
                p = re.compile("FUNCTION_DIFF_METHOD=(\w+)$")
                m = p.match(line)
                if not m:
                    self.parent.err("%s is not a valid method" % line)
                else:
                    for n in self.parent.diff_function_table.keys():
                        if n.upper() == m.group(1):
                            self.UsedFunctionDiffListCtrl.Insert( n, self.UsedFunctionDiffListCtrl.GetCount())
            elif line.find("NOCHANGE") != -1:
                p = re.compile("NOCHANGE=(\d)$")
                m = p.match(line)
                if not m:
                    self.parent.err("%s is not a valid value" % line)
                else:
                    try:
                        val = int(m.group(1))
                        self.MatchCheckBox.SetValue(val)
                    except:
                        self.parent.err("Could not convert %s to int" % m.group(1))
            elif line.find("IGNOREINSIG") != -1:
                p = re.compile("IGNOREINSIG=(\d)$")
                m = p.match(line)
                if not m:
                    self.parent.err("%s is not a valid value" % line)
                else:
                    try:
                        val = int(m.group(1))
                        self.InsignificantCheckBox.SetValue(val)
                    except:
                        self.parent.err("Could not convert %s to int" % m.group(1))
            elif line.find("INSIGFUNC") != -1:
                p = re.compile("INSIGFUNC=(\d+):(\d+):(\d+):(\d+)$")
                m = p.match(line)
                if not m:
                    self.parent.err("%s is not a valid value" % line)
                else:
                    try:
                        func_i = (int(m.group(1)),int(m.group(2)),int(m.group(3)),int(m.group(4)))
                    except:
                        self.parent.err("Could not turn %s into insiginifcant function definition" % line)
                        func_i = (1,1,1,1)
                    self.parent.msg("Set (%d:%d:%d:%d) as insignificant functiond definition" % func_i)    
                    self.parent.insignificant_function = func_i
            elif line.find("INSIGBB") != -1:
                p = re.compile("INSIGBB=(\d+)$")
                m = p.match(line)
                if not m:
                    self.parent.err("%s is not a valid value" % line)
                else:
                    try:
                        bb_i = int(m.group(1) )
                    except:
                        self.parent.err("Could not turn %s into insiginifcant function definition" % line)
                        bb_i = 2
                    if bb_i < 0:
                        bb_i = 2
                    self.parent.msg("Set %d as insignificant bb definition" % bb_i)    
                    self.parent.insignificant_bb = bb_i
            
