/*
 * Decompiled with CFR 0.152.
 */
package com.luciad.imageio.webp;

import com.luciad.imageio.webp.WebPImageWriterSpi;
import com.luciad.imageio.webp.WebPReader;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class WebPImageReaderSpi
extends ImageReaderSpi {
    private static final byte[] RIFF = new byte[]{82, 73, 70, 70};
    private static final byte[] WEBP = new byte[]{87, 69, 66, 80};
    private static final byte[] VP8_ = new byte[]{86, 80, 56, 32};
    private static final byte[] VP8X = new byte[]{86, 80, 56, 88};

    public WebPImageReaderSpi() {
        super("Luciad", "1.0", new String[]{"WebP", "webp"}, new String[]{"webp"}, new String[]{"image/webp"}, WebPReader.class.getName(), new Class[]{ImageInputStream.class}, new String[]{WebPImageWriterSpi.class.getName()}, false, null, null, null, null, false, null, null, null, null);
    }

    @Override
    public ImageReader createReaderInstance(Object extension) throws IOException {
        return new WebPReader(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canDecodeInput(Object source) throws IOException {
        if (!(source instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream stream = (ImageInputStream)source;
        byte[] b = new byte[4];
        ByteOrder oldByteOrder = stream.getByteOrder();
        stream.mark();
        stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        try {
            stream.readFully(b);
            if (!Arrays.equals(b, RIFF)) {
                boolean bl = false;
                return bl;
            }
            long chunkLength = stream.readUnsignedInt();
            long streamLength = stream.length();
            if (streamLength != -1L && streamLength != chunkLength + 8L) {
                boolean bl = false;
                return bl;
            }
            stream.readFully(b);
            if (!Arrays.equals(b, WEBP)) {
                boolean bl = false;
                return bl;
            }
            stream.readFully(b);
            if (!Arrays.equals(b, VP8_) && !Arrays.equals(b, VP8X)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            stream.setByteOrder(oldByteOrder);
            stream.reset();
        }
        return true;
    }

    @Override
    public String getDescription(Locale locale) {
        return "WebP Reader";
    }
}

