/*
 * Decompiled with CFR 0.152.
 */
package com.luciad.imageio.webp;

import com.luciad.imageio.webp.VP8StatusCode;
import com.luciad.imageio.webp.WebPReadParam;
import com.luciad.imageio.webp.WebPWriteParam;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Hashtable;
import org.scijava.nativelib.NativeLibraryUtil;

final class WebP {
    private static boolean NATIVE_LIBRARY_LOADED = false;

    static synchronized void loadNativeLibrary() {
        if (!NATIVE_LIBRARY_LOADED) {
            NATIVE_LIBRARY_LOADED = true;
            NativeLibraryUtil.loadNativeLibrary(WebP.class, "webp-imageio");
        }
    }

    private WebP() {
    }

    public static BufferedImage decode(WebPReadParam aReadParam, byte[] aData, int aOffset, int aLength) throws IOException {
        if (aReadParam == null) {
            throw new NullPointerException("Decoder options may not be null");
        }
        if (aData == null) {
            throw new NullPointerException("Input data may not be null");
        }
        if (aOffset + aLength > aData.length) {
            throw new IllegalArgumentException("Offset/length exceeds array size");
        }
        int[] out = new int[4];
        int[] pixels = WebP.decode(aReadParam.fPointer, aData, aOffset, aLength, out, ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN));
        VP8StatusCode status = VP8StatusCode.getStatusCode(out[0]);
        switch (status) {
            case VP8_STATUS_OK: {
                break;
            }
            case VP8_STATUS_OUT_OF_MEMORY: {
                throw new OutOfMemoryError();
            }
            default: {
                throw new IOException("Decode returned code " + (Object)((Object)status));
            }
        }
        int width = out[1];
        int height = out[2];
        boolean alpha = out[3] != 0;
        DirectColorModel colorModel = alpha ? new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216) : new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
        SampleModel sampleModel = ((ColorModel)colorModel).createCompatibleSampleModel(width, height);
        DataBufferInt db = new DataBufferInt(pixels, width * height);
        WritableRaster raster = WritableRaster.createWritableRaster(sampleModel, db, null);
        return new BufferedImage(colorModel, raster, false, new Hashtable());
    }

    private static native int[] decode(long var0, byte[] var2, int var3, int var4, int[] var5, boolean var6);

    public static int[] getInfo(byte[] aData, int aOffset, int aLength) throws IOException {
        int[] out = new int[2];
        int result = WebP.getInfo(aData, aOffset, aLength, out);
        if (result == 0) {
            throw new IOException("Invalid WebP data");
        }
        return out;
    }

    private static native int getInfo(byte[] var0, int var1, int var2, int[] var3);

    public static byte[] encode(WebPWriteParam aWriteParam, RenderedImage aImage) throws IOException {
        if (aWriteParam == null) {
            throw new NullPointerException("Encoder options may not be null");
        }
        if (aImage == null) {
            throw new NullPointerException("Image may not be null");
        }
        boolean encodeAlpha = WebP.hasTranslucency(aImage);
        if (encodeAlpha) {
            byte[] rgbaData = WebP.getRGBA(aImage);
            return WebP.encodeRGBA(aWriteParam.getPointer(), rgbaData, aImage.getWidth(), aImage.getHeight(), aImage.getWidth() * 4);
        }
        byte[] rgbData = WebP.getRGB(aImage);
        return WebP.encodeRGB(aWriteParam.getPointer(), rgbData, aImage.getWidth(), aImage.getHeight(), aImage.getWidth() * 3);
    }

    private static native byte[] encodeRGBA(long var0, byte[] var2, int var3, int var4, int var5);

    private static native byte[] encodeRGB(long var0, byte[] var2, int var3, int var4, int var5);

    private static boolean hasTranslucency(RenderedImage aRi) {
        return aRi.getColorModel().hasAlpha();
    }

    private static int getShift(int aMask) {
        int shift = 0;
        while ((aMask >> shift & 1) == 0) {
            ++shift;
        }
        return shift;
    }

    private static byte[] getRGB(RenderedImage aRi) throws IOException {
        int width = aRi.getWidth();
        int height = aRi.getHeight();
        ColorModel colorModel = aRi.getColorModel();
        if (colorModel instanceof ComponentColorModel) {
            ComponentSampleModel sampleModel = (ComponentSampleModel)aRi.getSampleModel();
            int type = sampleModel.getTransferType();
            if (type == 0) {
                return WebP.extractComponentRGBByte(width, height, sampleModel, (DataBufferByte)aRi.getData().getDataBuffer());
            }
            if (type == 3) {
                return WebP.extractComponentRGBInt(width, height, sampleModel, (DataBufferInt)aRi.getData().getDataBuffer());
            }
            throw new IOException("Incompatible image: " + aRi);
        }
        if (colorModel instanceof DirectColorModel) {
            SinglePixelPackedSampleModel sampleModel = (SinglePixelPackedSampleModel)aRi.getSampleModel();
            int type = sampleModel.getTransferType();
            if (type == 3) {
                return WebP.extractDirectRGBInt(width, height, (DirectColorModel)colorModel, sampleModel, (DataBufferInt)aRi.getData().getDataBuffer());
            }
            throw new IOException("Incompatible image: " + aRi);
        }
        return WebP.extractGenericRGB(aRi, width, height, colorModel);
    }

    private static byte[] extractGenericRGB(RenderedImage aRi, int aWidth, int aHeight, ColorModel aColorModel) {
        Object dataElements = null;
        byte[] rgbData = new byte[aWidth * aHeight * 3];
        int b = 0;
        for (int y = 0; y < aHeight; ++y) {
            int x = 0;
            while (x < aWidth) {
                dataElements = aRi.getData().getDataElements(x, y, dataElements);
                rgbData[b] = (byte)aColorModel.getRed(dataElements);
                rgbData[b + 1] = (byte)aColorModel.getGreen(dataElements);
                rgbData[b + 2] = (byte)aColorModel.getBlue(dataElements);
                ++x;
                b += 3;
            }
        }
        return rgbData;
    }

    private static byte[] extractDirectRGBInt(int aWidth, int aHeight, DirectColorModel aColorModel, SinglePixelPackedSampleModel aSampleModel, DataBufferInt aDataBuffer) {
        byte[] out = new byte[aWidth * aHeight * 3];
        int rMask = aColorModel.getRedMask();
        int gMask = aColorModel.getGreenMask();
        int bMask = aColorModel.getBlueMask();
        int rShift = WebP.getShift(rMask);
        int gShift = WebP.getShift(gMask);
        int bShift = WebP.getShift(bMask);
        int[] bank = aDataBuffer.getBankData()[0];
        int scanlineStride = aSampleModel.getScanlineStride();
        int scanIx = 0;
        int b = 0;
        for (int y = 0; y < aHeight; ++y) {
            int pixIx = scanIx;
            int x = 0;
            while (x < aWidth) {
                int pixel = bank[pixIx++];
                out[b] = (byte)((pixel & rMask) >>> rShift);
                out[b + 1] = (byte)((pixel & gMask) >>> gShift);
                out[b + 2] = (byte)((pixel & bMask) >>> bShift);
                ++x;
                b += 3;
            }
            scanIx += scanlineStride;
        }
        return out;
    }

    private static byte[] extractComponentRGBInt(int aWidth, int aHeight, ComponentSampleModel aSampleModel, DataBufferInt aDataBuffer) {
        byte[] out = new byte[aWidth * aHeight * 3];
        int[] bankIndices = aSampleModel.getBankIndices();
        int[] rBank = aDataBuffer.getBankData()[bankIndices[0]];
        int[] gBank = aDataBuffer.getBankData()[bankIndices[1]];
        int[] bBank = aDataBuffer.getBankData()[bankIndices[2]];
        int[] bankOffsets = aSampleModel.getBandOffsets();
        int rScanIx = bankOffsets[0];
        int gScanIx = bankOffsets[1];
        int bScanIx = bankOffsets[2];
        int pixelStride = aSampleModel.getPixelStride();
        int scanlineStride = aSampleModel.getScanlineStride();
        int b = 0;
        for (int y = 0; y < aHeight; ++y) {
            int rPixIx = rScanIx;
            int gPixIx = gScanIx;
            int bPixIx = bScanIx;
            int x = 0;
            while (x < aWidth) {
                out[b] = (byte)rBank[rPixIx];
                rPixIx += pixelStride;
                out[b + 1] = (byte)gBank[gPixIx];
                gPixIx += pixelStride;
                out[b + 2] = (byte)bBank[bPixIx];
                bPixIx += pixelStride;
                ++x;
                b += 3;
            }
            rScanIx += scanlineStride;
            gScanIx += scanlineStride;
            bScanIx += scanlineStride;
        }
        return out;
    }

    private static byte[] extractComponentRGBByte(int aWidth, int aHeight, ComponentSampleModel aSampleModel, DataBufferByte aDataBuffer) {
        byte[] out = new byte[aWidth * aHeight * 3];
        int[] bankIndices = aSampleModel.getBankIndices();
        byte[] rBank = aDataBuffer.getBankData()[bankIndices[0]];
        byte[] gBank = aDataBuffer.getBankData()[bankIndices[1]];
        byte[] bBank = aDataBuffer.getBankData()[bankIndices[2]];
        int[] bankOffsets = aSampleModel.getBandOffsets();
        int rScanIx = bankOffsets[0];
        int gScanIx = bankOffsets[1];
        int bScanIx = bankOffsets[2];
        int pixelStride = aSampleModel.getPixelStride();
        int scanlineStride = aSampleModel.getScanlineStride();
        int b = 0;
        for (int y = 0; y < aHeight; ++y) {
            int rPixIx = rScanIx;
            int gPixIx = gScanIx;
            int bPixIx = bScanIx;
            int x = 0;
            while (x < aWidth) {
                out[b] = rBank[rPixIx];
                rPixIx += pixelStride;
                out[b + 1] = gBank[gPixIx];
                gPixIx += pixelStride;
                out[b + 2] = bBank[bPixIx];
                bPixIx += pixelStride;
                ++x;
                b += 3;
            }
            rScanIx += scanlineStride;
            gScanIx += scanlineStride;
            bScanIx += scanlineStride;
        }
        return out;
    }

    private static byte[] getRGBA(RenderedImage aRi) throws IOException {
        int width = aRi.getWidth();
        int height = aRi.getHeight();
        ColorModel colorModel = aRi.getColorModel();
        if (colorModel instanceof ComponentColorModel) {
            ComponentSampleModel sampleModel = (ComponentSampleModel)aRi.getSampleModel();
            int type = sampleModel.getTransferType();
            if (type == 0) {
                return WebP.extractComponentRGBAByte(width, height, sampleModel, (DataBufferByte)aRi.getData().getDataBuffer());
            }
            if (type == 3) {
                return WebP.extractComponentRGBAInt(width, height, sampleModel, (DataBufferInt)aRi.getData().getDataBuffer());
            }
            throw new IOException("Incompatible image: " + aRi);
        }
        if (colorModel instanceof DirectColorModel) {
            SinglePixelPackedSampleModel sampleModel = (SinglePixelPackedSampleModel)aRi.getSampleModel();
            int type = sampleModel.getTransferType();
            if (type == 3) {
                return WebP.extractDirectRGBAInt(width, height, (DirectColorModel)colorModel, sampleModel, (DataBufferInt)aRi.getData().getDataBuffer());
            }
            throw new IOException("Incompatible image: " + aRi);
        }
        return WebP.extractGenericRGBA(aRi, width, height, colorModel);
    }

    private static byte[] extractGenericRGBA(RenderedImage aRi, int aWidth, int aHeight, ColorModel aColorModel) {
        Object dataElements = null;
        byte[] rgbData = new byte[aWidth * aHeight * 4];
        int b = 0;
        for (int y = 0; y < aHeight; ++y) {
            int x = 0;
            while (x < aWidth) {
                dataElements = aRi.getData().getDataElements(x, y, dataElements);
                rgbData[b] = (byte)aColorModel.getRed(dataElements);
                rgbData[b + 1] = (byte)aColorModel.getGreen(dataElements);
                rgbData[b + 2] = (byte)aColorModel.getBlue(dataElements);
                rgbData[b + 3] = (byte)aColorModel.getAlpha(dataElements);
                ++x;
                b += 4;
            }
        }
        return rgbData;
    }

    private static byte[] extractDirectRGBAInt(int aWidth, int aHeight, DirectColorModel aColorModel, SinglePixelPackedSampleModel aSampleModel, DataBufferInt aDataBuffer) {
        byte[] out = new byte[aWidth * aHeight * 4];
        int rMask = aColorModel.getRedMask();
        int gMask = aColorModel.getGreenMask();
        int bMask = aColorModel.getBlueMask();
        int aMask = aColorModel.getAlphaMask();
        int rShift = WebP.getShift(rMask);
        int gShift = WebP.getShift(gMask);
        int bShift = WebP.getShift(bMask);
        int aShift = WebP.getShift(aMask);
        int[] bank = aDataBuffer.getBankData()[0];
        int scanlineStride = aSampleModel.getScanlineStride();
        int scanIx = 0;
        int b = 0;
        for (int y = 0; y < aHeight; ++y) {
            int pixIx = scanIx;
            int x = 0;
            while (x < aWidth) {
                int pixel = bank[pixIx++];
                out[b] = (byte)((pixel & rMask) >>> rShift);
                out[b + 1] = (byte)((pixel & gMask) >>> gShift);
                out[b + 2] = (byte)((pixel & bMask) >>> bShift);
                out[b + 3] = (byte)((pixel & aMask) >>> aShift);
                ++x;
                b += 4;
            }
            scanIx += scanlineStride;
        }
        return out;
    }

    private static byte[] extractComponentRGBAInt(int aWidth, int aHeight, ComponentSampleModel aSampleModel, DataBufferInt aDataBuffer) {
        byte[] out = new byte[aWidth * aHeight * 4];
        int[] bankIndices = aSampleModel.getBankIndices();
        int[] rBank = aDataBuffer.getBankData()[bankIndices[0]];
        int[] gBank = aDataBuffer.getBankData()[bankIndices[1]];
        int[] bBank = aDataBuffer.getBankData()[bankIndices[2]];
        int[] aBank = aDataBuffer.getBankData()[bankIndices[3]];
        int[] bankOffsets = aSampleModel.getBandOffsets();
        int rScanIx = bankOffsets[0];
        int gScanIx = bankOffsets[1];
        int bScanIx = bankOffsets[2];
        int aScanIx = bankOffsets[3];
        int pixelStride = aSampleModel.getPixelStride();
        int scanlineStride = aSampleModel.getScanlineStride();
        int b = 0;
        for (int y = 0; y < aHeight; ++y) {
            int rPixIx = rScanIx;
            int gPixIx = gScanIx;
            int bPixIx = bScanIx;
            int aPixIx = aScanIx;
            int x = 0;
            while (x < aWidth) {
                out[b] = (byte)rBank[rPixIx];
                rPixIx += pixelStride;
                out[b + 1] = (byte)gBank[gPixIx];
                gPixIx += pixelStride;
                out[b + 2] = (byte)bBank[bPixIx];
                bPixIx += pixelStride;
                out[b + 3] = (byte)aBank[aPixIx];
                aPixIx += pixelStride;
                ++x;
                b += 4;
            }
            rScanIx += scanlineStride;
            gScanIx += scanlineStride;
            bScanIx += scanlineStride;
            aScanIx += scanlineStride;
        }
        return out;
    }

    private static byte[] extractComponentRGBAByte(int aWidth, int aHeight, ComponentSampleModel aSampleModel, DataBufferByte aDataBuffer) {
        byte[] out = new byte[aWidth * aHeight * 4];
        int[] bankIndices = aSampleModel.getBankIndices();
        byte[] rBank = aDataBuffer.getBankData()[bankIndices[0]];
        byte[] gBank = aDataBuffer.getBankData()[bankIndices[1]];
        byte[] bBank = aDataBuffer.getBankData()[bankIndices[2]];
        byte[] aBank = aDataBuffer.getBankData()[bankIndices[3]];
        int[] bankOffsets = aSampleModel.getBandOffsets();
        int rScanIx = bankOffsets[0];
        int gScanIx = bankOffsets[1];
        int bScanIx = bankOffsets[2];
        int aScanIx = bankOffsets[3];
        int pixelStride = aSampleModel.getPixelStride();
        int scanlineStride = aSampleModel.getScanlineStride();
        int b = 0;
        for (int y = 0; y < aHeight; ++y) {
            int rPixIx = rScanIx;
            int gPixIx = gScanIx;
            int bPixIx = bScanIx;
            int aPixIx = aScanIx;
            int x = 0;
            while (x < aWidth) {
                out[b] = rBank[rPixIx];
                rPixIx += pixelStride;
                out[b + 1] = gBank[gPixIx];
                gPixIx += pixelStride;
                out[b + 2] = bBank[bPixIx];
                bPixIx += pixelStride;
                out[b + 3] = aBank[aPixIx];
                aPixIx += pixelStride;
                ++x;
                b += 4;
            }
            rScanIx += scanlineStride;
            gScanIx += scanlineStride;
            bScanIx += scanlineStride;
            aScanIx += scanlineStride;
        }
        return out;
    }

    static {
        WebP.loadNativeLibrary();
    }
}

