/*
 * Decompiled with CFR 0.152.
 */
package com.luciad.imageio.webp;

import com.luciad.imageio.webp.WebP;
import java.util.Locale;
import javax.imageio.ImageWriteParam;

public class WebPWriteParam
extends ImageWriteParam {
    long fPointer = WebPWriteParam.createConfig();
    private final int defaultLossless;

    public WebPWriteParam(Locale aLocale) {
        super(aLocale);
        if (this.fPointer == 0L) {
            throw new OutOfMemoryError();
        }
        this.defaultLossless = WebPWriteParam.getLossless(this.fPointer);
        this.canWriteCompressed = true;
        this.compressionTypes = new String[]{"Lossy", "Lossless"};
        this.compressionType = this.compressionTypes[this.defaultLossless];
        this.compressionQuality = WebPWriteParam.getQuality(this.fPointer) / 100.0f;
        this.compressionMode = 2;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        WebPWriteParam.deleteConfig(this.fPointer);
        this.fPointer = 0L;
    }

    private static native long createConfig();

    private static native void deleteConfig(long var0);

    long getPointer() {
        return this.fPointer;
    }

    @Override
    public float getCompressionQuality() {
        return super.getCompressionQuality();
    }

    @Override
    public void setCompressionQuality(float quality) {
        super.setCompressionQuality(quality);
        WebPWriteParam.setQuality(this.fPointer, quality * 100.0f);
    }

    @Override
    public void setCompressionType(String compressionType) {
        super.setCompressionType(compressionType);
        for (int i = 0; i < this.compressionTypes.length; ++i) {
            if (!this.compressionTypes[i].equals(compressionType)) continue;
            WebPWriteParam.setLossless(this.fPointer, i);
            break;
        }
    }

    @Override
    public void unsetCompression() {
        super.unsetCompression();
        WebPWriteParam.setLossless(this.fPointer, this.defaultLossless);
    }

    public int getTargetSize() {
        return WebPWriteParam.getTargetSize(this.fPointer);
    }

    public void setTargetSize(int aTargetSize) {
        WebPWriteParam.setTargetSize(this.fPointer, aTargetSize);
    }

    public float getTargetPSNR() {
        return WebPWriteParam.getTargetPSNR(this.fPointer);
    }

    public void setTargetPSNR(float aTargetPSNR) {
        WebPWriteParam.setTargetPSNR(this.fPointer, aTargetPSNR);
    }

    public int getMethod() {
        return WebPWriteParam.getMethod(this.fPointer);
    }

    public void setMethod(int aMethod) {
        WebPWriteParam.setMethod(this.fPointer, aMethod);
    }

    public int getSegments() {
        return WebPWriteParam.getSegments(this.fPointer);
    }

    public void setSegments(int aSegments) {
        WebPWriteParam.setSegments(this.fPointer, aSegments);
    }

    public int getSnsStrength() {
        return WebPWriteParam.getSnsStrength(this.fPointer);
    }

    public void setSnsStrength(int aSnsStrength) {
        WebPWriteParam.setSnsStrength(this.fPointer, aSnsStrength);
    }

    public int getFilterStrength() {
        return WebPWriteParam.getFilterStrength(this.fPointer);
    }

    public void setFilterStrength(int aFilterStrength) {
        WebPWriteParam.setFilterStrength(this.fPointer, aFilterStrength);
    }

    public int getFilterSharpness() {
        return WebPWriteParam.getFilterSharpness(this.fPointer);
    }

    public void setFilterSharpness(int aFilterSharpness) {
        WebPWriteParam.setFilterSharpness(this.fPointer, aFilterSharpness);
    }

    public int getFilterType() {
        return WebPWriteParam.getFilterType(this.fPointer);
    }

    public void setFilterType(int aFilterType) {
        WebPWriteParam.setFilterType(this.fPointer, aFilterType);
    }

    public boolean isAutoAdjustFilterStrength() {
        return WebPWriteParam.getAutofilter(this.fPointer) != 0;
    }

    public void setAutoAdjustFilterStrength(boolean aAutofilter) {
        WebPWriteParam.setAutofilter(this.fPointer, aAutofilter ? 1 : 0);
    }

    public int getEntropyAnalysisPassCount() {
        return WebPWriteParam.getPass(this.fPointer);
    }

    public void setEntropyAnalysisPassCount(int aPass) {
        WebPWriteParam.setPass(this.fPointer, aPass);
    }

    public boolean isShowCompressed() {
        return WebPWriteParam.getShowCompressed(this.fPointer) != 0;
    }

    public void setShowCompressed(boolean aShowCompressed) {
        WebPWriteParam.setShowCompressed(this.fPointer, aShowCompressed ? 1 : 0);
    }

    public int getPreprocessing() {
        return WebPWriteParam.getPreprocessing(this.fPointer);
    }

    public void setPreprocessing(int aPreprocessing) {
        WebPWriteParam.setPreprocessing(this.fPointer, aPreprocessing);
    }

    public int getPartitions() {
        return WebPWriteParam.getPartitions(this.fPointer);
    }

    public void setPartitions(int aPartitions) {
        WebPWriteParam.setPartitions(this.fPointer, aPartitions);
    }

    public int getPartitionLimit() {
        return WebPWriteParam.getPartitionLimit(this.fPointer);
    }

    public void setPartitionLimit(int aPartitionLimit) {
        WebPWriteParam.setPartitionLimit(this.fPointer, aPartitionLimit);
    }

    public int getAlphaCompression() {
        return WebPWriteParam.getAlphaCompression(this.fPointer);
    }

    public void setAlphaCompression(int aAlphaCompression) {
        WebPWriteParam.setAlphaCompression(this.fPointer, aAlphaCompression);
    }

    public int getAlphaFiltering() {
        return WebPWriteParam.getAlphaFiltering(this.fPointer);
    }

    public void setAlphaFiltering(int aAlphaFiltering) {
        WebPWriteParam.setAlphaFiltering(this.fPointer, aAlphaFiltering);
    }

    public int getAlphaQuality() {
        return WebPWriteParam.getAlphaQuality(this.fPointer);
    }

    public void setAlphaQuality(int aAlphaQuality) {
        WebPWriteParam.setAlphaQuality(this.fPointer, aAlphaQuality);
    }

    public boolean isEmulateJpegSize() {
        return WebPWriteParam.getEmulateJpegSize(this.fPointer) != 0;
    }

    public void setEmulateJpegSize(boolean aEmulateJpegSize) {
        WebPWriteParam.setEmulateJpegSize(this.fPointer, aEmulateJpegSize ? 1 : 0);
    }

    public int getThreadLevel() {
        return WebPWriteParam.getThreadLevel(this.fPointer);
    }

    public void setThreadLevel(int aThreadLevel) {
        WebPWriteParam.setThreadLevel(this.fPointer, aThreadLevel);
    }

    public boolean isReduceMemoryUsage() {
        return WebPWriteParam.getLowMemory(this.fPointer) != 0;
    }

    public void setReduceMemoryUsage(boolean aLowMemory) {
        WebPWriteParam.setLowMemory(this.fPointer, aLowMemory ? 1 : 0);
    }

    private static native float getQuality(long var0);

    private static native void setQuality(long var0, float var2);

    private static native int getTargetSize(long var0);

    private static native void setTargetSize(long var0, int var2);

    private static native float getTargetPSNR(long var0);

    private static native void setTargetPSNR(long var0, float var2);

    private static native int getMethod(long var0);

    private static native void setMethod(long var0, int var2);

    private static native int getSegments(long var0);

    private static native void setSegments(long var0, int var2);

    private static native int getSnsStrength(long var0);

    private static native void setSnsStrength(long var0, int var2);

    private static native int getFilterStrength(long var0);

    private static native void setFilterStrength(long var0, int var2);

    private static native int getFilterSharpness(long var0);

    private static native void setFilterSharpness(long var0, int var2);

    private static native int getFilterType(long var0);

    private static native void setFilterType(long var0, int var2);

    private static native int getAutofilter(long var0);

    private static native void setAutofilter(long var0, int var2);

    private static native int getPass(long var0);

    private static native void setPass(long var0, int var2);

    private static native int getShowCompressed(long var0);

    private static native void setShowCompressed(long var0, int var2);

    private static native int getPreprocessing(long var0);

    private static native void setPreprocessing(long var0, int var2);

    private static native int getPartitions(long var0);

    private static native void setPartitions(long var0, int var2);

    private static native int getPartitionLimit(long var0);

    private static native void setPartitionLimit(long var0, int var2);

    private static native int getAlphaCompression(long var0);

    private static native void setAlphaCompression(long var0, int var2);

    private static native int getAlphaFiltering(long var0);

    private static native void setAlphaFiltering(long var0, int var2);

    private static native int getAlphaQuality(long var0);

    private static native void setAlphaQuality(long var0, int var2);

    private static native int getLossless(long var0);

    private static native void setLossless(long var0, int var2);

    private static native int getEmulateJpegSize(long var0);

    private static native void setEmulateJpegSize(long var0, int var2);

    private static native int getThreadLevel(long var0);

    private static native void setThreadLevel(long var0, int var2);

    private static native int getLowMemory(long var0);

    private static native void setLowMemory(long var0, int var2);

    static {
        WebP.loadNativeLibrary();
    }
}

