/**
 * Read environment variables from file.
 * https://github.com/motdotla/dotenv
 */
// require('dotenv').config();

/**
 * @see https://playwright.dev/docs/test-configuration
 * @type {import('@playwright/test').PlaywrightTestConfig}
 */
const config = {
  use: {
    browserName: 'chromium',
    viewport: { width: 1280, height: 720 },

    /* Maximum time each action such as `click()` can take. Defaults to 0 (no limit). */
    actionTimeout: 0,
    /* Base URL to use in actions like `await page.goto('/')`. */
    baseURL: 'http://127.0.0.1:4173',

    /* Collect trace when retrying the failed test. See https://playwright.dev/docs/trace-viewer */
    trace: 'on-first-retry'
  },
  testDir: './web/tests',
  /* Maximum time one test can run for. */
  timeout: 30 * 1000,
  expect: {
    /**
     * Maximum time expect() should wait for the condition to be met.
     * For example in `await expect(locator).toHaveText();`
     */
    timeout: 5000
  },
  /* Run tests in files in parallel */
  fullyParallel: true,
  /* Fail the build on CI if you accidentally left test.only in the source code. */
  forbidOnly: !!process.env.CI,
  /* Retry on CI only */
  retries: process.env.CI ? 2 : 0,
  /* Opt out of parallel tests on CI. */
  workers: process.env.CI ? 1 : undefined,
  /* Reporter to use. See https://playwright.dev/docs/test-reporters */
  reporter: 'html',

  /* Configure projects for major browsers */
  // projects: [
  // /* Test against desktop viewports. */
  //   {
  //     name: 'chromium',
  //     use: {
  //       browserName: 'chromium',
  //       viewport: { width: 1280, height: 720 }
  //     }
  //   },

  //   {
  //     name: 'firefox',
  //     use: {
  //       browserName: 'firefox',
  //       viewport: { width: 1280, height: 720 }
  //     }
  //   },

  //   {
  //     name: 'webkit',
  //     use: {
  //       browserName: 'webkit',
  //       viewport: { width: 1280, height: 720 }
  //     }
  //   },

  //   /* Test against mobile viewports. */
  //   {
  //     name: 'Mobile Chrome',
  //     use: {
  //       ...devices['Pixel 5']
  //     }
  //   },
  //   {
  //     name: 'Mobile Safari',
  //     use: {
  //       ...devices['iPhone 12']
  //     }
  //   },

  //   /* Test against branded browsers. */
  //   {
  //     name: 'Microsoft Edge',
  //     use: {
  //       channel: 'msedge'
  //     }
  //   },
  //   {
  //     name: 'Google Chrome',
  //     use: {
  //       channel: 'chrome'
  //     }
  //   }
  // ],

  /* Folder for test artifacts such as screenshots, videos, traces, etc. */
  // outputDir: 'test-results/',

  /* Run your local dev server before starting the tests */
  webServer: {
    command: 'npm run start',
    port: 4173
  }
}

export default config
