export const LogoInverted = () => (
  <svg
    width="32"
    height="32"
    viewBox="0 0 32 32"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      fill-rule="evenodd"
      clip-rule="evenodd"
      d="M0 0H32V10.2836C32 5.70869 28.2913 2 23.7164 2C23.3208 2 23 2.32075 23 2.71642V25.7836C23 26.1792 23.3208 26.5 23.7164 26.5C28.2913 26.5 32 22.7913 32 18.2164V32H0V0ZM10 19C10 19.5523 9.55055 20.0058 9.0016 19.9452C4.50088 19.4485 1 15.6331 1 11C1 6.3669 4.50088 2.55147 9.0016 2.05475C9.55055 1.99417 10 2.44772 10 3V19ZM10 23C10 22.4477 9.55228 22 9 22L2 22C1.44772 22 0.994168 22.4494 1.05475 22.9984C1.51529 27.1713 4.8287 30.4847 9.0016 30.9452C9.55055 31.0058 10 30.5523 10 30V23ZM12.7164 2C12.3208 2 12 2.32075 12 2.71642V18.2164C12 22.7913 15.7087 26.5 20.2836 26.5C20.6792 26.5 21 26.1793 21 25.7836V10.2836C21 5.70869 17.2913 2 12.7164 2Z"
      className="fill-current text-svg dark:text-darkSVG "
    />
  </svg>
)

// export const Logo = () => (
//   <svg
//     width="31"
//     height="29"
//     viewBox="0 0 62 58"
//     xmlns="http://www.w3.org/2000/svg"
//   >
//     <path
//       d="M18 34C18 35.1046 17.1011 36.0117 16.0032 35.8905C7.00176 34.8971 0 27.2662 0 18C0 8.73379 7.00176 1.10293 16.0032 0.109504C17.1011 -0.011665 18 0.895431 18 2V34Z"
//       className="fill-current text-primary dark:text-darkPrimary "
//     />
//     <path
//       d="M16 40C17.1046 40 18 40.8954 18 42V56C18 57.1046 17.1011 58.0117 16.0032 57.8905C7.65739 56.9694 1.03058 50.3426 0.109504 41.9968C-0.011665 40.8989 0.895431 40 2 40L16 40Z"
//       className="fill-current text-primary dark:text-darkPrimary "
//     />
//     <path
//       d="M44 1.43283C44 0.6415 44.6415 0 45.4328 0V0C54.5826 0 62 7.41737 62 16.5672V32.4328C62 41.5826 54.5826 49 45.4328 49V49C44.6415 49 44 48.3585 44 47.5672V1.43283Z"
//       className="fill-current text-primary dark:text-darkPrimary"
//     />
//     <path
//       d="M22 1.43283C22 0.6415 22.6415 0 23.4328 0V0C32.5826 0 40 7.41737 40 16.5672V47.5672C40 48.3585 39.3585 49 38.5672 49V49C29.4174 49 22 41.5826 22 32.4328V1.43283Z"
//       className="fill-current text-primary dark:text-darkPrimary"
//     />
//   </svg>
// )

export const ArrowRight = () => (
  <svg
    className="inline ml-2 "
    width="11"
    height="8"
    viewBox="0 0 11 8"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M1 3.99994H9.5M9.5 3.99994L6.5 0.999939M9.5 3.99994L6.5 7.00006"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
      className="stroke-current text-tertiary dark:text-darkTertiary"
    />
  </svg>
)

export const ArrowExternal = () => (
  <svg
    className="inline ml-1 transform -rotate-45"
    width="11"
    height="8"
    viewBox="0 0 11 8"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M1 3.99994H9.5M9.5 3.99994L6.5 0.999939M9.5 3.99994L6.5 7.00006"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
      className="stroke-current text-tertiary dark:text-darkTertiary"
    />
  </svg>
)

export const ArrowDown = () => (
  <svg
    className="inline ml-2"
    width="8"
    height="10"
    viewBox="0 0 8 10"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M4.00012 0.75V9.25M4.00012 9.25L7.00012 6.25M4.00012 9.25L1 6.25"
      stroke="#7382AB"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
      className="fill-current text-tertiary dark:text-darkTertiary"
    />
  </svg>
)

export const Chevron = () => (
  <svg
    width="12"
    height="12"
    viewBox="0 0 12 12"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M3.75 1.5L8.25 6L3.75 10.5002"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
      className="stroke-current text-tertiary dark:text-darkTertiary"
    />
  </svg>
)

export const Arena = () => (
  <a
    className="self-center text-tertiary dark:text-darkTertiary opacity-80 group "
    href="https://www.are.na/gavin-nelson/notes-on-taste"
    target="_blank"
    rel="noopener noreferrer"
    aria-label="are.na"
  >
    <svg
      width="21"
      height="13"
      viewBox="0 0 21 13"
      fill="none"
      mlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M20.8036 9.00069L17.9781 6.78023C17.8052 6.6447 17.8052 6.42217 17.9781 6.28623L20.8036 4.06617C20.9769 3.93051 21.0492 3.70107 20.9645 3.55659C20.8796 3.4128 20.6427 3.36144 20.4386 3.44302L17.079 4.78108C16.8747 4.8628 16.6822 4.75099 16.6516 4.53293L16.1465 0.945948C16.1156 0.728293 15.9519 0.549805 15.7821 0.549805C15.6129 0.549805 15.4491 0.728293 15.4187 0.946219L14.9132 4.5332C14.8823 4.75126 14.6901 4.86307 14.4856 4.78135L11.1815 3.46525C10.9766 3.38366 10.6428 3.38366 10.4384 3.46525L7.13384 4.78135C6.92947 4.86307 6.73702 4.75126 6.70639 4.5332L6.20129 0.946219C6.17025 0.728293 6.0064 0.549805 5.83713 0.549805C5.66758 0.549805 5.50346 0.728293 5.47297 0.946219L4.96759 4.5332C4.93682 4.75126 4.74451 4.86307 4.54014 4.78135L1.18057 3.44329C0.976335 3.36157 0.739842 3.41307 0.655002 3.55687C0.570298 3.70134 0.642534 3.93078 0.815465 4.06644L3.64106 6.2865C3.81426 6.4223 3.81426 6.64483 3.64106 6.7805L0.81533 9.00069C0.642398 9.13649 0.570163 9.37962 0.654867 9.54076C0.739706 9.70177 0.9762 9.76669 1.18017 9.68483L4.50964 8.34772C4.71415 8.266 4.90457 8.37727 4.93317 8.59547L5.41388 12.2135C5.44288 12.4313 5.63316 12.6096 5.83686 12.6096C6.04001 12.6096 6.23042 12.4314 6.25956 12.2135L6.74068 8.59547C6.76928 8.37727 6.96037 8.266 7.16379 8.34772L10.4387 9.66206C10.6426 9.74419 10.9764 9.74419 11.1808 9.66206L14.4551 8.34772C14.6589 8.266 14.8495 8.37727 14.8786 8.59547L15.3598 12.2135C15.3885 12.4313 15.5789 12.6096 15.7819 12.6096C15.9855 12.6096 16.1759 12.4314 16.2049 12.2135L16.6857 8.59547C16.7152 8.37727 16.9053 8.266 17.1093 8.34772L20.4389 9.68483C20.6424 9.76669 20.8793 9.70177 20.9642 9.54076C21.0492 9.37962 20.9769 9.13649 20.8036 9.00069ZM13.6149 6.80855L11.1266 8.72408C10.9524 8.85825 10.6667 8.85825 10.4931 8.72408L8.00447 6.80855C7.83031 6.67411 7.82896 6.4532 8.00175 6.31713L10.4953 4.35295C10.668 4.21674 10.9511 4.21674 11.1239 4.35295L13.6176 6.31713C13.7906 6.4532 13.7893 6.67411 13.6149 6.80855Z"
        className="transition duration-300 ease-in-out fill-current text-tertiary dark:text-darkTertiary group-hover:text-primary group-hover:dark:text-darkPrimary"
      />
    </svg>
  </a>
)
