module.exports = {
  parser: '@babel/eslint-parser',
  parserOptions: {
    sourceType: 'module',
    allowImportExportEverywhere: true,
  },
  env: {
    browser: true,
    node: true,
  },
  plugins: ['import', 'promise', 'compat', 'react'],
  extends: ['airbnb', 'plugin:prettier/recommended'],
  settings: {
    react: {
      version: '16.7',
    },
    'import/resolver': {
      webpack: {
        config: 'webpack/config.eslint.js',
      },
    },
  },
  rules: {
    'import/no-import-module-exports': [
      'error',
      {
        exceptions: ['**/*/webpack/**/*'],
      },
    ],
    'arrow-body-style': 'off',
    'arrow-parens': 'off',
    'class-methods-use-this': 'off',
    'compat/compat': 'off',
    'consistent-return': 'off',
    'comma-dangle': 'off',
    'default-param-last': 'off',
    'func-names': 'off',
    'generator-star-spacing': 'off',
    'no-nested-ternary': 'off',
    'import/no-cycle': 'off',
    'import/no-dynamic-require': 'off',
    'import/no-extraneous-dependencies': ['error', { devDependencies: true }],
    'import/no-unresolved': 'error',
    'import/prefer-default-export': 'off',
    'jsx-a11y/control-has-associated-label': 'off',
    'jsx-a11y/anchor-is-valid': 'off',
    'jsx-a11y/label-has-for': 'off',
    'jsx-a11y/label-has-associated-control': 'off',
    'jsx-a11y/no-static-element-interactions': 'off',
    'jsx-a11y/click-events-have-key-events': 'off',
    'react/jsx-no-useless-fragment': 'off',
    'react/jsx-curly-brace-presence': 'off',
    'no-console': [
      'error',
      {
        allow: ['info', 'error', 'warn'],
      },
    ],
    'no-use-before-define': 'off',
    'no-restricted-syntax': 'off',
    'no-multi-assign': 'off',
    'no-promise-executor-return': 'off',
    'no-shadow': 'off',
    'no-underscore-dangle': 'off',
    'no-throw-literal': 'off',
    'no-unused-vars': [
      'error',
      {
        args: 'after-used',
        argsIgnorePattern: '^_',
        varsIgnorePattern: '^_',
      },
    ],
    'padding-line-between-statements': [
      'error',
      { blankLine: 'always', prev: '*', next: 'return' },
      { blankLine: 'always', prev: ['block-like'], next: '*' },
      { blankLine: 'always', prev: ['const', 'let', 'var'], next: '*' },
      {
        blankLine: 'any',
        prev: ['const', 'let', 'var'],
        next: ['const', 'let', 'var'],
      },
    ],
    'prettier/prettier': ['error', { singleQuote: true }],
    'promise/param-names': 'error',
    'promise/always-return': 'error',
    'promise/catch-or-return': 'error',
    'promise/no-native': 'off',
    'react/sort-comp': [
      'error',
      {
        order: [
          'type-annotations',
          'static-methods',
          'lifecycle',
          'everything-else',
          'render',
        ],
      },
    ],
    'react/jsx-filename-extension': ['error', { extensions: ['.js', '.jsx'] }],
    'react/jsx-fragments': 'off',
    'react/jsx-no-bind': 'off',
    'react/jsx-props-no-spreading': 'off',
    'react/prefer-stateless-function': 'off',
    'react/prop-types': 'off',
    'react/no-deprecate': 'off',
  },
};
