# ChatGPDP - chat with your favourite characters

Change the initial prompt to change your fictional character's desired behavior.

If you're interested in chatting with your own PDF documents, check the [chatPDF](https://github.com/gabacode/chatPDF) project!

## Why this project?

We shouldn't really need a reason to publish a project like this, but particular times call for particular measures.

GPDP stands for "Giving Power to Democratic Participation", it's a censorship-resistant (for now) way of accessing to OpenAI's [GPT-3.5 models](https://platform.openai.com/docs/models/gpt-3-5) while their GDPR compliance is being evaluated.

Being open source, means that you can understand and learn how to build a similar bot, giving you a degree of "freedom" in setting your initial prompt, to experiment with different bot personalities, and satisfying your curiosity.

## General Notes

- Get a GPT API key from [OpenAI](https://platform.openai.com/account/api-keys) if you don't have one already.

- Set your API key and change the chat's colors from the top menu `Options -> Settings` or `Preferences` on macOS.

- Change your fictional character's desired behavior via the `Options -> Change Personality` menu.

- Right click on a message to Edit, Save, or Delete the message, and alter the course of your conversation.

- Take a screenshot of your conversation via `Edit -> Take Screenshot`.

- Save and load conversations from the `File` menu.

- If you're encountering any issues, try starting a new conversation via the `File -> New Chat` menu.

- Ask any questions to your favourite fictional character!

- Enjoy!

## Installation

### Windows 7 and greater

- Download and install the latest [Windows Installer](https://github.com/gabacode/chatGPDP/releases/latest).

### macOS (x86_64 only)

- Download and install the latest [.dmg Image](https://github.com/gabacode/chatGPDP/releases/latest).

### Linux (Debian, Ubuntu etc.)

- Download and install the latest [.AppImage](https://github.com/gabacode/chatGPDP/releases/latest).

## Run without installer (Recommended)

- [Install Python](https://www.python.org/downloads/) >=3.9.

- Launch the scripts provided:

#### On Linux/macOS

```bash
./launch.sh
```

#### On Windows

```bash
launch.bat
```

---

## Building

You can build your own executable by running the `build` scripts.

Go to the main folder of the project and run:

## On Linux and macOS

```bash
./build.sh
```

## On Windows

```bash
build.bat
```

Your compiled file will be inside the `/build` folder.

### So Long, and Thanks for All your laws 👋

Feel free to post on this repository for [feedback and suggestions](https://github.com/gabacode/chatGPDP/issues).

Use this technology responsibly, and don't forget to have fun!

Peace.
