# Contributing to Plate UI

#### Introduction

:+1::tada: First off, thanks for taking the time to contribute! :tada::+1:

The following is a set of guidelines (not rules) for contributing to Plate UI. Feel free to propose changes to this document in a pull request.

#### Code of Conduct

This project and everyone participating in it is governed by [our Code of Conduct](https://github.com/loenko/plate-ui/blob/master/.github/CODE_OF_CONDUCT.md). By participating, you are expected to uphold this code.

#### Your first contribution

There are many ways to contribute: 
* writing tutorials or blog posts
* improving the documentation
* submitting bug reports 
* submitting feature requests 
* writing new code
* writing unit tests for existing code

Unsure where to begin contributing to Plate UI? You can start by looking through the `good first issue` (issues which should only require a few lines of code, and a test or two) and `help wanted` (issues which should be a bit more involved than beginner issues) labels.

Working on your first Pull Request? You can learn how from this *free* series [How to Contribute to an Open Source Project on GitHub](https://egghead.io/series/how-to-contribute-to-an-open-source-project-on-github).

#### Getting Started
Please, don't use the issue tracker for support questions and other non-functional communication! There's a [Gitter room](https://gitter.im/Plate-UI/Lobby) where you can discuss any question/suggestion related to Plate UI.

Please, use [issue template](https://github.com/loenko/plate-ui/blob/master/.github/ISSUE_TEMPLATE.md) to create a detailed report on a problem (or description for a feature/enhancement suggestion), and make sure you've read the [pull request template](https://github.com/loenko/plate-ui/blob/master/.github/PULL_REQUEST_TEMPLATE.md) prior to submitting a new one.

#### Code Style
Please, be sure you follow the Ionic Team's [Stencil Style Guide](https://stenciljs.com/docs/style-guide/). If you would like to add `.tslint` config and script to the project - feel free to make a Pull Request!

#### Review Process
The repository maintainer(s) looks at Pull Requests (as well as issues submitted) on a regular basis. After feedback has been given you're expected to provide a response within three weeks. After three weeks we may close the pull request if it isn't showing any activity.