---
sidebarDepth: 0
---

# Available Rules

<!-- This file is automatically generated in tools/update-docs-rules-index.js, do not change! -->

## Recommended for Vue.js 3.x

Enforce all the rules in this category with:

```js
export default [
  ...eslintPluginVueScopedCSS.configs['flat/recommended'],
]
```

or

```json
{
  "extends": ["plugin:vue-scoped-css/vue3-recommended"]
}
```

| Rule ID | Description |    |
|:--------|:------------|:---|
| [vue-scoped-css/enforce-style-type](./enforce-style-type.md) | enforce the `<style>` tags to be plain or have the `scoped` or `module` attribute |  |
| [vue-scoped-css/no-deprecated-deep-combinator](./no-deprecated-deep-combinator.md) | disallow using deprecated deep combinators | :wrench: |
| [vue-scoped-css/no-parent-of-v-global](./no-parent-of-v-global.md) | disallow parent selector for `::v-global` pseudo-element |  |
| [vue-scoped-css/no-parsing-error](./no-parsing-error.md) | disallow parsing errors in `<style>` |  |
| [vue-scoped-css/no-unused-keyframes](./no-unused-keyframes.md) | disallow `@keyframes` which don't use in Scoped CSS |  |
| [vue-scoped-css/no-unused-selector](./no-unused-selector.md) | disallow selectors defined in Scoped CSS that don't use in `<template>` |  |
| [vue-scoped-css/require-v-deep-argument](./require-v-deep-argument.md) | require selector argument to be passed to `::v-deep()` | :wrench: |
| [vue-scoped-css/require-v-global-argument](./require-v-global-argument.md) | require selector argument to be passed to `::v-global()` |  |
| [vue-scoped-css/require-v-slotted-argument](./require-v-slotted-argument.md) | require selector argument to be passed to `::v-slotted()` |  |

## Recommended for Vue.js 2.x

Enforce all the rules in this category with:

```js
export default [
  ...eslintPluginVueScopedCSS.configs['flat/vue2-recommended'],
]
```

or

```json
{
  "extends": ["plugin:vue-scoped-css/recommended"]
}
```

| Rule ID | Description |    |
|:--------|:------------|:---|
| [vue-scoped-css/enforce-style-type](./enforce-style-type.md) | enforce the `<style>` tags to be plain or have the `scoped` or `module` attribute |  |
| [vue-scoped-css/no-parsing-error](./no-parsing-error.md) | disallow parsing errors in `<style>` |  |
| [vue-scoped-css/no-unused-keyframes](./no-unused-keyframes.md) | disallow `@keyframes` which don't use in Scoped CSS |  |
| [vue-scoped-css/no-unused-selector](./no-unused-selector.md) | disallow selectors defined in Scoped CSS that don't use in `<template>` |  |

## Uncategorized

No preset enables the rules in this category.
Please enable each rule if you want.

For example:

```json
{
  "rules": {
    "vue-scoped-css/no-deprecated-v-enter-v-leave-class": "error"
  }
}
```

| Rule ID | Description |    |
|:--------|:------------|:---|
| [vue-scoped-css/no-deprecated-v-enter-v-leave-class](./no-deprecated-v-enter-v-leave-class.md) | disallow v-enter and v-leave classes. |  |
| [vue-scoped-css/require-selector-used-inside](./require-selector-used-inside.md) | disallow selectors defined that is not used inside `<template>` |  |
| [vue-scoped-css/v-deep-pseudo-style](./v-deep-pseudo-style.md) | enforce `:deep()`/`::v-deep()` style | :wrench: |
| [vue-scoped-css/v-global-pseudo-style](./v-global-pseudo-style.md) | enforce `:global()`/`::v-global()` style | :wrench: |
| [vue-scoped-css/v-slotted-pseudo-style](./v-slotted-pseudo-style.md) | enforce `:slotted()`/`::v-slotted()` style | :wrench: |

## Deprecated

- :warning: We're going to remove deprecated rules in the next major release. Please migrate to successor/new rules.
- :innocent: We don't fix bugs which are in deprecated rules since we don't have enough resources.

| Rule ID | Replaced by |
|:--------|:------------|
| [vue-scoped-css/require-scoped](./require-scoped.md) | [vue-scoped-css/enforce-style-type](./enforce-style-type.md.md) |
