const fs = require("fs")
const XmlReader = require("xml-reader")

const xml = fs.readFileSync("src/fuse/locale/Strings.resx").toString().replace(/<!--[\s\S]*?-->/g, "")
const reader = XmlReader.create()

reader.on('done', data => {

    const members = []
    const statements = []

    for (const child of data.children) {
        if (child.name === "data") {
            const name = child.attributes.name
            const value = child.children[0]?.children[0]?.value

            members.push(`        /** ${value} */`)
            members.push(`        public static Text ${name} => _${name}.AsText();`)
            members.push(`        static readonly BehaviorSubject<string> _${name} = new BehaviorSubject<string>(Strings.${name});`)
            members.push(``)
            statements.push(`            _${name}.OnNext(Strings.${name});`)
        }
    }

    fs.writeFileSync("src/fuse/studio/Texts.cs", `// Generated by texts-cs.js (DO NOT EDIT)

using System.Reactive.Subjects;

namespace Outracks.Fuse
{
    public static class Texts
    {
${members.join("\n")}

        public static void Update()
        {
${statements.join("\n")}
        }
    }
}
`)
})

reader.parse(xml)
