/**
 * Created by Leon<silenceace@gmail.com> at 2023-03-30.
 */

import React from 'react'
import Svg, { Path, SvgProps } from 'react-native-svg'
const SvgComponent = (props: SvgProps) => {
  return (
    <Svg
      width="30"
      height="30"
      viewBox="0 0 30 30"
      fill="none"
      {...props}>
      <Path
        d="M24.8819 3.43725C25.1898 3.31623 25.525 3.28155 25.8512 3.33693C26.1774 3.39231 26.4823 3.53566 26.7331 3.75154C26.9838 3.96741 27.1709 4.24762 27.2742 4.56198C27.3775 4.87633 27.393 5.21291 27.3191 5.53544L23.0455 24.1873C22.9752 24.4943 22.8263 24.7779 22.6135 25.0101C22.4006 25.2423 22.1311 25.4153 21.8313 25.512C21.5315 25.6086 21.2117 25.6258 20.9032 25.5617C20.5948 25.4976 20.3083 25.3545 20.0719 25.1463L10.0364 16.3154L4.21732 15.1518C3.83203 15.075 3.48199 14.8754 3.2196 14.583C2.95721 14.2906 2.79659 13.9211 2.76179 13.5298C2.72699 13.1384 2.81987 12.7464 3.02654 12.4123C3.23321 12.0781 3.54255 11.8199 3.90823 11.6763L4.24187 12.5218L3.90914 11.6763L24.8819 3.43725ZM25.5473 5.12998L4.57459 13.3691L10.6328 14.58C10.7896 14.6113 10.9354 14.6834 11.0555 14.7891L21.2728 23.7818L25.5455 5.13089L25.5473 5.12998Z"
        fill={props.color}
      />
      <Path
        d="M26.6591 3.76909C26.8002 3.96452 26.858 4.208 26.8196 4.44599C26.7812 4.68398 26.6499 4.89699 26.4545 5.03818L10.9873 16.2091C10.8904 16.279 10.7808 16.3291 10.6646 16.3567C10.5484 16.3842 10.4279 16.3886 10.31 16.3695C10.1921 16.3505 10.0792 16.3084 9.97753 16.2457C9.8759 16.183 9.78762 16.1009 9.71772 16.0041C9.57655 15.8086 9.51884 15.5649 9.55729 15.3269C9.59573 15.0888 9.72718 14.8757 9.92272 14.7345L25.39 3.56363C25.5855 3.42259 25.8291 3.365 26.0671 3.40353C26.3051 3.44206 26.518 3.57356 26.6591 3.76909Z"
        fill={props.color}
      />
      <Path
        d="M10.4545 14.5627C10.6956 14.5627 10.9268 14.6585 11.0973 14.829C11.2678 14.9995 11.3636 15.2307 11.3636 15.4718V22.8709L14.9145 19.32C15.086 19.1544 15.3156 19.0628 15.554 19.0649C15.7923 19.0669 16.0203 19.1625 16.1889 19.3311C16.3574 19.4996 16.453 19.7276 16.4551 19.966C16.4572 20.2044 16.3656 20.434 16.2 20.6055L12.649 24.1564C12.3948 24.4106 12.0708 24.5837 11.7182 24.6538C11.3656 24.7239 11 24.6879 10.6679 24.5503C10.3357 24.4128 10.0517 24.1798 9.85195 23.8808C9.65216 23.5819 9.54549 23.2305 9.54541 22.8709V15.4709C9.54541 15.2298 9.64119 14.9986 9.81168 14.8281C9.98216 14.6576 10.2134 14.5618 10.4545 14.5618V14.5627Z"
        fill={props.color}
      />
    </Svg>
  )
}
const SvgIcon = React.memo(SvgComponent)
export default SvgIcon
