/**
 * Created by Leon<silenceace@gmail.com> at 2023-03-30.
 */

import React from 'react'
import Svg, { Path, SvgProps } from 'react-native-svg'
const SvgComponent = (props: SvgProps) => {
  return (
    <Svg
      width="30"
      height="30"
      viewBox="0 0 30 30"
      fill="none"
      {...props}>
      <Path
        d="M25.6445 16.1816C25.1353 16.1816 24.7223 16.5942 24.7192 17.1037V17.1082C24.7192 17.1082 24.7192 17.1082 24.7192 17.1096V23.5798C24.7192 24.1041 24.2962 24.5278 23.774 24.5278H5.06516C4.54322 24.5278 4.12059 24.1042 4.12059 23.5798V7.46047C4.12059 6.93622 4.54364 6.51174 5.06516 6.51174H13.8241C14.3352 6.51072 14.748 6.09637 14.748 5.58441C14.748 5.0722 14.3348 4.6571 13.8241 4.6571H4.94066C3.46524 4.6571 2.26941 5.85608 2.26941 7.33453V23.7043C2.26941 25.1829 3.46533 26.3824 4.94066 26.3824H23.8985C25.3738 26.3824 26.5698 25.1829 26.5698 23.7043V17.1048C26.5677 16.5945 26.1539 16.1816 25.6445 16.1816Z"
        fill={props.color}
      />
      <Path
        d="M27.4516 9.83861L21.4011 3.76955L21.1665 3.57639C21.033 3.50663 20.8682 3.47992 20.7125 3.47992C20.1829 3.47992 19.7535 3.91052 19.7535 4.44095C19.7535 4.5972 19.8445 4.8407 19.9146 4.97456L24.0631 9.16305H19.7975C13.3076 9.9695 10.9338 13.387 10.3357 21.3232C10.3349 21.8758 10.7644 22.3069 11.2938 22.3069C11.7155 22.3069 12.0978 21.9356 12.2258 21.5556C12.8242 14.4223 14.5059 11.6773 19.8309 11.0847L24.0634 11.0862L20.0426 15.1186L19.869 15.3386C19.8026 15.4697 19.777 15.6346 19.777 15.7859C19.777 16.3157 20.2064 16.7469 20.7352 16.7469C20.8694 16.7469 21.1069 16.6722 21.2258 16.6188L27.4515 10.4109L27.7181 10.1433L27.4516 9.83861Z"
        fill={props.color}
      />
    </Svg>
  )
}
const SvgIcon = React.memo(SvgComponent)
export default SvgIcon
