/**
 * Created by Leon<silenceace@gmail.com> at 2023-03-30.
 */

import React from 'react'
import Svg, { Path, SvgProps } from 'react-native-svg'
const SvgComponent = (props: SvgProps) => {
  return (
    <Svg
      width="30"
      height="30"
      viewBox="0 0 30 30"
      fill="none"
      {...props}>
      <Path
        d="M18.5625 27.5C18.3125 27.5 18.0625 27.375 18 27.125L13.375 16.6875L2.875 12C2.625 11.875 2.5 11.6875 2.5 11.4375C2.5 11.1875 2.6875 10.9375 2.9375 10.875L26.6875 2.56251C26.9375 2.50001 27.1875 2.56251 27.3125 2.68751C27.4375 2.81251 27.5625 3.12501 27.4375 3.31251L19.125 27.0625C19.0625 27.3125 18.875 27.5 18.5625 27.5ZM4.8125 11.5L14.0625 15.625C14.1875 15.6875 14.3125 15.8125 14.375 15.9375L18.5 25.1875L25.875 4.12501L4.8125 11.5Z"
        fill={props.color}
      />
      <Path
        d="M13.8125 16.8125C13.625 16.8125 13.5 16.75 13.375 16.625C13.125 16.375 13.125 16 13.375 15.75L26.4375 2.6875C26.6875 2.4375 27.0625 2.4375 27.3125 2.6875C27.5625 2.9375 27.5625 3.3125 27.3125 3.5625L14.25 16.625C14.125 16.75 14 16.8125 13.8125 16.8125Z"
        fill={props.color}
      />
    </Svg>
  )
}
const SvgIcon = React.memo(SvgComponent)
export default SvgIcon
