/**
 * Created by Leon<silenceace@gmail.com> at 2023-03-30.
 */

import React from 'react'
import Svg, { Path, SvgProps } from 'react-native-svg'
const SvgComponent = (props: SvgProps) => {
  return (
    <Svg
      width="30"
      height="30"
      viewBox="0 0 30 30"
      fill="none"
      {...props}>
      <Path
        d="M24.7461 3.00001H6.24599C5.65045 3.00043 5.07942 3.23719 4.6583 3.65831C4.23719 4.07942 4.00042 4.65045 4 5.246V25.9524C4.00042 26.548 4.23714 27.1192 4.6582 27.5406C5.07927 27.962 5.6503 28.1991 6.24599 28.1999H24.7461C25.0416 28.2004 25.3344 28.1425 25.6076 28.0298C25.8809 27.9171 26.1292 27.7517 26.3385 27.543C26.5478 27.3342 26.714 27.0864 26.8275 26.8134C26.941 26.5405 26.9996 26.2479 27 25.9524V5.246C26.9996 4.9505 26.9409 4.65798 26.8274 4.38515C26.7139 4.11233 26.5477 3.86454 26.3384 3.65596C26.1291 3.44738 25.8807 3.28209 25.6075 3.16954C25.3343 3.05699 25.0416 2.99938 24.7461 3.00001ZM25.4958 25.9524C25.4954 26.1511 25.4162 26.3415 25.2757 26.482C25.1352 26.6225 24.9448 26.7017 24.7461 26.7021H6.24599C6.04743 26.7017 5.85714 26.6225 5.71689 26.4819C5.57663 26.3414 5.49786 26.1509 5.49786 25.9524V5.246C5.49786 5.04758 5.57668 4.85729 5.71698 4.71699C5.85729 4.57669 6.04758 4.49786 6.24599 4.49786H24.7461C24.9446 4.49786 25.1351 4.57663 25.2756 4.71689C25.4162 4.85715 25.4954 5.04744 25.4958 5.246V25.9524Z"
        fill={props.color}
      />
      <Path
        d="M12.0262 18.571H18.9675C19.5631 18.5706 20.1341 18.3339 20.5552 17.9127C20.9763 17.4916 21.2131 16.9206 21.2135 16.325V12.0793C21.2129 11.52 21.0039 10.9811 20.6274 10.5676C20.2509 10.1541 19.7339 9.89571 19.1772 9.84279V9.3488C19.1759 8.46958 18.8261 7.62673 18.2044 7.00502C17.5827 6.38332 16.7398 6.03349 15.8606 6.03223H15.1061C14.2269 6.03349 13.384 6.38332 12.7623 7.00502C12.1406 7.62673 11.7908 8.46958 11.7895 9.3488V9.84597C11.2379 9.90473 10.7275 10.1653 10.3564 10.5775C9.98518 10.9897 9.77942 11.5245 9.77863 12.0793V16.325C9.77947 16.9207 10.0166 17.4918 10.438 17.9128C10.8593 18.3339 11.4305 18.5706 12.0262 18.571ZM15.1061 7.52691H15.8606C16.3427 7.52775 16.8048 7.71963 17.1457 8.06053C17.4866 8.40142 17.6785 8.86353 17.6793 9.34562V9.83009H13.289V9.3488C13.2886 8.8663 13.4797 8.40337 13.8205 8.06175C14.1612 7.72012 14.6236 7.52775 15.1061 7.52691ZM11.2749 12.0793C11.2774 11.8818 11.3577 11.6933 11.4984 11.5547C11.6391 11.4161 11.8287 11.3386 12.0262 11.3391H18.9675C19.1659 11.3391 19.3562 11.4179 19.4965 11.5582C19.6368 11.6985 19.7156 11.8888 19.7156 12.0872V16.333C19.7156 16.5314 19.6368 16.7217 19.4965 16.862C19.3562 17.0023 19.1659 17.0811 18.9675 17.0811H12.0262C11.9271 17.0813 11.8289 17.0619 11.7373 17.0239C11.6458 16.9859 11.5627 16.9302 11.4928 16.8599C11.4229 16.7895 11.3677 16.7061 11.3303 16.6143C11.2929 16.5225 11.2741 16.4242 11.2749 16.325V12.0793Z"
        fill={props.color}
      />
      <Path
        d="M15.4969 15.8597C15.5952 15.8591 15.6925 15.839 15.7832 15.8008C15.8738 15.7625 15.956 15.7067 16.0251 15.6366C16.0941 15.5665 16.1487 15.4835 16.1856 15.3923C16.2225 15.3011 16.2411 15.2036 16.2402 15.1052L16.2275 13.2086C16.2267 13.0108 16.1475 12.8213 16.0073 12.6817C15.8671 12.5421 15.6773 12.4637 15.4794 12.4637C15.3809 12.4643 15.2836 12.4843 15.1928 12.5226C15.1021 12.5608 15.0198 12.6166 14.9506 12.6866C14.8815 12.7567 14.8268 12.8397 14.7897 12.9309C14.7526 13.0221 14.7338 13.1197 14.7344 13.2182L14.7471 15.1242C14.7509 15.3206 14.8315 15.5076 14.9717 15.6452C15.1119 15.7827 15.3005 15.8597 15.4969 15.8597ZM22.4398 23.9335H8.5095C8.40825 23.9288 8.30711 23.9448 8.21218 23.9803C8.11725 24.0158 8.03051 24.0702 7.95721 24.1402C7.88391 24.2102 7.82556 24.2944 7.7857 24.3876C7.74583 24.4808 7.72528 24.5811 7.72528 24.6824C7.72528 24.7838 7.74583 24.8841 7.7857 24.9773C7.82556 25.0705 7.88391 25.1546 7.95721 25.2246C8.03051 25.2946 8.11725 25.349 8.21218 25.3846C8.30711 25.4201 8.40825 25.436 8.5095 25.4314H22.4398C22.541 25.436 22.6422 25.4201 22.7371 25.3846C22.832 25.349 22.9187 25.2946 22.992 25.2246C23.0653 25.1546 23.1237 25.0705 23.1636 24.9773C23.2034 24.8841 23.224 24.7838 23.224 24.6824C23.224 24.5811 23.2034 24.4808 23.1636 24.3876C23.1237 24.2944 23.0653 24.2102 22.992 24.1402C22.9187 24.0702 22.832 24.0158 22.7371 23.9803C22.6422 23.9448 22.541 23.9288 22.4398 23.9335ZM8.5095 22.9852H16.8232C17.0158 22.9764 17.1977 22.8936 17.3309 22.7541C17.4641 22.6146 17.5384 22.4292 17.5384 22.2363C17.5384 22.0434 17.4641 21.858 17.3309 21.7185C17.1977 21.579 17.0158 21.4962 16.8232 21.4874H8.5095C8.40825 21.4827 8.30711 21.4986 8.21218 21.5342C8.11725 21.5697 8.03051 21.6241 7.95721 21.6941C7.88391 21.7641 7.82556 21.8483 7.7857 21.9414C7.74583 22.0346 7.72528 22.1349 7.72528 22.2363C7.72528 22.3377 7.74583 22.438 7.7857 22.5312C7.82556 22.6244 7.88391 22.7085 7.95721 22.7785C8.03051 22.8485 8.11725 22.9029 8.21218 22.9384C8.30711 22.974 8.40825 22.9899 8.5095 22.9852Z"
        fill={props.color}
      />
    </Svg>
  )
}
const SvgIcon = React.memo(SvgComponent)
export default SvgIcon
