/**
 * Created by Leon<silenceace@gmail.com> at 2023-03-30.
 */

import React from 'react'
import Svg, { Path, SvgProps } from 'react-native-svg'
const SvgComponent = (props: SvgProps) => {
  return (
    <Svg
      width="30"
      height="30"
      viewBox="0 0 30 30"
      fill="none"
      {...props}>
      <Path
        d="M26.959 9.67383C26.291 8.38184 25.3389 7.22168 24.1289 6.23145C21.6738 4.22168 18.4248 3.11426 14.9736 3.11426C11.5225 3.11426 8.27051 4.22168 5.81836 6.23145C4.6084 7.22168 3.65625 8.38184 2.98828 9.67383C2.28809 11.0273 1.93359 12.4688 1.93359 13.9541C1.93359 16.5059 2.99121 18.9346 4.92773 20.874L4.78125 25.4883C4.75195 25.96 4.97461 26.417 5.36426 26.6865C5.59277 26.8447 5.86523 26.9268 6.13477 26.9268C6.33398 26.9268 6.53027 26.8828 6.71484 26.7949L11.5693 24.4219C12.6738 24.668 13.8164 24.7939 14.9707 24.7939C18.4219 24.7939 21.6709 23.6865 24.1289 21.6768C25.3389 20.6865 26.291 19.5264 26.959 18.2344C27.6592 16.8809 28.0137 15.4395 28.0137 13.9541C28.0137 12.4688 27.6592 11.0273 26.959 9.67383ZM14.9707 23.0361C13.7373 23.0361 12.5244 22.875 11.3672 22.5615L11.3643 22.5674V22.5645L6.55957 24.9141L6.71191 20.165L6.72656 20.1475C4.76953 18.457 3.69141 16.2598 3.69141 13.9541C3.69141 8.94727 8.75098 4.87207 14.9707 4.87207C21.1904 4.87207 26.25 8.94727 26.25 13.9541C26.25 18.9609 21.1904 23.0361 14.9707 23.0361Z"
        fill={props.color}
      />
      <Path
        d="M21.0674 11.4258H9.0791C8.5957 11.4258 8.20312 11.8213 8.20312 12.3047C8.20312 12.7881 8.59863 13.1836 9.0791 13.1836H21.0645C21.5479 13.1836 21.9404 12.7881 21.9404 12.3047C21.9404 11.8213 21.5479 11.4258 21.0674 11.4258ZM21.0674 14.707H9.0791C8.5957 14.707 8.20312 15.1025 8.20312 15.5859C8.20312 16.0693 8.59863 16.4648 9.0791 16.4648H21.0645C21.5479 16.4648 21.9404 16.0693 21.9404 15.5859C21.9404 15.1025 21.5479 14.707 21.0674 14.707Z"
        fill={props.color}
      />
    </Svg>
  )
}
const SvgIcon = React.memo(SvgComponent)
export default SvgIcon
