/**
 * Created by Leon<silenceace@gmail.com> at 2023-03-30.
 */

import React from 'react'
import Svg, { Path, SvgProps } from 'react-native-svg'
const SvgComponent = (props: SvgProps) => {
  return (
    <Svg
      width="30"
      height="30"
      viewBox="0 0 30 30"
      fill="none"
      {...props}>
      <Path
        d="M4.25 12V9.5C4.25317 8.10859 4.80731 6.77507 5.79119 5.79119C6.77507 4.80731 8.10859 4.25317 9.5 4.25H12C12.1985 4.25131 12.3885 4.33075 12.5289 4.47112C12.6693 4.61149 12.7487 4.80149 12.75 5C12.7487 5.19851 12.6693 5.38851 12.5289 5.52888C12.3885 5.66925 12.1985 5.74869 12 5.75H9.5C8.50552 5.75027 7.55185 6.14544 6.84864 6.84864C6.14544 7.55185 5.75027 8.50552 5.75 9.5V12C5.74869 12.1985 5.66925 12.3885 5.52888 12.5289C5.38851 12.6693 5.19851 12.7487 5 12.75C4.80149 12.7487 4.61149 12.6693 4.47112 12.5289C4.33075 12.3885 4.25131 12.1985 4.25 12Z"
        fill={props.color}
      />
      <Path
        d="M24.25 12V9.5C24.2497 8.50552 23.8546 7.55185 23.1514 6.84864C22.4482 6.14544 21.4945 5.75027 20.5 5.75H18C17.8015 5.74869 17.6115 5.66925 17.4711 5.52888C17.3308 5.38851 17.2513 5.19851 17.25 5C17.2513 4.80149 17.3308 4.61149 17.4711 4.47112C17.6115 4.33075 17.8015 4.25131 18 4.25H20.5C21.8914 4.25317 23.2249 4.80731 24.2088 5.79119C25.1927 6.77507 25.7468 8.10859 25.75 9.5V12C25.75 12.1989 25.671 12.3897 25.5303 12.5303C25.3897 12.671 25.1989 12.75 25 12.75C24.8011 12.75 24.6103 12.671 24.4697 12.5303C24.329 12.3897 24.25 12.1989 24.25 12ZM19 25.75C18.8011 25.75 18.6103 25.671 18.4697 25.5303C18.329 25.3897 18.25 25.1989 18.25 25C18.25 24.8011 18.329 24.6103 18.4697 24.4697C18.6103 24.329 18.8011 24.25 19 24.25H20.5C21.4945 24.2497 22.4482 23.8546 23.1514 23.1514C23.8546 22.4482 24.2497 21.4945 24.25 20.5V19C24.25 18.8011 24.329 18.6103 24.4697 18.4697C24.6103 18.329 24.8011 18.25 25 18.25C25.1989 18.25 25.3897 18.329 25.5303 18.4697C25.671 18.6103 25.75 18.8011 25.75 19V20.5C25.7468 21.8914 25.1927 23.2249 24.2088 24.2088C23.2249 25.1927 21.8914 25.7468 20.5 25.75H19ZM9.5 25.75C8.10859 25.7468 6.77507 25.1927 5.79119 24.2088C4.80731 23.2249 4.25317 21.8914 4.25 20.5V18C4.25131 17.8015 4.33075 17.6115 4.47112 17.4711C4.61149 17.3308 4.80149 17.2513 5 17.25C5.19851 17.2513 5.38851 17.3308 5.52888 17.4711C5.66925 17.6115 5.74869 17.8015 5.75 18V20.5C5.75027 21.4945 6.14544 22.4482 6.84864 23.1514C7.55185 23.8546 8.50552 24.2497 9.5 24.25H12C12.1989 24.25 12.3897 24.329 12.5303 24.4697C12.671 24.6103 12.75 24.8011 12.75 25C12.75 25.1989 12.671 25.3897 12.5303 25.5303C12.3897 25.671 12.1989 25.75 12 25.75H9.5Z"
        fill={props.color}
      />
    </Svg>
  )
}
const SvgIcon = React.memo(SvgComponent)
export default SvgIcon
