/**
 * Created by Leon<silenceace@gmail.com> at 2023-04-03.
 */

import React from 'react'
import Svg, { Path, SvgProps } from 'react-native-svg'
const SvgComponent = (props: SvgProps) => {
  return (
    <Svg
      width="30"
      height="30"
      viewBox="0 0 30 30"
      fill="none"
      {...props}>
      <Path
        d="M14.9805 1.85547C7.73172 1.85547 1.85547 7.73172 1.85547 14.9805C1.85547 22.2292 7.73172 28.1055 14.9805 28.1055C22.2292 28.1055 28.1055 22.2292 28.1055 14.9805C28.1055 7.73172 22.2292 1.85547 14.9805 1.85547ZM22.9354 22.9354C21.9017 23.9692 20.6983 24.7806 19.3589 25.3472C17.9732 25.9333 16.5 26.2305 14.9805 26.2305C13.4609 26.2305 11.9878 25.9333 10.602 25.3472C9.2626 24.7807 8.05929 23.9692 7.02552 22.9354C5.99172 21.9017 5.18031 20.6983 4.61377 19.3589C4.02766 17.9732 3.73047 16.5 3.73047 14.9805C3.73047 13.4609 4.02766 11.9878 4.61377 10.602C5.18028 9.2626 5.99172 8.05929 7.02552 7.02552C8.05929 5.99172 9.2626 5.18031 10.602 4.61377C11.9878 4.02766 13.4609 3.73047 14.9805 3.73047C16.5 3.73047 17.9731 4.02766 19.3589 4.61377C20.6983 5.18028 21.9017 5.99172 22.9354 7.02552C23.9692 8.05929 24.7806 9.2626 25.3472 10.602C25.9333 11.9878 26.2305 13.4609 26.2305 14.9805C26.2305 16.5 25.9333 17.9731 25.3472 19.3589C24.7807 20.6983 23.9692 21.9017 22.9354 22.9354Z"
        fill={props.color}
      />
      <Path
        d="M18.8099 8.36804C18.0341 7.20285 16.682 6.56113 15.0029 6.56113C13.672 6.56113 12.6085 6.99876 11.842 7.86191C11.2069 8.57719 10.8179 9.5429 10.6857 10.7322C10.5933 11.5636 10.6638 12.2019 10.6722 12.2719C10.7334 12.786 11.2001 13.1532 11.714 13.0919C12.2281 13.0307 12.5953 12.5643 12.534 12.0501C12.5335 12.0454 12.48 11.5627 12.5493 10.9393C12.6101 10.3918 12.78 9.62951 13.2441 9.10688C13.6449 8.65553 14.2202 8.43613 15.0029 8.43613C16.0495 8.43613 16.8262 8.77193 17.2492 9.40723C17.6966 10.079 17.6657 10.9325 17.4367 11.4804C17.3056 11.794 16.6835 12.3674 16.1837 12.8281C15.1312 13.7982 14.0429 14.8013 14.0429 16.0134V17.8139C14.0429 18.3316 14.4627 18.7514 14.9804 18.7514C15.4982 18.7514 15.9179 18.3316 15.9179 17.8139V16.0134C15.9179 15.9933 15.9283 15.8053 16.2873 15.371C16.5948 14.9991 17.0318 14.5963 17.4544 14.2068C18.1862 13.5323 18.8775 12.8951 19.1666 12.2035C19.4104 11.6202 19.5133 10.9637 19.464 10.3051C19.4115 9.60159 19.1852 8.93177 18.8099 8.36804Z"
        fill={props.color}
      />
      <Path
        d="M13.8311 20.5947C13.8311 20.9055 13.9545 21.2035 14.1743 21.4233C14.3941 21.6431 14.6921 21.7665 15.0029 21.7665C15.3137 21.7665 15.6118 21.6431 15.8316 21.4233C16.0513 21.2035 16.1748 20.9055 16.1748 20.5947C16.1748 20.2839 16.0513 19.9858 15.8316 19.766C15.6118 19.5463 15.3137 19.4228 15.0029 19.4228C14.6921 19.4228 14.3941 19.5463 14.1743 19.766C13.9545 19.9858 13.8311 20.2839 13.8311 20.5947Z"
        fill={props.color}
      />
    </Svg>
  )
}
const SvgIcon = React.memo(SvgComponent)
export default SvgIcon
