/**
 * Created by Leon<silenceace@gmail.com> at 2023-03-30.
 */

import React from 'react'
import Svg, { Path, SvgProps } from 'react-native-svg'
const SvgComponent = (props: SvgProps) => {
  return (
    <Svg
      width="30"
      height="30"
      viewBox="0 0 30 30"
      fill="none"
      {...props}>
      <Path
        d="M26.25 19.6875C25.75 19.6875 25.3125 20.125 25.3125 20.625V24.375C25.3125 24.5625 25.1875 24.6875 25 24.6875H5C4.8125 24.6875 4.6875 24.5625 4.6875 24.375V20.625C4.6875 20.125 4.25 19.6875 3.75 19.6875C3.25 19.6875 2.8125 20.125 2.8125 20.625V24.375C2.8125 25.5625 3.8125 26.5625 5 26.5625H25C26.1875 26.5625 27.1875 25.5625 27.1875 24.375V20.625C27.1875 20.125 26.75 19.6875 26.25 19.6875Z"
        fill={props.color}
      />
      <Path
        d="M14.3125 21.3125C14.5 21.5 14.75 21.5625 15 21.5625C15.25 21.5625 15.5 21.5 15.6875 21.3125L21.9375 15.0625C22.3125 14.6875 22.3125 14.125 21.9375 13.75C21.5625 13.375 21 13.375 20.625 13.75L16 18.375V5C16 4.5 15.5625 4.0625 15.0625 4.0625C14.5625 4.0625 14.0625 4.5 14.0625 5V18.375L9.4375 13.75C9.0625 13.375 8.5 13.375 8.125 13.75C7.75 14.125 7.75 14.6875 8.125 15.0625L14.3125 21.3125Z"
        fill={props.color}
      />
    </Svg>
  )
}
const SvgIcon = React.memo(SvgComponent)
export default SvgIcon
