<?php

namespace Framelix\FramelixDocs\View\Features;

use Framelix\Framelix\Dev\Debug;
use Framelix\Framelix\Form\Form;
use Framelix\Framelix\Network\Response;
use Framelix\Framelix\Url;
use Framelix\FramelixDocs\StorableMeta\SimpleDemoEntry;
use Framelix\FramelixDocs\View\View;

class StorableMeta extends View
{
    protected string $pageTitle = 'Storable Meta - The companion to Storables';

    public static function showForm(): void
    {
        $meta = new SimpleDemoEntry(new \Framelix\FramelixDocs\Storable\SimpleDemoEntry());
        $form = $meta->getEditForm();
        $form->submitUrl = Url::create();
        if (Form::isFormSubmitted($form->id)) {
            echo "Great. Your form has been submitted with the following automatically converted values.";
            Debug::dump($form->getConvertedSubmittedValues());
            Response::stopWithFormValidationResponse();
        }
        $form->show();
    }

    public static function showTable(): void
    {
        $arr = \Framelix\FramelixDocs\Storable\SimpleDemoEntry::getByCondition();
        $meta = new SimpleDemoEntry(new \Framelix\FramelixDocs\Storable\SimpleDemoEntry());
        $meta->getTable($arr)->show();
    }

    public static function showQuickSearch(): void
    {
        $meta = new SimpleDemoEntry(new \Framelix\FramelixDocs\Storable\SimpleDemoEntry());
        $meta->getQuickSearch()->show();
    }

    public function showContent(): void
    {
        ?>
        <p>
            <code>StorableMeta</code> is one of the most powerful constructs in Framelix. It combines a lot of features
            from the Framework and give you a nice all-in-one interface for the most common jobs for data managing
            applications. Things like tables, input forms, quick search are automatically generated by this technique.
        </p>
        <p>
            <code>StorableMeta</code>, as the name may leak, is metadata to a <code>Storable</code>. With metadata we
            mean things like: How is it searchable, what human readable label does it have, which type of user input
            field have it when automatically generating edit forms, which Html representation does it have when
            you display it in automatically generated tables, and so on.
        </p>
        <p>
            The more detailed data you give to our <code>StorableMeta</code>, the more Framelix can auto-gen for you.
        </p>
        <p>
            Let's see a full blown example in code, including the results when generating tables,
            forms and searches out of this StorableMeta.<br/>
            It will overhelm you at first, but we try to break it down step by step.
        </p>
        <?php
        echo $this->getAnchoredTitle('all', 'The complete meta code');
        $this->addSourceFile(SimpleDemoEntry::class);
        $this->showSourceFiles();

        echo $this->getAnchoredTitle('form', 'The form out of this meta');
        $this->addPhpExecutableMethod([__CLASS__, "showForm"],
            "The form",
            "The form that will be generated here, is completely generated only by the StorableMeta information we have above."
        );
        $this->showPhpExecutableMethodsCodeBlock();

        echo $this->getAnchoredTitle('table', 'The table out of this meta');
        $this->addPhpExecutableMethod([__CLASS__, "showTable"],
            "The table",
            "The table that will be generated here, is completely generated only by the StorableMeta information we have above."
        );
        $this->showPhpExecutableMethodsCodeBlock();

        echo $this->getAnchoredTitle('quicksearch', 'The quick search out of this meta');
        $this->addPhpExecutableMethod([__CLASS__, "showQuickSearch"],
            "The quick search",
            "QuickSearch as some sort of 'lazy' search. Type in what you want, the system do a lazy search and display the results. This is convinient and just work most use-cases."
        );
        $this->showPhpExecutableMethodsCodeBlock();
    }
}