<?php

namespace Framelix\FramelixDocs\View\Basics;

use Framelix\FramelixDocs\View\View;

class Config extends View
{
    protected string $pageTitle = 'Configuration';

    public function showContent(): void
    {
        ?>
        <p>
            Configuration in Framelix is done with configuration files that are default located in your <code>userdata/xxx/private/01-app.php</code>.
            This file is automatically generated when you have completed the setup.
            Here is the example file that this docs use right now.
        </p>
        <?php
        $this->addSourceFile(\Framelix\Framelix\Config::getUserConfigFilePath());
        $this->showSourceFiles();
        echo $this->getAnchoredTitle('configclass', 'The config classes');
        ?>
        <p>
            Everything you configure for Framelix should be basically available through
            the <?= $this->getSourceFileLinkTag([\Framelix\Framelix\Config::class]) ?> class.
            This class contains a lot of functions and properties that you can use, set or override in your own
            configuration file.
            Everything should have a proper doc comment that explain you what to do and how to set it.
        </p>
        <p>
            Each module can have individual <code>Config</code> classes that can contain module specific config flags.
            Like for example the module config of this docs module.
        </p>
        <?php
        $this->addSourceFile(\Framelix\FramelixDocs\Config::class);
        $this->showSourceFiles();
        echo $this->getAnchoredTitle('onregister', 'onRegister function');
        ?>
        <p>
            The <code>onRegister</code> static function will be executed, as soon as the module is loaded by the
            Framework.
            This configuration should set all default module settings that are required for the module.
            Like in this example, adding some compiler file groups and adding a default database connection.
        </p>
        <?php
        echo $this->getAnchoredTitle('loadingOrder', 'Loading order of config files');
        ?>
        <p>
            Configuration files are loaded in the order of the modules that are registered.
            At really first, <code>Framelix</code> will be registered.
            After that, the <code>FRAMELIX_MODULE</code> will be registered (Which is the module the URL is mapped to in
            the docker .env).<br/>
            You can register more modules by calling <code>Framelix::registerModule</code> in your own Config class.
        </p>
        <?php
    }
}