<?php

namespace Framelix\Framelix\Db;

use Framelix\Framelix\ObjectTransformable;

/**
 * Storable property interface to convert a property from/to database
 */
interface StorablePropertyInterface extends ObjectTransformable
{
    /**
     * Set up the property database schema definition to this storable property itself
     * This defines how the column will be created in the database
     * @param StorableSchemaProperty $storableSchemaProperty
     */
    public static function setupSelfStorableSchemaProperty(StorableSchemaProperty $storableSchemaProperty): void;

    /**
     * Create an instance from the original database value
     * @param mixed $dbValue
     * @return self|null
     */
    public static function createFromDbValue(mixed $dbValue): ?self;

    /**
     * Create an instance from a submitted form value
     * @param mixed $formValue
     * @return self|null
     */
    public static function createFromFormValue(mixed $formValue): ?self;

}