'use strict';

;
class FramelixCustomElement extends HTMLElement {
  originalContents;
  async connectedCallback() {
    if (this.originalContents === undefined) {
      this.originalContents = $(this).contents();
    }
    this.updateDomContents();
  }
  setRootContainerProps() {}
  updateDomContents() {
    this.setRootContainerProps();
  }
}
;
;
class FramelixCustomElementAlert extends FramelixCustomElement {
  initialized = false;
  static resetAllAlerts() {
    FramelixLocalStorage.remove('framelix_alerts_hidden');
    $('framelix-alert').removeClass('hidden');
  }
  updateHeaderText(str) {
    this.setAttribute('header', str);
    this.updateDomContents();
  }
  updateBodyHtml(html) {
    if ($(this).children('article').length) {
      $(this).find('article .text').html(html);
    } else {
      $(this).html(html);
    }
    this.originalContents = $(this).contents();
  }
  async updateDomContents() {
    super.updateDomContents();
    const self = this;
    const selfCash = $(this);
    const hidable = this.getAttribute('hidable');
    const bgcolor = this.getAttribute('bgcolor');
    const textcolor = this.getAttribute('textcolor');
    this.setAttribute('role', 'figure');
    const contents = this.originalContents;
    const header = this.getAttribute('header');
    if (header !== null) {
      selfCash.prepend(`<header><div class="text">&nbsp;</div></header>`);
      FramelixLang.get(header).then(value => {
        selfCash.find('header .text').html(value);
      });
    }
    selfCash.append(`<article><div class="text">&nbsp;</div></article>`);
    if (contents.length === 1 && contents[0].nodeType === Node.TEXT_NODE && contents[0].nodeValue.trim().startsWith('__')) {
      const value = contents[0].nodeValue;
      this.removeChild(contents[0]);
      FramelixLang.get(value).then(value => {
        selfCash.find('article .text').html(value);
      });
    } else {
      selfCash.find('article .text').append(contents);
    }
    if (hidable) {
      selfCash.children().first().append(`<framelix-button theme="transparent" icon="719" title="__framelix_alert_hide__" small></framelix-button>`);
    }
    if (bgcolor) {
      this.style.backgroundColor = bgcolor;
      if (!textcolor) {
        setTimeout(function () {
          self.style.color = FramelixColorUtils.invertColor(FramelixColorUtils.cssColorToHex(self.style.backgroundColor), true);
        }, 10);
      }
    }
    if (textcolor) {
      self.style.color = textcolor;
    }
    if (hidable) {
      const entries = FramelixLocalStorage.get('framelix_alerts_hidden') || {};
      if (entries[hidable] === 1) {
        this.classList.add('hidden');
      }
    }
    if (!this.initialized) {
      this.initialized = true;
      const self = this;
      this.addEventListener('click', async function (ev) {
        if (!hidable) {
          return;
        }
        const entries = FramelixLocalStorage.get('framelix_alerts_hidden') || {};
        entries[hidable] = 1;
        FramelixLocalStorage.set('framelix_alerts_hidden', entries);
        FramelixToast.success($('.framelix-user-settings').length ? '__framelix_alert_hidden_backend__' : '__framelix_alert_hidden__');
        self.classList.add('hidden');
      });
    }
  }
}
window.customElements.define('framelix-alert', FramelixCustomElementAlert);
;
class FramelixCustomElementButton extends FramelixCustomElement {
  initialized = false;
  async updateDomContents() {
    super.updateDomContents();
    const self = this;
    const selfCash = $(this);
    const icon = this.getAttribute('icon');
    let disabled = this.hasAttribute('disabled');
    const bgcolor = this.getAttribute('bgcolor');
    const textcolor = this.getAttribute('textcolor');
    this.setAttribute('role', 'button');
    if (!disabled) {
      if (this.getAttribute('tabindex') === null) {
        this.setAttribute('tabindex', '0');
      }
    } else if (disabled) {
      this.removeAttribute('tabindex');
      this.removeAttribute('role');
    }
    if (!this.hasAttribute('raw')) {
      selfCash.empty();
      const contents = this.originalContents;
      if (icon) {
        selfCash.prepend('<div class="icon"><framelix-icon icon="' + icon + '"></framelix-icon></div>');
      }
      if (contents.length === 1 && contents[0].nodeType === Node.TEXT_NODE && contents[0].nodeValue.trim().startsWith('__')) {
        const value = contents[0].nodeValue.trim();
        selfCash.append('<label class="label">&nbsp;</label>');
        FramelixLang.get(value).then(value => {
          selfCash.find('label.label').html(value);
          this.toggleAttribute('haslabel', value.length > 0);
        });
      } else {
        selfCash.append($('<label class="label"></label>').append(contents));
        this.toggleAttribute('haslabel', selfCash.find('label.label').text().trim().length > 0);
      }
    }
    if (bgcolor) {
      self.style.backgroundColor = bgcolor;
      if (!textcolor) {
        self.style.color = FramelixColorUtils.invertColor(bgcolor);
      }
    }
    if (textcolor) {
      self.style.color = textcolor === 'invert' ? FramelixColorUtils.invertColor(getComputedStyle(self).backgroundColor, true) : textcolor;
    }
    if (this.hasAttribute('href')) {
      this.setAttribute('role', 'link');
    }
    if (!this.initialized) {
      this.initialized = true;
      this.addEventListener('click', async function (ev) {
        disabled = disabled = this.hasAttribute('disabled');
        if (disabled) {
          return;
        }
        const clickConfirmMessage = this.getAttribute('confirm-message');
        if (clickConfirmMessage) {
          if (!(await FramelixModal.confirm(await FramelixLang.get(clickConfirmMessage)).confirmed)) {
            return;
          }
        }
        const requestOptions = FramelixTypeDefJsRequestOptions.fromAttrValue(this.getAttribute('request-options'));
        if (requestOptions) {
          ev.stopPropagation();
          ev.preventDefault();
          self.setAttribute('disabled', '1');
          self.updateDomContents();
          FramelixRequest.renderFromRequestOptions(requestOptions, this, null, function (loaded) {
            if (loaded >= 1) {
              self.removeAttribute('disabled');
              self.updateDomContents();
            }
          });
          return;
        }
        const href = this.getAttribute('href');
        if (href) {
          ev.stopPropagation();
          ev.preventDefault();
          const target = this.getAttribute('target') || '_self';
          const link = $('<a>').attr('href', href).attr('target', target);
          link.css('display', 'hidden');
          $('body').append();
          link.trigger('click');
          setTimeout(function () {
            link.remove();
          }, 1000);
        }
      });
      this.addEventListener('keydown', function (ev) {
        if (ev.key === ' ' || ev.key === 'Enter') {
          $(self).trigger('click');
        }
      });
    }
  }
}
window.customElements.define('framelix-button', FramelixCustomElementButton);
;
class FramelixCustomElementIcon extends FramelixCustomElement {
  initialized = false;
  async updateDomContents() {
    super.updateDomContents();
    const icon = this.getAttribute('icon');
    const size = this.getAttribute('size');
    this.setAttribute('role', 'img');
    if (size) {
      this.style.fontSize = size.match(/[^0-9]/) ? size : size + 'px';
    }
    this.innerHTML = '&#xe' + icon + ';';
  }
}
window.customElements.define('framelix-icon', FramelixCustomElementIcon);
;
class FramelixCustomElementImage extends FramelixCustomElement {
  async updateDomContents() {
    super.updateDomContents();
    await Framelix.wait(FramelixRandom.getRandomInt(100, 200));
    const lazy = !this.getAttribute('nolazy');
    const self = this;
    function show() {
      const parent = self.parentElement;
      let parentWidth = parent.getBoundingClientRect().width;
      if (self.getAttribute('minwidth')) {
        parentWidth = Math.max(parseInt(self.getAttribute('minwidth')), parentWidth);
      }
      if (self.getAttribute('maxwidth')) {
        parentWidth = Math.min(parseInt(self.getAttribute('maxwidth')), parentWidth);
      }
      if (parentWidth <= 0) {
        return;
      }
      let useUrl = '';
      const sizeAttr = [];
      for (const attr of self.attributes) {
        if (attr.name.startsWith('size-')) {
          const size = parseInt(attr.name.substring(5));
          sizeAttr.push({
            'size': size,
            'url': attr.value
          });
          if (parentWidth > size || useUrl === '') {
            useUrl = attr.value;
          }
        }
      }
      sizeAttr.sort(function (a, b) {
        if (a.size > b.size) return 1;
        if (a.size < b.size) return -1;
        return 0;
      });
      for (const row of sizeAttr) {
        if (parentWidth > row.size || useUrl === '') {
          useUrl = row.url;
        } else if (parentWidth < row.size) {
          useUrl = row.url;
          break;
        }
      }
      if (useUrl === '') useUrl = self.getAttribute('src');
      function checkResize(el) {
        if (self.getAttribute('recalculate')) {
          setTimeout(function () {
            FramelixResizeObserver.observe(el, function () {
              FramelixResizeObserver.unobserve(el);
              show();
            });
          }, 500);
        }
      }
      if (self.getAttribute('setparent')) {
        parent.style.backgroundImage = 'url(' + useUrl + ')';
        checkResize(parent);
      } else {
        const img = document.createElement('img');
        self.innerHTML = ``;
        self.appendChild(img);
        img.src = useUrl;
        checkResize(img);
      }
    }
    console.log("show");
    if (!lazy) {
      show();
    } else {
      FramelixIntersectionObserver.onGetVisible(this, show);
    }
  }
}
window.customElements.define('framelix-image', FramelixCustomElementImage);
;
class FramelixCustomElementTime extends FramelixCustomElement {
  initialized = false;
  async updateDomContents() {
    super.updateDomContents();
    const self = this;
    const datetime = this.getAttribute('datetime');
    const format = this.getAttribute('format');
    this.innerHTML = '<time datetime="' + datetime + '">' + dayjs(datetime).format(format) + '</time>';
    if (!this.initialized) {
      this.initialized = true;
    }
  }
}
window.customElements.define('framelix-time', FramelixCustomElementTime);