<?php

namespace SunlightExtend\Phpmailer;

use Fosc\Feature\Plugin\Config\FieldGenerator;
use PHPMailer\PHPMailer\PHPMailer;
use Sunlight\Plugin\Action\ConfigAction as BaseConfigAction;
use Sunlight\Router;
use Sunlight\Settings;
use Sunlight\Util\ConfigurationFile;
use Sunlight\Util\Form;
use Sunlight\Util\Request;

class ConfigAction extends BaseConfigAction
{
    private const SMTP_SECURE_MODE = [
        'none' => 'none',
        PHPMailer::ENCRYPTION_STARTTLS => 'TLS',
        PHPMailer::ENCRYPTION_SMTPS => 'SSL',
    ];
    
    protected function getFields(): array
    {
        $config = $this->plugin->getConfig();

        $emailSetupLink = ' <a href="' . _e(Router::admin('settings', ['fragment' => 'settings_emails'])) . '" target="_blank" class="button"><img src="' . Router::path('admin/public/images/icons/action.png') . '" alt="setting" class="icon">' . _lang('phpmailer.config.email_setting') . '</a>';
        return [
            'use_smtp' => [
                'label' => _lang('phpmailer.config.use_smtp'),
                'input' => Form::input('checkbox', 'config[use_smtp]', '1', ['checked' => Form::loadCheckbox('config', $config['use_smtp'], 'use_smtp')]),
                'type' => 'checkbox'
            ],
            'smtp_secure' => [
                'label' => _lang('phpmailer.config.smtp_secure'),
                'input' => Form::select('config[smtp_secure]', self::SMTP_SECURE_MODE, $config['smtp_secure'], ['class' => 'inputsmall']),
            ],
            'smtp_auth' => [
                'label' => _lang('phpmailer.config.smtp_auth'),
                'input' => Form::input('checkbox', 'config[smtp_auth]', '1', ['checked' => Form::loadCheckbox('config', $config['smtp_auth'], 'smtp_auth')]),
                'type' => 'checkbox'
            ],
            'smtp_port' => [
                'label' => _lang('phpmailer.config.smtp_port'),
                'input' => Form::input('number', 'config[smtp_port]', Request::post('smtp_port', $config['smtp_port']), ['checked' => Form::loadCheckbox('config', $config['smtp_port'], 'smtp_port'), 'class' => 'inputmedium']),
                'type' => 'text'
            ],
            'smtp_host' => [
                'label' => _lang('phpmailer.config.smtp_host'),
                'input' => Form::input('text', 'config[smtp_host]', Request::post('smtp_host', $config['smtp_host']), ['checked' => Form::loadCheckbox('config', $config['smtp_host'], 'smtp_host'), 'class' => 'inputmedium']),
                'type' => 'text'
            ],
            'smtp_user' => [
                'label' => _lang('phpmailer.config.smtp_user'),
                'input' => Form::input('text', 'config[smtp_user]', Request::post('smtp_user', $config['smtp_user']), ['checked' => Form::loadCheckbox('config', $config['smtp_user'], 'smtp_user'), 'class' => 'inputmedium']),
                'type' => 'text'
            ],
            'smtp_pass' => [
                'label' => _lang('phpmailer.config.smtp_pass'),
                'input' => Form::input('password', 'config[smtp_pass]', Request::post('smtp_pass', $config['smtp_pass']), ['checked' => Form::loadCheckbox('config', $config['smtp_pass'], 'smtp_pass'), 'class' => 'inputmedium']),
                'type' => 'text'
            ],
            'sender_email' => [
                'label' => _lang('phpmailer.config.sender_email'),
                'input' => Form::input('text', 'config[sender_email]', Request::post('sender_email', Settings::get('sysmail')), ['checked' => false, 'class' => 'inputmedium', 'disabled' => true]) . $emailSetupLink,
                'type' => 'text'
            ],
            'sender_name' => [
                'label' => _lang('phpmailer.config.sender_name'),
                'input' => Form::input('text', 'config[sender_name]', Request::post('sender_name', $config['sender_name']), ['checked' => Form::loadCheckbox('config', $config['sender_name'], 'sender_name'), 'class' => 'inputmedium']),
                'type' => 'text'
            ],
            'smtp_auto_tls' => [
                'label' => _lang('phpmailer.config.smtp_auto_tls'),
                'input' => Form::input('checkbox', 'config[smtp_auto_tls]', '1', ['checked' => Form::loadCheckbox('config', $config['smtp_auto_tls'], 'smtp_auto_tls')]),
                'type' => 'checkbox'
            ]
        ];
    }

    protected function mapSubmittedValue(ConfigurationFile $config, string $key, array $field, $value): ?string
    {
        switch ($key) {
            case 'smtp_secure':
            case 'smtp_host':
            case 'smtp_user':
            case 'smtp_pass':
            case 'sender_name':
                $config[$key] = $value;
                return null;
            case 'sender_email':
                $config[$key] = null; // always set to null, the name from the system settings will be used
                return null;
        }
        return parent::mapSubmittedValue($config, $key, $field, $value); // TODO: Change the autogenerated stub
    }
}
