#ifndef POSTSERVERLOGIC_H
#define POSTSERVERLOGIC_H

#include "IBuffPacket.h"
#include "ClientCommand.h"
#include "IObject.h"

//ദ͸߼

#define SEND_BUFF_SIZE  MAX_BUFF_1024      //ͻС
#define RECV_BUFF_SIZE  MAX_BUFF_1024      //ջС

class CPostServerData : public IClientMessage
{
public:
    CPostServerData()
    {
        m_pServerObject      = NULL;
        m_u4ServerID         = 0;
        m_u4ConnectID        = 0;
        m_u2RecvBuffLength   = 0;
        m_u2SendBuffLength   = 0;
    }

    ~CPostServerData()
    {
        if(m_u4ServerID != 0)
        {
            Close(S2S_INNEED_CALLBACK);
        }
    }

    bool Need_Send_Format()
    {
        //Ҫ÷װﷵtrue
        //ҪĻﷵfalseSend_Format_dataͲᱻ
        return true;
    }

    //ڼ䷢ݵװ
    bool Send_Format_data(char* pData, uint32 u4Len, IMessageBlockManager* pMessageBlockManager, ACE_Message_Block*& mbSend)
    {
        //жϻǷڣ򷵻ʧ
        if(NULL == pMessageBlockManager)
        {
            return false;
        }

        //뷢͵ڴ
        mbSend = pMessageBlockManager->Create(u4Len);

        if(NULL == mbSend)
        {
            OUR_DEBUG((LM_INFO, "[CPostServerData::Send_Format_data](%d)Format Create Data NULL(%d) OK.\n", m_u4ConnectID, u4Len));
            return false;
        }

        //ҪװݣдĴ
        //ֻֻ򵥵ڴ濽ʾĲ
        memcpy_safe(pData, u4Len, mbSend->wr_ptr(), u4Len);
        mbSend->wr_ptr(u4Len);
        return true;
    }

    //ṩƴ㷨ݰRecvData
    bool Recv_Format_data(ACE_Message_Block* mbRecv, IMessageBlockManager* pMessageBlockManager, uint16& u2CommandID, ACE_Message_Block*& mbFinishRecv, EM_PACKET_ROUTE& emPacketRoute)
    {
        ACE_UNUSED_ARG(emPacketRoute);

        //жϷݿǷС8߳󻺳С
        if(m_u2RecvBuffLength + mbRecv->length() < 8 || mbRecv->length() >= RECV_BUFF_SIZE)
        {
            if(mbRecv->length() > 0)
            {
                ACE_OS::memcpy(&m_szRecvBuffData[m_u2RecvBuffLength], mbRecv->rd_ptr(), mbRecv->length());
                m_u2RecvBuffLength += (uint16)mbRecv->length();
                mbRecv->rd_ptr(mbRecv->length());
            }

            OUR_DEBUG((LM_INFO, "[CPostServerData::Recv_Format_data]Get Data(%d).\n", mbRecv->length()));
            return false;
        }
        else
        {
            //ͳһ뻺壬ли
            ACE_OS::memcpy(&m_szRecvBuffData[m_u2RecvBuffLength], mbRecv->rd_ptr(), mbRecv->length());
            m_u2RecvBuffLength += (uint16)mbRecv->length();
            mbRecv->rd_ptr(mbRecv->length());
        }

        //ֽڹ̶8ֽڣΪһ
        //㷨

        //һ8ֽڳݰ
        u2CommandID = 0x1010;
        mbFinishRecv = pMessageBlockManager->Create(8);

        //ݰ
        memcpy_safe(m_szRecvBuffData, 8, mbFinishRecv->wr_ptr(), 8);
        mbFinishRecv->wr_ptr(8);

        //ݻǰλ
        if(m_u2RecvBuffLength - 8 > 0)
        {
            memcpy_safe(&m_szRecvBuffData[8], m_u2RecvBuffLength - 8, m_szRecvBuffData, m_u2RecvBuffLength - 8);
            m_u2RecvBuffLength -= 8;
        }
        else
        {
            m_u2RecvBuffLength = 0;
        }

        return true;
    }

    bool RecvData(uint16 u2CommandID, ACE_Message_Block* mbRecv,  _ClientIPInfo const& objServerIPInfo)
    {
        //ݰѾȫ.͸ͻ
        //OUR_DEBUG((LM_INFO, "[CPostServerData::RecvData]Get Data(%d).\n", mbRecv->length()));
        if(NULL != m_pServerObject &&  mbRecv->length() > 0)
        {
            uint16 u2RetCommand = u2CommandID;
            uint32 u4PacketLength = 8;      //̶8ֽ
            char* pData = new char[u4PacketLength + sizeof(uint32)];
            ACE_OS::memcpy(pData, (char* )&u4PacketLength, sizeof(uint32));
            ACE_OS::memcpy(&pData[sizeof(uint32)], m_szRecvBuffData, u4PacketLength);

            uint32 u4SendLength = u4PacketLength + sizeof(uint32);

            const char* ptrReturnData = reinterpret_cast<const char*>(pData);
            m_pServerObject->GetConnectManager()->PostMessage(m_u4ConnectID,ptrReturnData,(uint32)u4SendLength, SENDMESSAGE_JAMPNOMAL, u2RetCommand, PACKET_SEND_IMMEDIATLY, PACKET_IS_SELF_RECYC);
            OUR_DEBUG((LM_INFO, "[CPostServerData::RecvData](%d)Send Data(%d) OK.\n", m_u4ConnectID, u4SendLength));
        }
        else
        {
            OUR_DEBUG((LM_INFO, "[CPostServerData::RecvData]Get packet error(%s:%d).\n", objServerIPInfo.m_szClientIP, objServerIPInfo.m_nPort));
        }

        return true;
    }

    //
    bool SendData(const char* pData, uint32 u4Size)
    {
        //ͳ
        if(m_u2SendBuffLength + u4Size >= MAX_BUFF_1024 || u4Size >= SEND_BUFF_SIZE)
        {
            OUR_DEBUG((LM_ERROR, "[CPostServerData::SendData](%d) send buff full.\n", m_u4ServerID));
            return false;
        }

        //õǰ״̬
        if(SERVER_CONNECT_OK == m_pServerObject->GetClientManager()->GetConnectState(m_u4ServerID))
        {
            //ݷ뻺壬֮ǰ(еĻ)һ
            ACE_OS::memcpy(&m_szSendBuffData[m_u2SendBuffLength], pData, u4Size);
            m_u2SendBuffLength += u4Size;

            //
            OUR_DEBUG((LM_ERROR, "[CPostServerData::SendData](%d) Send [%d] Begin.\n", m_u4ServerID, m_u2SendBuffLength));

            char* ptrReturnData = const_cast<char*>(m_szSendBuffData);

            if(false == m_pServerObject->GetClientManager()->SendData((int)m_u4ServerID, ptrReturnData, m_u2SendBuffLength, false))
            {
                //ʧܣ
                OUR_DEBUG((LM_ERROR, "[CPostServerData::SendData](%d) Send [%d] End 1.\n", m_u4ServerID, m_u2SendBuffLength));
                return false;
            }
            else
            {
                //ͳɹ
                OUR_DEBUG((LM_ERROR, "[CPostServerData::SendData](%d) Send [%d] End.\n", m_u4ServerID, m_u2SendBuffLength));
                m_u2SendBuffLength = 0;
                return true;
            }
        }
        else
        {
            OUR_DEBUG((LM_ERROR, "[CPostServerData::SendData](%d) Send Buffer.", m_u4ServerID));
            //δã뻺壬ӽԶص
            ACE_OS::memcpy(&m_szSendBuffData[m_u2SendBuffLength], pData, u4Size);
            m_u2SendBuffLength += u4Size;
            return true;
        }
    }

    //رԶ̷
    bool Close(EM_s2s ems2s)
    {
        m_pServerObject->GetClientManager()->Close(m_u4ServerID);
        m_u4ServerID = 0;
        return true;
    }

    bool ConnectError(int nError,  _ClientIPInfo const& objServerIPInfo)
    {
        OUR_DEBUG((LM_ERROR, "[CPostServerData::ConnectError]Get Error[%s:%d](%d).\n", objServerIPInfo.m_szClientIP, objServerIPInfo.m_nPort, nError));
        return true;
    }

    void ReConnect(int nServerID)
    {
        //ɹӿ
        //m_u4ServerID = (uint32)nServerID;
        OUR_DEBUG((LM_ERROR, "[CPostServerData::ReConnect]ReConnect(%d).\n", nServerID));

        if(m_u2SendBuffLength > 0)
        {
            char* ptrReturnData = m_szSendBuffData;

            //
            if(true == m_pServerObject->GetClientManager()->SendData((int)m_u4ServerID, ptrReturnData, m_u2SendBuffLength, false))
            {
                //ͳɹ
                m_u2SendBuffLength = 0;
            }
        }
    }

    CServerObject* GetServerObject()
    {
        return m_pServerObject;
    }

    void SetServerObject(CServerObject* pServerObject)
    {
        m_pServerObject = pServerObject;
    }

    void SetConnectID(uint32 u4ConnectID)
    {
        m_u4ConnectID = u4ConnectID;
    }

    void SetServerID(uint32 u4ServerID)
    {
        m_u4ServerID = u4ServerID;
    }

    uint32 GetServerID()
    {
        return m_u4ServerID;
    }

private:
    ACE_Recursive_Thread_Mutex m_ThreadLock;
    CServerObject*             m_pServerObject;
    uint32                     m_u4ServerID;
    uint32                     m_u4ConnectID;
    char                       m_szRecvBuffData[RECV_BUFF_SIZE];  //ջ
    char                       m_szSendBuffData[SEND_BUFF_SIZE];  //ͻ
    uint16                     m_u2RecvBuffLength;                //ջ峤
    uint16                     m_u2SendBuffLength;                //ͻ峤
};

#endif
