#include "BaseCommand.h"

CBaseCommand::CBaseCommand(void)
{
  m_pServerObject = NULL;
  m_nCount        = 0;
}

CBaseCommand::~CBaseCommand(void)
{
}

void CBaseCommand::SetServerObject(CServerObject* pServerObject)
{
  m_pServerObject = pServerObject;
}

int CBaseCommand::DoMessage(IMessage* pMessage, bool& bDeleteFlag)
{
  //__ENTER_FUNCTIONԶĺ׷tryĺ꣬ڲ׽ʹ__THROW_FUNCTION()׳Ĵ
  //__THROW_FUNCTION("hello"); ԶLogļµassert.log¼ļ
  //Ƽʹ꣬סһҪںĽʹ__LEAVE_FUNCTION__LEAVE_FUNCTION_WITHRETURN֮ԡ
  //__LEAVE_FUNCTION_WITHRETURN__LEAVE_FUNCTIONͬǰ߿ֺ֧˳ʱ򷵻һ
  //Ƿһint
  //ôĩβ__LEAVE_FUNCTION_WITHRETURN(0); 0ǷصintȻҲֱ֧ͱ忴Լĺ
  //καʹ__LEAVE_FUNCTIONɡ
  __ENTER_FUNCTION();

  if(m_pServerObject == NULL)
  {
    OUR_DEBUG((LM_ERROR, "[CBaseCommand::DoMessage] m_pServerObject is NULL(%d).\n", bDeleteFlag));
    return -1;
  }

  if(pMessage == NULL)
  {
    OUR_DEBUG((LM_ERROR, "[CBaseCommand::DoMessage] pMessage is NULL.\n"));
    return -1;
  }

  //ӽϢ
  if(pMessage->GetMessageBase()->m_u2Cmd == CLIENT_LINK_CONNECT)
  {
    OUR_DEBUG((LM_ERROR, "[CBaseCommand::DoMessage] CLIENT_LINK_CONNECT OK.\n"));
	Do_Proxy_Connect(pMessage);
    return 0;
  }

  //ӶϿϢ
  if(pMessage->GetMessageBase()->m_u2Cmd == CLIENT_LINK_CDISCONNET)
  {
    OUR_DEBUG((LM_ERROR, "[CBaseCommand::DoMessage] CLIENT_LINK_CDISCONNET OK.\n"));
	Do_Proxy_DisConnect(pMessage);
    return 0;
  }

  //Ϣ
  if(pMessage->GetMessageBase()->m_u2Cmd == COMMAND_PROXY)
  {
	  Do_Proxy_Data(pMessage);
  }

  return 0;

  __LEAVE_FUNCTION_WITHRETURN(0);
}

void CBaseCommand::Init()
{
	uint32 u4WorkThreadCount = m_pServerObject->GetMessageManager()->GetWorkThreadCount();
	OUR_DEBUG((LM_ERROR, "[CBaseCommand::DoMessage] WorkThread Count=%d.\n", u4WorkThreadCount));

	App_ProxyThreadManager::instance()->Init(u4WorkThreadCount);


}

void CBaseCommand::Do_Proxy_Connect(IMessage* pMessage)
{
	ACE_INET_Addr AddrProxyServer;
	AddrProxyServer.set((int)PROXY_SERVER_PORT, PROXY_SERVER_IP);

	//õǰĹ߳ID
	uint32 u4ThreadID = pMessage->GetMessageBase()->m_u4WorkThreadID;

	CProxyClient* pProxyClient = new CProxyClient();
	if(NULL == pProxyClient)
	{
		OUR_DEBUG((LM_ERROR, "[CBaseCommand::Do_Proxy_Connect]pProxyClient new is NULL.\n"));
		return;
	}

	//ùϵ
	pProxyClient->SetWorkThreadID(u4ThreadID);
	pProxyClient->SetServerObject(pMessage->GetMessageBase()->m_u4ConnectID, m_pServerObject);
	pProxyClient->reactor(App_ProxyThreadManager::instance()->GetProxyClientReactor(u4ThreadID));

	//Զ̷
	int nError = App_ProxyThreadManager::instance()->GetProxyClientConnector(u4ThreadID)->connect(pProxyClient, AddrProxyServer);
	if(nError != 0)
	{
		OUR_DEBUG((LM_ERROR, "[CBaseCommand::Do_Proxy_Connect]Connect Fail.\n"));
		return;
	}
}

void CBaseCommand::Do_Proxy_DisConnect( IMessage* pMessage )
{
	//õǰĹ߳ID
	uint32 u4ThreadID = pMessage->GetMessageBase()->m_u4WorkThreadID;

	CProxyClient* pProxyClient = App_ProxyThreadManager::instance()->GetProxyClientManager(u4ThreadID)->FindProxyClient(pMessage->GetMessageBase()->m_u4ConnectID);
	if(NULL != pProxyClient)
	{
		//ҪرԶ̵
		pProxyClient->Close();
	}
}

void CBaseCommand::Do_Proxy_Data( IMessage* pMessage )
{
	//õǰĹ߳ID
	uint32 u4ThreadID = pMessage->GetMessageBase()->m_u4WorkThreadID;

	CProxyClient* pProxyClient =  App_ProxyThreadManager::instance()->GetProxyClientManager(u4ThreadID)->FindProxyClient(pMessage->GetMessageBase()->m_u4ConnectID);
	if(NULL != pProxyClient)
	{
		_PacketInfo HeadPacket;
		_PacketInfo BodyPacket;
		pMessage->GetPacketHead(HeadPacket);
		pMessage->GetPacketBody(BodyPacket);

		char szPostData[MAX_RECV_BUFF] = {'\0'};
		int nSendSize = BodyPacket.m_nDataLen;

		if(nSendSize > MAX_RECV_BUFF)
		{
			OUR_DEBUG((LM_ERROR, "[CBaseCommand::Do_Proxy_Data]data is more than MAX_RECV_BUFF.\n"));
			return;
		}

		//װת
		ACE_OS::memcpy(szPostData, HeadPacket.m_pData, HeadPacket.m_nDataLen);	
		ACE_OS::memcpy(&szPostData[HeadPacket.m_nDataLen], BodyPacket.m_pData, BodyPacket.m_nDataLen);	

		pProxyClient->SendData(szPostData, BodyPacket.m_nDataLen + HeadPacket.m_nDataLen);
	}
	else
	{
		OUR_DEBUG((LM_ERROR, "[CBaseCommand::Do_Proxy_Data]pProxyClient is Lost.\n"));
	}
}