#include "UserValidManager.h"

CUserValidManager::CUserValidManager()
{

}

CUserValidManager::~CUserValidManager()
{
    Close();
}

bool CUserValidManager::Read_All_Init_DataResoure()
{
    //ļȡǰֵ֧û룬빲ڴȥ
    char szFileName[MAX_BUFF_200] = {'\0'};
    sprintf_safe(szFileName, MAX_BUFF_200, "%s", SOURCE_FILE_PATH);
    FILE* pFile = fopen((char* )szFileName, "r");

    if(pFile == NULL)
    {
        //ļ
        return false;
    }

    fseek(pFile, 0l, SEEK_END);

    uint32 u4FileSize = ftell(pFile);

    if(u4FileSize == 0)
    {
        //ļΪ0
        return false;
    }

    fclose(pFile);

    m_mapUserValid.clear();
    m_vecFreeValid.clear();

    pFile = fopen((char* )szFileName, "r");
    fseek(pFile, 0l, SEEK_SET);

    char* pFileBuffer = new char[u4FileSize + 1];
    memset(pFileBuffer, 0, u4FileSize);

    //ȡļ,һζѭֱȫΪֹ
    uint32 u4ReadSize = (uint32)fread((char* )pFileBuffer, sizeof(char), u4FileSize, pFile);

    if(u4ReadSize >= u4FileSize)
    {
        //
    }
    else if(u4ReadSize == 0)
    {
        //ȡļʧ
        SAFE_DELETE_ARRAY(pFileBuffer);
        fclose(pFile);
        return false;
    }

    ID_t nIndex = 1;
    char szUserName[MAX_BUFF_50] = {'\0'};
    char szUserPass[MAX_BUFF_50] = {'\0'};

    char szFind[2] = {'\0'};
    sprintf_safe(szFind, 2, ";");

    char* pLine = strtok((char* )pFileBuffer, szFind);

    while(pLine != NULL)
    {
        if(nIndex > (uint32)Get_Cache_Count())
        {
            break;
        }

        bool blState = GetFileInfo(pLine, szUserName, szUserPass);

        if(true == blState)
        {
            _UserValid* pUserValid = (_UserValid* )Get_CacheBlock_By_Index(nIndex);

            if(NULL != pUserValid)
            {
                //ʼID
                pUserValid->SetCacheIndex(nIndex);

                //ʼڴ
                sprintf_safe(pUserValid->m_szUserName, MAX_BUFF_50, "%s", szUserName);
                sprintf_safe(pUserValid->m_szUserPass, MAX_BUFF_50, "%s", szUserPass);

                //Lruб
                //ﲻüLruǷΪǵһμ
                //ᳬGet_Cache_Count()
                m_objLRU.Add_Cached_Lru((string)szUserName, pUserValid->GetCacheIndex());

                pUserValid->m_u4LoginCount  = 0;
                pUserValid->SetHit();

                string strUserName;
                strUserName = (string)pUserValid->m_szUserName;

                m_mapUserValid.insert(mapUserValid::value_type(strUserName, pUserValid));

                nIndex++;
            }
        }

        pLine = strtok(NULL, szFind);
    }

    //ʣµûʹõĹڴһ
    if(nIndex <= (uint32)Get_Cache_Count())
    {
        for(ID_t i = nIndex; i <= (ID_t)Get_Cache_Count(); i++)
        {
            _UserValid* pUserValid = (_UserValid* )Get_CacheBlock_By_Index(i);

            if(NULL != pUserValid)
            {
                pUserValid->m_u4LoginCount                 = 0;
                pUserValid->SetUnHit();

                m_vecFreeValid.push_back(pUserValid);
            }
        }
    }

    SAFE_DELETE_ARRAY(pFileBuffer);
    fclose(pFile);

    Set_Memory_Init_Success();

    return true;
}

bool CUserValidManager::GetFileInfo( const char* pLine, char* pUserName, char* pUserPass )
{
    bool blRet = false;

    int nSplit = 0;
    int nLineSize = (int)strlen(pLine);

    for(int i = 0; i < nLineSize; i++)
    {
        if(pLine[i] == ',')
        {
            nSplit = i;
        }
    }

    if(pLine[0] != 13)
    {
        ACE_OS::memcpy(pUserName, pLine, nSplit);
        pUserName[nSplit] = '\0';
        ACE_OS::memcpy(pUserPass, &pLine[nSplit + 1], nLineSize - nSplit - 1);
        pUserPass[nLineSize - nSplit - 1] = '\0';
    }
    else
    {
        ACE_OS::memcpy(pUserName, pLine + 1, nSplit - 1);
        pUserName[nSplit - 1] = '\0';
        ACE_OS::memcpy(pUserPass, &pLine[nSplit + 1], nLineSize - nSplit - 1);
        pUserPass[nLineSize - nSplit - 1] = '\0';
    }


    if(nSplit > 0)
    {
        blRet = true;
    }

    return blRet;
}

void CUserValidManager::Close()
{
    m_mapUserValid.clear();
    m_vecFreeValid.clear();
}

bool CUserValidManager::Read_All_From_CacheMemory()
{
    m_mapUserValid.clear();
    m_vecFreeValid.clear();

    for(uint32 i = 1; i <= Get_Cache_Count(); i++)
    {
        _UserValid* pUserValid = (_UserValid* )Get_CacheBlock_By_Index(i);

        if(NULL != pUserValid)
        {
            //ݲŲ뵱ǰб
            if(ACE_OS::strlen(pUserValid->m_szUserName) != 0
               && ACE_OS::strlen(pUserValid->m_szUserPass) != 0
               && pUserValid->GetDelete() == false)
            {

                //Lruб
                //ﲻüLruǷΪǵһδڴ
                //ᳬGet_Cache_Count()
                m_objLRU.Add_Cached_Lru((string)pUserValid->m_szUserName, pUserValid->GetCacheIndex());

                string strUserName = (string)pUserValid->m_szUserName;
                m_mapUserValid.insert(mapUserValid::value_type(strUserName, pUserValid));
            }
            else
            {
                //ڿеݿ飬һ
                m_vecFreeValid.push_back(pUserValid);
            }
        }
    }

#if 0
    //Դ
    string strData = "rabbit";
    mapUserValid::iterator f = m_mapUserValid.find(strData);

    if(f == m_mapUserValid.end())
    {
        OUR_DEBUG((LM_INFO, "no find.\n"));
    }
    else
    {
        OUR_DEBUG((LM_INFO, "find.\n"));
    }

#endif
    return true;
}

_UserValid* CUserValidManager::GetUserValid( const char* pUserName )
{
    string strUserName = (string)pUserName;
    mapUserValid::iterator f = m_mapUserValid.find(strUserName);

    if(f == m_mapUserValid.end())
    {
        return NULL;
    }
    else
    {
        string strMapUserName = (string)f->first;
        _UserValid* pUserValid = (_UserValid* )f->second;

        if(NULL != pUserValid)
        {
            if(strUserName != (string)pUserValid->m_szUserName || pUserValid->GetDelete() == true)
            {
                //˵ǰѾЧˣӵǰmap
                m_mapUserValid.erase(f);
                m_vecFreeValid.push_back(pUserValid);

                //ɾLru
                m_objLRU.Delete_Cached_Lru(strUserName);

                //ݲɾݣ¼ص
                if(pUserValid->GetDelete() == false)
                {
                    m_mapUserValid.insert(mapUserValid::value_type((string)pUserValid->m_szUserName, pUserValid));
                }

                return NULL;
            }
            else
            {
                //
                m_objLRU.Add_Cached_Lru(strUserName, pUserValid->GetCacheIndex());

                return pUserValid;
            }
        }
        else
        {
            return NULL;
        }

    }
}

void CUserValidManager::Sync_DataReaource_To_Memory()
{
    char szFileName[MAX_BUFF_200] = {'\0'};
    sprintf_safe(szFileName, MAX_BUFF_200, "%s", SOURCE_FILE_PATH);
    FILE* pFile = fopen((char* )szFileName, "r");

    if(pFile == NULL)
    {
        //ļ
        return;
    }

    fseek(pFile, 0l, SEEK_END);

    uint32 u4FileSize = ftell(pFile);

    if(u4FileSize == 0)
    {
        //ļΪ0
        return;
    }

    fclose(pFile);

    //m_mapUserValid.clear();
    //m_vecFreeValid.clear();

    pFile = fopen((char* )szFileName, "r");
    fseek(pFile, 0l, SEEK_SET);

    char* pFileBuffer = new char[u4FileSize + 1];
    memset(pFileBuffer, 0, u4FileSize);

    //ȡļ,һζѭֱȫΪֹ
    uint32 u4ReadSize = (uint32)fread((char* )pFileBuffer, sizeof(char), u4FileSize, pFile);

    if(u4ReadSize >= u4FileSize)
    {
        //
    }
    else if(u4ReadSize == 0)
    {
        //ȡļʧ
        SAFE_DELETE_ARRAY(pFileBuffer);
        fclose(pFile);
        return;
    }

    char szUserName[MAX_BUFF_50] = {'\0'};
    char szUserPass[MAX_BUFF_50] = {'\0'};

    char szFind[2] = {'\0'};
    sprintf_safe(szFind, 2, ";");

    char* pLine = strtok((char* )pFileBuffer, szFind);

    Begin_Sync_DataReaource_To_Memory();

    while(pLine != NULL)
    {
        bool blState = GetFileInfo(pLine, szUserName, szUserPass);

        if(true == blState)
        {
            _UserValid* pUserValid = (_UserValid* )GetUserValid(szUserName);

            if(NULL != pUserValid)
            {
                //ʼڴ
                sprintf_safe(pUserValid->m_szUserName, MAX_BUFF_50, "%s", szUserName);
                sprintf_safe(pUserValid->m_szUserPass, MAX_BUFF_50, "%s", szUserPass);
                pUserValid->SetHit();
            }
            else
            {
                //ûУݣӿгȡݷ
                if(m_vecFreeValid.size() <= 0)
                {
                    //гѾûˣƳ
                    pLine = strtok(NULL, szFind);
                    continue;
                }

                _UserValid* pUserValid = (_UserValid* )m_vecFreeValid[0];

                if(NULL != pUserValid)
                {
                    //ʼڴ
                    sprintf_safe(pUserValid->m_szUserName, MAX_BUFF_50, "%s", szUserName);
                    sprintf_safe(pUserValid->m_szUserPass, MAX_BUFF_50, "%s", szUserPass);

                    pUserValid->m_u4LoginCount                 = 0;
                    pUserValid->SetHit();

                    string strUserName;
                    strUserName = (string)pUserValid->m_szUserName;

                    m_mapUserValid.insert(mapUserValid::value_type(strUserName, pUserValid));

                    vecValid::iterator b = m_vecFreeValid.begin();
                    m_vecFreeValid.erase(b);
                }
            }
        }

        pLine = strtok(NULL, szFind);
    }

    End_Sync_DataReaource_To_Memory();

    SAFE_DELETE_ARRAY(pFileBuffer);
    fclose(pFile);
}

void CUserValidManager::Begin_Sync_DataReaource_To_Memory()
{
    for(mapUserValid::iterator b = m_mapUserValid.begin(); b != m_mapUserValid.end(); b++)
    {
        _UserValid* pUserValid = (_UserValid* )b->second;

        if(NULL != pUserValid)
        {
            pUserValid->SetCheckState(CHECKS_UNHIT);
        }
    }
}

void CUserValidManager::End_Sync_DataReaource_To_Memory()
{
    for(mapUserValid::iterator b = m_mapUserValid.begin(); b != m_mapUserValid.end();)
    {
        _UserValid* pUserValid = (_UserValid* )b->second;

        if(NULL != pUserValid)
        {
            if(pUserValid->GetCheckState() != CHECKS_HIT)
            {
                //˵Ѿڱвˣ֮
                pUserValid->SetDelete(true);

                //Lruɾ
                m_objLRU.Delete_Cached_Lru((string)pUserValid->m_szUserName);

                m_mapUserValid.erase(b++);
                m_vecFreeValid.push_back(pUserValid);
            }
            else
            {
                b++;
            }
        }
    }

    OUR_DEBUG((LM_INFO, "[CUserValidManager::EndCheck]map is(%d), free is (%d).\n", m_mapUserValid.size(), m_vecFreeValid.size()));
}

void CUserValidManager::GetFreeValid()
{
    //ǰmapڣȥڴѰңпܴӺ̨Ѿؽˡ
    //mapWatchļǲһµģǰҲȥǰΪеȥѰҡ
    for(uint32 i = 0; i < (uint32)m_vecFreeValid.size(); i++)
    {
        if(m_vecFreeValid[i]->GetDelete() == false)
        {
            mapUserValid::iterator f = m_mapUserValid.find((string)m_vecFreeValid[i]->m_szUserName);

            if(f == m_mapUserValid.end())
            {
                m_mapUserValid.insert(mapUserValid::value_type((string)m_vecFreeValid[i]->m_szUserName, (_UserValid* )m_vecFreeValid[i]));
            }
        }
    }

    for(vecValid::iterator b = m_vecFreeValid.begin(); b != m_vecFreeValid.end();)
    {
        _UserValid* pUserValid = (_UserValid* )(*b);

        if(pUserValid->GetDelete() == false)
        {
            b = m_vecFreeValid.erase(b);
        }
        else
        {
            b++;
        }
    }
}

bool CUserValidManager::Load_From_DataResouce(const char* pUserName, uint32& u4CacheIndex)
{
    u4CacheIndex = 0;
    char szFileName[MAX_BUFF_200] = {'\0'};
    sprintf_safe(szFileName, MAX_BUFF_200, "%s", SOURCE_FILE_PATH);
    FILE* pFile = fopen((char* )szFileName, "r");

    if(pFile == NULL)
    {
        //ļ
        return false;
    }

    fseek(pFile, 0l, SEEK_END);

    uint32 u4FileSize = ftell(pFile);

    if(u4FileSize == 0)
    {
        //ļΪ0
        return false;
    }

    fclose(pFile);

    //m_mapUserValid.clear();
    //m_vecFreeValid.clear();

    pFile = fopen((char* )szFileName, "r");
    fseek(pFile, 0l, SEEK_SET);

    char* pFileBuffer = new char[u4FileSize + 1];
    memset(pFileBuffer, 0, u4FileSize);

    //ȡļ,һζѭֱȫΪֹ
    uint32 u4ReadSize = (uint32)fread((char* )pFileBuffer, sizeof(char), u4FileSize, pFile);

    if(u4ReadSize >= u4FileSize)
    {
        //
    }
    else if(u4ReadSize == 0)
    {
        //ȡļʧ
        SAFE_DELETE_ARRAY(pFileBuffer);
        fclose(pFile);
        return false;
    }

    char szUserName[MAX_BUFF_50] = {'\0'};
    char szUserPass[MAX_BUFF_50] = {'\0'};

    char szFind[2] = {'\0'};
    sprintf_safe(szFind, 2, ";");

    char* pLine = strtok((char* )pFileBuffer, szFind);

    while(pLine != NULL)
    {
        bool blState = GetFileInfo(pLine, szUserName, szUserPass);

        //ԴѰָûڹڴ
        if(true == blState && ACE_OS::strcmp(szUserName, pUserName) == 0)
        {
            _UserValid* pUserValid = (_UserValid* )GetUserValid(szUserName);

            if(NULL != pUserValid)
            {
                //ʼڴ
                sprintf_safe(pUserValid->m_szUserName, MAX_BUFF_50, "%s", szUserName);
                sprintf_safe(pUserValid->m_szUserPass, MAX_BUFF_50, "%s", szUserPass);
                pUserValid->SetHit();
                pUserValid->m_u4LoginCount                 = 0;
            }
            else
            {
                //ûУݣӿгȡݷ
                if(m_vecFreeValid.size() <= 0)
                {
                    //гѾˣ̭ʱδʵ
                    string strUserName;
                    bool blIsLast = m_objLRU.Check_Cached_Lru(strUserName);

                    if(blIsLast == false)
                    {
                        //ûҵ̭ݣ϶ǲϷġ
                        SAFE_DELETE_ARRAY(pFileBuffer);
                        fclose(pFile);
                        return false;
                    }

                    mapUserValid::iterator f = m_mapUserValid.find(strUserName);

                    if(f == m_mapUserValid.end())
                    {
                        SAFE_DELETE_ARRAY(pFileBuffer);
                        fclose(pFile);
                        return false;
                    }
                    else
                    {
                        _UserValid* pUserValid = (_UserValid* )f->second;

                        //LRU滻֮
                        m_objLRU.Delete_Cached_Lru(strUserName);
                        m_objLRU.Add_Cached_Lru((string)pUserName, pUserValid->GetCacheIndex());

                        m_mapUserValid.erase(f);

                        //ʼڴ
                        sprintf_safe(pUserValid->m_szUserName, MAX_BUFF_50, "%s", szUserName);
                        sprintf_safe(pUserValid->m_szUserPass, MAX_BUFF_50, "%s", szUserPass);
                        pUserValid->SetHit();
                        pUserValid->m_u4LoginCount                 = 0;

                        string strUserNewName;
                        strUserNewName = (string)pUserValid->m_szUserName;

                        m_mapUserValid.insert(mapUserValid::value_type(strUserNewName, pUserValid));
                        u4CacheIndex = pUserValid->GetCacheIndex();
                    }
                }
                else
                {
                    _UserValid* pUserValid = (_UserValid* )m_vecFreeValid[0];

                    if(NULL != pUserValid)
                    {
                        //ʼڴ
                        sprintf_safe(pUserValid->m_szUserName, MAX_BUFF_50, "%s", szUserName);
                        sprintf_safe(pUserValid->m_szUserPass, MAX_BUFF_50, "%s", szUserPass);
                        pUserValid->SetHit();
                        pUserValid->m_u4LoginCount                 = 0;

                        string strUserName;
                        strUserName = (string)pUserValid->m_szUserName;

                        m_mapUserValid.insert(mapUserValid::value_type(strUserName, pUserValid));

                        vecValid::iterator b = m_vecFreeValid.begin();
                        m_vecFreeValid.erase(b);
                    }
                }
            }

            break;
        }

        pLine = strtok(NULL, szFind);
    }

    SAFE_DELETE_ARRAY(pFileBuffer);
    fclose(pFile);

    Display();

    return true;
}

bool CUserValidManager::Init(uint32 u4CachedCount, key_t objMemorykey, uint32 u4CheckSize)
{
    //Lru
    m_objLRU.Set_Lru_Max_Count(u4CachedCount);

    //ø෽
    return CCacheManager::Init(u4CachedCount, objMemorykey, u4CheckSize);
}

void CUserValidManager::Display()
{
    OUR_DEBUG((LM_INFO, "[CUserValidManager::Display]m_mapUserValid count=%d, m_vecFreeValid=%d.\n", m_mapUserValid.size(), m_vecFreeValid.size()));

    for(mapUserValid::iterator b = m_mapUserValid.begin(); b!= m_mapUserValid.end(); b++)
    {
        _UserValid* pUserValid = (_UserValid* )b->second;

        OUR_DEBUG((LM_INFO, "[CUserValidManager::Display]UserName=%s.\n", pUserValid->m_szUserName));
    }
}

bool CUserValidManager::Reload_Map_CacheMemory(uint32 u4CacheIndex)
{
    string strOldUserName;

    m_objLRU.Get_Cached_KeyByIndex(u4CacheIndex, strOldUserName);

    mapUserValid::iterator f = m_mapUserValid.find(strOldUserName);

    if(f != m_mapUserValid.end())
    {
        _UserValid* pUserValid = (_UserValid* )f->second;

        //IndexбӦϵ
        m_objLRU.Reload_Cached_IndexList((string)pUserValid->m_szUserName, strOldUserName, u4CacheIndex);

        m_mapUserValid.erase(f);
        m_mapUserValid.insert(mapUserValid::value_type((string)pUserValid->m_szUserName, pUserValid));
        return true;
    }
    else
    {
        return false;
    }
}
