#ifndef _USERINFOMANAGER_H
#define _USERINFOMANAGER_H

#include "CacheManager.h"
#include <string>
#include <iostream>

//û
//add by freeeyes
#ifdef WIN32
#define SHM_USERINFO_KEY (key_t) "67892"
#define PRINTF printf_s
#else
#define SHM_USERINFO_KEY (key_t) 67892
#define PRINTF printf
#endif

#define MAX_LOGIN_VALID_COUNT  10
#define SOURCE_FILE_INFO_PATH "./LoginBufferFile/UserLogin.txt"

//û幦ܣ̳_CacheBlock
struct _UserInfo : public _CacheBlock
{
    //ݽṹ
    uint32 m_u4UserID;      //ûID
    uint32 m_u4Life;        //life
    uint32 m_u4Magic;       //magic

    _UserInfo()
    {
        m_u4UserID = 0;
        m_u4Life   = 0;
        m_u4Magic  = 0;
    }
};

typedef vector<_UserInfo*> vecUserInfo;          //δʹõvecValid
typedef map<uint32, _UserInfo*> mapUserInfo;     //ʹõvecValid

class CUserInfoManager : public CCacheManager
{
public:
    CUserInfoManager();
    ~CUserInfoManager();

    void Close();
    void Display();

    bool Init(uint32 u4CachedCount, key_t objMemorykey, uint32 u4CheckSize);

    _UserInfo* GetUserInfo(uint32 u4UserID);            //Ƶõû״̬
    void Sync_Memory_To_DataReaource();                 //ͬļ͹ڴ
    void GetFreeUserInfo();                             //ӿݿѰѾ¼ص

    bool Load_From_DataResouce(uint32 u4SeachUserID, uint32& u4CacheIndex);    //ļѰָû

    bool Reload_Map_CacheMemory(uint32 u4CacheIndex);     //ָcachedλõݵmapӳ

private:
    bool Read_All_Init_DataResoure();         //ļعڴ棬б
    bool Read_All_From_CacheMemory();         //ӹڴб
    void Begin_Sync_DataReaource_To_Memory(); //ʼͬ
    void End_Sync_DataReaource_To_Memory();   //ͬ
    bool GetFileInfo(const char* pLine, uint32& u4UserID, uint32& u4Life, uint32& u4Magic); //ļͬ
    bool WriteFileInfo(FILE* pFile, _UserInfo* pUserInfo);

private:
    mapUserInfo             m_mapUserInfo;
    vecUserInfo             m_vecFreeUserInfo;
    CCachedLRUList<uint32>  m_objLRU;
};


#endif
