#pragma once

#include "IBuffPacket.h"
#include "ClientCommand.h"
#include "IObject.h"
#include "DirView.h"

#include <string>
#include <map>

//ͻ(TCP)
#define COMMAND_LOGIN                  0x2000     //½
#define COMMAND_LOGOUT                 0x2001     //˳ 
#define COMMAND_FILELIST               0x2002     //ļļб
#define COMMAND_FILE_DOWNLOAD          0x2003     //ļ
#define COMMAND_FILE_UPLOAD            0x2004     //ļϴ
#define COMMAND_RETURN_LOGIN           0xe000     //½Ӧ 
#define COMMAND_RETURN_LOGOUT          0xe001     //ǳӦ
#define COMMAND_RETURN_FILELIST        0xe002     //ļļбӦ
#define COMMAND_RETURN_FILE_DOWNLOAD   0xe003     //ļ
#define COMMAND_RETURN_FILE_UPLOAD     0xe004     //ļϴ

//峣ñ
#define LOGIN_SUCCESS            0
#define LOGIN_FAIL_NOEXIST       1
#define LOGIN_FAIL_ONLINE        2
#define LOGIN_FAIL_PASSWORD      3

#define OP_OK                    0
#define OP_FAIL                  1

using namespace std;

//û½ṹ
struct _UserInfo
{
    char   m_szUserPass[MAX_BUFF_100];   //û
    bool   m_blOnline;                   //Ƿ falseΪߣtrueΪ
    uint32 m_u4ConnectID;                //ConnectID

    _UserInfo()
    {
        m_szUserPass[0] = '\0';
        m_blOnline      = false;
        m_u4ConnectID   = 0;
    }
};


typedef map<string, _UserInfo*> mapUserList; //ûб

class CBaseCommand : public CClientCommand
{
public:
    CBaseCommand(void);
    ~CBaseCommand(void);

    void InitUserList();
    void ClearUserList();
    int DoMessage(IMessage* pMessage, bool& bDeleteFlag);
    void SetServerObject(CServerObject* pServerObject);

private:
    int  CheckFtpUser(const char* pUserName, const char* pUserPass, uint32 u4ConnectID);  //˺
    void LeaveFtpUser(uint32 u4ConnectID);        //ӶϿʱ˳¼״̬
    void LeaveFtpUser(const char* pUserName);     //ûǳʱ˳¼״̬
    bool CheckOnlineUser(const char* pUserName, uint32 u4ConnectID);  //ȽûǷвȨ

    void Do_Ftp_Login(IMessage* pMessage);        //½
    void Do_Ftp_Logout(IMessage* pMessage);       //ǳ
    void Do_Ftp_FileList(IMessage* pMessage);     //ļб
    void Do_Ftp_FileDownLoad(IMessage* pMessage); //ļ
    void Do_Ftp_FileUpLoad(IMessage* pMessage);   //ļϴ

private:
    CServerObject* m_pServerObject;
    mapUserList    m_mapUserList;                   //ûб
};

