/*
 * WaitQuitSignal.cpp
 *
 * Linuxµ߳ʵ(light weighted process),߳ʱɶӦĽ̿ƽṹ
 * ֻǸýṹ븸̵߳Ľ̿ƽṹͬһڴռ䡣 ͬʱ̵߳Ľ̿ƽṹӸ̣̣߳
 * ƵõͬĽϢļбźȡ֮߳޸ź
 * 룬˿߳ʹõ߳ԭеĽϢ߳ȻSIGINTSIGTERMźŽзӦ˵
 * Ctrl+C SIGINTźŵʱ̲źţӽ̣̣߳Ĭϴ˳
 * ӽ˳ͬʱ򸸽̣̣߳SIGCHLDźţʾӽ˳ڸźûб˻ᵼ
 * ̣̣߳Ҳ˳ǰһ߳ǰźã
 * ߳ڲźá
 *  Created on: Aug 14, 2011
 *      Author: xian0617
 */

#ifndef WIN32
#include <iostream>
#include "WaitQuitSignal.h"
#include "ServerManager.h"

sigset_t WaitQuitSignal::m_wait_mask;
struct timespec WaitQuitSignal::m_time;

void WaitQuitSignal::init()
{
    sigemptyset(&m_wait_mask);
    sigaddset(&m_wait_mask, SIGINT);
    sigaddset(&m_wait_mask, SIGQUIT);
    sigaddset(&m_wait_mask, SIGTERM);
    sigaddset(&m_wait_mask, SIGKILL);
    pthread_sigmask(SIG_BLOCK, &m_wait_mask, nullptr);

    m_time.tv_sec  = 0;
    m_time.tv_nsec = 0;
}
bool WaitQuitSignal::wait(bool& blFlag)
{
    siginfo_t sig ;

    switch(sigtimedwait(&m_wait_mask,&sig,&m_time))
    {
    case SIGKILL:
    case SIGINT:
    case SIGQUIT:
    case SIGTERM:
        App_ServerManager::instance()->Close();
        blFlag = false;
        break;

    default:
        break;
    }

    return blFlag;
}
#endif
