#ifndef _PROTTYCLIENTMANAGER_H
#define _PROTTYCLIENTMANAGER_H

//TTy豸Proactorʵ
//add by freeeyes

#include "ITTyClientManager.h"
#include "ReTTyHandler.h"
#include "HashTable.h"
#include "XmlConfig.h"
#include "TimerManager.hpp"

class CReTTyClientManager : public ITTyClientManager
{
public:
    CReTTyClientManager();
    virtual ~CReTTyClientManager();

    bool StartConnectTask();                                                                             //ʱ
    void CancelConnectTask();                                                                            //رնʱ

    bool Init(ACE_Reactor* pReactor, uint16 u2MaxTTyCount, uint16 u2TimeCheck);                          //ʼ
    void Close();                                                                                        //ر

    int Connect(uint16 u2ConnectID, const char* pName, _TTyDevParam& inParam, ITTyMessage* pMessageRecv) final;  // ӣ򿪣˿
    int ConnectFrame(uint16 u2ConnectID, const char* pName, _TTyDevParam& inParam, uint32 u4PacketParseID) final;    // ӣ򿪣˿

    bool GetClientDevInfo(uint16 u2ConnectID, _TTyDevParam& outParam) final;                           // ȡϢ
    bool IsConnect(uint16 u2ConnectID) final;                                                          // Ƿӣ򿪣״̬

    bool Close(uint16 u2ConnectID) final;                                                              // رն˿
    bool Pause(uint16 u2ConnectID) final;                                                              // ͣ˿
    bool Resume(uint16 u2ConnectID) final;                                                             // ָͣ˿

    bool SendMessage(uint16 u2ConnectID, char*& pMessage, uint32 u4Len) final;                         // 

    int timer_task(brynet::TimerMgr::Ptr timerMgr);
    void start_new_task(brynet::TimerMgr::Ptr timerMgr);

private:
    CHashTable<CReTTyHandler> m_objTTyClientHandlerList;                         //豸б
    ACE_Recursive_Thread_Mutex m_ThreadWritrLock;                                //߳
    ACE_Reactor*               m_pReactor       = nullptr;                       //Ӧ
    uint16                     m_u2MaxListCount = MAX_BUFF_100;                  //豸
    uint16                     m_u2TimeCheck    = 120;                           //ʱʱ
    bool                       m_blTimerState   = true;                          //ʱ
};

using App_ReTTyClientManager = PSS_singleton<CReTTyClientManager>;

#endif
