
// ConnectHandle.h
// ͻ
// ܶʱ䣬ˣˡûʲôںý
// 2009Ĵһټ˼άϵĶļ̳
// ңЩѣҲںΪ֪ĵ·Ӳƽ̹¿ʼΪܸеҵ
// ӶݰĹܿء
// add by freeeyes
// 2008-12-22

#ifndef _CONNECTHANDLE_H
#define _CONNECTHANDLE_H

#include "ace/Reactor.h"
#include "ace/Svc_Handler.h"
#include "ace/Synch.h"
#include "ace/SOCK_Acceptor.h"
#include "ace/Reactor_Notification_Strategy.h"

#include "BaseTask.h"
#include "ObjectArrayList.h"
#include "HashTable.h"
#include "AceReactorManager.h"
#include "MessageService.h"
#include "IConnectManager.h"
#include "BaseHander.h"
#include "BuffPacketManager.h"
#include "ForbiddenIP.h"
#include "IPAccount.h"
#include "TimerManager.hpp"
#include "SendMessage.h"
#include "CommandAccount.h"
#include "TimeWheelLink.h"
#include "FileTest.h"
#include "TcpRedirection.h"
#include "PerformanceCounter.h"
#include "ConnectCounter.h"

#if PSS_PLATFORM != PLATFORM_WIN
#include "netinet/tcp.h"
#endif

class CConnectHandler : public ACE_Svc_Handler<ACE_SOCK_STREAM, ACE_MT_SYNCH>, public IHandler
{
public:
    CConnectHandler(void) = default;

    //д̳з
    int open(void*) final;                                                 //ûһ
    int handle_input(ACE_HANDLE fd = ACE_INVALID_HANDLE) final;            //ܿͻյݿ
    int handle_output(ACE_HANDLE fd = ACE_INVALID_HANDLE) final;           //Ϳͻ
    int handle_close(ACE_HANDLE h, ACE_Reactor_Mask mask) final;           //ӹر¼
    bool Device_Send_Data(const char* pData, ssize_t nLen) final;          //͸ݽӿ

    uint32 file_open(const IFileTestManager* pFileTest) const;                               //ļڴ򿪽ӿ
    int handle_write_file_stream(const char* pData, uint32 u4Size, uint8 u1ParseID) const;   //ļӿģݰ

    void Init(uint16 u2HandlerID);                                           //Connect Poolʼʱõķ
    void SetPacketParseInfoID(uint32 u4PacketParseInfoID);                   //öӦm_u4PacketParseInfoID
    uint32 GetPacketParseInfoID() const;                                     //Ӧm_u4PacketParseInfoID


    bool CheckSendMask(uint32 u4PacketLen) const;                            //ָӷǷ񳬹ֵ
    bool SendMessage(const CSendMessageInfo& objSendMessageInfo, uint32& u4PacketSize) final;  //͵ǰ

    bool SendTimeoutMessage();                                               //ӳʱϢ

    void SetLocalIPInfo(const char* pLocalIP, uint16 u2LocalPort);           //üIPͶ˿Ϣ

    void Close(uint32 u4ConnectID) final;                                    //رյǰ
    void CloseFinally();                                                     //roz

    uint32      GetHandlerID() const;                                        //õǰhandlerID
    void        SetConnectID(uint32 u4ConnectID);                            //õǰID
    uint32      GetConnectID() const;                                        //õǰID
    CONNECTSTATE       GetConnectState() const;                              //õ״̬
    CONNECTSTATE       GetSendBuffState() const;                             //õ״̬
    _ClientConnectInfo GetClientInfo() const;                                //õͻϢ
    _ClientIPInfo      GetClientIPInfo() const;                              //õͻIPϢ
    _ClientIPInfo      GetLocalIPInfo() const;                               //õIPϢ
    void SetConnectName(const char* pName);                                  //õǰ
    const char* GetConnectName() const;                                      //õ
    void SetIsLog(bool blIsLog) final;                                       //õǰǷд־
    bool GetIsLog() const;                                                   //õǰǷд־
    void SetHashID(int nHashID);                                             //Hash±
    int  GetHashID() const;                                                  //õHash±

    bool Write_SendData_To_File(bool blDelete, shared_ptr<IBuffPacket> pBuffPacket);                              //дļ
    bool Send_Input_To_Cache(const CSendMessageInfo& objSendMessageInfo, uint32& u4PacketSize);               //Ͷ뻺
    bool Send_Input_To_TCP(const CSendMessageInfo& objSendMessageInfo, uint32& u4PacketSize);                 //ݷ͸Զ
    bool PutSendPacket(uint32 u4ConnectID, ACE_Message_Block* pMbData, uint32 u4Size, const PSS_Time_Point& tvSend) final;//

private:
    ENUM_WHILE_STATE Recv_Packet_Cut(bool& blRet);                           //а
	bool Dispose_Recv_buffer();                                              //յݣа
	void Move_Recv_buffer();                                                 //ڴ滺
    void Send_Hander_Event(uint8 u1Option);                                  //Handler¼֪ͨҵ߳
    void ConnectOpen();                                                      //ش򿪴
    uint32 Get_Recv_length() const;                                          //õҪݳ
    int  Dispose_Paceket_Parse_Head(ACE_Message_Block* pmbHead);             //Ϣͷ
    int  Dispose_Paceket_Parse_Body(ACE_Message_Block* pmbBody, uint32 u4SrcBodyLength); //Ϣͷ
    int  Dispose_Paceket_Parse_Stream(ACE_Message_Block* pCurrMessage);      //Ϣ
    bool CheckMessage();                                                     //յ
    
    void ClearPacketParse();                                                 //ʹõPacketParse

    int  Dispose_Paceket_Parse_Stream_Single(ACE_Message_Block* pCurrMessage);//һݰ

    int  Dispose_Recv_Data();                                                 //
    int  Init_Open_Connect();                                                 //һνӳʼʱ

    uint32                     m_u4HandlerID          = 0;                     //HanderʱID
    uint32                     m_u4ConnectID          = 0;                     //ӵID
    uint32                     m_u4AllRecvSize        = 0;                     //ǰӽֽ
    uint32                     m_u4AllSendSize        = 0;                     //ǰӷֽ
    uint32                     m_u4MaxPacketSize      = MAX_MSG_PACKETLENGTH;  //ݰ󳤶
    uint32                     m_u4SendMaxBuffSize    = 5 * MAX_BUFF_1024;     //󻺳峤
    uint16                     m_u2LocalPort          = 0;                     //Ķ˿ں
    uint32                     m_u4PacketParseInfoID  = 0;                     //ӦpacketParseģID
    uint32                     m_u4CurrSize           = 0;                     //ǰMBַ
    uint32                     m_u4PacketDebugSize    = 0;                     //¼ܴݰֽ
    int                        m_nHashID              = 0;                     //ӦPoolHash±
    uint16                     m_u2MaxConnectTime     = 0;                     //ʱж
    uint16                     m_u2TcpNodelay         = TCP_NODELAY_ON;        //Nagle㷨
    CONNECTSTATE               m_u1ConnectState       = CONNECTSTATE::CONNECT_INIT;          //ĿǰӴ״̬
    CONNECTSTATE               m_u1SendBuffState      = CONNECTSTATE::CONNECT_SENDNON;       //ĿǰǷеȴ͵
    bool                       m_blBlockState         = false;                 //Ƿ״̬ falseΪ״̬trueΪ״̬
    bool                       m_blIsLog              = false;                 //Ƿд־falseΪд룬trueΪд
    string                     m_strLocalIP;                                   //صIP˿
    string                     m_strConnectName;                               //ƣԿŸ߼ȥ
    ACE_INET_Addr              m_addrRemote;                                   //Զӿͻ˵ַ
    ACE_INET_Addr              m_addrLocal;                                    //Զӿͻ˵ַ
    PSS_Time_Point             m_atvConnect;                                   //ǰӽʱ
    PSS_Time_Point             m_atvInput;                                     //һνʱ
    PSS_Time_Point             m_atvOutput;                                    //һηʱ
    shared_ptr<CPacketParse>   m_pPacketParse;                               //ݰ
    ACE_Message_Block*         m_pBlockRecv           = nullptr;               //ݻ
    ACE_Message_Block*         m_pBlockMessage        = nullptr;               //ǰͻȴݿ
    EM_IO_TYPE                 m_emIOType             = EM_IO_TYPE::NET_INPUT; //ǰIO
    IFileTestManager*          m_pFileTest            = nullptr;               //ļԽӿ
    string                     m_strDeviceName;                                //תӿ
    CMakePacket                m_MakePacket;                                   //߳Ϣ 
    shared_ptr<_Packet_Parse_Info> m_pPacketParseInfo     = nullptr;           //PacketParseĽ
    
};

//ConnectHandlerڴ
class CConnectHandlerPool
{
public:
    CConnectHandlerPool(void) = default;

    void Init(int nObjcetCount);
    void Close();

    CConnectHandler* Create();
    bool Delete(CConnectHandler* pObject);

    int GetUsedCount();
    int GetFreeCount();

private:
    ACE_Recursive_Thread_Mutex        m_ThreadWriteLock;                     //ƶ߳
    CHashTable<CConnectHandler>       m_objHashHandleList;                   //Hash
    CObjectArrayList<CConnectHandler> m_objHandlerList;                      //б
};


using App_ConnectHandlerPool = PSS_singleton<CConnectHandlerPool>;

#endif
